/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors.util;

import com.arm.mgd.lightweight.eventsource.IEventDispatcher;
import com.arm.mgd.lightweight.eventsource.IEventSource;
import com.arm.mgd.lightweight.eventsource.SimpleEventDispatcher;
import com.arm.mgd.lightweight.processors.IObservableProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingPushProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractObservableAsynchronousQueueingPushProcessor<T, P extends IQueueItemProcessor<T>, S extends AbstractObservableAsynchronousQueueingPushProcessor<T, P, S>>
extends AbstractAsynchronousQueueingPushProcessor<T, Processor<T, P, S>>
implements IObservableProcessor<S, T> {
    public AbstractObservableAsynchronousQueueingPushProcessor(@NonNull String threadName, int queueSize, @NonNull P processor) {
        super(threadName, queueSize, new Processor(processor));
        ((Processor)this.processor).createEventDispatcher(threadName, this);
    }

    @Override
    public @NonNull IEventSource<S, T> onItemProcessed() {
        return ((IEventDispatcher)NullUtils.neverNull(((Processor)this.processor).eventDispatcher)).getEventSource();
    }

    protected static class Processor<T, P extends IQueueItemProcessor<T>, S extends AbstractObservableAsynchronousQueueingPushProcessor<T, P, S>>
    implements IQueueItemProcessor<T> {
        protected @Nullable IEventDispatcher<S, T> eventDispatcher;
        private final @NonNull P delegateProcessor;

        public Processor(@NonNull P delegateProcessor) {
            this.delegateProcessor = delegateProcessor;
        }

        public void createEventDispatcher(@NonNull String threadName, @NonNull S host) {
            assert (this.eventDispatcher == null);
            this.eventDispatcher = new SimpleEventDispatcher<S, T>(host);
        }

        @Override
        public boolean process(@NonNull T itemToProcess) {
            boolean result = this.delegateProcessor.process(itemToProcess);
            ((IEventDispatcher)NullUtils.neverNull(this.eventDispatcher)).dispatchEvent(itemToProcess);
            return result;
        }
    }
}

