/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors.util;

import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractSynchronousPushProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.utils.NullUtils;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractFilterTransformProcessor<S, D>
extends AbstractSynchronousPushProcessor<S, Processor<S, D>> {
    public AbstractFilterTransformProcessor(@NonNull IPushProcessor<S> sourceProcessor, @NonNull IPushProcessor<D> targetProcessor) {
        super(new Processor<S, D>(sourceProcessor, targetProcessor));
        ((Processor)this.processor).setFilterFunction(this::filterItem);
    }

    @Override
    public @NonNull IPushProcessor<?> getParentProcessor() {
        return ((Processor)this.processor).sourceProcessor;
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown() && ((Processor)this.processor).targetProcessor.isShutdown();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        ((Processor)this.processor).targetProcessor.shutdown();
    }

    protected abstract @Nullable D filterItem(@NonNull S var1);

    protected static final class Processor<S, D>
    implements IQueueItemProcessor<S> {
        private @Nullable Function<@NonNull S, @Nullable D> filterFunction;
        private final @NonNull IPushProcessor<S> sourceProcessor;
        private final @NonNull IPushProcessor<D> targetProcessor;

        public Processor(@NonNull IPushProcessor<S> sourceProcessor, @NonNull IPushProcessor<D> targetProcessor) {
            this.sourceProcessor = sourceProcessor;
            this.targetProcessor = targetProcessor;
        }

        @Override
        public boolean process(@NonNull S itemToProcess) {
            @Nullable R filteredItem = ((Function)NullUtils.neverNull(this.filterFunction)).apply(itemToProcess);
            if (filteredItem == null) {
                return true;
            }
            return this.targetProcessor.enqueueItem(filteredItem);
        }

        private void setFilterFunction(Function<@NonNull S, @Nullable D> filterFunction) {
            assert (this.filterFunction == null);
            this.filterFunction = filterFunction;
        }
    }
}

