/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors.util;

import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingProcessorThread;
import com.arm.mgd.lightweight.processors.util.AbstractProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractAsynchronousQueueingPushProcessor<T, P extends IQueueItemProcessor<T>>
extends AbstractProcessor<T> {
    protected final @NonNull AbstractAsynchronousQueueingProcessorThread<T> processingThread;
    protected final @NonNull P processor;
    private boolean busy;

    public AbstractAsynchronousQueueingPushProcessor(@NonNull String threadName, int queueSize, @NonNull P processor) {
        this.processor = processor;
        this.processingThread = new AbstractAsynchronousQueueingProcessorThread(threadName, queueSize, new Processor(), () -> this.shutdownDependentProcessors(), this);
    }

    @Override
    public boolean enqueueItem(@NonNull T itemToEnqueue) {
        return this.processingThread.insert(itemToEnqueue);
    }

    @Override
    public boolean isBusy() {
        return this.busy || this.processingThread.isBusy();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.processingThread.shutdown();
    }

    synchronized void setBusy(boolean busy) {
        this.busy = busy;
    }

    private final class Processor
    implements IQueueItemProcessor<T> {
        private Processor() {
        }

        @Override
        public boolean process(@NonNull T itemToProcess) {
            try {
                try {
                    if (AbstractAsynchronousQueueingPushProcessor.this.processor.process(itemToProcess)) {
                        AbstractAsynchronousQueueingPushProcessor.this.pushDependentProcessors(itemToProcess);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AbstractAsynchronousQueueingPushProcessor.this.setBusy(false);
                    AbstractAsynchronousQueueingPushProcessor.this.setLastProcessedItem(itemToProcess);
                }
            }
            finally {
                AbstractAsynchronousQueueingPushProcessor.this.setBusy(false);
                AbstractAsynchronousQueueingPushProcessor.this.setLastProcessedItem(itemToProcess);
            }
            return false;
        }
    }
}

