/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors.util;

import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingPushProcessor;
import com.arm.mgd.lightweight.processors.util.IProcessorQueue;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.lightweight.util.TerminatableWorkerThread;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class AbstractAsynchronousQueueingProcessorThread<T>
implements IProcessorQueue<T> {
    private final WorkerThread thread;

    public AbstractAsynchronousQueueingProcessorThread(String threadName, int queueSize, IQueueItemProcessor<T> processor, @Nullable Runnable shutdownHandler, AbstractAsynchronousQueueingPushProcessor<T, ? extends IQueueItemProcessor<T>> host) {
        this.thread = new WorkerThread(threadName, queueSize, processor, shutdownHandler, host);
        this.thread.start();
    }

    @Override
    public boolean insert(@NonNull T itemToProcess) {
        if (!this.thread.requestShutdown) {
            while (!this.thread.queue.offer(itemToProcess)) {
                if (this.thread.requestShutdown) {
                    return false;
                }
                this.thread.waitForEvent();
            }
            this.thread.notifyEvent();
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return !this.thread.queue.isEmpty();
    }

    public void shutdown() {
        assert (!this.thread.requestShutdown);
        this.thread.requestShutdown = true;
        this.thread.notifyEvent();
    }

    protected void finalize() throws Throwable {
        this.thread.terminate();
    }

    private class WorkerThread
    extends TerminatableWorkerThread {
        private final IQueueItemProcessor<T> processor;
        private final BlockingQueue<T> queue;
        private volatile boolean requestShutdown;
        private final @Nullable Runnable shutdownHandler;
        private final AbstractAsynchronousQueueingPushProcessor<T, ? extends IQueueItemProcessor<T>> host;

        public WorkerThread(String threadName, int queueSize, @Nullable IQueueItemProcessor<T> processor, Runnable shutdownHandler, AbstractAsynchronousQueueingPushProcessor<T, ? extends IQueueItemProcessor<T>> host) {
            super(threadName);
            this.queue = new LinkedBlockingQueue(queueSize);
            this.processor = processor;
            this.shutdownHandler = shutdownHandler;
            this.host = host;
        }

        @Override
        protected void doOneWorkItem() {
            try {
                this.host.setBusy(true);
                Object itemToProcess = this.queue.remove();
                if (itemToProcess != null) {
                    this.processor.process(itemToProcess);
                }
            }
            finally {
                this.host.setBusy(false);
            }
        }

        @Override
        protected boolean handleException(Throwable e) {
            e.printStackTrace();
            return false;
        }

        @Override
        protected boolean hasOneWorkItem() {
            boolean queueIsEmpty = this.queue.isEmpty();
            if (queueIsEmpty && this.requestShutdown) {
                this.terminate();
            }
            return !queueIsEmpty;
        }

        @Override
        protected void onShutdown() {
            if (this.shutdownHandler != null) {
                this.shutdownHandler.run();
            }
            AbstractAsynchronousQueueingProcessorThread.this.thread.notifyEvent();
        }
    }
}

