/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.vulkan.VulkanAssetCallProcessor;
import com.arm.mgd.lightweight.model.VulkanModel;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import com.arm.mgd.lightweight.processors.ApiModelProcessorHelper;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingPushProcessor;
import com.arm.mgd.lightweight.processors.util.FunctionCallFilterTransformProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class VulkanModelProcessor
extends AbstractAsynchronousQueueingPushProcessor<FunctionCall, Processor> {
    private static final int QUEUE_SIZE = 10000;
    private final FunctionCallFilterTransformProcessor transformProcessor;

    public VulkanModelProcessor(VulkanModel vulkanModel, Consumer<@NonNull FunctionCall> insertFunctionCallback) {
        super("vulkan_model_call_processor_for_" + vulkanModel.getParentProcess(), 10000, new Processor(vulkanModel, insertFunctionCallback));
        this.transformProcessor = FunctionCallFilterTransformProcessor.apply(vulkanModel.getParentProcess().getProcessModelProcessor(), this);
    }

    @Override
    public @NonNull IPushProcessor<?> getParentProcessor() {
        return this.transformProcessor;
    }

    protected static class Processor
    implements IQueueItemProcessor<FunctionCall> {
        private final VulkanModel vulkanModel;
        private final Consumer<@NonNull FunctionCall> insertFunctionCallback;

        public Processor(VulkanModel vulkanModel, Consumer<@NonNull FunctionCall> insertFunctionCallback) {
            this.vulkanModel = vulkanModel;
            this.insertFunctionCallback = insertFunctionCallback;
        }

        @Override
        public boolean process(FunctionCall functionCall) {
            if (KapiSpec.VULKAN.equals(functionCall.getFunctionSpec().getKapiSpec())) {
                AbstractLightweightAssetFunctionCallProcessor assetProcessor = VulkanAssetCallProcessor.forFunctionCall(functionCall);
                if (assetProcessor != null) {
                    try {
                        ApiModelProcessorHelper.processCall(VULKANApi.class, this.vulkanModel.getAssetProcessorCallbacks(), functionCall, assetProcessor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.insertFunctionCallback.accept(functionCall);
                return true;
            }
            return false;
        }
    }
}

