/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ITraceItem;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.lightweight.LightweightModel;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.ITraceItemMarshaller;
import com.arm.mgd.lightweight.processors.util.AbstractSynchronousPushProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class TraceDataTraceItemProcessor
extends AbstractSynchronousPushProcessor<ITraceItem, Processor> {
    private static final int QUEUE_SIZE = 10000;

    public TraceDataTraceItemProcessor(LightweightModel model, @Nullable ITraceItemMarshaller marshaller) {
        super((String)NullUtils.neverNull((Object)TraceDataTraceItemProcessor.class.getSimpleName()), 10000, new Processor(model, marshaller));
    }

    @Override
    public @Nullable IPushProcessor<?> getParentProcessor() {
        return null;
    }

    protected static class Processor
    implements IQueueItemProcessor<ITraceItem> {
        private final @Nullable ITraceItemMarshaller marshaller;
        private final LightweightModel model;

        private static int getTraceItemPID(ITraceItem traceItem) {
            if (traceItem instanceof FunctionCall) {
                return ((FunctionCall)traceItem).getPid();
            }
            throw new AssertionError(traceItem);
        }

        public Processor(LightweightModel model, @Nullable ITraceItemMarshaller marshaller) {
            this.model = model;
            this.marshaller = marshaller;
        }

        @Override
        public boolean process(ITraceItem traceItem) {
            this.writeToDiskCache(traceItem);
            if (traceItem instanceof TargetEventDescriptor && this.processTargetEvent((TargetEventDescriptor)traceItem)) {
                return false;
            }
            this.forwardEventToProcessTarget(traceItem);
            return false;
        }

        private void forwardEventToProcessTarget(ITraceItem traceItem) {
            TracedProcess tracedProcess = this.model.getTracedProcess(Processor.getTraceItemPID(traceItem));
            tracedProcess.getProcessModelProcessor().enqueueItem(traceItem);
        }

        private boolean processTargetEvent(TargetEventDescriptor traceItem) {
            return false;
        }

        private void writeToDiskCache(ITraceItem traceItem) {
        }
    }
}

