/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ITraceItem;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractSynchronousPushProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class ProcessModelProcessor
extends AbstractSynchronousPushProcessor<ITraceItem, Processor> {
    private static final int QUEUE_SIZE = 10000;

    public ProcessModelProcessor(TracedProcess tracedProcess) {
        super((String)NullUtils.neverNull((Object)ProcessModelProcessor.class.getSimpleName()), 10000, new Processor(tracedProcess));
    }

    @Override
    public @NonNull IPushProcessor<?> getParentProcessor() {
        return ((Processor)this.processor).tracedProcess.getParentModel().getProcessor();
    }

    protected static class Processor
    implements IQueueItemProcessor<ITraceItem> {
        private final TracedProcess tracedProcess;

        public Processor(TracedProcess tracedProcess) {
            this.tracedProcess = tracedProcess;
        }

        @Override
        public boolean process(ITraceItem traceItem) {
            if (traceItem instanceof TargetEventDescriptor) {
                this.tracedProcess.handleNewTargetEvent((TargetEventDescriptor)traceItem);
                return false;
            }
            if (traceItem instanceof FunctionCall) {
                this.tracedProcess.addFunctionCall((FunctionCall)traceItem);
                return true;
            }
            throw new AssertionError((Object)("Unexpected trace item : " + traceItem.getClass() + " : " + traceItem));
        }
    }
}

