/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.target.data.FunctionCall;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IPushProcessor<T> {
    public static boolean waitForFunctionCallToBeProcessed(@NonNull IPushProcessor<?> processor, @NonNull FunctionCall itemToProcessTo, @Nullable CancellationFunction cancelled) {
        FunctionCall lastProcessedCall;
        while (!(processor.isShutdown() || cancelled != null && cancelled.isCancelled())) {
            lastProcessedCall = processor.getLastCompletedFunctionCall();
            if (lastProcessedCall != null && lastProcessedCall.compareTo(itemToProcessTo) >= 0) {
                return true;
            }
            try {
                processor.waitOnEvent();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (cancelled != null && cancelled.isCancelled()) {
            return false;
        }
        lastProcessedCall = processor.getLastCompletedFunctionCall();
        return lastProcessedCall != null && lastProcessedCall.compareTo(itemToProcessTo) >= 0;
    }

    public void addDependentProcessor(@NonNull IPushProcessor<? super T> var1);

    public boolean enqueueItem(@NonNull T var1);

    public @Nullable FunctionCall getLastCompletedFunctionCall();

    public @Nullable T getLastProcessedItem();

    public @Nullable IPushProcessor<?> getParentProcessor();

    public boolean isBusy();

    public boolean isShutdown();

    public boolean isShutdownRequested();

    public void shutdown();

    public void waitOnEvent() throws InterruptedException;

    @FunctionalInterface
    public static interface CancellationFunction {
        public boolean isCancelled();
    }
}

