/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAsset;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.GlesContextGroup;
import com.arm.mgd.lightweight.model.GlesRenderPass;
import com.arm.mgd.lightweight.processors.GlesContextGroupProcessor;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingPushProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.lightweight.state.value.AssetStateItemValue;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class GlesRenderpassProcessor
extends AbstractAsynchronousQueueingPushProcessor<FunctionCall, Processor> {
    private static final int QUEUE_SIZE = 10000;

    public GlesRenderpassProcessor(GlesContextGroup contextGroup, GlesContextGroupProcessor processor) {
        super(contextGroup + "_renderpass_processor", 10000, new Processor(contextGroup));
        processor.addDependentProcessor(this);
    }

    @Override
    public @NonNull IPushProcessor<?> getParentProcessor() {
        return ((Processor)this.processor).contextGroup.getProcessor();
    }

    @Override
    protected void onShutdown() {
        for (GlesContext context : ((Processor)this.processor).contextGroup) {
            context.getCurrentRenderpass().setComplete();
        }
    }

    protected static class Processor
    implements IQueueItemProcessor<FunctionCall> {
        private final GlesContextGroup contextGroup;

        public Processor(GlesContextGroup contextGroup) {
            this.contextGroup = contextGroup;
        }

        @Override
        public boolean process(FunctionCall functionCall) {
            FunctionCallID callID = functionCall.getID();
            GlesContext context = this.contextGroup.getContextForFunctionCall(functionCall);
            assert (context != null);
            if (!functionCall.hasError()) {
                AssetStateItemValue<GlFramebufferAsset> currentDrawFramebufferBinding = context.getGlesStateItems().GL_DRAW_FRAMEBUFFER_BINDING.waitForValue(callID);
                AssetItemID currentDrawFramebufferBindingID = (AssetItemID)currentDrawFramebufferBinding.getValue();
                assert (currentDrawFramebufferBindingID != null);
                GlFramebufferAsset currentDrawFramebuffer = context.getPerContextAssets().getLastGlFramebufferAssetBefore(currentDrawFramebufferBindingID, callID, true);
                assert (currentDrawFramebuffer != null);
                if (!context.getCurrentRenderpass().getDrawFramebuffer().equals(currentDrawFramebuffer)) {
                    GlesRenderPass renderpass = new GlesRenderPass(context, currentDrawFramebuffer, functionCall);
                    context.setCurrentRenderpass(renderpass);
                } else if (functionCall instanceof DrawFunctionCall) {
                    context.getCurrentRenderpass().addFunctionCall(functionCall);
                }
            }
            return true;
        }
    }
}

