/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.gles.GlesAssetCallProcessor;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.GlesContextGroup;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.lightweight.processors.ApiModelProcessorHelper;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingPushProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.lightweight.state.AbstractStateItemCallProcessor;
import com.arm.mgd.lightweight.state.gles.gen.GlesStateItems;
import com.arm.mgd.lightweight.state.gles.gen.GlesStateProcessor;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class GlesContextGroupProcessor
extends AbstractAsynchronousQueueingPushProcessor<FunctionCall, Processor> {
    private static final int QUEUE_SIZE = 10000;

    public GlesContextGroupProcessor(GlesContextGroup contextGroup) {
        super("context_group_" + contextGroup + "_asset_state_processor", 10000, new Processor(contextGroup));
        contextGroup.getParentModel().getParentProcess().getEglModel().getProcessor().addDependentProcessor(this);
    }

    @Override
    public @NonNull IPushProcessor<?> getParentProcessor() {
        return ((Processor)this.processor).contextGroup.getParentModel().getParentProcess().getEglModel().getProcessor();
    }

    protected static final class Processor
    implements IQueueItemProcessor<FunctionCall> {
        private final GlesContextGroup contextGroup;
        private @Nullable FunctionCallID lastSeenID;

        public Processor(GlesContextGroup contextGroup) {
            this.contextGroup = contextGroup;
            this.lastSeenID = null;
        }

        @Override
        public boolean process(@NonNull FunctionCall functionCall) {
            this.checkIdOrder(this.lastSeenID, functionCall.getID());
            GlesContext context = this.contextGroup.getContextForFunctionCall(functionCall);
            assert (context != null);
            if (KapiSpec.GLES.equals(functionCall.getFunctionSpec().getKapiSpec())) {
                AbstractStateItemCallProcessor<GlesStateItems> stateProcessor = GlesStateProcessor.getProcessorFor(functionCall.getFunctionSpec());
                AbstractLightweightAssetFunctionCallProcessor assetProcessor = GlesAssetCallProcessor.forFunctionCall(functionCall);
                try {
                    ApiModelProcessorHelper.processCall(GLESApi.class, context.getAssetProcessorCallbacks(), functionCall, assetProcessor, stateProcessor, context.getGlesStateItems());
                }
                catch (AbortActionException e) {
                    CoreLogging.warning(this.contextGroup.getParentModel(), e.getMessage());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return true;
            }
            boolean isEglFunction = KapiSpec.EGL.equals(functionCall.getFunctionSpec().getKapiSpec());
            MidstreamDataAttachment attachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
            assert (isEglFunction || attachment != null) : "Call passed to GlesContextGroupProcessor that is neither an EGL function nor a midstream trace function";
            if (attachment != null) {
                try {
                    attachment.processLightweightPreCallProcessor(GLESApi.class, context.getAssetProcessorCallbacks());
                    attachment.processLightweightPostCallProcessor(GLESApi.class, context.getAssetProcessorCallbacks());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return isEglFunction;
        }

        private synchronized void checkIdOrder(@Nullable FunctionCallID lastID, FunctionCallID currentID) {
            assert (lastID == null || lastID.compareTo(currentID) < 0);
            this.lastSeenID = currentID;
        }
    }
}

