/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.egl.EglAssetCallProcessor;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.model.api.EGLApi;
import com.arm.mgd.lightweight.processors.ApiModelProcessorHelper;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingPushProcessor;
import com.arm.mgd.lightweight.processors.util.FunctionCallFilterTransformProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import com.arm.mgd.lightweight.state.AbstractStateItemCallProcessor;
import com.arm.mgd.lightweight.state.egl.gen.EglStateItems;
import com.arm.mgd.lightweight.state.egl.gen.EglStateProcessor;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class EglModelProcessor
extends AbstractAsynchronousQueueingPushProcessor<FunctionCall, Processor> {
    private static final int QUEUE_SIZE = 10000;
    private final FunctionCallFilterTransformProcessor transformProcessor;

    public EglModelProcessor(TracedProcess tracedProcess) {
        super("egl_model_call_processor_for_" + tracedProcess, 10000, new Processor(tracedProcess));
        this.transformProcessor = FunctionCallFilterTransformProcessor.apply(tracedProcess.getProcessModelProcessor(), this);
    }

    @Override
    public @NonNull IPushProcessor<?> getParentProcessor() {
        return this.transformProcessor;
    }

    protected static class Processor
    implements IQueueItemProcessor<FunctionCall> {
        private final TracedProcess tracedProcess;

        public Processor(TracedProcess tracedProcess) {
            this.tracedProcess = tracedProcess;
        }

        @Override
        public boolean process(FunctionCall functionCall) {
            if (KapiSpec.EGL.equals(functionCall.getFunctionSpec().getKapiSpec())) {
                AbstractStateItemCallProcessor<EglStateItems> stateProcessor = EglStateProcessor.getProcessorFor(functionCall.getFunctionSpec());
                AbstractLightweightAssetFunctionCallProcessor assetProcessor = EglAssetCallProcessor.forFunctionCall(functionCall);
                try {
                    ApiModelProcessorHelper.processCall(EGLApi.class, this.tracedProcess.getEglModel().getAssetProcessorCallbacks(), functionCall, assetProcessor, stateProcessor, this.tracedProcess.getEglModel().getEglStateItemsForThread(functionCall));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.mapFunctionToGlesContext(functionCall);
            } else {
                MidstreamDataAttachment attachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (attachment != null) {
                    try {
                        attachment.processLightweightPreCallProcessor(EGLApi.class, this.tracedProcess.getEglModel().getAssetProcessorCallbacks());
                        attachment.processLightweightPostCallProcessor(EGLApi.class, this.tracedProcess.getEglModel().getAssetProcessorCallbacks());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (KapiSpec.GLES.equals(functionCall.getFunctionSpec().getKapiSpec()) || attachment != null) {
                    this.mapFunctionToGlesContext(functionCall);
                }
            }
            return false;
        }

        private void mapFunctionToGlesContext(FunctionCall functionCall) {
            EglContextAsset eglContextAsset = this.tracedProcess.getEglModel().getEglContextForFunctionCall(functionCall);
            if (eglContextAsset != null) {
                GlesContext glesContext = this.tracedProcess.getGlesModel().getContextForEGLContext(eglContextAsset);
                assert (glesContext != null);
                glesContext.addFunctionCall(functionCall);
                glesContext.getContextGroup().getProcessor().enqueueItem(functionCall);
            }
        }
    }
}

