/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.cl.ClAssetCallProcessor;
import com.arm.mgd.lightweight.model.ClModel;
import com.arm.mgd.lightweight.model.api.CLApi;
import com.arm.mgd.lightweight.processors.ApiModelProcessorHelper;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.processors.util.AbstractAsynchronousQueueingPushProcessor;
import com.arm.mgd.lightweight.processors.util.FunctionCallFilterTransformProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class ClModelProcessor
extends AbstractAsynchronousQueueingPushProcessor<FunctionCall, Processor> {
    private static final int QUEUE_SIZE = 10000;
    private final FunctionCallFilterTransformProcessor transformProcessor;

    public ClModelProcessor(ClModel clModel, Consumer<@NonNull FunctionCall> insertFunctionCallback) {
        super("cl_model_call_processor_for_" + clModel.getParentProcess(), 10000, new Processor(clModel, insertFunctionCallback));
        this.transformProcessor = FunctionCallFilterTransformProcessor.apply(clModel.getParentProcess().getProcessModelProcessor(), this);
    }

    @Override
    public @NonNull IPushProcessor<?> getParentProcessor() {
        return this.transformProcessor;
    }

    protected static class Processor
    implements IQueueItemProcessor<FunctionCall> {
        private final ClModel clModel;
        private final Consumer<@NonNull FunctionCall> insertFunctionCallback;

        public Processor(ClModel clModel, Consumer<@NonNull FunctionCall> insertFunctionCallback) {
            this.clModel = clModel;
            this.insertFunctionCallback = insertFunctionCallback;
        }

        @Override
        public boolean process(FunctionCall functionCall) {
            if (KapiSpec.CL.equals(functionCall.getFunctionSpec().getKapiSpec())) {
                AbstractLightweightAssetFunctionCallProcessor assetProcessor = ClAssetCallProcessor.forFunctionCall(functionCall);
                try {
                    ApiModelProcessorHelper.processCall(CLApi.class, this.clModel.getAssetProcessorCallbacks(), functionCall, assetProcessor);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.insertFunctionCallback.accept(functionCall);
                return true;
            }
            return false;
        }
    }
}

