/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors;

import com.arm.mgd.core.asset.processors.MissingAssetException;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.state.AbstractStateItemCallProcessor;
import com.arm.mgd.lightweight.state.IStateItemContainer;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ApiModelProcessorHelper {
    public static <API_MODEL> void processCall(@NonNull Class<API_MODEL> clazz, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @Nullable AbstractLightweightAssetFunctionCallProcessor<API_MODEL> assetProcessor) throws Exception {
        ApiModelProcessorHelper.processPreCallAttachments(clazz, callbacks, functionCall);
        if (assetProcessor != null) {
            try {
                assetProcessor.execute(callbacks, functionCall);
            }
            catch (MissingAssetException e) {
                CoreLogging.warning(null, (String)NullUtils.neverNull((Object)e.getMessage()));
            }
        }
        ApiModelProcessorHelper.processPostCallAttachments(clazz, callbacks, functionCall);
    }

    public static <API_MODEL, STATE_ITEMS extends IStateItemContainer> void processCall(@NonNull Class<API_MODEL> clazz, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @Nullable AbstractLightweightAssetFunctionCallProcessor<API_MODEL> assetProcessor, @Nullable AbstractStateItemCallProcessor<STATE_ITEMS> stateProcessor, @NonNull STATE_ITEMS stateItems) throws Exception {
        ApiModelProcessorHelper.processPreCallAttachments(clazz, callbacks, functionCall);
        if (assetProcessor != null) {
            try {
                assetProcessor.execute(callbacks, functionCall);
            }
            catch (MissingAssetException e) {
                CoreLogging.warning(null, (String)NullUtils.neverNull((Object)e.getMessage()));
            }
        }
        if (stateProcessor != null) {
            stateProcessor.execute(functionCall, stateItems);
        }
        ApiModelProcessorHelper.processPostCallAttachments(clazz, callbacks, functionCall);
    }

    private static <API_MODEL> void processPostCallAttachments(@NonNull Class<API_MODEL> clazz, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall) throws Exception {
        for (AbstractFreeAttachment freeAttachment : functionCall.getFreeAttachments()) {
            freeAttachment.processLightweightPostCallProcessor(clazz, callbacks);
        }
    }

    private static <API_MODEL> void processPreCallAttachments(@NonNull Class<API_MODEL> clazz, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall) throws Exception {
        for (AbstractFreeAttachment freeAttachment : functionCall.getFreeAttachments()) {
            freeAttachment.processLightweightPreCallProcessor(clazz, callbacks);
        }
    }
}

