/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.model;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.vulkan.AllVulkanAssets;
import com.arm.mgd.lightweight.model.IApiModel;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import com.arm.mgd.lightweight.processors.VulkanModelProcessor;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.util.IObservableFunctionCallContainer;
import com.arm.mgd.lightweight.util.ObservableFunctionCallContainer;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VulkanModel
implements IApiModel {
    private final @NonNull ILightweightAssetProcessorCallbacks<VULKANApi> assetProcessorCallbacks = new ILightweightAssetProcessorCallbacks<VULKANApi>(){

        @Override
        public void addMidstreamTraceStateUpdates(@NonNull FunctionCall functionCall, @NonNull Map<String, List<MidstreamStateItem>> stateItems) {
        }

        @Override
        public <T extends IAssetItem<VULKANApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, @NonNull FunctionCallID currentFunctionCallID, @NonNull AssetItemID id, boolean live) {
            switch (traits.SPEC.getScope()) {
                case COMMON: {
                    if (!$assertionsDisabled && !VulkanModel.this.getGlobalAssets().isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return VulkanModel.this.getGlobalAssets().getLastAssetBefore(traits, id, currentFunctionCallID, live);
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + traits.LIGHTWEIGHT_ASSET_CLASS.getSimpleName());
        }

        @Override
        public <T extends IAssetItem<VULKANApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, FunctionCallID currentFunctionCallID, AssetItemID id, @Nullable Long specificInstanceId) {
            if (specificInstanceId == null) {
                return this.getAssetObject(traits, currentFunctionCallID, id, true);
            }
            switch (traits.SPEC.getScope()) {
                case COMMON: {
                    if (!$assertionsDisabled && !VulkanModel.this.getGlobalAssets().isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return VulkanModel.this.getGlobalAssets().getLastAssetBefore(traits, id, currentFunctionCallID, specificInstanceId);
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + traits.LIGHTWEIGHT_ASSET_CLASS.getSimpleName());
        }

        @Override
        public @NonNull String getCoreLoggingSourceKey() {
            return VulkanModel.this.getParentProcess().getCoreLoggingSourceKey();
        }

        @Override
        public @Nullable FunctionCall getLastProcessedCall() {
            return VulkanModel.this.processor.getLastCompletedFunctionCall();
        }

        @Override
        public @NonNull IStateItem<?> getStateItem(FunctionCall currentFunctionCall, StateSpec stateSpec) throws IllegalArgumentException {
            throw new IllegalArgumentException("Invalid state item " + stateSpec.getName());
        }

        @Override
        public @NonNull TracedProcess getTracedProcess() {
            return VulkanModel.this.parentProcess;
        }

        @Override
        public <T extends IAssetItem<VULKANApi, ?>> void insertNewAsset(@NonNull T newAsset) {
            switch (newAsset.getAssetTableSpec().getScope()) {
                case COMMON: {
                    VulkanModel.this.getGlobalAssets().addChildAsset(newAsset);
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + newAsset.getClass().getSimpleName());
        }

        @Override
        public boolean isIgnoredCall(@NonNull FunctionCall functionCall, boolean isLocalScope) {
            return false;
        }

        @Override
        public <T extends IAssetItem<VULKANApi, ?>> void onAssetCreated(@NonNull T newAsset) {
        }
    };
    private final @NonNull AllVulkanAssets.GlobalAssets assets;
    private final @NonNull ObservableFunctionCallContainer functions;
    private final @NonNull TracedProcess parentProcess;
    private final @NonNull VulkanModelProcessor processor;

    public VulkanModel(@NonNull TracedProcess parentProcess) {
        this.parentProcess = parentProcess;
        this.assets = new AllVulkanAssets.GlobalAssets();
        this.functions = new ObservableFunctionCallContainer("vulkan_functions");
        this.processor = new VulkanModelProcessor(this, functionCall -> this.addFunctionCall((FunctionCall)functionCall));
    }

    public @NonNull ILightweightAssetProcessorCallbacks<VULKANApi> getAssetProcessorCallbacks() {
        return this.assetProcessorCallbacks;
    }

    @Override
    public @NonNull String getCoreLoggingSourceKey() {
        return this.parentProcess.getCoreLoggingSourceKey();
    }

    public @NonNull IObservableFunctionCallContainer getFunctions() {
        return this.functions;
    }

    public @NonNull AllVulkanAssets.GlobalAssets getGlobalAssets() {
        return this.assets;
    }

    public @NonNull TracedProcess getParentProcess() {
        return this.parentProcess;
    }

    public @NonNull VulkanModelProcessor getProcessor() {
        return this.processor;
    }

    private void addFunctionCall(@NonNull FunctionCall functionCall) {
        assert (KapiSpec.VULKAN.equals(functionCall.getFunctionSpec().getKapiSpec()));
        this.functions.addFunctionCall(functionCall);
    }
}

