/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.model;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TargetEventDescriptor;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.lightweight.LightweightModel;
import com.arm.mgd.lightweight.model.ClModel;
import com.arm.mgd.lightweight.model.EglModel;
import com.arm.mgd.lightweight.model.GlesModel;
import com.arm.mgd.lightweight.model.IApiModelWithState;
import com.arm.mgd.lightweight.model.internal.AbstractApiModelWithState;
import com.arm.mgd.lightweight.processors.ProcessModelProcessor;
import com.arm.mgd.lightweight.util.AbstractObservableFunctionCallContainer;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class TracedProcess
extends AbstractObservableFunctionCallContainer
implements ICoreLoggingSource {
    private final List<@NonNull IApiModelWithState> allModelsWithState;
    private final ClModel clModel;
    private final EglModel eglModel;
    private final GlesModel glesModel;
    private final LightweightModel parentModel;
    private final int processID;
    private final ProcessModelProcessor processor;

    public TracedProcess(LightweightModel parentModel, int processID) {
        super("traced_process_" + processID + "_function_call_event_dispatcher");
        this.processID = processID;
        this.parentModel = parentModel;
        this.processor = new ProcessModelProcessor(this);
        this.eglModel = new EglModel(this);
        this.glesModel = new GlesModel(this);
        this.clModel = new ClModel(this);
        this.allModelsWithState = NullUtils.unmodifiableList((List)NullUtils.asList((Object[])new AbstractApiModelWithState[]{this.eglModel, this.glesModel}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFunctionCall(FunctionCall functionCall) {
        assert (functionCall.getPid() == this.processID);
        Object object = this.functionCallMutex;
        synchronized (object) {
            super.addFunctionCall(functionCall);
        }
        super.dispatchNewFunctionCallsEvent();
    }

    public List<@NonNull IApiModelWithState> getAllApiModelsWithState() {
        return this.allModelsWithState;
    }

    public ClModel getClModel() {
        return this.clModel;
    }

    @Override
    public String getCoreLoggingSourceKey() {
        return this.parentModel.getCoreLoggingSourceKey();
    }

    public EglModel getEglModel() {
        return this.eglModel;
    }

    public GlesModel getGlesModel() {
        return this.glesModel;
    }

    public LightweightModel getParentModel() {
        return this.parentModel;
    }

    public ProcessModelProcessor getProcessModelProcessor() {
        return this.processor;
    }

    public void handleNewTargetEvent(TargetEventDescriptor traceItem) {
        assert (false);
    }

    public String toString() {
        return "PROCESS " + this.processID;
    }
}

