/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.model;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.gles.AllGlesAssets;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.GlesContextGroup;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.lightweight.model.internal.AbstractApiModelWithState;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.state.IStateItemContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class GlesModel
extends AbstractApiModelWithState {
    private final Map<EglContextAsset, GlesContext> contexts;
    private final TracedProcess parentProcess;

    private static void deleteAllAssetsForMidstreamTrace(GlesContext context, FunctionCall functionCall, Predicate<@NonNull IAssetItem<GLESApi, ?>> isRetained) {
        LightweightAssetBuilder.deleteAssetHelper(functionCall, isRetained, context.getPerContextAssets());
    }

    private static void deleteAllAssetsForMidstreamTrace(GlesContextGroup group, FunctionCall functionCall, Predicate<@NonNull IAssetItem<GLESApi, ?>> isRetained) {
        LightweightAssetBuilder.deleteAssetHelper(functionCall, isRetained, group.getPerContextGroupAssets());
    }

    public GlesModel(TracedProcess parentProcess) {
        this.parentProcess = parentProcess;
        this.contexts = new HashMap<EglContextAsset, GlesContext>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllAssetsForContextForMidstreamTrace(GlesContext currentContext, ILightweightAssetProcessorCallbacks<GLESApi> callbacks, FunctionCall functionCall, Predicate<@NonNull IAssetItem<GLESApi, ?>> isRetained) {
        Map<EglContextAsset, GlesContext> map = this.contexts;
        synchronized (map) {
            GlesModel.deleteAllAssetsForMidstreamTrace(currentContext, functionCall, isRetained);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllAssetsForContextGroupForMidstreamTrace(GlesContext currentContext, ILightweightAssetProcessorCallbacks<GLESApi> callbacks, FunctionCall functionCall, Predicate<@NonNull IAssetItem<GLESApi, ?>> isRetained) {
        Map<EglContextAsset, GlesContext> map = this.contexts;
        synchronized (map) {
            GlesContextGroup group = currentContext.getContextGroup();
            GlesModel.deleteAllAssetsForMidstreamTrace(currentContext, functionCall, isRetained);
            GlesModel.deleteAllAssetsForMidstreamTrace(group, functionCall, isRetained);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable GlesContext getContextForEGLContext(EglContextAsset eglContext) {
        Map<EglContextAsset, GlesContext> map = this.contexts;
        synchronized (map) {
            return this.contexts.get(eglContext);
        }
    }

    public @Nullable GlesContext getContextForFunctionCall(FunctionCall functionCall) {
        EglContextAsset eglContextAsset = this.parentProcess.getEglModel().getEglContextForFunctionCall(functionCall);
        if (eglContextAsset != null) {
            return this.getContextForEGLContext(eglContextAsset);
        }
        return null;
    }

    @Override
    public String getCoreLoggingSourceKey() {
        return this.parentProcess.getCoreLoggingSourceKey();
    }

    public TracedProcess getParentProcess() {
        return this.parentProcess;
    }

    public AllGlesAssets.PerContextAssets getPerContextAssets(GlesContext context) {
        return context.getPerContextAssets();
    }

    public AllGlesAssets.PerContextGroupAssets getPerContextGroupAssets(GlesContextGroup contextGroup) {
        return contextGroup.getPerContextGroupAssets();
    }

    @Override
    public @Nullable IStateItemContainer waitForStateForFunction(@NonNull ICoreProgressMonitor progressMonitor, @NonNull FunctionCall functionCall) {
        GlesContext context;
        if ((KapiSpec.EGL.equals(functionCall.getFunctionSpec().getKapiSpec()) || KapiSpec.GLES.equals(functionCall.getFunctionSpec().getKapiSpec())) && IPushProcessor.waitForFunctionCallToBeProcessed(this.parentProcess.getEglModel().getProcessor(), functionCall, () -> progressMonitor.isCancelled()) && (context = this.getContextForFunctionCall(functionCall)) != null && IPushProcessor.waitForFunctionCallToBeProcessed(context.getContextGroup().getProcessor(), functionCall, () -> progressMonitor.isCancelled())) {
            return context.getGlesStateItems();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGlesContext(GlesContext newContext) {
        Map<EglContextAsset, GlesContext> map = this.contexts;
        synchronized (map) {
            assert (!this.contexts.containsKey(newContext.getEglContextAsset()));
            this.contexts.put(newContext.getEglContextAsset(), newContext);
        }
    }
}

