/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.model;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.gles.AllGlesAssets;
import com.arm.mgd.lightweight.asset.gles.GlTextureAsset;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.GlesModel;
import com.arm.mgd.lightweight.processors.GlesContextGroupProcessor;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class GlesContextGroup
implements Iterable<GlesContext> {
    private final AllGlesAssets.PerContextGroupAssets assets;
    private final List<@NonNull GlesContext> contexts;
    private final EglContextAsset eglContextAsset;
    private final GlesModel parentModel;
    private final GlesContextGroupProcessor processor;

    public GlesContextGroup(GlesModel parentModel, EglContextAsset eglContextAsset) {
        this.parentModel = parentModel;
        this.eglContextAsset = eglContextAsset;
        this.assets = new AllGlesAssets.PerContextGroupAssets();
        this.contexts = new ArrayList<GlesContext>();
        this.processor = new GlesContextGroupProcessor(this);
        this.assets.addChildAsset(new GlTextureAsset(eglContextAsset.getCreatingFunction(), AssetItemID.ZERO));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof GlesContextGroup) {
            GlesContextGroup that = (GlesContextGroup)obj;
            return this.eglContextAsset.equals(that.eglContextAsset) && this.parentModel.equals(that.parentModel);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable GlesContext getContextForFunctionCall(FunctionCall functionCall) {
        List<GlesContext> list = this.contexts;
        synchronized (list) {
            for (GlesContext context : this.contexts) {
                if (!context.containsFunctionCall(functionCall)) continue;
                return context;
            }
            return null;
        }
    }

    public EglContextAsset getEglContextAsset() {
        return this.eglContextAsset;
    }

    public GlesModel getParentModel() {
        return this.parentModel;
    }

    public AllGlesAssets.PerContextGroupAssets getPerContextGroupAssets() {
        return this.assets;
    }

    public GlesContextGroupProcessor getProcessor() {
        return this.processor;
    }

    public int hashCode() {
        return this.eglContextAsset.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<@NonNull GlesContext> iterator() {
        List<GlesContext> list = this.contexts;
        synchronized (list) {
            return new ReadOnlySubList<GlesContext>(this.contexts).iterator();
        }
    }

    public String toString() {
        return (String)NullUtils.neverNull((Object)Long.toHexString(this.eglContextAsset.getId().asLong()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGlesContext(GlesContext context) {
        List<GlesContext> list = this.contexts;
        synchronized (list) {
            assert (context.getContextGroup().equals(this));
            this.contexts.add(context);
        }
    }
}

