/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.model;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.gles.AllGlesAssets;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexArrayObjectAsset;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.model.GlesContextGroup;
import com.arm.mgd.lightweight.model.GlesModel;
import com.arm.mgd.lightweight.model.GlesRenderPass;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.lightweight.state.IIndexedStateItem;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.gles.gen.GlesStateItems;
import com.arm.mgd.lightweight.util.AbstractObservableFunctionCallContainer;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlesContext
extends AbstractObservableFunctionCallContainer {
    private final @NonNull AllGlesAssets.PerContextAssets assets;
    private final @NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks = new ILightweightAssetProcessorCallbacks<GLESApi>(){

        @Override
        public boolean isIgnoredCall(@NonNull FunctionCall functionCall, boolean isLocalScope) {
            if (!functionCall.hasMidstreamTraceData()) {
                return false;
            }
            return !(isLocalScope ? GlesContext.this.containsFunctionCall(functionCall) : GlesContext.this.contextGroup.getContextForFunctionCall(functionCall) != null);
        }

        @Override
        public void addMidstreamTraceStateUpdates(@NonNull FunctionCall currentFunctionCall, @NonNull Map<String, List<MidstreamStateItem>> stateItems) {
            MidstreamStateItem.applyMidstreamStateUpdatesToStateItems(currentFunctionCall, stateItems, GlesContext.this.glesStateItems);
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, FunctionCallID currentFunctionCallID, AssetItemID id, boolean live) {
            if (!($assertionsDisabled || GlesContext.this.containsFunctionCall(currentFunctionCallID) || GlesContext.this.getCreatingFunction().getID().equals(currentFunctionCallID))) {
                throw new AssertionError();
            }
            switch (traits.SPEC.getScope()) {
                case LOCAL: {
                    if (!$assertionsDisabled && !GlesContext.this.assets.isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return GlesContext.this.assets.getLastAssetBefore(traits, id, currentFunctionCallID, live);
                }
                case SHARED: {
                    AllGlesAssets.PerContextGroupAssets perContextGroupAssets = GlesContext.this.getPerContextGroupAssets();
                    if (!$assertionsDisabled && !perContextGroupAssets.isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return perContextGroupAssets.getLastAssetBefore(traits, id, currentFunctionCallID, live);
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + traits.LIGHTWEIGHT_ASSET_CLASS.getSimpleName());
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, FunctionCallID currentFunctionCallID, AssetItemID id, @Nullable Long specificInstanceId) {
            if (specificInstanceId == null) {
                return this.getAssetObject(traits, currentFunctionCallID, id, true);
            }
            if (!($assertionsDisabled || GlesContext.this.containsFunctionCall(currentFunctionCallID) || GlesContext.this.getCreatingFunction().getID().equals(currentFunctionCallID))) {
                throw new AssertionError();
            }
            switch (traits.SPEC.getScope()) {
                case LOCAL: {
                    if (!$assertionsDisabled && !GlesContext.this.assets.isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return GlesContext.this.assets.getLastAssetBefore(traits, id, currentFunctionCallID, specificInstanceId);
                }
                case SHARED: {
                    AllGlesAssets.PerContextGroupAssets perContextGroupAssets = GlesContext.this.getPerContextGroupAssets();
                    if (!$assertionsDisabled && !perContextGroupAssets.isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return perContextGroupAssets.getLastAssetBefore(traits, id, currentFunctionCallID, specificInstanceId);
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + traits.LIGHTWEIGHT_ASSET_CLASS.getSimpleName());
        }

        @Override
        public @NonNull String getCoreLoggingSourceKey() {
            return GlesContext.this.parentModel.getCoreLoggingSourceKey();
        }

        @Override
        public @Nullable FunctionCall getLastProcessedCall() {
            return GlesContext.this.contextGroup.getProcessor().getLastCompletedFunctionCall();
        }

        @Override
        public @NonNull IStateItem<?> getStateItem(@NonNull FunctionCall currentFunctionCall, @NonNull StateSpec stateSpec) throws IllegalArgumentException {
            IStateItem<?> stateItem = GlesContext.this.glesStateItems.lookupStateItem(stateSpec);
            if (stateItem != null) {
                return stateItem;
            }
            throw new IllegalArgumentException("Invalid state item " + stateSpec.getName());
        }

        @Override
        public TracedProcess getTracedProcess() {
            return GlesContext.this.parentModel.getParentProcess();
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> void insertNewAsset(T newAsset) {
            if (!$assertionsDisabled && !GlesContext.this.containsFunctionCall(newAsset.getCreatingFunction())) {
                throw new AssertionError();
            }
            switch (newAsset.getAssetTableSpec().getScope()) {
                case LOCAL: {
                    GlesContext.this.assets.addChildAsset(newAsset);
                    return;
                }
                case SHARED: {
                    AllGlesAssets.PerContextGroupAssets perContextGroupAssets = GlesContext.this.getPerContextGroupAssets();
                    perContextGroupAssets.addChildAsset(newAsset);
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + newAsset.getClass().getSimpleName());
        }

        @Override
        public <T extends IAssetItem<GLESApi, ?>> void onAssetCreated(@NonNull T newAsset) {
        }
    };
    private final @NonNull GlesContextGroup contextGroup;
    private @NonNull GlesRenderPass currentRenderPass;
    private final @NonNull EglContextAsset eglContextAsset;
    private final @NonNull GlesStateItems glesStateItems;
    private final @NonNull GlesModel parentModel;
    private final @NonNull List<@NonNull GlesRenderPass> renderpasses;

    public static @NonNull GlesContext create(@NonNull GlesModel parentModel, @NonNull EglContextAsset eglContext) {
        GlesContext sharedContext;
        assert (parentModel.getContextForEGLContext(eglContext) == null) : "Already has context mapping: " + ((GlesContext)NullUtils.neverNull((Object)parentModel.getContextForEGLContext(eglContext))).getEglContextAsset() + " vs " + eglContext;
        EglContextAsset sharedEglContext = eglContext.getImmutablePropertySharedContext().getValue();
        GlesContext glesContext = sharedContext = sharedEglContext != null ? parentModel.getContextForEGLContext(sharedEglContext) : null;
        assert (sharedContext == null && sharedEglContext == null || sharedContext != null && sharedEglContext != null);
        GlesContext result = new GlesContext(parentModel, eglContext, sharedContext);
        parentModel.addGlesContext(result);
        return result;
    }

    private GlesContext(@NonNull GlesModel parentModel, @NonNull EglContextAsset eglContextAsset, @Nullable GlesContext sharedContext) {
        super("gles_context_0x" + Long.toHexString(eglContextAsset.getId().asLong()) + "_function_list_event_dispatcher");
        this.parentModel = parentModel;
        this.eglContextAsset = eglContextAsset;
        this.contextGroup = sharedContext != null ? sharedContext.contextGroup : new GlesContextGroup(parentModel, eglContextAsset);
        this.glesStateItems = new GlesStateItems(this);
        this.assets = new AllGlesAssets.PerContextAssets();
        this.renderpasses = new ArrayList<GlesRenderPass>();
        this.contextGroup.addGlesContext(this);
        GlFramebufferAsset fbo0 = GlFramebufferAsset.createFboZero(eglContextAsset.getCreatingFunction());
        this.assets.addChildAsset(fbo0);
        this.assets.addChildAsset(new GlVertexArrayObjectAsset(eglContextAsset.getCreatingFunction(), AssetItemID.ZERO));
        this.assets.addChildAsset(new GlTextureUnitAsset(eglContextAsset.getCreatingFunction(), AssetItemID.ZERO));
        this.assets.addChildAsset(new GlTransformFeedbackAsset(eglContextAsset.getCreatingFunction(), AssetItemID.ZERO));
        this.currentRenderPass = new GlesRenderPass(this, fbo0, eglContextAsset.getCreatingFunction());
        this.renderpasses.add(this.currentRenderPass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFunctionCall(FunctionCall functionCall) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            super.addFunctionCall(functionCall);
        }
        super.dispatchNewFunctionCallsEvent();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof GlesContext) {
            GlesContext that = (GlesContext)obj;
            return this.eglContextAsset.equals(that.eglContextAsset) && this.contextGroup.equals(that.contextGroup) && this.parentModel.equals(that.parentModel);
        }
        return false;
    }

    public @NonNull ILightweightAssetProcessorCallbacks<GLESApi> getAssetProcessorCallbacks() {
        return this.callbacks;
    }

    public @NonNull GlesContextGroup getContextGroup() {
        return this.contextGroup;
    }

    public @NonNull FunctionCall getCreatingFunction() {
        return this.eglContextAsset.getCreatingFunction();
    }

    public @NonNull GlesRenderPass getCurrentRenderpass() {
        return this.currentRenderPass;
    }

    public @NonNull EglContextAsset getEglContextAsset() {
        return this.eglContextAsset;
    }

    public @NonNull GlesStateItems getGlesStateItems() {
        return this.glesStateItems;
    }

    public @Nullable FunctionCall getLastProcessedStateProcessorFunctionCall() {
        return this.contextGroup.getProcessor().getLastCompletedFunctionCall();
    }

    public GlesModel getParentModel() {
        return this.parentModel;
    }

    public @NonNull AllGlesAssets.PerContextAssets getPerContextAssets() {
        return this.assets;
    }

    public AllGlesAssets.PerContextGroupAssets getPerContextGroupAssets() {
        return this.contextGroup.getPerContextGroupAssets();
    }

    public int hashCode() {
        return this.eglContextAsset.hashCode();
    }

    public @Nullable IIndexedStateItem<?> lookupIndexedStateItemBySpec(@NonNull StateSpec stateSpec) {
        return this.glesStateItems.lookupIndexedStateItem(stateSpec);
    }

    public @Nullable IStateItem<?> lookupStateItemBySpec(@NonNull StateSpec stateSpec) {
        return this.glesStateItems.lookupStateItem(stateSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentRenderpass(@NonNull GlesRenderPass currentRenderPass) {
        assert (this.currentRenderPass.getCreatingFunction().compareTo(currentRenderPass.getCreatingFunction()) < 0);
        List<GlesRenderPass> list = this.renderpasses;
        synchronized (list) {
            this.currentRenderPass.setComplete();
            this.renderpasses.add(currentRenderPass);
            this.currentRenderPass = currentRenderPass;
        }
    }

    public String toString() {
        return (String)NullUtils.neverNull((Object)Long.toHexString(this.eglContextAsset.getId().asLong()));
    }
}

