/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.model;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.egl.AllEglAssets;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.model.EglPerThreadData;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.model.api.EGLApi;
import com.arm.mgd.lightweight.model.internal.AbstractApiModelWithState;
import com.arm.mgd.lightweight.processors.EglModelProcessor;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemContainer;
import com.arm.mgd.lightweight.state.egl.gen.EglStateItems;
import com.arm.mgd.lightweight.state.value.AssetStateItemValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class EglModel
extends AbstractApiModelWithState {
    private final @NonNull ILightweightAssetProcessorCallbacks<EGLApi> assetProcessorCallbacks = new ILightweightAssetProcessorCallbacks<EGLApi>(){

        @Override
        public void addMidstreamTraceStateUpdates(FunctionCall currentFunctionCall, Map<String, List<MidstreamStateItem>> stateItems) {
            EglStateItems eglStateItems = EglModel.this.getEglStateItemsForThread(currentFunctionCall);
            MidstreamStateItem.applyMidstreamStateUpdatesToStateItems(currentFunctionCall, stateItems, eglStateItems);
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, FunctionCallID currentFunctionCallID, AssetItemID id, boolean live) {
            switch (traits.SPEC.getScope()) {
                case COMMON: {
                    if (!$assertionsDisabled && !EglModel.this.getGlobalAssets().isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return EglModel.this.getGlobalAssets().getLastAssetBefore(traits, id, currentFunctionCallID, live);
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + traits.LIGHTWEIGHT_ASSET_CLASS.getSimpleName());
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, FunctionCallID currentFunctionCallID, AssetItemID id, @Nullable Long specificInstanceId) {
            if (specificInstanceId == null) {
                return this.getAssetObject(traits, currentFunctionCallID, id, true);
            }
            switch (traits.SPEC.getScope()) {
                case COMMON: {
                    if (!$assertionsDisabled && !EglModel.this.getGlobalAssets().isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return EglModel.this.getGlobalAssets().getLastAssetBefore(traits, id, currentFunctionCallID, specificInstanceId);
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + traits.LIGHTWEIGHT_ASSET_CLASS.getSimpleName());
        }

        @Override
        public @NonNull String getCoreLoggingSourceKey() {
            return EglModel.this.getParentProcess().getCoreLoggingSourceKey();
        }

        @Override
        public @Nullable FunctionCall getLastProcessedCall() {
            return EglModel.this.processor.getLastCompletedFunctionCall();
        }

        @Override
        public IStateItem<?> getStateItem(@NonNull FunctionCall currentFunctionCall, @NonNull StateSpec stateSpec) throws IllegalArgumentException {
            EglStateItems eglStateItems = EglModel.this.getEglStateItemsForThread(currentFunctionCall);
            IStateItem<?> result = eglStateItems.lookupStateItem(stateSpec);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Invalid state item " + stateSpec.getName());
        }

        @Override
        public @NonNull TracedProcess getTracedProcess() {
            return EglModel.this.parentProcess;
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> void insertNewAsset(@NonNull T newAsset) {
            switch (newAsset.getAssetTableSpec().getScope()) {
                case COMMON: {
                    EglModel.this.getGlobalAssets().addChildAsset(newAsset);
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + newAsset.getClass().getSimpleName());
        }

        @Override
        public boolean isIgnoredCall(@NonNull FunctionCall functionCall, boolean isLocalScope) {
            return false;
        }

        @Override
        public <T extends IAssetItem<EGLApi, ?>> void onAssetCreated(@NonNull T newAsset) {
            if (newAsset instanceof EglContextAsset) {
                GlesContext.create(EglModel.this.parentProcess.getGlesModel(), (EglContextAsset)newAsset);
            }
        }
    };
    private final @NonNull AllEglAssets.GlobalAssets assets;
    private final @NonNull TracedProcess parentProcess;
    private final @NonNull Map<Long, EglPerThreadData> perThreadData;
    private final @NonNull EglModelProcessor processor;

    public EglModel(@NonNull TracedProcess parentProcess) {
        this.parentProcess = parentProcess;
        this.assets = new AllEglAssets.GlobalAssets();
        this.perThreadData = new HashMap<Long, EglPerThreadData>();
        this.processor = new EglModelProcessor(parentProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllAssetsForMidstreamTrace(FunctionCall functionCall, Predicate<@NonNull IAssetItem<EGLApi, ?>> isRetained) {
        Map<Long, EglPerThreadData> map = this.perThreadData;
        synchronized (map) {
            LightweightAssetBuilder.deleteAssetHelper(functionCall, isRetained, this.assets);
        }
    }

    public @NonNull ILightweightAssetProcessorCallbacks<EGLApi> getAssetProcessorCallbacks() {
        return this.assetProcessorCallbacks;
    }

    @Override
    public @NonNull String getCoreLoggingSourceKey() {
        return this.parentProcess.getCoreLoggingSourceKey();
    }

    public @Nullable EglContextAsset getEglContextForFunctionCall(@NonNull FunctionCall functionCall) {
        FunctionCallID callID = functionCall.getID();
        EglStateItems eglStateItems = this.getEglStateItemsForThread(functionCall);
        AssetStateItemValue<EglDisplayAsset> currentDisplay = eglStateItems.EGL_CURRENT_DISPLAY.waitForValue(callID);
        AssetStateItemValue<EglContextAsset> currentContext = eglStateItems.EGL_CURRENT_CONTEXT.waitForValue(callID);
        AssetItemID currentDisplayID = (AssetItemID)currentDisplay.getValue();
        AssetItemID currentContextID = (AssetItemID)currentContext.getValue();
        if (currentDisplayID != null && currentContextID != null) {
            EglDisplayAsset eglDisplayAsset = this.assets.getLastEglDisplayAssetBefore(currentDisplayID, callID, false);
            assert (eglDisplayAsset != null || currentDisplayID.asLong() == 0L);
            if (eglDisplayAsset != null) {
                EglContextAsset eglContextAsset = eglDisplayAsset.getEglContextAssetAt(callID, currentContextID, false);
                assert (eglContextAsset != null || currentContextID.asLong() == 0L);
                return eglContextAsset;
            }
        }
        return null;
    }

    public @NonNull EglStateItems getEglStateItemsForThread(FunctionCall functionCall) {
        return this.getPerThreadDataFor(functionCall).getEglStateItems();
    }

    public @NonNull AllEglAssets.GlobalAssets getGlobalAssets() {
        return this.assets;
    }

    public @NonNull TracedProcess getParentProcess() {
        return this.parentProcess;
    }

    public @NonNull EglModelProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public @Nullable IStateItemContainer waitForStateForFunction(ICoreProgressMonitor progressMonitor, FunctionCall functionCall) {
        if ((KapiSpec.EGL.equals(functionCall.getFunctionSpec().getKapiSpec()) || KapiSpec.GLES.equals(functionCall.getFunctionSpec().getKapiSpec())) && IPushProcessor.waitForFunctionCallToBeProcessed(this.processor, functionCall, () -> progressMonitor.isCancelled())) {
            return this.getEglStateItemsForThread(functionCall);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NonNull EglPerThreadData getPerThreadDataFor(FunctionCall functionCall) {
        Map<Long, EglPerThreadData> map = this.perThreadData;
        synchronized (map) {
            Long key = functionCall.getTid();
            EglPerThreadData result = this.perThreadData.get(key);
            if (result == null) {
                result = new EglPerThreadData(this, functionCall);
                this.perThreadData.put(key, result);
            }
            return result;
        }
    }
}

