/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.model;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.cl.AllClAssets;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.model.IApiModel;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.model.api.CLApi;
import com.arm.mgd.lightweight.processors.ClModelProcessor;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.util.IObservableFunctionCallContainer;
import com.arm.mgd.lightweight.util.ObservableFunctionCallContainer;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ClModel
implements IApiModel {
    private final @NonNull ILightweightAssetProcessorCallbacks<CLApi> assetProcessorCallbacks = new ILightweightAssetProcessorCallbacks<CLApi>(){

        @Override
        public void addMidstreamTraceStateUpdates(@NonNull FunctionCall functionCall, @NonNull Map<String, List<MidstreamStateItem>> stateItems) {
        }

        @Override
        public <T extends IAssetItem<CLApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, @NonNull FunctionCallID currentFunctionCallID, @NonNull AssetItemID id, boolean live) {
            switch (traits.SPEC.getScope()) {
                case COMMON: {
                    if (!$assertionsDisabled && !ClModel.this.getGlobalAssets().isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return ClModel.this.getGlobalAssets().getLastAssetBefore(traits, id, currentFunctionCallID, live);
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + traits.LIGHTWEIGHT_ASSET_CLASS.getSimpleName());
        }

        @Override
        public <T extends IAssetItem<CLApi, ?>> @Nullable T getAssetObject(KapiSpec.AssetTraits<?, T, ?> traits, @NonNull FunctionCallID currentFunctionCallID, @NonNull AssetItemID id, @Nullable Long specificInstanceId) {
            if (specificInstanceId == null) {
                return this.getAssetObject(traits, currentFunctionCallID, id, true);
            }
            switch (traits.SPEC.getScope()) {
                case COMMON: {
                    if (!$assertionsDisabled && !ClModel.this.getGlobalAssets().isAcceptableClass(traits.LIGHTWEIGHT_ASSET_CLASS)) {
                        throw new AssertionError();
                    }
                    return ClModel.this.getGlobalAssets().getLastAssetBefore(traits, id, currentFunctionCallID, specificInstanceId);
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + traits.LIGHTWEIGHT_ASSET_CLASS.getSimpleName());
        }

        @Override
        public @NonNull String getCoreLoggingSourceKey() {
            return ClModel.this.getParentProcess().getCoreLoggingSourceKey();
        }

        @Override
        public @Nullable FunctionCall getLastProcessedCall() {
            return ClModel.this.processor.getLastCompletedFunctionCall();
        }

        @Override
        public @NonNull IStateItem<?> getStateItem(@NonNull FunctionCall currentFunctionCall, @NonNull StateSpec stateSpec) throws IllegalArgumentException {
            throw new IllegalArgumentException("Invalid state item " + stateSpec.getName());
        }

        @Override
        public @NonNull TracedProcess getTracedProcess() {
            return ClModel.this.parentProcess;
        }

        @Override
        public <T extends IAssetItem<CLApi, ?>> void insertNewAsset(@NonNull T newAsset) {
            switch (newAsset.getAssetTableSpec().getScope()) {
                case COMMON: {
                    ClModel.this.getGlobalAssets().addChildAsset(newAsset);
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid asset type " + newAsset.getClass().getSimpleName());
        }

        @Override
        public boolean isIgnoredCall(@NonNull FunctionCall functionCall, boolean isLocalScope) {
            return false;
        }

        @Override
        public <T extends IAssetItem<CLApi, ?>> void onAssetCreated(@NonNull T newAsset) {
        }
    };
    private final @NonNull AllClAssets.GlobalAssets assets;
    private final @NonNull ObservableFunctionCallContainer functions;
    private final @NonNull TracedProcess parentProcess;
    private final @NonNull ClModelProcessor processor;

    public ClModel(@NonNull TracedProcess parentProcess) {
        this.parentProcess = parentProcess;
        this.assets = new AllClAssets.GlobalAssets();
        this.functions = new ObservableFunctionCallContainer("opencl_functions");
        this.processor = new ClModelProcessor(this, functionCall -> this.addFunctionCall((FunctionCall)functionCall));
    }

    public @NonNull ILightweightAssetProcessorCallbacks<CLApi> getAssetProcessorCallbacks() {
        return this.assetProcessorCallbacks;
    }

    @Override
    public @NonNull String getCoreLoggingSourceKey() {
        return this.parentProcess.getCoreLoggingSourceKey();
    }

    public @NonNull IObservableFunctionCallContainer getFunctions() {
        return this.functions;
    }

    public @NonNull AllClAssets.GlobalAssets getGlobalAssets() {
        return this.assets;
    }

    public @NonNull TracedProcess getParentProcess() {
        return this.parentProcess;
    }

    public @NonNull ClModelProcessor getProcessor() {
        return this.processor;
    }

    private void addFunctionCall(@NonNull FunctionCall functionCall) {
        assert (KapiSpec.CL.equals(functionCall.getFunctionSpec().getKapiSpec()));
        this.functions.addFunctionCall(functionCall);
    }
}

