/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.eventsource;

import com.arm.mgd.lightweight.eventsource.IEventDispatcher;
import com.arm.mgd.lightweight.eventsource.IEventListener;
import com.arm.mgd.lightweight.eventsource.IEventSource;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractEventDispatcher<HOST_TYPE, DATA_TYPE>
implements IEventDispatcher<HOST_TYPE, DATA_TYPE> {
    private final @NonNull IEventSource<HOST_TYPE, DATA_TYPE> eventSource = new IEventSource<HOST_TYPE, DATA_TYPE>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void addEventListener(@NonNull IEventListener<HOST_TYPE, DATA_TYPE> newListener) {
            Set set = AbstractEventDispatcher.this.listeners;
            synchronized (set) {
                AbstractEventDispatcher.this.listeners.add(newListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addWeakEventListener(@NonNull IEventListener<HOST_TYPE, DATA_TYPE> listener) {
            Set set = AbstractEventDispatcher.this.listeners;
            synchronized (set) {
                AbstractEventDispatcher.this.listeners.add(new WeakListener(listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void removeEventListener(@NonNull IEventListener<HOST_TYPE, DATA_TYPE> listener) {
            Set set = AbstractEventDispatcher.this.listeners;
            synchronized (set) {
                AbstractEventDispatcher.this.listeners.remove(listener);
            }
        }
    };
    private final @NonNull HOST_TYPE hostObject;
    private final @NonNull Set<IEventListener<HOST_TYPE, DATA_TYPE>> listeners = new HashSet<IEventListener<HOST_TYPE, DATA_TYPE>>();

    public AbstractEventDispatcher(@NonNull HOST_TYPE hostObject) {
        this.hostObject = hostObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(DATA_TYPE data) {
        Set<IEventListener<HOST_TYPE, DATA_TYPE>> set = this.listeners;
        synchronized (set) {
            Iterator<IEventListener<HOST_TYPE, DATA_TYPE>> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakListener weakListener;
                IEventListener<HOST_TYPE, DATA_TYPE> listener = iterator.next();
                listener.onEventReceived(this.hostObject, data);
                if (!(listener instanceof WeakListener) || (weakListener = (WeakListener)listener).isReferenceValid()) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public final IEventSource<HOST_TYPE, DATA_TYPE> getEventSource() {
        return this.eventSource;
    }

    private static class WeakListener<HOST_TYPE, DATA_TYPE>
    implements IEventListener<HOST_TYPE, DATA_TYPE> {
        private final @NonNull WeakReference<IEventListener<HOST_TYPE, DATA_TYPE>> listenerRef;

        public WeakListener(@NonNull IEventListener<HOST_TYPE, DATA_TYPE> listener) {
            this.listenerRef = new WeakReference<IEventListener<HOST_TYPE, DATA_TYPE>>(listener);
        }

        public boolean isReferenceValid() {
            return this.listenerRef.get() != null;
        }

        @Override
        public void onEventReceived(HOST_TYPE host, DATA_TYPE data) {
            IEventListener listener = (IEventListener)this.listenerRef.get();
            if (listener != null) {
                listener.onEventReceived(host, data);
            }
        }
    }
}

