/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.eventsource;

import com.arm.mgd.lightweight.eventsource.AbstractEventDispatcher;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAsynchronousEventDispatcher<HOST_TYPE, DATA_TYPE>
extends AbstractEventDispatcher<HOST_TYPE, DATA_TYPE> {
    private final @NonNull RepeatedEventAction action;
    private final @NonNull Queue<DATA_TYPE> eventQueue = new LinkedList<DATA_TYPE>();

    public AbstractAsynchronousEventDispatcher(@NonNull RepeatedEventAction action, @NonNull HOST_TYPE hostObject) {
        super(hostObject);
        this.action = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispatchEvent(DATA_TYPE data) {
        Queue<DATA_TYPE> queue = this.eventQueue;
        synchronized (queue) {
            if (!this.eventQueue.isEmpty()) {
                switch (this.action) {
                    case DROP: {
                        return;
                    }
                    case QUEUE: {
                        break;
                    }
                    case REPLACE: {
                        this.eventQueue.clear();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected action: " + (Object)((Object)this.action)));
                    }
                }
            }
            this.eventQueue.add(data);
            this.onNewQueueItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean dispatchOneEventItem() {
        @Nullable DATA_TYPE item = null;
        Queue<DATA_TYPE> queue = this.eventQueue;
        synchronized (queue) {
            if (!this.eventQueue.isEmpty()) {
                item = this.eventQueue.remove();
            }
        }
        if (item != null) {
            super.dispatchEvent(item);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isQueueEmpty() {
        Queue<DATA_TYPE> queue = this.eventQueue;
        synchronized (queue) {
            return this.eventQueue.isEmpty();
        }
    }

    protected abstract void onNewQueueItem();

    public static enum RepeatedEventAction {
        DROP,
        QUEUE,
        REPLACE;

    }
}

