/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.bridge;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.state.StateId;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.state.TargetStateMap;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.bridge.LightweightStateBridge;
import com.arm.mgd.lightweight.bridge.LightweightStateBridgeStateItem;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
final class LightweightStateBridgeTargetStateMap
implements TargetStateMap {
    private static final long serialVersionUID = -8391286975735529986L;
    private final KapiSpec apiSpec;
    private final Map<StateId, LightweightStateBridgeStateItem> stateItemMap = new HashMap<StateId, LightweightStateBridgeStateItem>();
    private final LightweightStateBridge parent;

    public LightweightStateBridgeTargetStateMap(KapiSpec apiSpec, LightweightStateBridge parent) {
        this.apiSpec = apiSpec;
        this.parent = parent;
        for (StateSpec stateSpec : apiSpec.getApi().getStates().getState()) {
            assert (stateSpec != null);
            if (stateSpec.getStateType().getIndexCount() != null || stateSpec.getStateType().getIndexCountRef() != null) continue;
            this.stateItemMap.put(new StateId(stateSpec), new LightweightStateBridgeStateItem(this, stateSpec));
        }
    }

    @Override
    public KapiSpec getApiSpec() {
        return this.apiSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateItem getStateItemBySpec(StateSpec stateSpec) {
        TraceStateSnapshot snapshot = this.parent.getTraceStateSnapshot();
        Map<StateId, LightweightStateBridgeStateItem> map = this.stateItemMap;
        synchronized (map) {
            StateItem s = this.stateItemMap.get(new StateId(stateSpec));
            if (s == null) {
                CoreLogging.warning(snapshot.getModel(), "State item '" + stateSpec.getId() + "' not found");
            }
            return (StateItem)NullUtils.neverNull((Object)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends StateItem> getStateItems() {
        Map<StateId, LightweightStateBridgeStateItem> map = this.stateItemMap;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.stateItemMap.values());
        }
    }

    @Override
    public TraceStateSnapshot getStateSnapshot() {
        return this.parent.getTraceStateSnapshot();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    final LightweightStateBridge getLightweightStateBridge() {
        return this.parent;
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = -8391286975735529986L;
        private final KapiSpec apiSpec;
        private final TraceStateSnapshot snapshot;

        public SerializationProxy(LightweightStateBridgeTargetStateMap object) {
            this.snapshot = object.getStateSnapshot();
            this.apiSpec = object.apiSpec;
        }

        public Object readResolve() {
            return new LightweightStateBridgeTargetStateMap(this.apiSpec, this.snapshot.getLightweightStateBridge());
        }
    }
}

