/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.bridge;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.state.StateValue;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.ApiName;
import com.arm.mgd.kapi.gen.AssetObjectSpec;
import com.arm.mgd.kapi.gen.StateVariableTypeSpec;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.bridge.LightweightStateBridgeCurrentFunctionInfo;
import com.arm.mgd.lightweight.bridge.LightweightStateBridgeTargetStateMap;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import com.arm.mgd.lightweight.state.egl.gen.EglStateItems;
import com.arm.mgd.lightweight.state.value.RGBAStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
final class LightweightStateBridgeStateItem
implements StateItem {
    private static final long serialVersionUID = -6501650638339974871L;
    private transient @Nullable ValueCache cachedValue;
    private transient LightweightStateBridgeCurrentFunctionInfo currentFunctionInfo;
    private final LightweightStateBridgeTargetStateMap parentMap;
    private final StateSpec stateSpec;

    private static @Nullable IStateItem<?> mapStateSpec(@Nullable EglStateItems eglStateItems, @Nullable GlesContext glesContext, StateSpec stateSpec, FunctionCall targetfunction) {
        switch (stateSpec.getKapiSpec().getApi().getApiInfo().getName()) {
            case GLES: 
            case EGL: {
                if (eglStateItems != null) {
                    if (stateSpec.getKapiSpec().getApi().getApiInfo().getName() == ApiName.EGL) {
                        return eglStateItems.lookupStateItem(stateSpec);
                    }
                    if (glesContext != null && IPushProcessor.waitForFunctionCallToBeProcessed(glesContext.getContextGroup().getProcessor(), targetfunction, null)) {
                        return glesContext.getGlesStateItems().lookupStateItem(stateSpec);
                    }
                }
                return null;
            }
        }
        throw new AssertionError(stateSpec);
    }

    public LightweightStateBridgeStateItem(LightweightStateBridgeTargetStateMap parentMap, StateSpec stateSpec) {
        this.parentMap = parentMap;
        this.stateSpec = stateSpec;
        this.cachedValue = null;
        this.currentFunctionInfo = parentMap.getLightweightStateBridge().getCurrentFunctionInfo();
    }

    @Override
    public SortedSet<FunctionCall> getAllModifyingFunctions(int from, int to) {
        assert (from >= 0);
        assert (from < to);
        TreeSet<FunctionCall> result = new TreeSet<FunctionCall>();
        ValueCache value = this.getCachedValue();
        IStateItem<?> localStateItem = value.stateItem;
        if (localStateItem != null) {
            for (FunctionCall functionCall : localStateItem.waitForListOfModifyingFunctionCalls()) {
                if (functionCall.getIndex() < from || functionCall.getIndex() >= to) continue;
                result.add(functionCall);
            }
        }
        return result;
    }

    @Override
    public final Class<StateItem> getIDiffableTClass() {
        return StateItem.class;
    }

    @Override
    public String getItemAsString() {
        IAssetItem assetItem;
        if (this.stateSpec.getAssetClass() != null && (assetItem = this.getValueAsAsset()) != null) {
            return assetItem.getLabelText();
        }
        return this.getValuesAsString();
    }

    @Override
    public @Nullable FunctionCall getLastAffectedByFunction() {
        FunctionCall functionCall;
        ValueCache value = this.getCachedValue();
        IStateItem<?> localStateItem = value.stateItem;
        if (localStateItem != null && (functionCall = this.currentFunctionInfo.selectedFunction) != null) {
            return localStateItem.findLastAffectingCallBefore(functionCall);
        }
        return null;
    }

    @Override
    public @Nullable FunctionCall getNextAffectedByFunction() {
        FunctionCall functionCall;
        ValueCache value = this.getCachedValue();
        IStateItem<?> localStateItem = value.stateItem;
        if (localStateItem != null && (functionCall = this.currentFunctionInfo.selectedFunction) != null) {
            return localStateItem.findNextAffectingCallAfter(functionCall);
        }
        return null;
    }

    @Override
    public @NonNull StateSpec getStateSpec() {
        return this.stateSpec;
    }

    @Override
    public StateValue[] getValue() {
        ValueCache value = this.getCachedValue();
        return value.convertedStateValue;
    }

    @Override
    public @Nullable IAssetItem getValueAsAsset() {
        Long assetItemId;
        IStateItemValue<?> stateItemValue;
        ValueCache value = this.getCachedValue();
        IStateItem<?> stateItem = value.stateItem;
        IStateItemValue<Object> iStateItemValue = value.stateItemValue != null ? value.stateItemValue : (stateItemValue = stateItem != null ? stateItem.getDefaultValue() : null);
        if (stateItemValue != null) {
            assert (stateItemValue instanceof IStateItemValueWithAssetValue);
            Object lwAssetValue = ((IStateItemValueWithAssetValue)stateItemValue).getAssetValue();
            assetItemId = lwAssetValue != null ? Long.valueOf(lwAssetValue.getId().asLong()) : null;
        } else {
            assetItemId = AssetProcessorBase.asAssetID(this);
        }
        if (assetItemId == null) {
            return null;
        }
        AssetObjectSpec assetClass = this.stateSpec.getAssetClass();
        if (assetClass == null) {
            return null;
        }
        AssetTableSpec assetTableSpec = assetClass.getAssetTable();
        if (assetTableSpec == null) {
            return null;
        }
        AssetTable assetTable = this.parentMap.getStateSnapshot().getAssetTableBySpec(assetTableSpec);
        return assetTable.get(assetItemId);
    }

    @Override
    public boolean isAffectedBySelectedFunctionCall() {
        return this.isModifiedByCurrentFunction();
    }

    @Override
    public boolean isChanged() {
        return this.getLastAffectedByFunction() != null;
    }

    @Override
    public boolean isModifiedByCurrentFunction() {
        FunctionCall functionCall;
        ValueCache value = this.getCachedValue();
        IStateItem<?> localStateItem = value.stateItem;
        if (localStateItem != null && (functionCall = this.currentFunctionInfo.selectedFunction) != null) {
            return localStateItem.isAffectedBy(functionCall);
        }
        return false;
    }

    private synchronized ValueCache getCachedValue() {
        LightweightStateBridgeCurrentFunctionInfo newState = this.parentMap.getLightweightStateBridge().getCurrentFunctionInfo();
        if (this.cachedValue == null || this.currentFunctionInfo != newState) {
            this.currentFunctionInfo = newState;
            FunctionCall function = this.currentFunctionInfo.selectedFunction;
            if (function != null) {
                IStateItem<?> newStateItem = LightweightStateBridgeStateItem.mapStateSpec(this.currentFunctionInfo.eglStateItems, this.currentFunctionInfo.glesContext, this.stateSpec, function);
                IStateItemValue<?> newStateItemValue = newStateItem != null ? (IStateItemValue<?>)newStateItem.waitForValue(function.getID()) : null;
                this.cachedValue = new ValueCache(newStateItem, newStateItemValue, this.updateConvertedValue(newStateItemValue));
            } else {
                this.cachedValue = new ValueCache(null, null, this.updateConvertedValue(null));
            }
        }
        return (ValueCache)NullUtils.neverNull((Object)this.cachedValue);
    }

    private String getValuesAsString() {
        StringBuilder sb = new StringBuilder();
        ValueCache value = this.getCachedValue();
        StateValue[] convertedStateValue = value.convertedStateValue;
        boolean first = true;
        StateValue[] stateValueArray = convertedStateValue;
        int n = convertedStateValue.length;
        int n2 = 0;
        while (n2 < n) {
            StateValue stateValue = stateValueArray[n2];
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (NumberUtils.isIntNumber(stateValue.value)) {
                Number n3 = (Number)stateValue.value;
                if (n3.longValue() > 65535L) {
                    sb.append("0x" + Long.toHexString(((Number)stateValue.value).longValue()).toUpperCase());
                } else {
                    sb.append(n3);
                }
            } else {
                sb.append(stateValue.value);
            }
            ++n2;
        }
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    private List<@NonNull StateValue> makeStateValues(@Nullable Object o) {
        if (o instanceof AssetItemID) {
            if (this.stateSpec.getStateType().getStateVariableType() == StateVariableTypeSpec.Y) {
                return Arrays.asList(new StateValue(Pointer.valueOf(((AssetItemID)o).asLong())));
            }
            return Arrays.asList(new StateValue(((AssetItemID)o).asLong()));
        }
        if (o instanceof RGBAStateItemValue.RGBA) {
            RGBAStateItemValue.RGBA rgba = (RGBAStateItemValue.RGBA)o;
            return Arrays.asList(new StateValue(Float.valueOf(rgba.r)), new StateValue(Float.valueOf(rgba.g)), new StateValue(Float.valueOf(rgba.b)), new StateValue(Float.valueOf(rgba.a)));
        }
        if (o instanceof Boolean) {
            boolean b = (Boolean)o;
            if (this.stateSpec.getKapiSpec() == KapiSpec.EGL) {
                return Arrays.asList(new StateValue(b ? KapiSpec.EGL.constants.EGL_TRUE : KapiSpec.EGL.constants.EGL_FALSE));
            }
            if (this.stateSpec.getKapiSpec() == KapiSpec.GLES) {
                return Arrays.asList(new StateValue(b ? KapiSpec.GLES.constants.GL_TRUE : KapiSpec.GLES.constants.GL_FALSE));
            }
            return Arrays.asList(new StateValue(o));
        }
        assert (o == null || o instanceof Number || o instanceof String || o instanceof Pointer || o instanceof AbstractConstantOrAliasSpecExtended);
        return Arrays.asList(new StateValue(o));
    }

    private Object readResolve() {
        this.currentFunctionInfo = this.parentMap.getLightweightStateBridge().getCurrentFunctionInfo();
        this.cachedValue = null;
        return this;
    }

    private StateValue[] updateConvertedValue(@Nullable IStateItemValue<?> value) {
        if (value != null && value.hasAffectingFunctions()) {
            return (StateValue[])value.getValues().stream().flatMap(o -> this.makeStateValues(o).stream()).toArray(StateValue[]::new);
        }
        if (!this.stateSpec.getDefaultValue().isEmpty()) {
            return (StateValue[])this.stateSpec.getDefaultValue().stream().map(s -> new StateValue(s.getValue())).toArray(StateValue[]::new);
        }
        int length = this.stateSpec.getStateType().getCardinality() != null ? Math.max(1, this.stateSpec.getStateType().getCardinality().intValue()) : 1;
        Object[] result = new StateValue[length];
        Arrays.fill(result, StateValue.UNKNOWN);
        return result;
    }

    private static class ValueCache {
        public final StateValue[] convertedStateValue;
        public final @Nullable IStateItem<?> stateItem;
        public final @Nullable IStateItemValue<?> stateItemValue;

        public ValueCache(@Nullable IStateItem<?> stateItem, @Nullable IStateItemValue<?> stateItemValue, StateValue[] convertedStateValue) {
            this.stateItem = stateItem;
            this.stateItemValue = stateItemValue;
            this.convertedStateValue = convertedStateValue;
        }
    }
}

