/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.bridge;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.state.TargetStateMap;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.bridge.LightweightStateBridgeCurrentFunctionInfo;
import com.arm.mgd.lightweight.bridge.LightweightStateBridgeTargetStateMap;
import com.arm.mgd.lightweight.model.GlesContext;
import com.arm.mgd.lightweight.model.TracedProcess;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import com.arm.mgd.lightweight.state.egl.gen.EglStateItems;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class LightweightStateBridge {
    private volatile LightweightStateBridgeCurrentFunctionInfo currentState;
    private final TracedProcess lightweightProcessModel;
    private volatile @Nullable FunctionCall targetFunction;
    private final Map<KapiSpec, LightweightStateBridgeTargetStateMap> targetStateMaps;
    private final TraceStateSnapshot traceStateSnapshot;

    public LightweightStateBridge(TraceStateSnapshot traceStateSnapshot) {
        this.traceStateSnapshot = traceStateSnapshot;
        this.lightweightProcessModel = traceStateSnapshot.getModel().getParentProcessTarget().getLightweightProcess();
        this.targetStateMaps = new HashMap<KapiSpec, LightweightStateBridgeTargetStateMap>();
        this.targetFunction = null;
        this.currentState = new LightweightStateBridgeCurrentFunctionInfo(null, null, null);
    }

    public StateItem getStateItemBySpec(StateSpec stateSpec) {
        assert (stateSpec.getKapiSpec() != null);
        return this.getTargetStateMap(stateSpec.getKapiSpec()).getStateItemBySpec(stateSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetStateMap getTargetStateMap(KapiSpec api) {
        Map<KapiSpec, LightweightStateBridgeTargetStateMap> map = this.targetStateMaps;
        synchronized (map) {
            LightweightStateBridgeTargetStateMap result = this.targetStateMaps.get(api);
            if (result == null) {
                result = new LightweightStateBridgeTargetStateMap(api, this);
                this.targetStateMaps.put(api, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@Nullable FunctionCall selectedFunction) {
        LightweightStateBridge lightweightStateBridge = this;
        synchronized (lightweightStateBridge) {
            this.targetFunction = selectedFunction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LightweightStateBridgeCurrentFunctionInfo getCurrentFunctionInfo() {
        if (this.currentState.selectedFunction != this.targetFunction) {
            LightweightStateBridge lightweightStateBridge = this;
            synchronized (lightweightStateBridge) {
                FunctionCall selectedFunction = this.targetFunction;
                if (this.currentState.selectedFunction != selectedFunction) {
                    if (selectedFunction != null) {
                        EglStateItems eglStateItems = null;
                        GlesContext glesContext = null;
                        if (IPushProcessor.waitForFunctionCallToBeProcessed(this.lightweightProcessModel.getEglModel().getProcessor(), selectedFunction, null)) {
                            eglStateItems = this.lightweightProcessModel.getEglModel().getEglStateItemsForThread(selectedFunction);
                            EglContextAsset eglContextAsset = eglStateItems.EGL_CURRENT_CONTEXT.waitForValue(selectedFunction.getID()).getAssetValue();
                            if (eglContextAsset != null) {
                                glesContext = this.lightweightProcessModel.getGlesModel().getContextForEGLContext(eglContextAsset);
                            }
                        }
                        this.currentState = new LightweightStateBridgeCurrentFunctionInfo(eglStateItems, glesContext, selectedFunction);
                    } else {
                        this.currentState = new LightweightStateBridgeCurrentFunctionInfo(null, null, null);
                    }
                }
            }
        }
        return this.currentState;
    }

    TraceStateSnapshot getTraceStateSnapshot() {
        return this.traceStateSnapshot;
    }
}

