/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.DeletableAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.vulkan.VulkanAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.asset.vulkan.IVkAttachmentDescription;
import com.arm.mgd.lightweight.asset.vulkan.IVkSubpassDependency;
import com.arm.mgd.lightweight.asset.vulkan.IVkSubpassDescription;
import com.arm.mgd.lightweight.asset.vulkan.VkRenderPassAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractVkRenderPassAsset
extends AbstractAssetItem<VULKANApi, VkRenderPassAsset.Value> {
    private final ImmutablePropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> attachments;
    private final ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> dependencies;
    private final ImmutablePropertyValue<@NonNull Bitfield> flags;
    private final ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> subpasses;
    private final IAssetItemLifecycleManager<VkRenderPassAsset> lifecycleManager;

    protected AbstractVkRenderPassAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, List<IVkAttachmentDescription> attachments, List<IVkSubpassDependency> dependencies, Bitfield flags, List<IVkSubpassDescription> subpasses) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.attachments = new ImmutablePropertyValue<List<IVkAttachmentDescription>>(this, VkRenderPassAssetProperties.PROPERTY_ATTACHMENTS, attachments);
        this.dependencies = new ImmutablePropertyValue<List<IVkSubpassDependency>>(this, VkRenderPassAssetProperties.PROPERTY_DEPENDENCIES, dependencies);
        this.flags = new ImmutablePropertyValue<Bitfield>(this, VkRenderPassAssetProperties.PROPERTY_FLAGS, flags);
        this.subpasses = new ImmutablePropertyValue<List<IVkSubpassDescription>>(this, VkRenderPassAssetProperties.PROPERTY_SUBPASSES, subpasses);
        this.lifecycleManager = new DeletableAssetLifecycleManager<VkRenderPassAsset>((VkRenderPassAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(VkRenderPassAssetProperties.PROPERTY_ATTACHMENTS, VkRenderPassAssetProperties.PROPERTY_DEPENDENCIES, VkRenderPassAssetProperties.PROPERTY_FLAGS, VkRenderPassAssetProperties.PROPERTY_SUBPASSES));
    }

    public ImmutablePropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> getImmutablePropertyAttachments() {
        return this.attachments;
    }

    public ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> getImmutablePropertyDependencies() {
        return this.dependencies;
    }

    public ImmutablePropertyValue<@NonNull Bitfield> getImmutablePropertyFlags() {
        return this.flags;
    }

    public ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> getImmutablePropertySubpasses() {
        return this.subpasses;
    }

    @Override
    public String getAssetTypeLabel() {
        return "VkRenderPassAsset";
    }

    @Override
    protected VkRenderPassAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkRenderPassAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (VkRenderPassAsset)this, lastCallID);
    }

    @Override
    protected VkRenderPassAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, VkRenderPassAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkRenderPassAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("VkRenderPassAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("attachments = ").append(this.getImmutablePropertyAttachments()).append(", ").append("dependencies = ").append(this.getImmutablePropertyDependencies()).append(", ").append("flags = ").append(this.getImmutablePropertyFlags()).append(", ").append("subpasses = ").append(this.getImmutablePropertySubpasses()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<VkRenderPassAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<VULKANApi, ?>> getImmutablePropertyAssetDependencies() {
        return Collections.emptySet();
    }

    public static abstract class Value
    extends AbstractAssetItemValue<VkRenderPassAsset> {
        private final IAssetPropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> attachments;
        private final IAssetPropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> dependencies;
        private final IAssetPropertyValue<@NonNull Bitfield> flags;
        private final IAssetPropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> subpasses;

        public Value(ClosedFunctionCallIDRange functionCallRange, VkRenderPassAsset assetObject, IAssetPropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> attachments, IAssetPropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> dependencies, IAssetPropertyValue<@NonNull Bitfield> flags, IAssetPropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> subpasses) {
            super(functionCallRange, assetObject, attachments, dependencies, flags, subpasses);
            this.attachments = attachments;
            this.dependencies = dependencies;
            this.flags = flags;
            this.subpasses = subpasses;
        }

        public final IAssetPropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> getAttachments() {
            return this.attachments;
        }

        public final IAssetPropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> getDependencies() {
            return this.dependencies;
        }

        public final IAssetPropertyValue<@NonNull Bitfield> getFlags() {
            return this.flags;
        }

        public final IAssetPropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> getSubpasses() {
            return this.subpasses;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("VkRenderPassAsset#").append(((VkRenderPassAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("attachments = ").append(this.getAttachments()).append(", ").append("dependencies = ").append(this.getDependencies()).append(", ").append("flags = ").append(this.getFlags()).append(", ").append("subpasses = ").append(this.getSubpasses()).append("}");
            return result.toString();
        }
    }

    public static class VkRenderPassAssetProperties {
        public static final SimpleAssetProperty<@NonNull List<@NonNull IVkAttachmentDescription>> PROPERTY_ATTACHMENTS = new SimpleAssetProperty("attachments");
        public static final SimpleAssetProperty<@NonNull List<@NonNull IVkSubpassDependency>> PROPERTY_DEPENDENCIES = new SimpleAssetProperty("dependencies");
        public static final SimpleAssetProperty<@NonNull Bitfield> PROPERTY_FLAGS = new SimpleAssetProperty("flags");
        public static final SimpleAssetProperty<@NonNull List<@NonNull IVkSubpassDescription>> PROPERTY_SUBPASSES = new SimpleAssetProperty("subpasses");
    }
}

