/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.DeletableAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.vulkan.VulkanAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorSetLayoutAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineLayoutAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractVkPipelineLayoutAsset
extends AbstractAssetItem<VULKANApi, VkPipelineLayoutAsset.Value> {
    private final ImmutablePropertyValue<@NonNull Bitfield> flags;
    private final ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> pushConstants;
    private final ImmutablePropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> setLayouts;
    private final IAssetItemLifecycleManager<VkPipelineLayoutAsset> lifecycleManager;

    protected AbstractVkPipelineLayoutAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, Bitfield flags, List<VULKAN.Structs.VkPushConstantRange> pushConstants, List<VkDescriptorSetLayoutAsset> setLayouts) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.flags = new ImmutablePropertyValue<Bitfield>(this, VkPipelineLayoutAssetProperties.PROPERTY_FLAGS, flags);
        this.pushConstants = new ImmutablePropertyValue<List<VULKAN.Structs.VkPushConstantRange>>(this, VkPipelineLayoutAssetProperties.PROPERTY_PUSH_CONSTANTS, pushConstants);
        this.setLayouts = new ImmutablePropertyValue<List<VkDescriptorSetLayoutAsset>>(this, VkPipelineLayoutAssetProperties.PROPERTY_SET_LAYOUTS, setLayouts);
        this.lifecycleManager = new DeletableAssetLifecycleManager<VkPipelineLayoutAsset>((VkPipelineLayoutAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(VkPipelineLayoutAssetProperties.PROPERTY_FLAGS, VkPipelineLayoutAssetProperties.PROPERTY_PUSH_CONSTANTS, VkPipelineLayoutAssetProperties.PROPERTY_SET_LAYOUTS));
    }

    public ImmutablePropertyValue<@NonNull Bitfield> getImmutablePropertyFlags() {
        return this.flags;
    }

    public ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> getImmutablePropertyPushConstants() {
        return this.pushConstants;
    }

    public ImmutablePropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> getImmutablePropertySetLayouts() {
        return this.setLayouts;
    }

    @Override
    public String getAssetTypeLabel() {
        return "VkPipelineLayoutAsset";
    }

    @Override
    protected VkPipelineLayoutAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkPipelineLayoutAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (VkPipelineLayoutAsset)this, lastCallID);
    }

    @Override
    protected VkPipelineLayoutAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, VkPipelineLayoutAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkPipelineLayoutAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("VkPipelineLayoutAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("flags = ").append(this.getImmutablePropertyFlags()).append(", ").append("pushConstants = ").append(this.getImmutablePropertyPushConstants()).append(", ").append("setLayouts = ").append(this.getImmutablePropertySetLayouts()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<VkPipelineLayoutAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<VULKANApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<VULKANApi, ?>> result = new HashSet();
        for (IAssetItem iAssetItem : this.getImmutablePropertySetLayouts().getValue()) {
            if (iAssetItem == null) continue;
            result.add(iAssetItem);
        }
        return result;
    }

    public static abstract class Value
    extends AbstractAssetItemValue<VkPipelineLayoutAsset> {
        private final IAssetPropertyValue<@NonNull Bitfield> flags;
        private final IAssetPropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> pushConstants;
        private final IAssetPropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> setLayouts;

        public Value(ClosedFunctionCallIDRange functionCallRange, VkPipelineLayoutAsset assetObject, IAssetPropertyValue<@NonNull Bitfield> flags, IAssetPropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> pushConstants, IAssetPropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> setLayouts) {
            super(functionCallRange, assetObject, flags, pushConstants, setLayouts);
            this.flags = flags;
            this.pushConstants = pushConstants;
            this.setLayouts = setLayouts;
        }

        public final IAssetPropertyValue<@NonNull Bitfield> getFlags() {
            return this.flags;
        }

        public final IAssetPropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> getPushConstants() {
            return this.pushConstants;
        }

        public final IAssetPropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> getSetLayouts() {
            return this.setLayouts;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("VkPipelineLayoutAsset#").append(((VkPipelineLayoutAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("flags = ").append(this.getFlags()).append(", ").append("pushConstants = ").append(this.getPushConstants()).append(", ").append("setLayouts = ").append(this.getSetLayouts()).append("}");
            return result.toString();
        }
    }

    public static class VkPipelineLayoutAssetProperties {
        public static final SimpleAssetProperty<@NonNull Bitfield> PROPERTY_FLAGS = new SimpleAssetProperty("flags");
        public static final SimpleAssetProperty<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> PROPERTY_PUSH_CONSTANTS = new SimpleAssetProperty("pushConstants");
        public static final SimpleAssetProperty<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> PROPERTY_SET_LAYOUTS = new SimpleAssetProperty("setLayouts");
    }
}

