/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineLayoutAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractVkPipelineAsset<SUB_TYPE extends VkPipelineAsset<SUB_TYPE, VALUE_TYPE>, VALUE_TYPE extends VkPipelineAsset.Value<SUB_TYPE, VALUE_TYPE>>
extends AbstractAssetItem<VULKANApi, VALUE_TYPE> {
    protected AbstractVkPipelineAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId) {
        super(creatingFunctionCall, id, uniqueInstanceId);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(VkPipelineAssetProperties.PROPERTY_BASE_PIPELINE_HANDLE, VkPipelineAssetProperties.PROPERTY_FLAGS, VkPipelineAssetProperties.PROPERTY_LAYOUT));
    }

    @Override
    public String getAssetTypeLabel() {
        return "VkPipelineAsset";
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS.SPEC;
    }

    public abstract String toString();

    @Override
    public abstract IAssetItemLifecycleManager<SUB_TYPE> getLifecycleManager();

    public static abstract class Value<SUB_TYPE extends VkPipelineAsset<SUB_TYPE, VALUE_TYPE>, VALUE_TYPE extends VkPipelineAsset.Value<SUB_TYPE, VALUE_TYPE>>
    extends AbstractAssetItemValue<SUB_TYPE> {
        private final IAssetPropertyValue<@Nullable VkPipelineAsset<?, ?>> basePipelineHandle;
        private final IAssetPropertyValue<@Nullable Long> flags;
        private final IAssetPropertyValue<@Nullable VkPipelineLayoutAsset> layout;

        public Value(ClosedFunctionCallIDRange functionCallRange, SUB_TYPE assetObject, IAssetPropertyValue<@Nullable VkPipelineAsset<?, ?>> basePipelineHandle, IAssetPropertyValue<@Nullable Long> flags, IAssetPropertyValue<@Nullable VkPipelineLayoutAsset> layout, IAssetPropertyValue<?> ... propertyValues) {
            super(functionCallRange, assetObject, Value.join(propertyValues, basePipelineHandle, flags, layout));
            this.basePipelineHandle = basePipelineHandle;
            this.flags = flags;
            this.layout = layout;
        }

        public final IAssetPropertyValue<@Nullable VkPipelineAsset<?, ?>> getBasePipelineHandle() {
            return this.basePipelineHandle;
        }

        public final IAssetPropertyValue<@Nullable Long> getFlags() {
            return this.flags;
        }

        public final IAssetPropertyValue<@Nullable VkPipelineLayoutAsset> getLayout() {
            return this.layout;
        }

        public abstract String toString();
    }

    public static class VkPipelineAssetProperties {
        public static final SimpleAssetProperty<@Nullable VkPipelineAsset<?, ?>> PROPERTY_BASE_PIPELINE_HANDLE = new SimpleAssetProperty("basePipelineHandle");
        public static final SimpleAssetProperty<@Nullable Long> PROPERTY_FLAGS = new SimpleAssetProperty("flags");
        public static final SimpleAssetProperty<@Nullable VkPipelineLayoutAsset> PROPERTY_LAYOUT = new SimpleAssetProperty("layout");
    }
}

