/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.DeletableAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.vulkan.VulkanAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.asset.vulkan.VkImageAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageViewAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractVkImageViewAsset
extends AbstractAssetItem<VULKANApi, VkImageViewAsset.Value> {
    private final ImmutablePropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> components;
    private final ImmutablePropertyValue<@NonNull Bitfield> flags;
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format;
    private final ImmutablePropertyValue<@NonNull VkImageAsset> image;
    private final ImmutablePropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> subresourceRange;
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> viewType;
    private final IAssetItemLifecycleManager<VkImageViewAsset> lifecycleManager;

    protected AbstractVkImageViewAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, VULKAN.Structs.VkComponentMapping components, Bitfield flags, AbstractConstantOrAliasSpecExtended format, VkImageAsset image, VULKAN.Structs.VkImageSubresourceRange subresourceRange, AbstractConstantOrAliasSpecExtended viewType) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.components = new ImmutablePropertyValue<VULKAN.Structs.VkComponentMapping>(this, VkImageViewAssetProperties.PROPERTY_COMPONENTS, components);
        this.flags = new ImmutablePropertyValue<Bitfield>(this, VkImageViewAssetProperties.PROPERTY_FLAGS, flags);
        this.format = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, VkImageViewAssetProperties.PROPERTY_FORMAT, format);
        this.image = new ImmutablePropertyValue<VkImageAsset>(this, VkImageViewAssetProperties.PROPERTY_IMAGE, image);
        this.subresourceRange = new ImmutablePropertyValue<VULKAN.Structs.VkImageSubresourceRange>(this, VkImageViewAssetProperties.PROPERTY_SUBRESOURCE_RANGE, subresourceRange);
        this.viewType = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, VkImageViewAssetProperties.PROPERTY_VIEW_TYPE, viewType);
        this.lifecycleManager = new DeletableAssetLifecycleManager<VkImageViewAsset>((VkImageViewAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(VkImageViewAssetProperties.PROPERTY_COMPONENTS, VkImageViewAssetProperties.PROPERTY_FLAGS, VkImageViewAssetProperties.PROPERTY_FORMAT, VkImageViewAssetProperties.PROPERTY_IMAGE, VkImageViewAssetProperties.PROPERTY_SUBRESOURCE_RANGE, VkImageViewAssetProperties.PROPERTY_VIEW_TYPE));
    }

    public ImmutablePropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> getImmutablePropertyComponents() {
        return this.components;
    }

    public ImmutablePropertyValue<@NonNull Bitfield> getImmutablePropertyFlags() {
        return this.flags;
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyFormat() {
        return this.format;
    }

    public ImmutablePropertyValue<@NonNull VkImageAsset> getImmutablePropertyImage() {
        return this.image;
    }

    public ImmutablePropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> getImmutablePropertySubresourceRange() {
        return this.subresourceRange;
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyViewType() {
        return this.viewType;
    }

    @Override
    public String getAssetTypeLabel() {
        return "VkImageViewAsset";
    }

    @Override
    protected VkImageViewAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkImageViewAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (VkImageViewAsset)this, lastCallID);
    }

    @Override
    protected VkImageViewAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, VkImageViewAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkImageViewAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("VkImageViewAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("components = ").append(this.getImmutablePropertyComponents()).append(", ").append("flags = ").append(this.getImmutablePropertyFlags()).append(", ").append("format = ").append(this.getImmutablePropertyFormat()).append(", ").append("image = ").append(this.getImmutablePropertyImage()).append(", ").append("subresourceRange = ").append(this.getImmutablePropertySubresourceRange()).append(", ").append("viewType = ").append(this.getImmutablePropertyViewType()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<VkImageViewAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<VULKANApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<VULKANApi, ?>> result = new HashSet();
        IAssetItem assetValue = this.getImmutablePropertyImage().getValue();
        if (assetValue != null) {
            result.add(assetValue);
        }
        return result;
    }

    public static abstract class Value
    extends AbstractAssetItemValue<VkImageViewAsset> {
        private final IAssetPropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> components;
        private final IAssetPropertyValue<@NonNull Bitfield> flags;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format;
        private final IAssetPropertyValue<@NonNull VkImageAsset> image;
        private final IAssetPropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> subresourceRange;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> viewType;

        public Value(ClosedFunctionCallIDRange functionCallRange, VkImageViewAsset assetObject, IAssetPropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> components, IAssetPropertyValue<@NonNull Bitfield> flags, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format, IAssetPropertyValue<@NonNull VkImageAsset> image, IAssetPropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> subresourceRange, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> viewType) {
            super(functionCallRange, assetObject, components, flags, format, image, subresourceRange, viewType);
            this.components = components;
            this.flags = flags;
            this.format = format;
            this.image = image;
            this.subresourceRange = subresourceRange;
            this.viewType = viewType;
        }

        public final IAssetPropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> getComponents() {
            return this.components;
        }

        public final IAssetPropertyValue<@NonNull Bitfield> getFlags() {
            return this.flags;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getFormat() {
            return this.format;
        }

        public final IAssetPropertyValue<@NonNull VkImageAsset> getImage() {
            return this.image;
        }

        public final IAssetPropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> getSubresourceRange() {
            return this.subresourceRange;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getViewType() {
            return this.viewType;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("VkImageViewAsset#").append(((VkImageViewAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("components = ").append(this.getComponents()).append(", ").append("flags = ").append(this.getFlags()).append(", ").append("format = ").append(this.getFormat()).append(", ").append("image = ").append(this.getImage()).append(", ").append("subresourceRange = ").append(this.getSubresourceRange()).append(", ").append("viewType = ").append(this.getViewType()).append("}");
            return result.toString();
        }
    }

    public static class VkImageViewAssetProperties {
        public static final SimpleAssetProperty<@NonNull VULKAN.Structs.VkComponentMapping> PROPERTY_COMPONENTS = new SimpleAssetProperty("components");
        public static final SimpleAssetProperty<@NonNull Bitfield> PROPERTY_FLAGS = new SimpleAssetProperty("flags");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_FORMAT = new SimpleAssetProperty("format");
        public static final SimpleAssetProperty<@NonNull VkImageAsset> PROPERTY_IMAGE = new SimpleAssetProperty("image");
        public static final SimpleAssetProperty<@NonNull VULKAN.Structs.VkImageSubresourceRange> PROPERTY_SUBRESOURCE_RANGE = new SimpleAssetProperty("subresourceRange");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_VIEW_TYPE = new SimpleAssetProperty("viewType");
    }
}

