/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.DeletableAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.vulkan.VulkanAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.asset.vulkan.VkFramebufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageViewAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkRenderPassAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractVkFramebufferAsset
extends AbstractAssetItem<VULKANApi, VkFramebufferAsset.Value> {
    private final ImmutablePropertyValue<@NonNull List<@NonNull VkImageViewAsset>> attachments;
    private final ImmutablePropertyValue<@NonNull Bitfield> flags;
    private final ImmutablePropertyValue<@NonNull Long> height;
    private final ImmutablePropertyValue<@NonNull Long> layers;
    private final ImmutablePropertyValue<@NonNull VkRenderPassAsset> renderPass;
    private final ImmutablePropertyValue<@NonNull Long> width;
    private final IAssetItemLifecycleManager<VkFramebufferAsset> lifecycleManager;

    protected AbstractVkFramebufferAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, List<VkImageViewAsset> attachments, Bitfield flags, long height, long layers, VkRenderPassAsset renderPass, long width) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.attachments = new ImmutablePropertyValue<List<VkImageViewAsset>>(this, VkFramebufferAssetProperties.PROPERTY_ATTACHMENTS, attachments);
        this.flags = new ImmutablePropertyValue<Bitfield>(this, VkFramebufferAssetProperties.PROPERTY_FLAGS, flags);
        this.height = new ImmutablePropertyValue<Long>(this, VkFramebufferAssetProperties.PROPERTY_HEIGHT, height);
        this.layers = new ImmutablePropertyValue<Long>(this, VkFramebufferAssetProperties.PROPERTY_LAYERS, layers);
        this.renderPass = new ImmutablePropertyValue<VkRenderPassAsset>(this, VkFramebufferAssetProperties.PROPERTY_RENDER_PASS, renderPass);
        this.width = new ImmutablePropertyValue<Long>(this, VkFramebufferAssetProperties.PROPERTY_WIDTH, width);
        this.lifecycleManager = new DeletableAssetLifecycleManager<VkFramebufferAsset>((VkFramebufferAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(VkFramebufferAssetProperties.PROPERTY_ATTACHMENTS, VkFramebufferAssetProperties.PROPERTY_FLAGS, VkFramebufferAssetProperties.PROPERTY_HEIGHT, VkFramebufferAssetProperties.PROPERTY_LAYERS, VkFramebufferAssetProperties.PROPERTY_RENDER_PASS, VkFramebufferAssetProperties.PROPERTY_WIDTH));
    }

    public ImmutablePropertyValue<@NonNull List<@NonNull VkImageViewAsset>> getImmutablePropertyAttachments() {
        return this.attachments;
    }

    public ImmutablePropertyValue<@NonNull Bitfield> getImmutablePropertyFlags() {
        return this.flags;
    }

    public ImmutablePropertyValue<@NonNull Long> getImmutablePropertyHeight() {
        return this.height;
    }

    public ImmutablePropertyValue<@NonNull Long> getImmutablePropertyLayers() {
        return this.layers;
    }

    public ImmutablePropertyValue<@NonNull VkRenderPassAsset> getImmutablePropertyRenderPass() {
        return this.renderPass;
    }

    public ImmutablePropertyValue<@NonNull Long> getImmutablePropertyWidth() {
        return this.width;
    }

    @Override
    public String getAssetTypeLabel() {
        return "VkFramebufferAsset";
    }

    @Override
    protected VkFramebufferAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkFramebufferAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (VkFramebufferAsset)this, lastCallID);
    }

    @Override
    protected VkFramebufferAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, VkFramebufferAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkFramebufferAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("VkFramebufferAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("attachments = ").append(this.getImmutablePropertyAttachments()).append(", ").append("flags = ").append(this.getImmutablePropertyFlags()).append(", ").append("height = ").append(this.getImmutablePropertyHeight()).append(", ").append("layers = ").append(this.getImmutablePropertyLayers()).append(", ").append("renderPass = ").append(this.getImmutablePropertyRenderPass()).append(", ").append("width = ").append(this.getImmutablePropertyWidth()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<VkFramebufferAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<VULKANApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<VULKANApi, ?>> result = new HashSet();
        for (IAssetItem iAssetItem : this.getImmutablePropertyAttachments().getValue()) {
            if (iAssetItem == null) continue;
            result.add(iAssetItem);
        }
        IAssetItem iAssetItem = this.getImmutablePropertyRenderPass().getValue();
        if (iAssetItem != null) {
            result.add(iAssetItem);
        }
        return result;
    }

    public static abstract class Value
    extends AbstractAssetItemValue<VkFramebufferAsset> {
        private final IAssetPropertyValue<@NonNull List<@NonNull VkImageViewAsset>> attachments;
        private final IAssetPropertyValue<@NonNull Bitfield> flags;
        private final IAssetPropertyValue<@NonNull Long> height;
        private final IAssetPropertyValue<@NonNull Long> layers;
        private final IAssetPropertyValue<@NonNull VkRenderPassAsset> renderPass;
        private final IAssetPropertyValue<@NonNull Long> width;

        public Value(ClosedFunctionCallIDRange functionCallRange, VkFramebufferAsset assetObject, IAssetPropertyValue<@NonNull List<@NonNull VkImageViewAsset>> attachments, IAssetPropertyValue<@NonNull Bitfield> flags, IAssetPropertyValue<@NonNull Long> height, IAssetPropertyValue<@NonNull Long> layers, IAssetPropertyValue<@NonNull VkRenderPassAsset> renderPass, IAssetPropertyValue<@NonNull Long> width) {
            super(functionCallRange, assetObject, attachments, flags, height, layers, renderPass, width);
            this.attachments = attachments;
            this.flags = flags;
            this.height = height;
            this.layers = layers;
            this.renderPass = renderPass;
            this.width = width;
        }

        public final IAssetPropertyValue<@NonNull List<@NonNull VkImageViewAsset>> getAttachments() {
            return this.attachments;
        }

        public final IAssetPropertyValue<@NonNull Bitfield> getFlags() {
            return this.flags;
        }

        public final IAssetPropertyValue<@NonNull Long> getHeight() {
            return this.height;
        }

        public final IAssetPropertyValue<@NonNull Long> getLayers() {
            return this.layers;
        }

        public final IAssetPropertyValue<@NonNull VkRenderPassAsset> getRenderPass() {
            return this.renderPass;
        }

        public final IAssetPropertyValue<@NonNull Long> getWidth() {
            return this.width;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("VkFramebufferAsset#").append(((VkFramebufferAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("attachments = ").append(this.getAttachments()).append(", ").append("flags = ").append(this.getFlags()).append(", ").append("height = ").append(this.getHeight()).append(", ").append("layers = ").append(this.getLayers()).append(", ").append("renderPass = ").append(this.getRenderPass()).append(", ").append("width = ").append(this.getWidth()).append("}");
            return result.toString();
        }
    }

    public static class VkFramebufferAssetProperties {
        public static final SimpleAssetProperty<@NonNull List<@NonNull VkImageViewAsset>> PROPERTY_ATTACHMENTS = new SimpleAssetProperty("attachments");
        public static final SimpleAssetProperty<@NonNull Bitfield> PROPERTY_FLAGS = new SimpleAssetProperty("flags");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_HEIGHT = new SimpleAssetProperty("height");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_LAYERS = new SimpleAssetProperty("layers");
        public static final SimpleAssetProperty<@NonNull VkRenderPassAsset> PROPERTY_RENDER_PASS = new SimpleAssetProperty("renderPass");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_WIDTH = new SimpleAssetProperty("width");
    }
}

