/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.DeletableAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.vulkan.VulkanAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.asset.vulkan.VkDeviceMemoryAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractVkDeviceMemoryAsset
extends AbstractAssetItem<VULKANApi, VkDeviceMemoryAsset.Value> {
    private final ImmutablePropertyValue<@NonNull Long> allocationSize;
    private final ImmutablePropertyValue<@NonNull Long> memoryTypeIndex;
    private final IAssetItemLifecycleManager<VkDeviceMemoryAsset> lifecycleManager;

    protected AbstractVkDeviceMemoryAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, long allocationSize, long memoryTypeIndex) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.allocationSize = new ImmutablePropertyValue<Long>(this, VkDeviceMemoryAssetProperties.PROPERTY_ALLOCATION_SIZE, allocationSize);
        this.memoryTypeIndex = new ImmutablePropertyValue<Long>(this, VkDeviceMemoryAssetProperties.PROPERTY_MEMORY_TYPE_INDEX, memoryTypeIndex);
        this.lifecycleManager = new DeletableAssetLifecycleManager<VkDeviceMemoryAsset>((VkDeviceMemoryAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(VkDeviceMemoryAssetProperties.PROPERTY_ALLOCATION_SIZE, VkDeviceMemoryAssetProperties.PROPERTY_MEMORY_TYPE_INDEX));
    }

    public ImmutablePropertyValue<@NonNull Long> getImmutablePropertyAllocationSize() {
        return this.allocationSize;
    }

    public ImmutablePropertyValue<@NonNull Long> getImmutablePropertyMemoryTypeIndex() {
        return this.memoryTypeIndex;
    }

    @Override
    public String getAssetTypeLabel() {
        return "VkDeviceMemoryAsset";
    }

    @Override
    protected VkDeviceMemoryAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkDeviceMemoryAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (VkDeviceMemoryAsset)this, lastCallID);
    }

    @Override
    protected VkDeviceMemoryAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, VkDeviceMemoryAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkDeviceMemoryAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("VkDeviceMemoryAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("allocationSize = ").append(this.getImmutablePropertyAllocationSize()).append(", ").append("memoryTypeIndex = ").append(this.getImmutablePropertyMemoryTypeIndex()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<VkDeviceMemoryAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<VULKANApi, ?>> getImmutablePropertyAssetDependencies() {
        return Collections.emptySet();
    }

    public static abstract class Value
    extends AbstractAssetItemValue<VkDeviceMemoryAsset> {
        private final IAssetPropertyValue<@NonNull Long> allocationSize;
        private final IAssetPropertyValue<@NonNull Long> memoryTypeIndex;

        public Value(ClosedFunctionCallIDRange functionCallRange, VkDeviceMemoryAsset assetObject, IAssetPropertyValue<@NonNull Long> allocationSize, IAssetPropertyValue<@NonNull Long> memoryTypeIndex) {
            super(functionCallRange, assetObject, allocationSize, memoryTypeIndex);
            this.allocationSize = allocationSize;
            this.memoryTypeIndex = memoryTypeIndex;
        }

        public final IAssetPropertyValue<@NonNull Long> getAllocationSize() {
            return this.allocationSize;
        }

        public final IAssetPropertyValue<@NonNull Long> getMemoryTypeIndex() {
            return this.memoryTypeIndex;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("VkDeviceMemoryAsset#").append(((VkDeviceMemoryAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("allocationSize = ").append(this.getAllocationSize()).append(", ").append("memoryTypeIndex = ").append(this.getMemoryTypeIndex()).append("}");
            return result.toString();
        }
    }

    public static class VkDeviceMemoryAssetProperties {
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_ALLOCATION_SIZE = new SimpleAssetProperty("allocationSize");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_MEMORY_TYPE_INDEX = new SimpleAssetProperty("memoryTypeIndex");
    }
}

