/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.DeletableAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.vulkan.VulkanAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferViewAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractVkBufferViewAsset
extends AbstractAssetItem<VULKANApi, VkBufferViewAsset.Value> {
    private final ImmutablePropertyValue<@NonNull VkBufferAsset> buffer;
    private final ImmutablePropertyValue<@NonNull Bitfield> flags;
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format;
    private final ImmutablePropertyValue<@NonNull Long> offset;
    private final ImmutablePropertyValue<@NonNull Long> range;
    private final IAssetItemLifecycleManager<VkBufferViewAsset> lifecycleManager;

    protected AbstractVkBufferViewAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, VkBufferAsset buffer, Bitfield flags, AbstractConstantOrAliasSpecExtended format, long offset, long range) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.buffer = new ImmutablePropertyValue<VkBufferAsset>(this, VkBufferViewAssetProperties.PROPERTY_BUFFER, buffer);
        this.flags = new ImmutablePropertyValue<Bitfield>(this, VkBufferViewAssetProperties.PROPERTY_FLAGS, flags);
        this.format = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, VkBufferViewAssetProperties.PROPERTY_FORMAT, format);
        this.offset = new ImmutablePropertyValue<Long>(this, VkBufferViewAssetProperties.PROPERTY_OFFSET, offset);
        this.range = new ImmutablePropertyValue<Long>(this, VkBufferViewAssetProperties.PROPERTY_RANGE, range);
        this.lifecycleManager = new DeletableAssetLifecycleManager<VkBufferViewAsset>((VkBufferViewAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(VkBufferViewAssetProperties.PROPERTY_BUFFER, VkBufferViewAssetProperties.PROPERTY_FLAGS, VkBufferViewAssetProperties.PROPERTY_FORMAT, VkBufferViewAssetProperties.PROPERTY_OFFSET, VkBufferViewAssetProperties.PROPERTY_RANGE));
    }

    public ImmutablePropertyValue<@NonNull VkBufferAsset> getImmutablePropertyBuffer() {
        return this.buffer;
    }

    public ImmutablePropertyValue<@NonNull Bitfield> getImmutablePropertyFlags() {
        return this.flags;
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertyFormat() {
        return this.format;
    }

    public ImmutablePropertyValue<@NonNull Long> getImmutablePropertyOffset() {
        return this.offset;
    }

    public ImmutablePropertyValue<@NonNull Long> getImmutablePropertyRange() {
        return this.range;
    }

    @Override
    public String getAssetTypeLabel() {
        return "VkBufferViewAsset";
    }

    @Override
    protected VkBufferViewAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkBufferViewAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (VkBufferViewAsset)this, lastCallID);
    }

    @Override
    protected VkBufferViewAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, VkBufferViewAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkBufferViewAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("VkBufferViewAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("buffer = ").append(this.getImmutablePropertyBuffer()).append(", ").append("flags = ").append(this.getImmutablePropertyFlags()).append(", ").append("format = ").append(this.getImmutablePropertyFormat()).append(", ").append("offset = ").append(this.getImmutablePropertyOffset()).append(", ").append("range = ").append(this.getImmutablePropertyRange()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<VkBufferViewAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<VULKANApi, ?>> getImmutablePropertyAssetDependencies() {
        HashSet<@NonNull IAssetItem<VULKANApi, ?>> result = new HashSet();
        IAssetItem assetValue = this.getImmutablePropertyBuffer().getValue();
        if (assetValue != null) {
            result.add(assetValue);
        }
        return result;
    }

    public static abstract class Value
    extends AbstractAssetItemValue<VkBufferViewAsset> {
        private final IAssetPropertyValue<@NonNull VkBufferAsset> buffer;
        private final IAssetPropertyValue<@NonNull Bitfield> flags;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format;
        private final IAssetPropertyValue<@NonNull Long> offset;
        private final IAssetPropertyValue<@NonNull Long> range;

        public Value(ClosedFunctionCallIDRange functionCallRange, VkBufferViewAsset assetObject, IAssetPropertyValue<@NonNull VkBufferAsset> buffer, IAssetPropertyValue<@NonNull Bitfield> flags, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format, IAssetPropertyValue<@NonNull Long> offset, IAssetPropertyValue<@NonNull Long> range) {
            super(functionCallRange, assetObject, buffer, flags, format, offset, range);
            this.buffer = buffer;
            this.flags = flags;
            this.format = format;
            this.offset = offset;
            this.range = range;
        }

        public final IAssetPropertyValue<@NonNull VkBufferAsset> getBuffer() {
            return this.buffer;
        }

        public final IAssetPropertyValue<@NonNull Bitfield> getFlags() {
            return this.flags;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getFormat() {
            return this.format;
        }

        public final IAssetPropertyValue<@NonNull Long> getOffset() {
            return this.offset;
        }

        public final IAssetPropertyValue<@NonNull Long> getRange() {
            return this.range;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("VkBufferViewAsset#").append(((VkBufferViewAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("buffer = ").append(this.getBuffer()).append(", ").append("flags = ").append(this.getFlags()).append(", ").append("format = ").append(this.getFormat()).append(", ").append("offset = ").append(this.getOffset()).append(", ").append("range = ").append(this.getRange()).append("}");
            return result.toString();
        }
    }

    public static class VkBufferViewAssetProperties {
        public static final SimpleAssetProperty<@NonNull VkBufferAsset> PROPERTY_BUFFER = new SimpleAssetProperty("buffer");
        public static final SimpleAssetProperty<@NonNull Bitfield> PROPERTY_FLAGS = new SimpleAssetProperty("flags");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_FORMAT = new SimpleAssetProperty("format");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_OFFSET = new SimpleAssetProperty("offset");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_RANGE = new SimpleAssetProperty("range");
    }
}

