/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan.gen;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItemValue;
import com.arm.mgd.lightweight.asset.lifecycle.DeletableAssetLifecycleManager;
import com.arm.mgd.lightweight.asset.lifecycle.IAssetItemLifecycleManager;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.vulkan.VulkanAssetValueProcessor;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimpleAssetProperty;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractVkBufferAsset
extends AbstractAssetItem<VULKANApi, VkBufferAsset.Value> {
    private final ImmutablePropertyValue<@NonNull Bitfield> flags;
    private final ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices;
    private final ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode;
    private final ImmutablePropertyValue<@NonNull Long> size;
    private final ImmutablePropertyValue<@NonNull Bitfield> usage;
    private final IAssetItemLifecycleManager<VkBufferAsset> lifecycleManager;

    protected AbstractVkBufferAsset(FunctionCall creatingFunctionCall, AssetItemID id, UniqueInstanceId uniqueInstanceId, Bitfield flags, LongsArgAttachment queueFamilyIndices, AbstractConstantOrAliasSpecExtended sharingMode, long size, Bitfield usage) {
        super(creatingFunctionCall, id, uniqueInstanceId);
        this.flags = new ImmutablePropertyValue<Bitfield>(this, VkBufferAssetProperties.PROPERTY_FLAGS, flags);
        this.queueFamilyIndices = new ImmutablePropertyValue<LongsArgAttachment>(this, VkBufferAssetProperties.PROPERTY_QUEUE_FAMILY_INDICES, queueFamilyIndices);
        this.sharingMode = new ImmutablePropertyValue<AbstractConstantOrAliasSpecExtended>(this, VkBufferAssetProperties.PROPERTY_SHARING_MODE, sharingMode);
        this.size = new ImmutablePropertyValue<Long>(this, VkBufferAssetProperties.PROPERTY_SIZE, size);
        this.usage = new ImmutablePropertyValue<Bitfield>(this, VkBufferAssetProperties.PROPERTY_USAGE, usage);
        this.lifecycleManager = new DeletableAssetLifecycleManager<VkBufferAsset>((VkBufferAsset)this, this.lifecycleManagerPrivateInterface, false);
    }

    @Override
    public List<IAssetProperty<?>> getAllProperties() {
        return Collections.unmodifiableList(Arrays.asList(VkBufferAssetProperties.PROPERTY_FLAGS, VkBufferAssetProperties.PROPERTY_QUEUE_FAMILY_INDICES, VkBufferAssetProperties.PROPERTY_SHARING_MODE, VkBufferAssetProperties.PROPERTY_SIZE, VkBufferAssetProperties.PROPERTY_USAGE));
    }

    public ImmutablePropertyValue<@NonNull Bitfield> getImmutablePropertyFlags() {
        return this.flags;
    }

    public ImmutablePropertyValue<@NonNull LongsArgAttachment> getImmutablePropertyQueueFamilyIndices() {
        return this.queueFamilyIndices;
    }

    public ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getImmutablePropertySharingMode() {
        return this.sharingMode;
    }

    public ImmutablePropertyValue<@NonNull Long> getImmutablePropertySize() {
        return this.size;
    }

    public ImmutablePropertyValue<@NonNull Bitfield> getImmutablePropertyUsage() {
        return this.usage;
    }

    @Override
    public String getAssetTypeLabel() {
        return "VkBufferAsset";
    }

    @Override
    protected VkBufferAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkBufferAssetValueProcessor.INSTANCE.execute(callbacks, progressMonitor, (VkBufferAsset)this, lastCallID);
    }

    @Override
    protected VkBufferAsset.Value executeLightweightValueProcessor(ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, ICoreProgressMonitor progressMonitor, VkBufferAsset.Value fromValue, FunctionCallID lastCallID) throws Exception {
        return VulkanAssetValueProcessor.VkBufferAssetValueProcessor.INSTANCE.update(callbacks, progressMonitor, fromValue, lastCallID);
    }

    @Override
    public AssetTableSpec getAssetTableSpec() {
        return KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("VkBufferAsset#").append(this.getId()).append("@").append(this.getCreatingFunction()).append("{").append("flags = ").append(this.getImmutablePropertyFlags()).append(", ").append("queueFamilyIndices = ").append(this.getImmutablePropertyQueueFamilyIndices()).append(", ").append("sharingMode = ").append(this.getImmutablePropertySharingMode()).append(", ").append("size = ").append(this.getImmutablePropertySize()).append(", ").append("usage = ").append(this.getImmutablePropertyUsage()).append("}");
        return result.toString();
    }

    @Override
    public IAssetItemLifecycleManager<VkBufferAsset> getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public @NonNull Set<@NonNull IAssetItem<VULKANApi, ?>> getImmutablePropertyAssetDependencies() {
        return Collections.emptySet();
    }

    public static abstract class Value
    extends AbstractAssetItemValue<VkBufferAsset> {
        private final IAssetPropertyValue<@NonNull Bitfield> flags;
        private final IAssetPropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices;
        private final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode;
        private final IAssetPropertyValue<@NonNull Long> size;
        private final IAssetPropertyValue<@NonNull Bitfield> usage;

        public Value(ClosedFunctionCallIDRange functionCallRange, VkBufferAsset assetObject, IAssetPropertyValue<@NonNull Bitfield> flags, IAssetPropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices, IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode, IAssetPropertyValue<@NonNull Long> size, IAssetPropertyValue<@NonNull Bitfield> usage) {
            super(functionCallRange, assetObject, flags, queueFamilyIndices, sharingMode, size, usage);
            this.flags = flags;
            this.queueFamilyIndices = queueFamilyIndices;
            this.sharingMode = sharingMode;
            this.size = size;
            this.usage = usage;
        }

        public final IAssetPropertyValue<@NonNull Bitfield> getFlags() {
            return this.flags;
        }

        public final IAssetPropertyValue<@NonNull LongsArgAttachment> getQueueFamilyIndices() {
            return this.queueFamilyIndices;
        }

        public final IAssetPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> getSharingMode() {
            return this.sharingMode;
        }

        public final IAssetPropertyValue<@NonNull Long> getSize() {
            return this.size;
        }

        public final IAssetPropertyValue<@NonNull Bitfield> getUsage() {
            return this.usage;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("VkBufferAsset#").append(((VkBufferAsset)this.getAssetObject()).getId()).append(".Value@").append(this.getValidFunctionCallRange()).append("{").append("flags = ").append(this.getFlags()).append(", ").append("queueFamilyIndices = ").append(this.getQueueFamilyIndices()).append(", ").append("sharingMode = ").append(this.getSharingMode()).append(", ").append("size = ").append(this.getSize()).append(", ").append("usage = ").append(this.getUsage()).append("}");
            return result.toString();
        }
    }

    public static class VkBufferAssetProperties {
        public static final SimpleAssetProperty<@NonNull Bitfield> PROPERTY_FLAGS = new SimpleAssetProperty("flags");
        public static final SimpleAssetProperty<@NonNull LongsArgAttachment> PROPERTY_QUEUE_FAMILY_INDICES = new SimpleAssetProperty("queueFamilyIndices");
        public static final SimpleAssetProperty<@NonNull AbstractConstantOrAliasSpecExtended> PROPERTY_SHARING_MODE = new SimpleAssetProperty("sharingMode");
        public static final SimpleAssetProperty<@NonNull Long> PROPERTY_SIZE = new SimpleAssetProperty("size");
        public static final SimpleAssetProperty<@NonNull Bitfield> PROPERTY_USAGE = new SimpleAssetProperty("usage");
    }
}

