/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.vulkan;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AbstractAssetContainerMap;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferViewAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkCommandBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorPoolAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorSetAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorSetLayoutAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDeviceMemoryAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkFramebufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageViewAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineLayoutAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkRenderPassAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkShaderModuleAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkSwapchainKHRAsset;
import com.arm.mgd.lightweight.model.VulkanModel;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class AllVulkanAssets {

    public static final class CurrentAssetProvider {
        private final @NonNull VulkanModel apiModel;

        public CurrentAssetProvider(@NonNull VulkanModel apiModel) {
            this.apiModel = apiModel;
        }

        private @NonNull GlobalAssets getGlobalAssets() {
            return this.apiModel.getGlobalAssets();
        }

        public @Nullable VkBufferAsset getVkBufferAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkBufferAsset result = this.getGlobalAssets().getLastVkBufferAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkBufferViewAsset getVkBufferViewAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkBufferViewAsset result = this.getGlobalAssets().getLastVkBufferViewAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkCommandBufferAsset getVkCommandBufferAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkCommandBufferAsset result = this.getGlobalAssets().getLastVkCommandBufferAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkDescriptorPoolAsset getVkDescriptorPoolAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkDescriptorPoolAsset result = this.getGlobalAssets().getLastVkDescriptorPoolAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkDescriptorSetAsset getVkDescriptorSetAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkDescriptorSetAsset result = this.getGlobalAssets().getLastVkDescriptorSetAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkDescriptorSetLayoutAsset getVkDescriptorSetLayoutAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkDescriptorSetLayoutAsset result = this.getGlobalAssets().getLastVkDescriptorSetLayoutAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkDeviceMemoryAsset getVkDeviceMemoryAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkDeviceMemoryAsset result = this.getGlobalAssets().getLastVkDeviceMemoryAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkFramebufferAsset getVkFramebufferAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkFramebufferAsset result = this.getGlobalAssets().getLastVkFramebufferAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkImageAsset getVkImageAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkImageAsset result = this.getGlobalAssets().getLastVkImageAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkImageViewAsset getVkImageViewAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkImageViewAsset result = this.getGlobalAssets().getLastVkImageViewAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkPipelineAsset getVkPipelineAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkPipelineAsset result = this.getGlobalAssets().getLastVkPipelineAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkPipelineLayoutAsset getVkPipelineLayoutAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkPipelineLayoutAsset result = this.getGlobalAssets().getLastVkPipelineLayoutAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkRenderPassAsset getVkRenderPassAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkRenderPassAsset result = this.getGlobalAssets().getLastVkRenderPassAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkShaderModuleAsset getVkShaderModuleAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkShaderModuleAsset result = this.getGlobalAssets().getLastVkShaderModuleAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }

        public @Nullable VkSwapchainKHRAsset getVkSwapchainKHRAssetAt(@NonNull FunctionCall functionCall, @NonNull AssetItemID id, boolean live) {
            VkSwapchainKHRAsset result = this.getGlobalAssets().getLastVkSwapchainKHRAssetBefore(id, functionCall.getID(), live);
            if (result == null || live && !result.getLifecycleManager().isAssetLive(functionCall.getID()) || !live && !result.getLifecycleManager().isAssetRetained(functionCall.getID())) {
                return null;
            }
            return result;
        }
    }

    public static final class GlobalAssets
    extends AbstractAssetContainerMap<IAssetItem<VULKANApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            if (KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            if (KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS.SPEC.equals(assetTableSpec)) {
                return true;
            }
            return KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS.SPEC.equals(assetTableSpec);
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            if (VkBufferAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkBufferViewAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkCommandBufferAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkDescriptorPoolAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkDescriptorSetAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkDescriptorSetLayoutAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkDeviceMemoryAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkFramebufferAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkImageAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkImageViewAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkPipelineAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkPipelineLayoutAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkRenderPassAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            if (VkShaderModuleAsset.class.isAssignableFrom(assetClass)) {
                return true;
            }
            return VkSwapchainKHRAsset.class.isAssignableFrom(assetClass);
        }

        public @Nullable VkBufferAsset getLastVkBufferAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkBufferViewAsset getLastVkBufferViewAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkCommandBufferAsset getLastVkCommandBufferAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkDescriptorPoolAsset getLastVkDescriptorPoolAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkDescriptorSetAsset getLastVkDescriptorSetAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkDescriptorSetLayoutAsset getLastVkDescriptorSetLayoutAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkDeviceMemoryAsset getLastVkDeviceMemoryAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkFramebufferAsset getLastVkFramebufferAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkImageAsset getLastVkImageAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkImageViewAsset getLastVkImageViewAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkPipelineAsset getLastVkPipelineAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkPipelineLayoutAsset getLastVkPipelineLayoutAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkRenderPassAsset getLastVkRenderPassAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkShaderModuleAsset getLastVkShaderModuleAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS, id, functionCallID, live);
        }

        public @Nullable VkSwapchainKHRAsset getLastVkSwapchainKHRAssetBefore(AssetItemID id, FunctionCallID functionCallID, boolean live) {
            return this.getLastAssetBefore(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS, id, functionCallID, live);
        }
    }

    public static final class PerContextAssets
    extends AbstractAssetContainerMap<IAssetItem<VULKANApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            return false;
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            return false;
        }
    }

    public static final class PerContextGroupAssets
    extends AbstractAssetContainerMap<IAssetItem<VULKANApi, ?>> {
        @Override
        public boolean isAcceptableClass(AssetTableSpec assetTableSpec) {
            return false;
        }

        @Override
        public <T extends IAssetItem<?, ?>> boolean isAcceptableClass(Class<T> assetClass) {
            return false;
        }
    }
}

