/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.properties;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.NumberValueConverter;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.asset.gles.ShaderUniform;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractShaderUniform;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ShaderUniformValuePropertyValue
extends AbstractAssetPropertyValue<Number[][]> {
    private final int arrayLength;
    private final int elementLength;
    private @NonNull AbstractConstantOrAliasSpecExtended type;
    private final Number[][] value;
    private final @Nullable NumberValueConverter<?> valueConverter;

    public ShaderUniformValuePropertyValue(@NonNull IAssetPropertyValue<Number[][]> cloneProperty) {
        super(cloneProperty);
        ShaderUniformValuePropertyValue that = (ShaderUniformValuePropertyValue)cloneProperty;
        this.arrayLength = that.arrayLength;
        this.elementLength = that.elementLength;
        this.type = that.type;
        this.value = new Number[this.arrayLength > 1 ? this.arrayLength : 1][this.elementLength > 1 ? this.elementLength : 1];
        this.valueConverter = that.valueConverter;
        Number[][] newValue = cloneProperty.getValue();
        int i = 0;
        while (i < this.value.length) {
            this.value[i] = this.mapAndValidateValue(newValue[i]);
            ++i;
        }
    }

    public ShaderUniformValuePropertyValue(@NonNull ShaderUniform assetObject) {
        super(assetObject, AbstractShaderUniform.ShaderUniformProperties.PROPERTY_VALUE);
        this.type = assetObject.getImmutablePropertyType().getValue();
        this.arrayLength = Math.max(1, assetObject.getImmutablePropertyArrayLength().getValue());
        this.elementLength = Math.max(1, assetObject.getImmutablePropertyElementLength().getValue());
        if (this.type.getCtype() != null) {
            this.valueConverter = this.type.getCtype().getValueConverter();
            this.value = new Number[this.arrayLength > 1 ? this.arrayLength : 1][this.elementLength > 1 ? this.elementLength : 1];
            Number[] defaultValues = this.type.createZeroNumberArray(1);
            assert (defaultValues != null);
            assert (defaultValues.length == this.elementLength);
            int index = 0;
            while (index < this.arrayLength) {
                System.arraycopy(defaultValues, 0, this.value[index], 0, this.elementLength);
                ++index;
            }
        } else {
            this.valueConverter = null;
            this.value = new Number[this.arrayLength > 1 ? this.arrayLength : 1][this.elementLength > 1 ? this.elementLength : 1];
            int index = 0;
            while (index < this.arrayLength) {
                Arrays.fill(this.value[index], Float.valueOf(0.0f));
                ++index;
            }
        }
    }

    @Override
    public @NonNull Number @NonNull [] @NonNull [] getValue() {
        return this.value;
    }

    public @NonNull Number @NonNull [] getValue(int index) {
        return this.value[index];
    }

    public synchronized void setValue(@NonNull FunctionCall functionCall, int index, Number[] value) {
        this.addAffectingFunctionCall(functionCall);
        this.value[index] = this.mapAndValidateValue(value);
    }

    public void setValue(@NonNull FunctionCall functionCall, Number[] allValues) {
        int expectedLength = this.arrayLength * this.elementLength;
        if (allValues == null || allValues.length != expectedLength) {
            assert (false) : "Unexpected data length in ShaderUniformValuePropertyValue.setValue: " + expectedLength + " vs " + (allValues != null ? allValues.length : 0);
            return;
        }
        this.addAffectingFunctionCall(functionCall);
        Number[] slice = new Number[this.elementLength];
        int i = 0;
        while (i < this.arrayLength) {
            System.arraycopy(allValues, i * this.elementLength, slice, 0, this.elementLength);
            this.value[i] = this.mapAndValidateValue(slice);
            ++i;
        }
    }

    public synchronized void setValueFrom(@NonNull FunctionCall functionCall, @NonNull IAssetPropertyValue<Number[][]> thatProperty) {
        this.addAffectingFunctionCall(functionCall);
        Number[][] newValue = thatProperty.getValue();
        int i = 0;
        while (i < this.value.length) {
            this.value[i] = this.mapAndValidateValue(newValue[i]);
            ++i;
        }
    }

    @Override
    public String toString() {
        int mElementCount;
        int mLoopCount;
        boolean isMatrix;
        StringBuilder result = new StringBuilder();
        ShaderUniform uniform = (ShaderUniform)this.assetObject;
        boolean isArray = this.arrayLength > 1;
        int mColumns = this.type.getNumberOfColumnsAsInt();
        int mRows = this.type.getNumberOfRowsAsInt();
        boolean rowMajor = uniform.getUniformDescriptor().resolveIsRowMajor();
        boolean bl = isMatrix = mColumns > 1 && mRows > 1;
        int n = isMatrix ? (rowMajor ? mColumns : mRows) : (mLoopCount = 1);
        int n2 = isMatrix ? (rowMajor ? mRows : mColumns) : (mElementCount = Math.max(mRows, mColumns));
        if (isArray) {
            result.append("[");
        }
        int i = 0;
        while (i < this.arrayLength) {
            Number[] oneValue = this.value[i];
            if (isMatrix) {
                result.append("[");
            }
            int r = 0;
            while (r < mLoopCount) {
                if (r > 0) {
                    result.append(",\n ");
                    if (isArray) {
                        result.append(" ");
                    }
                }
                result.append("[");
                int c = 0;
                while (c < mElementCount) {
                    int pos;
                    int n3 = pos = isMatrix ? c * mLoopCount + r : c;
                    if (c > 0) {
                        result.append(", ");
                    }
                    result.append(oneValue[pos]);
                    ++c;
                }
                result.append("]");
                ++r;
            }
            if (isMatrix) {
                result.append("]");
            }
            if (isArray) {
                if (i + 1 < this.arrayLength) {
                    result.append(",\n ");
                } else {
                    result.append("]");
                }
            }
            ++i;
        }
        return result.toString();
    }

    private Number[] mapAndValidateValue(Number[] newValue) {
        assert (newValue.length == this.elementLength);
        Number[] result = new Number[this.elementLength];
        int i = 0;
        while (i < this.elementLength) {
            result[i] = this.valueConverter != null ? this.valueConverter.convert(newValue[i]) : newValue[i];
            ++i;
        }
        return result;
    }
}

