/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.properties;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MapPropertyValue<KEY_TYPE, VALUE_TYPE>
extends AbstractAssetPropertyValue<Map<KEY_TYPE, VALUE_TYPE>> {
    private final @NonNull Map<KEY_TYPE, VALUE_TYPE> map = new HashMap<KEY_TYPE, VALUE_TYPE>();

    public MapPropertyValue(@NonNull IAssetItem<?, ?> assetObject, @NonNull IAssetProperty<@NonNull Map<KEY_TYPE, VALUE_TYPE>> assetProperty) {
        super(assetObject, assetProperty);
    }

    public MapPropertyValue(@NonNull IAssetPropertyValue<@NonNull Map<KEY_TYPE, VALUE_TYPE>> cloneProperty) {
        super(cloneProperty);
        this.map.putAll(cloneProperty.getValue());
    }

    public synchronized void eraseKey(@NonNull FunctionCall functionCall, KEY_TYPE key) {
        this.addAffectingFunctionCall(functionCall);
        this.map.remove(key);
    }

    public synchronized void eraseKeys(@NonNull FunctionCall functionCall, @NonNull List<KEY_TYPE> keys) {
        this.addAffectingFunctionCall(functionCall);
        keys.forEach(key -> {
            VALUE_TYPE VALUE_TYPE = this.map.remove(key);
        });
    }

    @Override
    public @NonNull Map<KEY_TYPE, VALUE_TYPE> getValue() {
        return Collections.unmodifiableMap(this.map);
    }

    public @Nullable VALUE_TYPE removeValue(@NonNull FunctionCall functionCall, @NonNull KEY_TYPE key) {
        this.addAffectingFunctionCall(functionCall);
        return this.map.remove(key);
    }

    public synchronized void setValue(@NonNull FunctionCall functionCall, KEY_TYPE key, VALUE_TYPE value) {
        this.addAffectingFunctionCall(functionCall);
        this.map.put(key, value);
    }

    public void setValue(@NonNull FunctionCall functionCall, @NonNull Map<KEY_TYPE, VALUE_TYPE> map) {
        this.addAffectingFunctionCall(functionCall);
        map.clear();
        map.putAll(map);
    }

    public synchronized void setValueFrom(@NonNull FunctionCall functionCall, @NonNull IAssetPropertyValue<@NonNull Map<KEY_TYPE, VALUE_TYPE>> thatProperty) {
        this.addAffectingFunctionCall(functionCall);
        this.map.clear();
        this.map.putAll(thatProperty.getValue());
    }

    @Override
    public String toString() {
        return String.valueOf(this.map);
    }
}

