/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.properties;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class ListPropertyValue<VALUE_TYPE>
extends AbstractAssetPropertyValue<List<VALUE_TYPE>> {
    private final @NonNull List<VALUE_TYPE> list = new ArrayList<VALUE_TYPE>();

    public ListPropertyValue(@NonNull IAssetItem<?, ?> assetObject, @NonNull IAssetProperty<@NonNull List<VALUE_TYPE>> assetProperty) {
        super(assetObject, assetProperty);
    }

    public ListPropertyValue(@NonNull IAssetItem<?, ?> assetObject, @NonNull IAssetProperty<@NonNull List<VALUE_TYPE>> assetProperty, @NonNull List<VALUE_TYPE> initializer) {
        super(assetObject, assetProperty);
        this.list.addAll(initializer);
    }

    public ListPropertyValue(@NonNull IAssetPropertyValue<@NonNull List<VALUE_TYPE>> cloneProperty) {
        super(cloneProperty);
        this.list.addAll((Collection)cloneProperty.getValue());
    }

    @Override
    public @NonNull List<VALUE_TYPE> getValue() {
        return Collections.unmodifiableList(this.list);
    }

    public void setValue(@NonNull FunctionCall functionCall, @NonNull List<VALUE_TYPE> list) {
        this.addAffectingFunctionCall(functionCall);
        list.clear();
        list.addAll(list);
    }

    public synchronized void setValueFrom(@NonNull FunctionCall functionCall, @NonNull IAssetPropertyValue<@NonNull List<VALUE_TYPE>> thatProperty) {
        this.addAffectingFunctionCall(functionCall);
        this.list.clear();
        this.list.addAll((Collection)thatProperty.getValue());
    }

    public synchronized void removeValue(@NonNull FunctionCall functionCall, VALUE_TYPE value) {
        this.addAffectingFunctionCall(functionCall);
        this.list.remove(value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.list);
    }
}

