/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.properties;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public final class ImmutablePropertyValue<PROPERTY_TYPE>
implements IAssetPropertyValue<PROPERTY_TYPE> {
    private final @NonNull IAssetItem<?, ?> assetObject;
    private final @NonNull IAssetProperty<PROPERTY_TYPE> assetProperty;
    private PROPERTY_TYPE value;

    public ImmutablePropertyValue(@NonNull IAssetItem<?, ?> assetObject, @NonNull IAssetProperty<PROPERTY_TYPE> assetProperty, PROPERTY_TYPE value) {
        this.assetObject = assetObject;
        this.assetProperty = assetProperty;
        this.value = value;
    }

    @Override
    public @NonNull FunctionCall getLastAffectingFunction() {
        return this.assetObject.getCreatingFunction();
    }

    @Override
    public @NonNull IAssetItem<?, ?> getParentAssetObject() {
        return this.assetObject;
    }

    @Override
    public @NonNull IAssetProperty<PROPERTY_TYPE> getProperty() {
        return this.assetProperty;
    }

    @Override
    public @NonNull ClosedFunctionCallIDRange getValidFunctionCallRange() {
        FunctionCallIDRange assetBounds = this.assetObject.getLifecycleManager().getAssetRetainedBounds();
        if (assetBounds.isClosedRange()) {
            return new ClosedFunctionCallIDRange(assetBounds.getFrom(), (FunctionCallID)NullUtils.neverNull((Object)assetBounds.getTo()));
        }
        FunctionCall lastCall = this.assetObject.getFunctionCall(this.assetObject.getFunctionCallCount() - 1);
        return new ClosedFunctionCallIDRange(assetBounds.getFrom(), lastCall.getID().next());
    }

    @Override
    public PROPERTY_TYPE getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

