/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.properties;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public final class ByteArrayPropertyValue
extends AbstractAssetPropertyValue<byte[]> {
    private byte[] value;

    public ByteArrayPropertyValue(@NonNull IAssetItem<?, ?> assetObject, @NonNull IAssetProperty<byte[]> assetProperty) {
        super(assetObject, assetProperty);
    }

    public ByteArrayPropertyValue(@NonNull IAssetPropertyValue<byte[]> cloneProperty) {
        super(cloneProperty);
        byte[] sourceArray = cloneProperty.getValue();
        if (sourceArray != null) {
            this.value = (byte[])sourceArray.clone();
        }
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    public void setValue(@NonNull FunctionCall functionCall, byte[] value) {
        this.setValue(functionCall, value, value.length);
    }

    public synchronized void setValue(@NonNull FunctionCall functionCall, byte[] value, long size) {
        this.addAffectingFunctionCall(functionCall);
        assert (size >= 0L);
        assert (size < Integer.MAX_VALUE);
        this.value = new byte[(int)size];
        if (value != null) {
            assert ((long)value.length == size);
            System.arraycopy(value, 0, this.value, 0, (int)size);
        }
    }

    public synchronized void setValue(@NonNull FunctionCall functionCall, byte[] value, long offset, long size) {
        this.addAffectingFunctionCall(functionCall);
        assert (offset >= 0L);
        assert (offset < Integer.MAX_VALUE);
        assert (size >= 0L);
        assert (size < Integer.MAX_VALUE);
        assert (value != null);
        assert ((long)value.length == size);
        assert (offset + size < Integer.MAX_VALUE);
        if ((long)this.value.length < offset + size) {
            byte[] newValue = new byte[(int)(offset + size)];
            System.arraycopy(this.value, 0, newValue, 0, this.value.length);
            this.value = newValue;
        }
        System.arraycopy(this.value, (int)offset, value, 0, value.length);
    }

    public synchronized void setValueFrom(@NonNull FunctionCall functionCall, @NonNull IAssetPropertyValue<byte[]> thatProperty) {
        this.addAffectingFunctionCall(functionCall);
        this.value = thatProperty.getValue();
    }

    @Override
    public String toString() {
        return Arrays.toString(this.value);
    }
}

