/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.vulkan;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.lang.handle.HandleAttachment;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetValueProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.ProvidedAssetProcessors;
import com.arm.mgd.lightweight.asset.processor.vulkan.AbstractVulkanAssetValueProcessorBase;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.ListPropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimplePropertyValue;
import com.arm.mgd.lightweight.asset.vulkan.IVkAttachmentDescription;
import com.arm.mgd.lightweight.asset.vulkan.IVkSubpassDependency;
import com.arm.mgd.lightweight.asset.vulkan.IVkSubpassDescription;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferViewAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkCommandBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkComputePipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorPoolAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorSetAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorSetLayoutAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDeviceMemoryAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkFramebufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkGraphicsPipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageViewAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineLayoutAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkRenderPassAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkShaderModuleAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkSwapchainKHRAsset;
import com.arm.mgd.lightweight.asset.vulkan.gen.AbstractVkCommandBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.gen.AbstractVkDescriptorPoolAsset;
import com.arm.mgd.lightweight.asset.vulkan.gen.AbstractVkGraphicsPipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.gen.AbstractVkPipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.gen.AbstractVkSwapchainKHRAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class VulkanAssetValueProcessor {

    public static final class VkBufferAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkBufferAsset, VkBufferAsset.Value> {
        public static final @NonNull VkBufferAssetValueProcessor INSTANCE = new VkBufferAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKBINDBUFFERMEMORY, VkBindBufferMemory.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKCREATEBUFFER, VkCreateBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKDESTROYBUFFER, VkDestroyBuffer.HELPER_INSTANCE);
            }
        };

        private VkBufferAssetValueProcessor() {
        }

        @Override
        public @NonNull VkBufferAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkBufferAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkBufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices = assetObject.getImmutablePropertyQueueFamilyIndices();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode = assetObject.getImmutablePropertySharingMode();
            ImmutablePropertyValue<@NonNull Long> size = assetObject.getImmutablePropertySize();
            ImmutablePropertyValue<@NonNull Bitfield> usage = assetObject.getImmutablePropertyUsage();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, flags, queueFamilyIndices, sharingMode, size, usage)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkBufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)sharingMode, (IAssetPropertyValue<Long>)size, (IAssetPropertyValue<Bitfield>)usage);
        }

        @Override
        public @NonNull VkBufferAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkBufferAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkBufferAsset assetObject = (VkBufferAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkBufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices = assetObject.getImmutablePropertyQueueFamilyIndices();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode = assetObject.getImmutablePropertySharingMode();
            ImmutablePropertyValue<@NonNull Long> size = assetObject.getImmutablePropertySize();
            ImmutablePropertyValue<@NonNull Bitfield> usage = assetObject.getImmutablePropertyUsage();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, flags, queueFamilyIndices, sharingMode, size, usage)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkBufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)sharingMode, (IAssetPropertyValue<Long>)size, (IAssetPropertyValue<Bitfield>)usage);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode, @NonNull ImmutablePropertyValue<@NonNull Long> size, @NonNull ImmutablePropertyValue<@NonNull Bitfield> usage) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, flags, queueFamilyIndices, sharingMode, size, usage);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkBufferAsset.Value processedValue;
                VkBufferAsset.Value unProcessedValue = new VkBufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)sharingMode, (IAssetPropertyValue<Long>)size, (IAssetPropertyValue<Bitfield>)usage);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkBufferAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var4, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> var5, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull ImmutablePropertyValue<@NonNull Long> var7, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var8) throws Exception;
        }

        private static final class VkBindBufferMemory
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkBindBufferMemory HELPER_INSTANCE = new VkBindBufferMemory();

            private VkBindBufferMemory() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> property_queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_sharingMode, @NonNull ImmutablePropertyValue<@NonNull Long> property_size, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_usage) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKBINDBUFFERMEMORY.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkBindBufferMemoryDecorator.getArgumentDevice(functionCall);
                    Handle arg_buffer = VULKAN.VkBindBufferMemoryDecorator.getArgumentBuffer(functionCall);
                    Handle arg_memory = VULKAN.VkBindBufferMemoryDecorator.getArgumentMemory(functionCall);
                    Long arg_memoryOffset = VULKAN.VkBindBufferMemoryDecorator.getArgumentMemoryOffset(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBindBufferMemoryDecorator.getReturnValue(functionCall);
                    VkBufferAsset bufferAsset = assetObject;
                    AssetItemID memoryAsset_id_value = AssetItemID.valueOf(arg_memory);
                    VkDeviceMemoryAsset memoryAsset = VkBindBufferMemory.requireAsset(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, callbacks, functionCall, VkBindBufferMemory.getVkDeviceMemoryAsset(callbacks, functionCall, memoryAsset_id_value), memoryAsset_id_value);
                    ProvidedAssetProcessors.processProvidedActionForVkBufferAssetOnVkBindBufferMemory(callbacks, functionCall, bufferAsset, arg_device, arg_buffer, arg_memory, arg_memoryOffset, returnValue_, memoryAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class VkCreateBuffer
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateBuffer HELPER_INSTANCE = new VkCreateBuffer();

            private VkCreateBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> property_queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_sharingMode, @NonNull ImmutablePropertyValue<@NonNull Long> property_size, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_usage) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATEBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateBufferDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkBufferCreateInfo arg_pCreateInfo = VULKAN.VkCreateBufferDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateBufferDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pBuffer = VULKAN.VkCreateBufferDecorator.getArgumentPBuffer(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateBufferDecorator.getReturnValue(functionCall);
                    VkBufferAsset bufferAsset = assetObject;
                    return true;
                }
                return false;
            }
        }

        private static final class VkDestroyBuffer
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkDestroyBuffer HELPER_INSTANCE = new VkDestroyBuffer();

            private VkDestroyBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> property_queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_sharingMode, @NonNull ImmutablePropertyValue<@NonNull Long> property_size, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_usage) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKDESTROYBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkDestroyBufferDecorator.getArgumentDevice(functionCall);
                    Handle arg_buffer = VULKAN.VkDestroyBufferDecorator.getArgumentBuffer(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyBufferDecorator.getArgumentPAllocator(functionCall);
                    VkBufferAsset deletedBufferAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForVkBufferAssetOnVkDestroyBuffer(callbacks, functionCall, deletedBufferAsset, arg_device, arg_buffer, arg_pAllocator);
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkBufferViewAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkBufferViewAsset, VkBufferViewAsset.Value> {
        public static final @NonNull VkBufferViewAssetValueProcessor INSTANCE = new VkBufferViewAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKCREATEBUFFERVIEW, VkCreateBufferView.HELPER_INSTANCE);
            }
        };

        private VkBufferViewAssetValueProcessor() {
        }

        @Override
        public @NonNull VkBufferViewAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkBufferViewAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkBufferViewAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull VkBufferAsset> buffer = assetObject.getImmutablePropertyBuffer();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format = assetObject.getImmutablePropertyFormat();
            ImmutablePropertyValue<@NonNull Long> offset = assetObject.getImmutablePropertyOffset();
            ImmutablePropertyValue<@NonNull Long> range = assetObject.getImmutablePropertyRange();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(buffer, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, buffer, flags, format, offset, range)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkBufferViewAsset.Value(validRange, assetObject, (IAssetPropertyValue<VkBufferAsset>)buffer, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<Long>)offset, (IAssetPropertyValue<Long>)range);
        }

        @Override
        public @NonNull VkBufferViewAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkBufferViewAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkBufferViewAsset assetObject = (VkBufferViewAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkBufferViewAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull VkBufferAsset> buffer = assetObject.getImmutablePropertyBuffer();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format = assetObject.getImmutablePropertyFormat();
            ImmutablePropertyValue<@NonNull Long> offset = assetObject.getImmutablePropertyOffset();
            ImmutablePropertyValue<@NonNull Long> range = assetObject.getImmutablePropertyRange();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(buffer, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, buffer, flags, format, offset, range)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkBufferViewAsset.Value(validRange, assetObject, (IAssetPropertyValue<VkBufferAsset>)buffer, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<Long>)offset, (IAssetPropertyValue<Long>)range);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkBufferViewAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull VkBufferAsset> buffer, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format, @NonNull ImmutablePropertyValue<@NonNull Long> offset, @NonNull ImmutablePropertyValue<@NonNull Long> range) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, buffer, flags, format, offset, range);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkBufferViewAsset.Value processedValue;
                VkBufferViewAsset.Value unProcessedValue = new VkBufferViewAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<VkBufferAsset>)buffer, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<Long>)offset, (IAssetPropertyValue<Long>)range);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkBufferViewAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull VkBufferAsset> var4, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var5, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull ImmutablePropertyValue<@NonNull Long> var7, @NonNull ImmutablePropertyValue<@NonNull Long> var8) throws Exception;
        }

        private static final class VkCreateBufferView
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateBufferView HELPER_INSTANCE = new VkCreateBufferView();

            private VkCreateBufferView() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkBufferViewAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull VkBufferAsset> property_buffer, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_format, @NonNull ImmutablePropertyValue<@NonNull Long> property_offset, @NonNull ImmutablePropertyValue<@NonNull Long> property_range) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATEBUFFERVIEW.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateBufferViewDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkBufferViewCreateInfo arg_pCreateInfo = VULKAN.VkCreateBufferViewDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateBufferViewDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pView = VULKAN.VkCreateBufferViewDecorator.getArgumentPView(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateBufferViewDecorator.getReturnValue(functionCall);
                    Handle temp_getBuffer_return_value_0 = arg_pCreateInfo.getBuffer();
                    AssetItemID parentBuffer_id_value = AssetItemID.valueOf(temp_getBuffer_return_value_0);
                    VkBufferAsset parentBuffer = VkCreateBufferView.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, callbacks, functionCall, VkCreateBufferView.getVkBufferAsset(callbacks, functionCall, parentBuffer_id_value), parentBuffer_id_value);
                    VkBufferViewAsset bufferView = assetObject;
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkCommandBufferAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkCommandBufferAsset, VkCommandBufferAsset.Value> {
        public static final @NonNull VkCommandBufferAssetValueProcessor INSTANCE = new VkCommandBufferAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKALLOCATECOMMANDBUFFERS, VkAllocateCommandBuffers.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKBEGINCOMMANDBUFFER, VkBeginCommandBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKENDCOMMANDBUFFER, VkEndCommandBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKRESETCOMMANDBUFFER, VkResetCommandBuffer.HELPER_INSTANCE);
            }
        };

        private VkCommandBufferAssetValueProcessor() {
        }

        @Override
        public @NonNull VkCommandBufferAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkCommandBufferAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkCommandBufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Handle> commandPool = assetObject.getImmutablePropertyCommandPool();
            ImmutablePropertyValue<@Nullable Pointer> device = assetObject.getImmutablePropertyDevice();
            SimplePropertyValue<@Nullable Object> inheritanceInfo = new SimplePropertyValue<Object>(assetObject, AbstractVkCommandBufferAsset.VkCommandBufferAssetProperties.PROPERTY_INHERITANCE_INFO, null);
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> level = assetObject.getImmutablePropertyLevel();
            SimplePropertyValue<@Nullable Long> usageFlags = new SimplePropertyValue<Long>(assetObject, AbstractVkCommandBufferAsset.VkCommandBufferAssetProperties.PROPERTY_USAGE_FLAGS, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, commandPool, device, inheritanceInfo, level, usageFlags)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkCommandBufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<Handle>)commandPool, (IAssetPropertyValue<Pointer>)device, (IAssetPropertyValue<VULKAN.Structs.VkCommandBufferInheritanceInfo>)inheritanceInfo, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)level, (IAssetPropertyValue<Long>)usageFlags);
        }

        @Override
        public @NonNull VkCommandBufferAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkCommandBufferAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkCommandBufferAsset assetObject = (VkCommandBufferAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkCommandBufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Handle> commandPool = assetObject.getImmutablePropertyCommandPool();
            ImmutablePropertyValue<@Nullable Pointer> device = assetObject.getImmutablePropertyDevice();
            SimplePropertyValue<@Nullable VULKAN.Structs.VkCommandBufferInheritanceInfo> inheritanceInfo = new SimplePropertyValue<VULKAN.Structs.VkCommandBufferInheritanceInfo>(fromValue.getInheritanceInfo());
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> level = assetObject.getImmutablePropertyLevel();
            SimplePropertyValue<@Nullable Long> usageFlags = new SimplePropertyValue<Long>(fromValue.getUsageFlags());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, commandPool, device, inheritanceInfo, level, usageFlags)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkCommandBufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<Handle>)commandPool, (IAssetPropertyValue<Pointer>)device, (IAssetPropertyValue<VULKAN.Structs.VkCommandBufferInheritanceInfo>)inheritanceInfo, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)level, (IAssetPropertyValue<Long>)usageFlags);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkCommandBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Handle> commandPool, @NonNull ImmutablePropertyValue<@Nullable Pointer> device, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkCommandBufferInheritanceInfo> inheritanceInfo, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> level, @NonNull SimplePropertyValue<@Nullable Long> usageFlags) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, commandPool, device, inheritanceInfo, level, usageFlags);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkCommandBufferAsset.Value processedValue;
                VkCommandBufferAsset.Value unProcessedValue = new VkCommandBufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Handle>)commandPool, (IAssetPropertyValue<Pointer>)device, (IAssetPropertyValue<VULKAN.Structs.VkCommandBufferInheritanceInfo>)inheritanceInfo, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)level, (IAssetPropertyValue<Long>)usageFlags);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                inheritanceInfo.setValueFrom(functionCall, processedValue.getInheritanceInfo());
                usageFlags.setValueFrom(functionCall, processedValue.getUsageFlags());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkCommandBufferAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull Handle> var4, @NonNull ImmutablePropertyValue<@Nullable Pointer> var5, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkCommandBufferInheritanceInfo> var6, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@Nullable Long> var8) throws Exception;
        }

        private static final class VkAllocateCommandBuffers
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkAllocateCommandBuffers HELPER_INSTANCE = new VkAllocateCommandBuffers();

            private VkAllocateCommandBuffers() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkCommandBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Handle> property_commandPool, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_device, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkCommandBufferInheritanceInfo> property_inheritanceInfo, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_level, @NonNull SimplePropertyValue<@Nullable Long> property_usageFlags) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKALLOCATECOMMANDBUFFERS.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkCommandBufferAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentPAllocateInfo(functionCall);
                    LongsArgAttachment arg_pCommandBuffers = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentPCommandBuffers(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateCommandBuffersDecorator.getReturnValue(functionCall);
                    VkCommandBufferAsset allocatedCommandBuffer = assetObject;
                    return true;
                }
                return false;
            }
        }

        private static final class VkBeginCommandBuffer
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkBeginCommandBuffer HELPER_INSTANCE = new VkBeginCommandBuffer();

            private VkBeginCommandBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkCommandBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Handle> property_commandPool, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_device, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkCommandBufferInheritanceInfo> property_inheritanceInfo, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_level, @NonNull SimplePropertyValue<@Nullable Long> property_usageFlags) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKBEGINCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_commandBuffer = VULKAN.VkBeginCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                    VULKAN.Structs.VkCommandBufferBeginInfo arg_pBeginInfo = VULKAN.VkBeginCommandBufferDecorator.getArgumentPBeginInfo(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBeginCommandBufferDecorator.getReturnValue(functionCall);
                    VkCommandBufferAsset commandBufferAsset = assetObject;
                    VULKAN.Structs.VkCommandBufferInheritanceInfo temp_getPInheritanceInfo_return_value_0 = arg_pBeginInfo.getPInheritanceInfo();
                    property_inheritanceInfo.setValue(functionCall, temp_getPInheritanceInfo_return_value_0);
                    ProvidedAssetProcessors.processProvidedActionForVkCommandBufferAssetOnVkBeginCommandBuffer(callbacks, functionCall, commandBufferAsset, property_inheritanceInfo, property_usageFlags, arg_commandBuffer, arg_pBeginInfo, returnValue_);
                    return true;
                }
                return false;
            }
        }

        private static final class VkEndCommandBuffer
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkEndCommandBuffer HELPER_INSTANCE = new VkEndCommandBuffer();

            private VkEndCommandBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkCommandBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Handle> property_commandPool, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_device, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkCommandBufferInheritanceInfo> property_inheritanceInfo, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_level, @NonNull SimplePropertyValue<@Nullable Long> property_usageFlags) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKENDCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_commandBuffer = VULKAN.VkEndCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkEndCommandBufferDecorator.getReturnValue(functionCall);
                    VkCommandBufferAsset commandBufferAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForVkCommandBufferAssetOnVkEndCommandBuffer(callbacks, functionCall, commandBufferAsset, property_inheritanceInfo, property_usageFlags, arg_commandBuffer, returnValue_);
                    return true;
                }
                return false;
            }
        }

        private static final class VkResetCommandBuffer
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkResetCommandBuffer HELPER_INSTANCE = new VkResetCommandBuffer();

            private VkResetCommandBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkCommandBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Handle> property_commandPool, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_device, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkCommandBufferInheritanceInfo> property_inheritanceInfo, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_level, @NonNull SimplePropertyValue<@Nullable Long> property_usageFlags) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKRESETCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_commandBuffer = VULKAN.VkResetCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                    Bitfield arg_flags = VULKAN.VkResetCommandBufferDecorator.getArgumentFlags(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkResetCommandBufferDecorator.getReturnValue(functionCall);
                    VkCommandBufferAsset commandBufferAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForVkCommandBufferAssetOnVkResetCommandBuffer(callbacks, functionCall, commandBufferAsset, property_inheritanceInfo, property_usageFlags, arg_commandBuffer, arg_flags, returnValue_);
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkComputePipelineAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkComputePipelineAsset, VkComputePipelineAsset.Value> {
        public static final @NonNull VkComputePipelineAssetValueProcessor INSTANCE = new VkComputePipelineAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private VkComputePipelineAssetValueProcessor() {
        }

        @Override
        public @NonNull VkComputePipelineAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkComputePipelineAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkComputePipelineAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> basePipelineHandle = new SimplePropertyValue<Object>(assetObject, AbstractVkPipelineAsset.VkPipelineAssetProperties.PROPERTY_BASE_PIPELINE_HANDLE, null);
            SimplePropertyValue<@Nullable Long> flags = new SimplePropertyValue<Long>(assetObject, AbstractVkPipelineAsset.VkPipelineAssetProperties.PROPERTY_FLAGS, 0L);
            SimplePropertyValue<@Nullable Object> layout = new SimplePropertyValue<Object>(assetObject, AbstractVkPipelineAsset.VkPipelineAssetProperties.PROPERTY_LAYOUT, null);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(basePipelineHandle, functionCall);
                this.ensureAssetReferencesValidAt(layout, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, basePipelineHandle, flags, layout)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkComputePipelineAsset.Value(validRange, assetObject, (IAssetPropertyValue<VkPipelineAsset<?, ?>>)basePipelineHandle, (IAssetPropertyValue<Long>)flags, (IAssetPropertyValue<VkPipelineLayoutAsset>)layout);
        }

        @Override
        public @NonNull VkComputePipelineAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkComputePipelineAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkComputePipelineAsset assetObject = (VkComputePipelineAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkComputePipelineAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable VkPipelineAsset<?, ?>> basePipelineHandle = new SimplePropertyValue(fromValue.getBasePipelineHandle());
            SimplePropertyValue<@Nullable Long> flags = new SimplePropertyValue<Long>(fromValue.getFlags());
            SimplePropertyValue<@Nullable VkPipelineLayoutAsset> layout = new SimplePropertyValue<VkPipelineLayoutAsset>(fromValue.getLayout());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(basePipelineHandle, functionCall);
                    this.ensureAssetReferencesValidAt(layout, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, basePipelineHandle, flags, layout)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkComputePipelineAsset.Value(validRange, assetObject, basePipelineHandle, (IAssetPropertyValue<Long>)flags, (IAssetPropertyValue<VkPipelineLayoutAsset>)layout);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkComputePipelineAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable VkPipelineAsset<?, ?>> basePipelineHandle, @NonNull SimplePropertyValue<@Nullable Long> flags, @NonNull SimplePropertyValue<@Nullable VkPipelineLayoutAsset> layout) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, basePipelineHandle, flags, layout);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkComputePipelineAsset.Value processedValue;
                VkComputePipelineAsset.Value unProcessedValue = new VkComputePipelineAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<VkPipelineAsset<?, ?>>)basePipelineHandle, (IAssetPropertyValue<Long>)flags, (IAssetPropertyValue<VkPipelineLayoutAsset>)layout);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                basePipelineHandle.setValueFrom(functionCall, processedValue.getBasePipelineHandle());
                flags.setValueFrom(functionCall, processedValue.getFlags());
                layout.setValueFrom(functionCall, processedValue.getLayout());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkComputePipelineAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable VkPipelineAsset<?, ?>> var4, @NonNull SimplePropertyValue<@Nullable Long> var5, @NonNull SimplePropertyValue<@Nullable VkPipelineLayoutAsset> var6) throws Exception;
        }
    }

    public static final class VkDescriptorPoolAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkDescriptorPoolAsset, VkDescriptorPoolAsset.Value> {
        public static final @NonNull VkDescriptorPoolAssetValueProcessor INSTANCE = new VkDescriptorPoolAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKRESETDESCRIPTORPOOL, VkResetDescriptorPool.HELPER_INSTANCE);
            }
        };

        private VkDescriptorPoolAssetValueProcessor() {
        }

        @Override
        public @NonNull VkDescriptorPoolAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkDescriptorPoolAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkDescriptorPoolAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ListPropertyValue<@NonNull VkDescriptorSetAsset> descriptorSets = new ListPropertyValue<VkDescriptorSetAsset>((IAssetItem<?, ?>)assetObject, AbstractVkDescriptorPoolAsset.VkDescriptorPoolAssetProperties.PROPERTY_DESCRIPTOR_SETS);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(descriptorSets, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, descriptorSets)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkDescriptorPoolAsset.Value(validRange, assetObject, (IAssetPropertyValue<List<VkDescriptorSetAsset>>)descriptorSets);
        }

        @Override
        public @NonNull VkDescriptorPoolAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkDescriptorPoolAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkDescriptorPoolAsset assetObject = (VkDescriptorPoolAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkDescriptorPoolAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ListPropertyValue<@NonNull VkDescriptorSetAsset> descriptorSets = new ListPropertyValue<VkDescriptorSetAsset>(fromValue.getDescriptorSets());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(descriptorSets, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, descriptorSets)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkDescriptorPoolAsset.Value(validRange, assetObject, (IAssetPropertyValue<List<VkDescriptorSetAsset>>)descriptorSets);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkDescriptorPoolAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ListPropertyValue<@NonNull VkDescriptorSetAsset> descriptorSets) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, descriptorSets);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkDescriptorPoolAsset.Value processedValue;
                VkDescriptorPoolAsset.Value unProcessedValue = new VkDescriptorPoolAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<List<VkDescriptorSetAsset>>)descriptorSets);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                descriptorSets.setValueFrom(functionCall, processedValue.getDescriptorSets());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkDescriptorPoolAsset var2, @NonNull FunctionCall var3, @NonNull ListPropertyValue<@NonNull VkDescriptorSetAsset> var4) throws Exception;
        }

        private static final class VkResetDescriptorPool
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkResetDescriptorPool HELPER_INSTANCE = new VkResetDescriptorPool();

            private VkResetDescriptorPool() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkDescriptorPoolAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ListPropertyValue<@NonNull VkDescriptorSetAsset> property_descriptorSets) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKRESETDESCRIPTORPOOL.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkResetDescriptorPoolDecorator.getArgumentDevice(functionCall);
                    Handle arg_descriptorPool = VULKAN.VkResetDescriptorPoolDecorator.getArgumentDescriptorPool(functionCall);
                    Bitfield arg_flags = VULKAN.VkResetDescriptorPoolDecorator.getArgumentFlags(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkResetDescriptorPoolDecorator.getReturnValue(functionCall);
                    VkDescriptorPoolAsset descriptorPoolAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForVkDescriptorPoolAssetOnVkResetDescriptorPool(callbacks, functionCall, descriptorPoolAsset, property_descriptorSets, arg_device, arg_descriptorPool, arg_flags, returnValue_);
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkDescriptorSetAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkDescriptorSetAsset, VkDescriptorSetAsset.Value> {
        public static final @NonNull VkDescriptorSetAssetValueProcessor INSTANCE = new VkDescriptorSetAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKALLOCATEDESCRIPTORSETS, VkAllocateDescriptorSets.HELPER_INSTANCE);
            }
        };

        private VkDescriptorSetAssetValueProcessor() {
        }

        @Override
        public @NonNull VkDescriptorSetAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkDescriptorSetAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkDescriptorSetAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull VkDescriptorPoolAsset> descriptorPool = assetObject.getImmutablePropertyDescriptorPool();
            ImmutablePropertyValue<@Nullable VkDescriptorSetLayoutAsset> layout = assetObject.getImmutablePropertyLayout();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(descriptorPool, functionCall);
                this.ensureAssetReferencesValidAt(layout, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, descriptorPool, layout)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkDescriptorSetAsset.Value(validRange, assetObject, (IAssetPropertyValue<VkDescriptorPoolAsset>)descriptorPool, (IAssetPropertyValue<VkDescriptorSetLayoutAsset>)layout);
        }

        @Override
        public @NonNull VkDescriptorSetAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkDescriptorSetAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkDescriptorSetAsset assetObject = (VkDescriptorSetAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkDescriptorSetAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull VkDescriptorPoolAsset> descriptorPool = assetObject.getImmutablePropertyDescriptorPool();
            ImmutablePropertyValue<@Nullable VkDescriptorSetLayoutAsset> layout = assetObject.getImmutablePropertyLayout();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(descriptorPool, functionCall);
                    this.ensureAssetReferencesValidAt(layout, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, descriptorPool, layout)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkDescriptorSetAsset.Value(validRange, assetObject, (IAssetPropertyValue<VkDescriptorPoolAsset>)descriptorPool, (IAssetPropertyValue<VkDescriptorSetLayoutAsset>)layout);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkDescriptorSetAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull VkDescriptorPoolAsset> descriptorPool, @NonNull ImmutablePropertyValue<@Nullable VkDescriptorSetLayoutAsset> layout) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, descriptorPool, layout);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkDescriptorSetAsset.Value processedValue;
                VkDescriptorSetAsset.Value unProcessedValue = new VkDescriptorSetAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<VkDescriptorPoolAsset>)descriptorPool, (IAssetPropertyValue<VkDescriptorSetLayoutAsset>)layout);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkDescriptorSetAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull VkDescriptorPoolAsset> var4, @NonNull ImmutablePropertyValue<@Nullable VkDescriptorSetLayoutAsset> var5) throws Exception;
        }

        private static final class VkAllocateDescriptorSets
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkAllocateDescriptorSets HELPER_INSTANCE = new VkAllocateDescriptorSets();

            private VkAllocateDescriptorSets() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkDescriptorSetAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull VkDescriptorPoolAsset> property_descriptorPool, @NonNull ImmutablePropertyValue<@Nullable VkDescriptorSetLayoutAsset> property_layout) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKALLOCATEDESCRIPTORSETS.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkDescriptorSetAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentPAllocateInfo(functionCall);
                    HandleArrayAttachment arg_pDescriptorSets = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentPDescriptorSets(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateDescriptorSetsDecorator.getReturnValue(functionCall);
                    Handle temp_getDescriptorPool_return_value_0 = arg_pAllocateInfo.getDescriptorPool();
                    AssetItemID descriptorPool_id_value = AssetItemID.valueOf(temp_getDescriptorPool_return_value_0);
                    VkDescriptorPoolAsset descriptorPool = VkAllocateDescriptorSets.requireAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, callbacks, functionCall, VkAllocateDescriptorSets.getVkDescriptorPoolAsset(callbacks, functionCall, descriptorPool_id_value), descriptorPool_id_value);
                    VkDescriptorSetAsset allocatedDescriptorSet = assetObject;
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkDescriptorSetLayoutAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkDescriptorSetLayoutAsset, VkDescriptorSetLayoutAsset.Value> {
        public static final @NonNull VkDescriptorSetLayoutAssetValueProcessor INSTANCE = new VkDescriptorSetLayoutAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKCREATEDESCRIPTORSETLAYOUT, VkCreateDescriptorSetLayout.HELPER_INSTANCE);
            }
        };

        private VkDescriptorSetLayoutAssetValueProcessor() {
        }

        @Override
        public @NonNull VkDescriptorSetLayoutAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkDescriptorSetLayoutAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkDescriptorSetLayoutAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkDescriptorSetLayoutBinding>> bindings = assetObject.getImmutablePropertyBindings();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, bindings)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkDescriptorSetLayoutAsset.Value(validRange, assetObject, (IAssetPropertyValue<List<VULKAN.Structs.VkDescriptorSetLayoutBinding>>)bindings);
        }

        @Override
        public @NonNull VkDescriptorSetLayoutAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkDescriptorSetLayoutAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkDescriptorSetLayoutAsset assetObject = (VkDescriptorSetLayoutAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkDescriptorSetLayoutAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkDescriptorSetLayoutBinding>> bindings = assetObject.getImmutablePropertyBindings();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, bindings)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkDescriptorSetLayoutAsset.Value(validRange, assetObject, (IAssetPropertyValue<List<VULKAN.Structs.VkDescriptorSetLayoutBinding>>)bindings);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkDescriptorSetLayoutAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkDescriptorSetLayoutBinding>> bindings) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, bindings);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkDescriptorSetLayoutAsset.Value processedValue;
                VkDescriptorSetLayoutAsset.Value unProcessedValue = new VkDescriptorSetLayoutAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<List<VULKAN.Structs.VkDescriptorSetLayoutBinding>>)bindings);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkDescriptorSetLayoutAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkDescriptorSetLayoutBinding>> var4) throws Exception;
        }

        private static final class VkCreateDescriptorSetLayout
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateDescriptorSetLayout HELPER_INSTANCE = new VkCreateDescriptorSetLayout();

            private VkCreateDescriptorSetLayout() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkDescriptorSetLayoutAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkDescriptorSetLayoutBinding>> property_bindings) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATEDESCRIPTORSETLAYOUT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkDescriptorSetLayoutCreateInfo arg_pCreateInfo = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pSetLayout = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPSetLayout(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateDescriptorSetLayoutDecorator.getReturnValue(functionCall);
                    VkDescriptorSetLayoutAsset descriptorSetLayoutAsset = assetObject;
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkDeviceMemoryAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkDeviceMemoryAsset, VkDeviceMemoryAsset.Value> {
        public static final @NonNull VkDeviceMemoryAssetValueProcessor INSTANCE = new VkDeviceMemoryAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKALLOCATEMEMORY, VkAllocateMemory.HELPER_INSTANCE);
            }
        };

        private VkDeviceMemoryAssetValueProcessor() {
        }

        @Override
        public @NonNull VkDeviceMemoryAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkDeviceMemoryAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkDeviceMemoryAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Long> allocationSize = assetObject.getImmutablePropertyAllocationSize();
            ImmutablePropertyValue<@NonNull Long> memoryTypeIndex = assetObject.getImmutablePropertyMemoryTypeIndex();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, allocationSize, memoryTypeIndex)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkDeviceMemoryAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)allocationSize, (IAssetPropertyValue<Long>)memoryTypeIndex);
        }

        @Override
        public @NonNull VkDeviceMemoryAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkDeviceMemoryAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkDeviceMemoryAsset assetObject = (VkDeviceMemoryAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkDeviceMemoryAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Long> allocationSize = assetObject.getImmutablePropertyAllocationSize();
            ImmutablePropertyValue<@NonNull Long> memoryTypeIndex = assetObject.getImmutablePropertyMemoryTypeIndex();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, allocationSize, memoryTypeIndex)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkDeviceMemoryAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)allocationSize, (IAssetPropertyValue<Long>)memoryTypeIndex);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkDeviceMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Long> allocationSize, @NonNull ImmutablePropertyValue<@NonNull Long> memoryTypeIndex) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, allocationSize, memoryTypeIndex);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkDeviceMemoryAsset.Value processedValue;
                VkDeviceMemoryAsset.Value unProcessedValue = new VkDeviceMemoryAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)allocationSize, (IAssetPropertyValue<Long>)memoryTypeIndex);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkDeviceMemoryAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull Long> var4, @NonNull ImmutablePropertyValue<@NonNull Long> var5) throws Exception;
        }

        private static final class VkAllocateMemory
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkAllocateMemory HELPER_INSTANCE = new VkAllocateMemory();

            private VkAllocateMemory() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkDeviceMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Long> property_allocationSize, @NonNull ImmutablePropertyValue<@NonNull Long> property_memoryTypeIndex) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKALLOCATEMEMORY.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkAllocateMemoryDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkMemoryAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateMemoryDecorator.getArgumentPAllocateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkAllocateMemoryDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pMemory = VULKAN.VkAllocateMemoryDecorator.getArgumentPMemory(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateMemoryDecorator.getReturnValue(functionCall);
                    VkDeviceMemoryAsset deviceMemoryAsset = assetObject;
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkFramebufferAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkFramebufferAsset, VkFramebufferAsset.Value> {
        public static final @NonNull VkFramebufferAssetValueProcessor INSTANCE = new VkFramebufferAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKCREATEFRAMEBUFFER, VkCreateFramebuffer.HELPER_INSTANCE);
            }
        };

        private VkFramebufferAssetValueProcessor() {
        }

        @Override
        public @NonNull VkFramebufferAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkFramebufferAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkFramebufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull List<@NonNull VkImageViewAsset>> attachments = assetObject.getImmutablePropertyAttachments();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull Long> height = assetObject.getImmutablePropertyHeight();
            ImmutablePropertyValue<@NonNull Long> layers = assetObject.getImmutablePropertyLayers();
            ImmutablePropertyValue<@NonNull VkRenderPassAsset> renderPass = assetObject.getImmutablePropertyRenderPass();
            ImmutablePropertyValue<@NonNull Long> width = assetObject.getImmutablePropertyWidth();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(attachments, functionCall);
                this.ensureAssetReferencesValidAt(renderPass, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attachments, flags, height, layers, renderPass, width)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkFramebufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<List<VkImageViewAsset>>)attachments, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<Long>)layers, (IAssetPropertyValue<VkRenderPassAsset>)renderPass, (IAssetPropertyValue<Long>)width);
        }

        @Override
        public @NonNull VkFramebufferAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkFramebufferAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkFramebufferAsset assetObject = (VkFramebufferAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkFramebufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull List<@NonNull VkImageViewAsset>> attachments = assetObject.getImmutablePropertyAttachments();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull Long> height = assetObject.getImmutablePropertyHeight();
            ImmutablePropertyValue<@NonNull Long> layers = assetObject.getImmutablePropertyLayers();
            ImmutablePropertyValue<@NonNull VkRenderPassAsset> renderPass = assetObject.getImmutablePropertyRenderPass();
            ImmutablePropertyValue<@NonNull Long> width = assetObject.getImmutablePropertyWidth();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(attachments, functionCall);
                    this.ensureAssetReferencesValidAt(renderPass, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attachments, flags, height, layers, renderPass, width)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkFramebufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<List<VkImageViewAsset>>)attachments, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<Long>)layers, (IAssetPropertyValue<VkRenderPassAsset>)renderPass, (IAssetPropertyValue<Long>)width);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkFramebufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VkImageViewAsset>> attachments, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull Long> height, @NonNull ImmutablePropertyValue<@NonNull Long> layers, @NonNull ImmutablePropertyValue<@NonNull VkRenderPassAsset> renderPass, @NonNull ImmutablePropertyValue<@NonNull Long> width) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attachments, flags, height, layers, renderPass, width);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkFramebufferAsset.Value processedValue;
                VkFramebufferAsset.Value unProcessedValue = new VkFramebufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<List<VkImageViewAsset>>)attachments, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<Long>)layers, (IAssetPropertyValue<VkRenderPassAsset>)renderPass, (IAssetPropertyValue<Long>)width);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkFramebufferAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VkImageViewAsset>> var4, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var5, @NonNull ImmutablePropertyValue<@NonNull Long> var6, @NonNull ImmutablePropertyValue<@NonNull Long> var7, @NonNull ImmutablePropertyValue<@NonNull VkRenderPassAsset> var8, @NonNull ImmutablePropertyValue<@NonNull Long> var9) throws Exception;
        }

        private static final class VkCreateFramebuffer
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateFramebuffer HELPER_INSTANCE = new VkCreateFramebuffer();

            private VkCreateFramebuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkFramebufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VkImageViewAsset>> property_attachments, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull Long> property_height, @NonNull ImmutablePropertyValue<@NonNull Long> property_layers, @NonNull ImmutablePropertyValue<@NonNull VkRenderPassAsset> property_renderPass, @NonNull ImmutablePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATEFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateFramebufferDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkFramebufferCreateInfo arg_pCreateInfo = VULKAN.VkCreateFramebufferDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateFramebufferDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pFramebuffer = VULKAN.VkCreateFramebufferDecorator.getArgumentPFramebuffer(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateFramebufferDecorator.getReturnValue(functionCall);
                    Handle temp_getRenderPass_return_value_0 = arg_pCreateInfo.getRenderPass();
                    AssetItemID renderPass_id_value = AssetItemID.valueOf(temp_getRenderPass_return_value_0);
                    VkRenderPassAsset renderPass = VkCreateFramebuffer.requireAsset(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, callbacks, functionCall, VkCreateFramebuffer.getVkRenderPassAsset(callbacks, functionCall, renderPass_id_value), renderPass_id_value);
                    VkFramebufferAsset framebufferAsset = assetObject;
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkGraphicsPipelineAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkGraphicsPipelineAsset, VkGraphicsPipelineAsset.Value> {
        public static final @NonNull VkGraphicsPipelineAssetValueProcessor INSTANCE = new VkGraphicsPipelineAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private VkGraphicsPipelineAssetValueProcessor() {
        }

        @Override
        public @NonNull VkGraphicsPipelineAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkGraphicsPipelineAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkGraphicsPipelineAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> basePipelineHandle = new SimplePropertyValue<Object>(assetObject, AbstractVkPipelineAsset.VkPipelineAssetProperties.PROPERTY_BASE_PIPELINE_HANDLE, null);
            SimplePropertyValue<@Nullable Long> flags = new SimplePropertyValue<Long>(assetObject, AbstractVkPipelineAsset.VkPipelineAssetProperties.PROPERTY_FLAGS, 0L);
            SimplePropertyValue<@Nullable Object> layout = new SimplePropertyValue<Object>(assetObject, AbstractVkPipelineAsset.VkPipelineAssetProperties.PROPERTY_LAYOUT, null);
            SimplePropertyValue<@Nullable Object> colorBlendState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_COLOR_BLEND_STATE, null);
            SimplePropertyValue<@Nullable Object> depthStencilState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_DEPTH_STENCIL_STATE, null);
            SimplePropertyValue<@Nullable Object> dynamicState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_DYNAMIC_STATE, null);
            SimplePropertyValue<@Nullable Object> inputAssemblyState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_INPUT_ASSEMBLY_STATE, null);
            SimplePropertyValue<@Nullable Object> multisampleState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_MULTISAMPLE_STATE, null);
            SimplePropertyValue<@Nullable Object> rasterizationState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_RASTERIZATION_STATE, null);
            SimplePropertyValue<@Nullable Object> renderpass = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_RENDERPASS, null);
            SimplePropertyValue<@NonNull Long> subpass = new SimplePropertyValue<Long>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_SUBPASS, 0L);
            SimplePropertyValue<@Nullable Object> tessellationState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_TESSELLATION_STATE, null);
            SimplePropertyValue<@Nullable Object> vertexInputState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_VERTEX_INPUT_STATE, null);
            SimplePropertyValue<@Nullable Object> viewportState = new SimplePropertyValue<Object>(assetObject, AbstractVkGraphicsPipelineAsset.VkGraphicsPipelineAssetProperties.PROPERTY_VIEWPORT_STATE, null);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(basePipelineHandle, functionCall);
                this.ensureAssetReferencesValidAt(layout, functionCall);
                this.ensureAssetReferencesValidAt(renderpass, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, basePipelineHandle, flags, layout, colorBlendState, depthStencilState, dynamicState, inputAssemblyState, multisampleState, rasterizationState, renderpass, subpass, tessellationState, vertexInputState, viewportState)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkGraphicsPipelineAsset.Value(validRange, assetObject, (IAssetPropertyValue<VkPipelineAsset<?, ?>>)basePipelineHandle, (IAssetPropertyValue<Long>)flags, (IAssetPropertyValue<VkPipelineLayoutAsset>)layout, (IAssetPropertyValue<VULKAN.Structs.VkPipelineColorBlendStateCreateInfo>)colorBlendState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineDepthStencilStateCreateInfo>)depthStencilState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineDynamicStateCreateInfo>)dynamicState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineInputAssemblyStateCreateInfo>)inputAssemblyState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineMultisampleStateCreateInfo>)multisampleState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineRasterizationStateCreateInfo>)rasterizationState, (IAssetPropertyValue<VkRenderPassAsset>)renderpass, (IAssetPropertyValue<Long>)subpass, (IAssetPropertyValue<VULKAN.Structs.VkPipelineTessellationStateCreateInfo>)tessellationState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineVertexInputStateCreateInfo>)vertexInputState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineViewportStateCreateInfo>)viewportState);
        }

        @Override
        public @NonNull VkGraphicsPipelineAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkGraphicsPipelineAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkGraphicsPipelineAsset assetObject = (VkGraphicsPipelineAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkGraphicsPipelineAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable VkPipelineAsset<?, ?>> basePipelineHandle = new SimplePropertyValue(fromValue.getBasePipelineHandle());
            SimplePropertyValue<@Nullable Long> flags = new SimplePropertyValue<Long>(fromValue.getFlags());
            SimplePropertyValue<@Nullable VkPipelineLayoutAsset> layout = new SimplePropertyValue<VkPipelineLayoutAsset>(fromValue.getLayout());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineColorBlendStateCreateInfo> colorBlendState = new SimplePropertyValue<VULKAN.Structs.VkPipelineColorBlendStateCreateInfo>(fromValue.getColorBlendState());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineDepthStencilStateCreateInfo> depthStencilState = new SimplePropertyValue<VULKAN.Structs.VkPipelineDepthStencilStateCreateInfo>(fromValue.getDepthStencilState());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineDynamicStateCreateInfo> dynamicState = new SimplePropertyValue<VULKAN.Structs.VkPipelineDynamicStateCreateInfo>(fromValue.getDynamicState());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineInputAssemblyStateCreateInfo> inputAssemblyState = new SimplePropertyValue<VULKAN.Structs.VkPipelineInputAssemblyStateCreateInfo>(fromValue.getInputAssemblyState());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineMultisampleStateCreateInfo> multisampleState = new SimplePropertyValue<VULKAN.Structs.VkPipelineMultisampleStateCreateInfo>(fromValue.getMultisampleState());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineRasterizationStateCreateInfo> rasterizationState = new SimplePropertyValue<VULKAN.Structs.VkPipelineRasterizationStateCreateInfo>(fromValue.getRasterizationState());
            SimplePropertyValue<@Nullable VkRenderPassAsset> renderpass = new SimplePropertyValue<VkRenderPassAsset>(fromValue.getRenderpass());
            SimplePropertyValue<@NonNull Long> subpass = new SimplePropertyValue<Long>(fromValue.getSubpass());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineTessellationStateCreateInfo> tessellationState = new SimplePropertyValue<VULKAN.Structs.VkPipelineTessellationStateCreateInfo>(fromValue.getTessellationState());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineVertexInputStateCreateInfo> vertexInputState = new SimplePropertyValue<VULKAN.Structs.VkPipelineVertexInputStateCreateInfo>(fromValue.getVertexInputState());
            SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineViewportStateCreateInfo> viewportState = new SimplePropertyValue<VULKAN.Structs.VkPipelineViewportStateCreateInfo>(fromValue.getViewportState());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(basePipelineHandle, functionCall);
                    this.ensureAssetReferencesValidAt(layout, functionCall);
                    this.ensureAssetReferencesValidAt(renderpass, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, basePipelineHandle, flags, layout, colorBlendState, depthStencilState, dynamicState, inputAssemblyState, multisampleState, rasterizationState, renderpass, subpass, tessellationState, vertexInputState, viewportState)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkGraphicsPipelineAsset.Value(validRange, assetObject, (IAssetPropertyValue<VkPipelineAsset<?, ?>>)basePipelineHandle, (IAssetPropertyValue<Long>)flags, (IAssetPropertyValue<VkPipelineLayoutAsset>)layout, (IAssetPropertyValue<VULKAN.Structs.VkPipelineColorBlendStateCreateInfo>)colorBlendState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineDepthStencilStateCreateInfo>)depthStencilState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineDynamicStateCreateInfo>)dynamicState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineInputAssemblyStateCreateInfo>)inputAssemblyState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineMultisampleStateCreateInfo>)multisampleState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineRasterizationStateCreateInfo>)rasterizationState, (IAssetPropertyValue<VkRenderPassAsset>)renderpass, (IAssetPropertyValue<Long>)subpass, (IAssetPropertyValue<VULKAN.Structs.VkPipelineTessellationStateCreateInfo>)tessellationState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineVertexInputStateCreateInfo>)vertexInputState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineViewportStateCreateInfo>)viewportState);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkGraphicsPipelineAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable VkPipelineAsset<?, ?>> basePipelineHandle, @NonNull SimplePropertyValue<@Nullable Long> flags, @NonNull SimplePropertyValue<@Nullable VkPipelineLayoutAsset> layout, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineColorBlendStateCreateInfo> colorBlendState, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineDepthStencilStateCreateInfo> depthStencilState, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineDynamicStateCreateInfo> dynamicState, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineInputAssemblyStateCreateInfo> inputAssemblyState, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineMultisampleStateCreateInfo> multisampleState, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineRasterizationStateCreateInfo> rasterizationState, @NonNull SimplePropertyValue<@Nullable VkRenderPassAsset> renderpass, @NonNull SimplePropertyValue<@NonNull Long> subpass, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineTessellationStateCreateInfo> tessellationState, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineVertexInputStateCreateInfo> vertexInputState, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineViewportStateCreateInfo> viewportState) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, basePipelineHandle, flags, layout, colorBlendState, depthStencilState, dynamicState, inputAssemblyState, multisampleState, rasterizationState, renderpass, subpass, tessellationState, vertexInputState, viewportState);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkGraphicsPipelineAsset.Value processedValue;
                VkGraphicsPipelineAsset.Value unProcessedValue = new VkGraphicsPipelineAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<VkPipelineAsset<?, ?>>)basePipelineHandle, (IAssetPropertyValue<Long>)flags, (IAssetPropertyValue<VkPipelineLayoutAsset>)layout, (IAssetPropertyValue<VULKAN.Structs.VkPipelineColorBlendStateCreateInfo>)colorBlendState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineDepthStencilStateCreateInfo>)depthStencilState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineDynamicStateCreateInfo>)dynamicState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineInputAssemblyStateCreateInfo>)inputAssemblyState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineMultisampleStateCreateInfo>)multisampleState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineRasterizationStateCreateInfo>)rasterizationState, (IAssetPropertyValue<VkRenderPassAsset>)renderpass, (IAssetPropertyValue<Long>)subpass, (IAssetPropertyValue<VULKAN.Structs.VkPipelineTessellationStateCreateInfo>)tessellationState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineVertexInputStateCreateInfo>)vertexInputState, (IAssetPropertyValue<VULKAN.Structs.VkPipelineViewportStateCreateInfo>)viewportState);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                basePipelineHandle.setValueFrom(functionCall, processedValue.getBasePipelineHandle());
                flags.setValueFrom(functionCall, processedValue.getFlags());
                layout.setValueFrom(functionCall, processedValue.getLayout());
                colorBlendState.setValueFrom(functionCall, processedValue.getColorBlendState());
                depthStencilState.setValueFrom(functionCall, processedValue.getDepthStencilState());
                dynamicState.setValueFrom(functionCall, processedValue.getDynamicState());
                inputAssemblyState.setValueFrom(functionCall, processedValue.getInputAssemblyState());
                multisampleState.setValueFrom(functionCall, processedValue.getMultisampleState());
                rasterizationState.setValueFrom(functionCall, processedValue.getRasterizationState());
                renderpass.setValueFrom(functionCall, processedValue.getRenderpass());
                subpass.setValueFrom(functionCall, processedValue.getSubpass());
                tessellationState.setValueFrom(functionCall, processedValue.getTessellationState());
                vertexInputState.setValueFrom(functionCall, processedValue.getVertexInputState());
                viewportState.setValueFrom(functionCall, processedValue.getViewportState());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkGraphicsPipelineAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable VkPipelineAsset<?, ?>> var4, @NonNull SimplePropertyValue<@Nullable Long> var5, @NonNull SimplePropertyValue<@Nullable VkPipelineLayoutAsset> var6, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineColorBlendStateCreateInfo> var7, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineDepthStencilStateCreateInfo> var8, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineDynamicStateCreateInfo> var9, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineInputAssemblyStateCreateInfo> var10, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineMultisampleStateCreateInfo> var11, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineRasterizationStateCreateInfo> var12, @NonNull SimplePropertyValue<@Nullable VkRenderPassAsset> var13, @NonNull SimplePropertyValue<@NonNull Long> var14, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineTessellationStateCreateInfo> var15, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineVertexInputStateCreateInfo> var16, @NonNull SimplePropertyValue<@Nullable VULKAN.Structs.VkPipelineViewportStateCreateInfo> var17) throws Exception;
        }
    }

    public static final class VkImageAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkImageAsset, VkImageAsset.Value> {
        public static final @NonNull VkImageAssetValueProcessor INSTANCE = new VkImageAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKBINDIMAGEMEMORY, VkBindImageMemory.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKCREATEIMAGE, VkCreateImage.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKDESTROYIMAGE, VkDestroyImage.HELPER_INSTANCE);
            }
        };

        private VkImageAssetValueProcessor() {
        }

        @Override
        public @NonNull VkImageAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkImageAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkImageAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Long> arrayLayers = assetObject.getImmutablePropertyArrayLayers();
            ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent3D> extent = assetObject.getImmutablePropertyExtent();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format = assetObject.getImmutablePropertyFormat();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageType = assetObject.getImmutablePropertyImageType();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> initialLayout = assetObject.getImmutablePropertyInitialLayout();
            ImmutablePropertyValue<@NonNull Long> mipLevels = assetObject.getImmutablePropertyMipLevels();
            ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices = assetObject.getImmutablePropertyQueueFamilyIndices();
            ImmutablePropertyValue<@NonNull Bitfield> samples = assetObject.getImmutablePropertySamples();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode = assetObject.getImmutablePropertySharingMode();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> tiling = assetObject.getImmutablePropertyTiling();
            ImmutablePropertyValue<@NonNull Bitfield> usage = assetObject.getImmutablePropertyUsage();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, arrayLayers, extent, flags, format, imageType, initialLayout, mipLevels, queueFamilyIndices, samples, sharingMode, tiling, usage)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkImageAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)arrayLayers, (IAssetPropertyValue<VULKAN.Structs.VkExtent3D>)extent, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageType, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)initialLayout, (IAssetPropertyValue<Long>)mipLevels, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<Bitfield>)samples, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)sharingMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)tiling, (IAssetPropertyValue<Bitfield>)usage);
        }

        @Override
        public @NonNull VkImageAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkImageAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkImageAsset assetObject = (VkImageAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkImageAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Long> arrayLayers = assetObject.getImmutablePropertyArrayLayers();
            ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent3D> extent = assetObject.getImmutablePropertyExtent();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format = assetObject.getImmutablePropertyFormat();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageType = assetObject.getImmutablePropertyImageType();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> initialLayout = assetObject.getImmutablePropertyInitialLayout();
            ImmutablePropertyValue<@NonNull Long> mipLevels = assetObject.getImmutablePropertyMipLevels();
            ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices = assetObject.getImmutablePropertyQueueFamilyIndices();
            ImmutablePropertyValue<@NonNull Bitfield> samples = assetObject.getImmutablePropertySamples();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode = assetObject.getImmutablePropertySharingMode();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> tiling = assetObject.getImmutablePropertyTiling();
            ImmutablePropertyValue<@NonNull Bitfield> usage = assetObject.getImmutablePropertyUsage();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, arrayLayers, extent, flags, format, imageType, initialLayout, mipLevels, queueFamilyIndices, samples, sharingMode, tiling, usage)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkImageAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)arrayLayers, (IAssetPropertyValue<VULKAN.Structs.VkExtent3D>)extent, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageType, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)initialLayout, (IAssetPropertyValue<Long>)mipLevels, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<Bitfield>)samples, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)sharingMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)tiling, (IAssetPropertyValue<Bitfield>)usage);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Long> arrayLayers, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent3D> extent, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> initialLayout, @NonNull ImmutablePropertyValue<@NonNull Long> mipLevels, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull Bitfield> samples, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> sharingMode, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> tiling, @NonNull ImmutablePropertyValue<@NonNull Bitfield> usage) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, arrayLayers, extent, flags, format, imageType, initialLayout, mipLevels, queueFamilyIndices, samples, sharingMode, tiling, usage);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkImageAsset.Value processedValue;
                VkImageAsset.Value unProcessedValue = new VkImageAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)arrayLayers, (IAssetPropertyValue<VULKAN.Structs.VkExtent3D>)extent, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageType, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)initialLayout, (IAssetPropertyValue<Long>)mipLevels, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<Bitfield>)samples, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)sharingMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)tiling, (IAssetPropertyValue<Bitfield>)usage);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkImageAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull Long> var4, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent3D> var5, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var6, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var8, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var9, @NonNull ImmutablePropertyValue<@NonNull Long> var10, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> var11, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var12, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var13, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var14, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var15) throws Exception;
        }

        private static final class VkBindImageMemory
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkBindImageMemory HELPER_INSTANCE = new VkBindImageMemory();

            private VkBindImageMemory() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Long> property_arrayLayers, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent3D> property_extent, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_format, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_initialLayout, @NonNull ImmutablePropertyValue<@NonNull Long> property_mipLevels, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> property_queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_samples, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_sharingMode, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_tiling, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_usage) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKBINDIMAGEMEMORY.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkBindImageMemoryDecorator.getArgumentDevice(functionCall);
                    Handle arg_image = VULKAN.VkBindImageMemoryDecorator.getArgumentImage(functionCall);
                    Handle arg_memory = VULKAN.VkBindImageMemoryDecorator.getArgumentMemory(functionCall);
                    Long arg_memoryOffset = VULKAN.VkBindImageMemoryDecorator.getArgumentMemoryOffset(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBindImageMemoryDecorator.getReturnValue(functionCall);
                    VkImageAsset imageAsset = assetObject;
                    AssetItemID memoryAsset_id_value = AssetItemID.valueOf(arg_memory);
                    VkDeviceMemoryAsset memoryAsset = VkBindImageMemory.requireAsset(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, callbacks, functionCall, VkBindImageMemory.getVkDeviceMemoryAsset(callbacks, functionCall, memoryAsset_id_value), memoryAsset_id_value);
                    ProvidedAssetProcessors.processProvidedActionForVkImageAssetOnVkBindImageMemory(callbacks, functionCall, imageAsset, arg_device, arg_image, arg_memory, arg_memoryOffset, returnValue_, memoryAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class VkCreateImage
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateImage HELPER_INSTANCE = new VkCreateImage();

            private VkCreateImage() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Long> property_arrayLayers, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent3D> property_extent, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_format, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_initialLayout, @NonNull ImmutablePropertyValue<@NonNull Long> property_mipLevels, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> property_queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_samples, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_sharingMode, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_tiling, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_usage) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATEIMAGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateImageDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkImageCreateInfo arg_pCreateInfo = VULKAN.VkCreateImageDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateImageDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pImage = VULKAN.VkCreateImageDecorator.getArgumentPImage(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateImageDecorator.getReturnValue(functionCall);
                    VkImageAsset imageAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForVkImageAssetOnVkCreateImage(callbacks, functionCall, imageAsset, arg_device, arg_pCreateInfo, arg_pAllocator, arg_pImage, returnValue_);
                    return true;
                }
                return false;
            }
        }

        private static final class VkDestroyImage
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkDestroyImage HELPER_INSTANCE = new VkDestroyImage();

            private VkDestroyImage() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Long> property_arrayLayers, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent3D> property_extent, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_format, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_initialLayout, @NonNull ImmutablePropertyValue<@NonNull Long> property_mipLevels, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> property_queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_samples, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_sharingMode, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_tiling, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_usage) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKDESTROYIMAGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkDestroyImageDecorator.getArgumentDevice(functionCall);
                    Handle arg_image = VULKAN.VkDestroyImageDecorator.getArgumentImage(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyImageDecorator.getArgumentPAllocator(functionCall);
                    VkImageAsset deletedImageAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForVkImageAssetOnVkDestroyImage(callbacks, functionCall, deletedImageAsset, arg_device, arg_image, arg_pAllocator);
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkImageViewAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkImageViewAsset, VkImageViewAsset.Value> {
        public static final @NonNull VkImageViewAssetValueProcessor INSTANCE = new VkImageViewAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKCREATEIMAGEVIEW, VkCreateImageView.HELPER_INSTANCE);
            }
        };

        private VkImageViewAssetValueProcessor() {
        }

        @Override
        public @NonNull VkImageViewAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkImageViewAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkImageViewAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> components = assetObject.getImmutablePropertyComponents();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format = assetObject.getImmutablePropertyFormat();
            ImmutablePropertyValue<@NonNull VkImageAsset> image = assetObject.getImmutablePropertyImage();
            ImmutablePropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> subresourceRange = assetObject.getImmutablePropertySubresourceRange();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> viewType = assetObject.getImmutablePropertyViewType();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(image, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, components, flags, format, image, subresourceRange, viewType)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkImageViewAsset.Value(validRange, assetObject, (IAssetPropertyValue<VULKAN.Structs.VkComponentMapping>)components, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<VkImageAsset>)image, (IAssetPropertyValue<VULKAN.Structs.VkImageSubresourceRange>)subresourceRange, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)viewType);
        }

        @Override
        public @NonNull VkImageViewAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkImageViewAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkImageViewAsset assetObject = (VkImageViewAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkImageViewAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> components = assetObject.getImmutablePropertyComponents();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format = assetObject.getImmutablePropertyFormat();
            ImmutablePropertyValue<@NonNull VkImageAsset> image = assetObject.getImmutablePropertyImage();
            ImmutablePropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> subresourceRange = assetObject.getImmutablePropertySubresourceRange();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> viewType = assetObject.getImmutablePropertyViewType();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(image, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, components, flags, format, image, subresourceRange, viewType)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkImageViewAsset.Value(validRange, assetObject, (IAssetPropertyValue<VULKAN.Structs.VkComponentMapping>)components, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<VkImageAsset>)image, (IAssetPropertyValue<VULKAN.Structs.VkImageSubresourceRange>)subresourceRange, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)viewType);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkImageViewAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> components, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format, @NonNull ImmutablePropertyValue<@NonNull VkImageAsset> image, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> subresourceRange, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> viewType) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, components, flags, format, image, subresourceRange, viewType);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkImageViewAsset.Value processedValue;
                VkImageViewAsset.Value unProcessedValue = new VkImageViewAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<VULKAN.Structs.VkComponentMapping>)components, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<VkImageAsset>)image, (IAssetPropertyValue<VULKAN.Structs.VkImageSubresourceRange>)subresourceRange, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)viewType);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkImageViewAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> var4, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var5, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull ImmutablePropertyValue<@NonNull VkImageAsset> var7, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> var8, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var9) throws Exception;
        }

        private static final class VkCreateImageView
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateImageView HELPER_INSTANCE = new VkCreateImageView();

            private VkCreateImageView() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkImageViewAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkComponentMapping> property_components, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_format, @NonNull ImmutablePropertyValue<@NonNull VkImageAsset> property_image, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkImageSubresourceRange> property_subresourceRange, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_viewType) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATEIMAGEVIEW.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateImageViewDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkImageViewCreateInfo arg_pCreateInfo = VULKAN.VkCreateImageViewDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateImageViewDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pView = VULKAN.VkCreateImageViewDecorator.getArgumentPView(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateImageViewDecorator.getReturnValue(functionCall);
                    Handle temp_getImage_return_value_0 = arg_pCreateInfo.getImage();
                    AssetItemID imageAsset_id_value = AssetItemID.valueOf(temp_getImage_return_value_0);
                    VkImageAsset imageAsset = VkCreateImageView.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, callbacks, functionCall, VkCreateImageView.getVkImageAsset(callbacks, functionCall, imageAsset_id_value), imageAsset_id_value);
                    VkImageViewAsset imageViewAsset = assetObject;
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkPipelineLayoutAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkPipelineLayoutAsset, VkPipelineLayoutAsset.Value> {
        public static final @NonNull VkPipelineLayoutAssetValueProcessor INSTANCE = new VkPipelineLayoutAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKCREATEPIPELINELAYOUT, VkCreatePipelineLayout.HELPER_INSTANCE);
            }
        };

        private VkPipelineLayoutAssetValueProcessor() {
        }

        @Override
        public @NonNull VkPipelineLayoutAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkPipelineLayoutAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkPipelineLayoutAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> pushConstants = assetObject.getImmutablePropertyPushConstants();
            ImmutablePropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> setLayouts = assetObject.getImmutablePropertySetLayouts();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(setLayouts, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, flags, pushConstants, setLayouts)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkPipelineLayoutAsset.Value(validRange, assetObject, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<List<VULKAN.Structs.VkPushConstantRange>>)pushConstants, (IAssetPropertyValue<List<VkDescriptorSetLayoutAsset>>)setLayouts);
        }

        @Override
        public @NonNull VkPipelineLayoutAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkPipelineLayoutAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkPipelineLayoutAsset assetObject = (VkPipelineLayoutAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkPipelineLayoutAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> pushConstants = assetObject.getImmutablePropertyPushConstants();
            ImmutablePropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> setLayouts = assetObject.getImmutablePropertySetLayouts();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(setLayouts, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, flags, pushConstants, setLayouts)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkPipelineLayoutAsset.Value(validRange, assetObject, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<List<VULKAN.Structs.VkPushConstantRange>>)pushConstants, (IAssetPropertyValue<List<VkDescriptorSetLayoutAsset>>)setLayouts);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkPipelineLayoutAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> pushConstants, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> setLayouts) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, flags, pushConstants, setLayouts);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkPipelineLayoutAsset.Value processedValue;
                VkPipelineLayoutAsset.Value unProcessedValue = new VkPipelineLayoutAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<List<VULKAN.Structs.VkPushConstantRange>>)pushConstants, (IAssetPropertyValue<List<VkDescriptorSetLayoutAsset>>)setLayouts);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkPipelineLayoutAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var4, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> var5, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> var6) throws Exception;
        }

        private static final class VkCreatePipelineLayout
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreatePipelineLayout HELPER_INSTANCE = new VkCreatePipelineLayout();

            private VkCreatePipelineLayout() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkPipelineLayoutAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VULKAN.Structs.VkPushConstantRange>> property_pushConstants, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull VkDescriptorSetLayoutAsset>> property_setLayouts) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATEPIPELINELAYOUT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkPipelineLayoutCreateInfo arg_pCreateInfo = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pPipelineLayout = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPPipelineLayout(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreatePipelineLayoutDecorator.getReturnValue(functionCall);
                    VkPipelineLayoutAsset pipelineLayout = assetObject;
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkRenderPassAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkRenderPassAsset, VkRenderPassAsset.Value> {
        public static final @NonNull VkRenderPassAssetValueProcessor INSTANCE = new VkRenderPassAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKCREATERENDERPASS, VkCreateRenderPass.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKCREATERENDERPASS2, VkCreateRenderPass2.HELPER_INSTANCE);
            }
        };

        private VkRenderPassAssetValueProcessor() {
        }

        @Override
        public @NonNull VkRenderPassAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkRenderPassAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkRenderPassAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> attachments = assetObject.getImmutablePropertyAttachments();
            ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> dependencies = assetObject.getImmutablePropertyDependencies();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> subpasses = assetObject.getImmutablePropertySubpasses();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attachments, dependencies, flags, subpasses)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkRenderPassAsset.Value(validRange, assetObject, (IAssetPropertyValue<List<IVkAttachmentDescription>>)attachments, (IAssetPropertyValue<List<IVkSubpassDependency>>)dependencies, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<List<IVkSubpassDescription>>)subpasses);
        }

        @Override
        public @NonNull VkRenderPassAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkRenderPassAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkRenderPassAsset assetObject = (VkRenderPassAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkRenderPassAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> attachments = assetObject.getImmutablePropertyAttachments();
            ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> dependencies = assetObject.getImmutablePropertyDependencies();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> subpasses = assetObject.getImmutablePropertySubpasses();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attachments, dependencies, flags, subpasses)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkRenderPassAsset.Value(validRange, assetObject, (IAssetPropertyValue<List<IVkAttachmentDescription>>)attachments, (IAssetPropertyValue<List<IVkSubpassDependency>>)dependencies, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<List<IVkSubpassDescription>>)subpasses);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkRenderPassAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> attachments, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> dependencies, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> subpasses) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attachments, dependencies, flags, subpasses);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkRenderPassAsset.Value processedValue;
                VkRenderPassAsset.Value unProcessedValue = new VkRenderPassAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<List<IVkAttachmentDescription>>)attachments, (IAssetPropertyValue<List<IVkSubpassDependency>>)dependencies, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<List<IVkSubpassDescription>>)subpasses);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkRenderPassAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> var4, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> var5, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var6, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> var7) throws Exception;
        }

        private static final class VkCreateRenderPass
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateRenderPass HELPER_INSTANCE = new VkCreateRenderPass();

            private VkCreateRenderPass() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkRenderPassAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> property_attachments, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> property_dependencies, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> property_subpasses) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATERENDERPASS.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateRenderPassDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkRenderPassCreateInfo arg_pCreateInfo = VULKAN.VkCreateRenderPassDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateRenderPassDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pRenderPass = VULKAN.VkCreateRenderPassDecorator.getArgumentPRenderPass(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateRenderPassDecorator.getReturnValue(functionCall);
                    VkRenderPassAsset renderPassAsset = assetObject;
                    return true;
                }
                return false;
            }
        }

        private static final class VkCreateRenderPass2
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateRenderPass2 HELPER_INSTANCE = new VkCreateRenderPass2();

            private VkCreateRenderPass2() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkRenderPassAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkAttachmentDescription>> property_attachments, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDependency>> property_dependencies, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull List<@NonNull IVkSubpassDescription>> property_subpasses) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATERENDERPASS2.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateRenderPass2Decorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkRenderPassCreateInfo2 arg_pCreateInfo = VULKAN.VkCreateRenderPass2Decorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateRenderPass2Decorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pRenderPass = VULKAN.VkCreateRenderPass2Decorator.getArgumentPRenderPass(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateRenderPass2Decorator.getReturnValue(functionCall);
                    VkRenderPassAsset renderPassAsset = assetObject;
                    return true;
                }
                return false;
            }
        }
    }

    public static final class VkShaderModuleAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkShaderModuleAsset, VkShaderModuleAsset.Value> {
        public static final @NonNull VkShaderModuleAssetValueProcessor INSTANCE = new VkShaderModuleAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private VkShaderModuleAssetValueProcessor() {
        }

        @Override
        public @NonNull VkShaderModuleAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkShaderModuleAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkShaderModuleAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkShaderModuleAsset.Value(validRange, assetObject);
        }

        @Override
        public @NonNull VkShaderModuleAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkShaderModuleAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkShaderModuleAsset assetObject = (VkShaderModuleAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkShaderModuleAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkShaderModuleAsset.Value(validRange, assetObject);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkShaderModuleAsset assetObject, @NonNull FunctionCall functionCall) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkShaderModuleAsset.Value processedValue;
                VkShaderModuleAsset.Value unProcessedValue = new VkShaderModuleAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkShaderModuleAsset var2, @NonNull FunctionCall var3) throws Exception;
        }
    }

    public static final class VkSwapchainKHRAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<VULKANApi, VkSwapchainKHRAsset, VkSwapchainKHRAsset.Value> {
        public static final @NonNull VkSwapchainKHRAssetValueProcessor INSTANCE = new VkSwapchainKHRAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.VULKAN.functions.VKCREATESWAPCHAINKHR, VkCreateSwapchainKhr.HELPER_INSTANCE);
                this.put(KapiSpec.VULKAN.functions.VKGETSWAPCHAINIMAGESKHR, VkGetSwapchainImagesKhr.HELPER_INSTANCE);
            }
        };

        private VkSwapchainKHRAssetValueProcessor() {
        }

        @Override
        public @NonNull VkSwapchainKHRAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkSwapchainKHRAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkSwapchainKHRAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> clipped = assetObject.getImmutablePropertyClipped();
            ImmutablePropertyValue<@NonNull Bitfield> compositeAlpha = assetObject.getImmutablePropertyCompositeAlpha();
            ImmutablePropertyValue<@NonNull Long> imageArrayLayers = assetObject.getImmutablePropertyImageArrayLayers();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageColorSpace = assetObject.getImmutablePropertyImageColorSpace();
            ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent2D> imageExtent = assetObject.getImmutablePropertyImageExtent();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageFormat = assetObject.getImmutablePropertyImageFormat();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageSharingMode = assetObject.getImmutablePropertyImageSharingMode();
            ImmutablePropertyValue<@NonNull Bitfield> imageUsage = assetObject.getImmutablePropertyImageUsage();
            ListPropertyValue<@NonNull VkImageAsset> images = new ListPropertyValue<VkImageAsset>((IAssetItem<?, ?>)assetObject, AbstractVkSwapchainKHRAsset.VkSwapchainKHRAssetProperties.PROPERTY_IMAGES);
            SimplePropertyValue<@Nullable Object> oldSwapchain = new SimplePropertyValue<Object>(assetObject, AbstractVkSwapchainKHRAsset.VkSwapchainKHRAssetProperties.PROPERTY_OLD_SWAPCHAIN, null);
            ImmutablePropertyValue<@NonNull Bitfield> preTransform = assetObject.getImmutablePropertyPreTransform();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> presentMode = assetObject.getImmutablePropertyPresentMode();
            ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices = assetObject.getImmutablePropertyQueueFamilyIndices();
            ImmutablePropertyValue<@NonNull Handle> surface = assetObject.getImmutablePropertySurface();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(images, functionCall);
                this.ensureAssetReferencesValidAt(oldSwapchain, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, clipped, compositeAlpha, imageArrayLayers, imageColorSpace, imageExtent, imageFormat, imageSharingMode, imageUsage, images, oldSwapchain, preTransform, presentMode, queueFamilyIndices, surface)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkSwapchainKHRAsset.Value(validRange, assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)clipped, (IAssetPropertyValue<Bitfield>)compositeAlpha, (IAssetPropertyValue<Long>)imageArrayLayers, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageColorSpace, (IAssetPropertyValue<VULKAN.Structs.VkExtent2D>)imageExtent, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageFormat, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageSharingMode, (IAssetPropertyValue<Bitfield>)imageUsage, (IAssetPropertyValue<List<VkImageAsset>>)images, (IAssetPropertyValue<VkSwapchainKHRAsset>)oldSwapchain, (IAssetPropertyValue<Bitfield>)preTransform, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)presentMode, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<Handle>)surface);
        }

        @Override
        public @NonNull VkSwapchainKHRAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull VkSwapchainKHRAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull VkSwapchainKHRAsset assetObject = (VkSwapchainKHRAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get VkSwapchainKHRAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> clipped = assetObject.getImmutablePropertyClipped();
            ImmutablePropertyValue<@NonNull Bitfield> compositeAlpha = assetObject.getImmutablePropertyCompositeAlpha();
            ImmutablePropertyValue<@NonNull Long> imageArrayLayers = assetObject.getImmutablePropertyImageArrayLayers();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageColorSpace = assetObject.getImmutablePropertyImageColorSpace();
            ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent2D> imageExtent = assetObject.getImmutablePropertyImageExtent();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageFormat = assetObject.getImmutablePropertyImageFormat();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageSharingMode = assetObject.getImmutablePropertyImageSharingMode();
            ImmutablePropertyValue<@NonNull Bitfield> imageUsage = assetObject.getImmutablePropertyImageUsage();
            ListPropertyValue<@NonNull VkImageAsset> images = new ListPropertyValue<VkImageAsset>(fromValue.getImages());
            SimplePropertyValue<@Nullable VkSwapchainKHRAsset> oldSwapchain = new SimplePropertyValue<VkSwapchainKHRAsset>(fromValue.getOldSwapchain());
            ImmutablePropertyValue<@NonNull Bitfield> preTransform = assetObject.getImmutablePropertyPreTransform();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> presentMode = assetObject.getImmutablePropertyPresentMode();
            ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices = assetObject.getImmutablePropertyQueueFamilyIndices();
            ImmutablePropertyValue<@NonNull Handle> surface = assetObject.getImmutablePropertySurface();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(images, functionCall);
                    this.ensureAssetReferencesValidAt(oldSwapchain, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, clipped, compositeAlpha, imageArrayLayers, imageColorSpace, imageExtent, imageFormat, imageSharingMode, imageUsage, images, oldSwapchain, preTransform, presentMode, queueFamilyIndices, surface)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new VkSwapchainKHRAsset.Value(validRange, assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)clipped, (IAssetPropertyValue<Bitfield>)compositeAlpha, (IAssetPropertyValue<Long>)imageArrayLayers, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageColorSpace, (IAssetPropertyValue<VULKAN.Structs.VkExtent2D>)imageExtent, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageFormat, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageSharingMode, (IAssetPropertyValue<Bitfield>)imageUsage, (IAssetPropertyValue<List<VkImageAsset>>)images, (IAssetPropertyValue<VkSwapchainKHRAsset>)oldSwapchain, (IAssetPropertyValue<Bitfield>)preTransform, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)presentMode, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<Handle>)surface);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkSwapchainKHRAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> clipped, @NonNull ImmutablePropertyValue<@NonNull Bitfield> compositeAlpha, @NonNull ImmutablePropertyValue<@NonNull Long> imageArrayLayers, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageColorSpace, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent2D> imageExtent, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageFormat, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> imageSharingMode, @NonNull ImmutablePropertyValue<@NonNull Bitfield> imageUsage, @NonNull ListPropertyValue<@NonNull VkImageAsset> images, @NonNull SimplePropertyValue<@Nullable VkSwapchainKHRAsset> oldSwapchain, @NonNull ImmutablePropertyValue<@NonNull Bitfield> preTransform, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> presentMode, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull Handle> surface) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, clipped, compositeAlpha, imageArrayLayers, imageColorSpace, imageExtent, imageFormat, imageSharingMode, imageUsage, images, oldSwapchain, preTransform, presentMode, queueFamilyIndices, surface);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                VkSwapchainKHRAsset.Value processedValue;
                VkSwapchainKHRAsset.Value unProcessedValue = new VkSwapchainKHRAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)clipped, (IAssetPropertyValue<Bitfield>)compositeAlpha, (IAssetPropertyValue<Long>)imageArrayLayers, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageColorSpace, (IAssetPropertyValue<VULKAN.Structs.VkExtent2D>)imageExtent, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageFormat, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)imageSharingMode, (IAssetPropertyValue<Bitfield>)imageUsage, (IAssetPropertyValue<List<VkImageAsset>>)images, (IAssetPropertyValue<VkSwapchainKHRAsset>)oldSwapchain, (IAssetPropertyValue<Bitfield>)preTransform, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)presentMode, (IAssetPropertyValue<LongsArgAttachment>)queueFamilyIndices, (IAssetPropertyValue<Handle>)surface);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                images.setValueFrom(functionCall, processedValue.getImages());
                oldSwapchain.setValueFrom(functionCall, processedValue.getOldSwapchain());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> var1, @NonNull VkSwapchainKHRAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var4, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var5, @NonNull ImmutablePropertyValue<@NonNull Long> var6, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent2D> var8, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var9, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var10, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var11, @NonNull ListPropertyValue<@NonNull VkImageAsset> var12, @NonNull SimplePropertyValue<@Nullable VkSwapchainKHRAsset> var13, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var14, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var15, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> var16, @NonNull ImmutablePropertyValue<@NonNull Handle> var17) throws Exception;
        }

        private static final class VkCreateSwapchainKhr
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkCreateSwapchainKhr HELPER_INSTANCE = new VkCreateSwapchainKhr();

            private VkCreateSwapchainKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkSwapchainKHRAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_clipped, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_compositeAlpha, @NonNull ImmutablePropertyValue<@NonNull Long> property_imageArrayLayers, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageColorSpace, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent2D> property_imageExtent, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageFormat, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageSharingMode, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_imageUsage, @NonNull ListPropertyValue<@NonNull VkImageAsset> property_images, @NonNull SimplePropertyValue<@Nullable VkSwapchainKHRAsset> property_oldSwapchain, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_preTransform, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_presentMode, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> property_queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull Handle> property_surface) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKCREATESWAPCHAINKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentDevice(functionCall);
                    VULKAN.Structs.VkSwapchainCreateInfoKHR arg_pCreateInfo = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPCreateInfo(functionCall);
                    VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPAllocator(functionCall);
                    HandleAttachment arg_pSwapchain = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPSwapchain(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateSwapchainKHRDecorator.getReturnValue(functionCall);
                    VkSwapchainKHRAsset swapchainAsset = assetObject;
                    return true;
                }
                return false;
            }
        }

        private static final class VkGetSwapchainImagesKhr
        extends AbstractVulkanAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final VkGetSwapchainImagesKhr HELPER_INSTANCE = new VkGetSwapchainImagesKhr();

            private VkGetSwapchainImagesKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull VkSwapchainKHRAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_clipped, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_compositeAlpha, @NonNull ImmutablePropertyValue<@NonNull Long> property_imageArrayLayers, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageColorSpace, @NonNull ImmutablePropertyValue<@NonNull VULKAN.Structs.VkExtent2D> property_imageExtent, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageFormat, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_imageSharingMode, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_imageUsage, @NonNull ListPropertyValue<@NonNull VkImageAsset> property_images, @NonNull SimplePropertyValue<@Nullable VkSwapchainKHRAsset> property_oldSwapchain, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_preTransform, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_presentMode, @NonNull ImmutablePropertyValue<@NonNull LongsArgAttachment> property_queueFamilyIndices, @NonNull ImmutablePropertyValue<@NonNull Handle> property_surface) throws Exception {
                assert (KapiSpec.VULKAN.functions.VKGETSWAPCHAINIMAGESKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_device = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentDevice(functionCall);
                    Handle arg_swapchain = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentSwapchain(functionCall);
                    LongPtrArgAttachment arg_pSwapchainImageCount = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentPSwapchainImageCount(functionCall);
                    HandleArrayAttachment arg_pSwapchainImages = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentPSwapchainImages(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkGetSwapchainImagesKHRDecorator.getReturnValue(functionCall);
                    VkSwapchainKHRAsset swapchainAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForVkSwapchainKhraSsetOnVkGetSwapchainImagesKhr(callbacks, functionCall, swapchainAsset, property_images, property_oldSwapchain, arg_device, arg_swapchain, arg_pSwapchainImageCount, arg_pSwapchainImages, returnValue_);
                    return true;
                }
                return false;
            }
        }
    }
}

