/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.vulkan;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.lang.handle.HandleAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.ValueTransformHelper;
import com.arm.mgd.lightweight.asset.processor.vulkan.AbstractVulkanAssetCallProcessorBase;
import com.arm.mgd.lightweight.asset.vulkan.IVkAttachmentDescription;
import com.arm.mgd.lightweight.asset.vulkan.IVkSubpassDependency;
import com.arm.mgd.lightweight.asset.vulkan.IVkSubpassDescription;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferViewAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkCommandBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkComputePipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorPoolAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorSetAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorSetLayoutAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDeviceMemoryAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkFramebufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkGraphicsPipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageViewAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkPipelineLayoutAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkRenderPassAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkShaderModuleAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkSwapchainKHRAsset;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class VulkanAssetCallProcessor {
    private static final Map<IFunctionOrAliasSpecExtended, AbstractLightweightAssetFunctionCallProcessor> ASSET_PROCESSORS = new HashMap<IFunctionOrAliasSpecExtended, AbstractLightweightAssetFunctionCallProcessor>(){
        {
            this.put(KapiSpec.VULKAN.functions.VKALLOCATECOMMANDBUFFERS, new VkAllocateCommandBuffers());
            this.put(KapiSpec.VULKAN.functions.VKALLOCATEDESCRIPTORSETS, new VkAllocateDescriptorSets());
            this.put(KapiSpec.VULKAN.functions.VKALLOCATEMEMORY, new VkAllocateMemory());
            this.put(KapiSpec.VULKAN.functions.VKBEGINCOMMANDBUFFER, new VkBeginCommandBuffer());
            this.put(KapiSpec.VULKAN.functions.VKBINDBUFFERMEMORY, new VkBindBufferMemory());
            this.put(KapiSpec.VULKAN.functions.VKBINDIMAGEMEMORY, new VkBindImageMemory());
            this.put(KapiSpec.VULKAN.functions.VKCREATEBUFFER, new VkCreateBuffer());
            this.put(KapiSpec.VULKAN.functions.VKCREATEBUFFERVIEW, new VkCreateBufferView());
            this.put(KapiSpec.VULKAN.functions.VKCREATECOMPUTEPIPELINES, new VkCreateComputePipelines());
            this.put(KapiSpec.VULKAN.functions.VKCREATEDESCRIPTORPOOL, new VkCreateDescriptorPool());
            this.put(KapiSpec.VULKAN.functions.VKCREATEDESCRIPTORSETLAYOUT, new VkCreateDescriptorSetLayout());
            this.put(KapiSpec.VULKAN.functions.VKCREATEFRAMEBUFFER, new VkCreateFramebuffer());
            this.put(KapiSpec.VULKAN.functions.VKCREATEGRAPHICSPIPELINES, new VkCreateGraphicsPipelines());
            this.put(KapiSpec.VULKAN.functions.VKCREATEIMAGE, new VkCreateImage());
            this.put(KapiSpec.VULKAN.functions.VKCREATEIMAGEVIEW, new VkCreateImageView());
            this.put(KapiSpec.VULKAN.functions.VKCREATEPIPELINELAYOUT, new VkCreatePipelineLayout());
            this.put(KapiSpec.VULKAN.functions.VKCREATERENDERPASS, new VkCreateRenderPass());
            this.put(KapiSpec.VULKAN.functions.VKCREATERENDERPASS2, new VkCreateRenderPass2());
            this.put(KapiSpec.VULKAN.functions.VKCREATESHADERMODULE, new VkCreateShaderModule());
            this.put(KapiSpec.VULKAN.functions.VKCREATESWAPCHAINKHR, new VkCreateSwapchainKhr());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYBUFFER, new VkDestroyBuffer());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYBUFFERVIEW, new VkDestroyBufferView());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYDESCRIPTORPOOL, new VkDestroyDescriptorPool());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYDESCRIPTORSETLAYOUT, new VkDestroyDescriptorSetLayout());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYFRAMEBUFFER, new VkDestroyFramebuffer());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYIMAGE, new VkDestroyImage());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYIMAGEVIEW, new VkDestroyImageView());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYPIPELINE, new VkDestroyPipeline());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYPIPELINELAYOUT, new VkDestroyPipelineLayout());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYRENDERPASS, new VkDestroyRenderPass());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYSHADERMODULE, new VkDestroyShaderModule());
            this.put(KapiSpec.VULKAN.functions.VKDESTROYSWAPCHAINKHR, new VkDestroySwapchainKhr());
            this.put(KapiSpec.VULKAN.functions.VKENDCOMMANDBUFFER, new VkEndCommandBuffer());
            this.put(KapiSpec.VULKAN.functions.VKFREECOMMANDBUFFERS, new VkFreeCommandBuffers());
            this.put(KapiSpec.VULKAN.functions.VKFREEDESCRIPTORSETS, new VkFreeDescriptorSets());
            this.put(KapiSpec.VULKAN.functions.VKFREEMEMORY, new VkFreeMemory());
            this.put(KapiSpec.VULKAN.functions.VKGETSWAPCHAINIMAGESKHR, new VkGetSwapchainImagesKhr());
            this.put(KapiSpec.VULKAN.functions.VKRESETCOMMANDBUFFER, new VkResetCommandBuffer());
            this.put(KapiSpec.VULKAN.functions.VKRESETDESCRIPTORPOOL, new VkResetDescriptorPool());
        }
    };

    public static @Nullable AbstractLightweightAssetFunctionCallProcessor forFunctionCall(@NonNull FunctionCall functionCall) {
        if (functionCall.hasError()) {
            return null;
        }
        return ASSET_PROCESSORS.get(functionCall.getFunctionSpec());
    }

    public static final class VkAllocateCommandBuffers
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKALLOCATECOMMANDBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkCommandBufferAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentPAllocateInfo(functionCall);
                LongsArgAttachment arg_pCommandBuffers = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentPCommandBuffers(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateCommandBuffersDecorator.getReturnValue(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_pCommandBuffers);
                VkAllocateCommandBuffers.forEachAssetItemID(temp_valueOf_return_value_0, allocatedCommandBuffer_id_value -> {
                    Handle temp_getCommandPool_return_value_1 = arg_pAllocateInfo.getCommandPool();
                    AbstractConstantOrAliasSpecExtended temp_getLevel_return_value_2 = arg_pAllocateInfo.getLevel();
                    VkCommandBufferAsset vkCommandBufferAsset = VkAllocateCommandBuffers.createNewVkCommandBufferAsset(callbacks, functionCall, allocatedCommandBuffer_id_value, temp_getCommandPool_return_value_1, arg_device, temp_getLevel_return_value_2);
                });
            }
        }
    }

    public static final class VkAllocateDescriptorSets
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKALLOCATEDESCRIPTORSETS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkDescriptorSetAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentPAllocateInfo(functionCall);
                HandleArrayAttachment arg_pDescriptorSets = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentPDescriptorSets(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateDescriptorSetsDecorator.getReturnValue(functionCall);
                Handle temp_getDescriptorPool_return_value_0 = arg_pAllocateInfo.getDescriptorPool();
                AssetItemID descriptorPool_id_value = AssetItemID.valueOf(temp_getDescriptorPool_return_value_0);
                VkDescriptorPoolAsset descriptorPool = VkAllocateDescriptorSets.requireAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, callbacks, functionCall, VkAllocateDescriptorSets.getVkDescriptorPoolAsset(callbacks, functionCall, descriptorPool_id_value), descriptorPool_id_value);
                List<AssetItemID> temp_valueOf_return_value_1 = AssetItemID.valueOf(arg_pDescriptorSets);
                VkAllocateDescriptorSets.forEachAssetItemID(temp_valueOf_return_value_1, allocatedDescriptorSet_id_value -> {
                    VkDescriptorSetAsset vkDescriptorSetAsset = this.createNewVkDescriptorSetAsset(callbacks, functionCall, allocatedDescriptorSet_id_value, descriptorPool, null);
                });
            }
        }
    }

    public static final class VkAllocateMemory
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKALLOCATEMEMORY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkAllocateMemoryDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkMemoryAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateMemoryDecorator.getArgumentPAllocateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkAllocateMemoryDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pMemory = VULKAN.VkAllocateMemoryDecorator.getArgumentPMemory(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateMemoryDecorator.getReturnValue(functionCall);
                AssetItemID deviceMemoryAsset_id_value = AssetItemID.valueOf(arg_pMemory);
                Long temp_getAllocationSize_return_value_0 = arg_pAllocateInfo.getAllocationSize();
                long temp_longValue_return_value_1 = temp_getAllocationSize_return_value_0;
                Long temp_getMemoryTypeIndex_return_value_2 = arg_pAllocateInfo.getMemoryTypeIndex();
                long temp_longValue_return_value_3 = temp_getMemoryTypeIndex_return_value_2;
                VkDeviceMemoryAsset vkDeviceMemoryAsset = this.createNewVkDeviceMemoryAsset(callbacks, functionCall, deviceMemoryAsset_id_value, temp_longValue_return_value_1, temp_longValue_return_value_3);
            }
        }
    }

    public static final class VkBeginCommandBuffer
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKBEGINCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_commandBuffer = VULKAN.VkBeginCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                VULKAN.Structs.VkCommandBufferBeginInfo arg_pBeginInfo = VULKAN.VkBeginCommandBufferDecorator.getArgumentPBeginInfo(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBeginCommandBufferDecorator.getReturnValue(functionCall);
                AssetItemID commandBufferAsset_id_value = AssetItemID.valueOf(arg_commandBuffer);
                VkCommandBufferAsset commandBufferAsset = VkBeginCommandBuffer.requireAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, callbacks, functionCall, VkBeginCommandBuffer.getVkCommandBufferAsset(callbacks, functionCall, commandBufferAsset_id_value), commandBufferAsset_id_value);
                commandBufferAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class VkBindBufferMemory
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKBINDBUFFERMEMORY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkBindBufferMemoryDecorator.getArgumentDevice(functionCall);
                Handle arg_buffer = VULKAN.VkBindBufferMemoryDecorator.getArgumentBuffer(functionCall);
                Handle arg_memory = VULKAN.VkBindBufferMemoryDecorator.getArgumentMemory(functionCall);
                Long arg_memoryOffset = VULKAN.VkBindBufferMemoryDecorator.getArgumentMemoryOffset(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBindBufferMemoryDecorator.getReturnValue(functionCall);
                AssetItemID bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                VkBufferAsset bufferAsset = VkBindBufferMemory.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, callbacks, functionCall, VkBindBufferMemory.getVkBufferAsset(callbacks, functionCall, bufferAsset_id_value), bufferAsset_id_value);
                bufferAsset.addFunctionCall(functionCall);
                AssetItemID memoryAsset_id_value = AssetItemID.valueOf(arg_memory);
                VkDeviceMemoryAsset vkDeviceMemoryAsset = VkBindBufferMemory.requireAsset(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, callbacks, functionCall, VkBindBufferMemory.getVkDeviceMemoryAsset(callbacks, functionCall, memoryAsset_id_value), memoryAsset_id_value);
            }
        }
    }

    public static final class VkBindImageMemory
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKBINDIMAGEMEMORY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkBindImageMemoryDecorator.getArgumentDevice(functionCall);
                Handle arg_image = VULKAN.VkBindImageMemoryDecorator.getArgumentImage(functionCall);
                Handle arg_memory = VULKAN.VkBindImageMemoryDecorator.getArgumentMemory(functionCall);
                Long arg_memoryOffset = VULKAN.VkBindImageMemoryDecorator.getArgumentMemoryOffset(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBindImageMemoryDecorator.getReturnValue(functionCall);
                AssetItemID imageAsset_id_value = AssetItemID.valueOf(arg_image);
                VkImageAsset imageAsset = VkBindImageMemory.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, callbacks, functionCall, VkBindImageMemory.getVkImageAsset(callbacks, functionCall, imageAsset_id_value), imageAsset_id_value);
                imageAsset.addFunctionCall(functionCall);
                AssetItemID memoryAsset_id_value = AssetItemID.valueOf(arg_memory);
                VkDeviceMemoryAsset vkDeviceMemoryAsset = VkBindImageMemory.requireAsset(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, callbacks, functionCall, VkBindImageMemory.getVkDeviceMemoryAsset(callbacks, functionCall, memoryAsset_id_value), memoryAsset_id_value);
            }
        }
    }

    public static final class VkCreateBuffer
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateBufferDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkBufferCreateInfo arg_pCreateInfo = VULKAN.VkCreateBufferDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateBufferDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pBuffer = VULKAN.VkCreateBufferDecorator.getArgumentPBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateBufferDecorator.getReturnValue(functionCall);
                AssetItemID bufferAsset_id_value = AssetItemID.valueOf(arg_pBuffer);
                Bitfield temp_getFlags_return_value_0 = arg_pCreateInfo.getFlags();
                LongsArgAttachment temp_getPQueueFamilyIndices_return_value_1 = arg_pCreateInfo.getPQueueFamilyIndices();
                AbstractConstantOrAliasSpecExtended temp_getSharingMode_return_value_2 = arg_pCreateInfo.getSharingMode();
                Long temp_getSize_return_value_3 = arg_pCreateInfo.getSize();
                long temp_longValue_return_value_4 = temp_getSize_return_value_3;
                Bitfield temp_getUsage_return_value_5 = arg_pCreateInfo.getUsage();
                VkBufferAsset vkBufferAsset = this.createNewVkBufferAsset(callbacks, functionCall, bufferAsset_id_value, temp_getFlags_return_value_0, temp_getPQueueFamilyIndices_return_value_1, temp_getSharingMode_return_value_2, temp_longValue_return_value_4, temp_getUsage_return_value_5);
            }
        }
    }

    public static final class VkCreateBufferView
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEBUFFERVIEW.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateBufferViewDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkBufferViewCreateInfo arg_pCreateInfo = VULKAN.VkCreateBufferViewDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateBufferViewDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pView = VULKAN.VkCreateBufferViewDecorator.getArgumentPView(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateBufferViewDecorator.getReturnValue(functionCall);
                Handle temp_getBuffer_return_value_0 = arg_pCreateInfo.getBuffer();
                AssetItemID parentBuffer_id_value = AssetItemID.valueOf(temp_getBuffer_return_value_0);
                VkBufferAsset parentBuffer = VkCreateBufferView.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, callbacks, functionCall, VkCreateBufferView.getVkBufferAsset(callbacks, functionCall, parentBuffer_id_value), parentBuffer_id_value);
                AssetItemID bufferView_id_value = AssetItemID.valueOf(arg_pView);
                Bitfield temp_getFlags_return_value_1 = arg_pCreateInfo.getFlags();
                AbstractConstantOrAliasSpecExtended temp_getFormat_return_value_2 = arg_pCreateInfo.getFormat();
                Long temp_getOffset_return_value_3 = arg_pCreateInfo.getOffset();
                long temp_longValue_return_value_4 = temp_getOffset_return_value_3;
                Long temp_getRange_return_value_5 = arg_pCreateInfo.getRange();
                long temp_longValue_return_value_6 = temp_getRange_return_value_5;
                VkBufferViewAsset vkBufferViewAsset = this.createNewVkBufferViewAsset(callbacks, functionCall, bufferView_id_value, parentBuffer, temp_getFlags_return_value_1, temp_getFormat_return_value_2, temp_longValue_return_value_4, temp_longValue_return_value_6);
            }
        }
    }

    public static final class VkCreateComputePipelines
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATECOMPUTEPIPELINES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateComputePipelinesDecorator.getArgumentDevice(functionCall);
                Handle arg_pipelineCache = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPipelineCache(functionCall);
                Long arg_createInfoCount = VULKAN.VkCreateComputePipelinesDecorator.getArgumentCreateInfoCount(functionCall);
                List<@NonNull VULKAN.Structs.VkComputePipelineCreateInfo> arg_pCreateInfos = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPCreateInfos(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPAllocator(functionCall);
                HandleArrayAttachment arg_pPipelines = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPPipelines(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateComputePipelinesDecorator.getReturnValue(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_pPipelines);
                VkCreateComputePipelines.forEachAssetItemID(temp_valueOf_return_value_0, pipelineAsset_id_value -> {
                    VkComputePipelineAsset vkComputePipelineAsset = VkCreateComputePipelines.createNewVkComputePipelineAsset(callbacks, functionCall, pipelineAsset_id_value);
                });
            }
        }
    }

    public static final class VkCreateDescriptorPool
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEDESCRIPTORPOOL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateDescriptorPoolDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkDescriptorPoolCreateInfo arg_pCreateInfo = VULKAN.VkCreateDescriptorPoolDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateDescriptorPoolDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pDescriptorPool = VULKAN.VkCreateDescriptorPoolDecorator.getArgumentPDescriptorPool(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateDescriptorPoolDecorator.getReturnValue(functionCall);
                AssetItemID descriptorPoolAsset_id_value = AssetItemID.valueOf(arg_pDescriptorPool);
                VkDescriptorPoolAsset vkDescriptorPoolAsset = this.createNewVkDescriptorPoolAsset(callbacks, functionCall, descriptorPoolAsset_id_value);
            }
        }
    }

    public static final class VkCreateDescriptorSetLayout
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEDESCRIPTORSETLAYOUT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkDescriptorSetLayoutCreateInfo arg_pCreateInfo = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pSetLayout = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPSetLayout(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateDescriptorSetLayoutDecorator.getReturnValue(functionCall);
                AssetItemID descriptorSetLayoutAsset_id_value = AssetItemID.valueOf(arg_pSetLayout);
                List<VULKAN.Structs.VkDescriptorSetLayoutBinding> temp_getPBindings_return_value_0 = arg_pCreateInfo.getPBindings();
                VkDescriptorSetLayoutAsset vkDescriptorSetLayoutAsset = this.createNewVkDescriptorSetLayoutAsset(callbacks, functionCall, descriptorSetLayoutAsset_id_value, temp_getPBindings_return_value_0);
            }
        }
    }

    public static final class VkCreateFramebuffer
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateFramebufferDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkFramebufferCreateInfo arg_pCreateInfo = VULKAN.VkCreateFramebufferDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateFramebufferDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pFramebuffer = VULKAN.VkCreateFramebufferDecorator.getArgumentPFramebuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateFramebufferDecorator.getReturnValue(functionCall);
                Handle temp_getRenderPass_return_value_0 = arg_pCreateInfo.getRenderPass();
                AssetItemID renderPass_id_value = AssetItemID.valueOf(temp_getRenderPass_return_value_0);
                VkRenderPassAsset renderPass = VkCreateFramebuffer.requireAsset(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, callbacks, functionCall, VkCreateFramebuffer.getVkRenderPassAsset(callbacks, functionCall, renderPass_id_value), renderPass_id_value);
                AssetItemID framebufferAsset_id_value = AssetItemID.valueOf(arg_pFramebuffer);
                ArrayList<VkImageViewAsset> temp_new_list_1 = new ArrayList<VkImageViewAsset>();
                Bitfield temp_getFlags_return_value_2 = arg_pCreateInfo.getFlags();
                Long temp_getHeight_return_value_3 = arg_pCreateInfo.getHeight();
                long temp_longValue_return_value_4 = temp_getHeight_return_value_3;
                Long temp_getLayers_return_value_5 = arg_pCreateInfo.getLayers();
                long temp_longValue_return_value_6 = temp_getLayers_return_value_5;
                Long temp_getWidth_return_value_7 = arg_pCreateInfo.getWidth();
                long temp_longValue_return_value_8 = temp_getWidth_return_value_7;
                VkFramebufferAsset vkFramebufferAsset = VkCreateFramebuffer.createNewVkFramebufferAsset(callbacks, functionCall, framebufferAsset_id_value, temp_new_list_1, temp_getFlags_return_value_2, temp_longValue_return_value_4, temp_longValue_return_value_6, renderPass, temp_longValue_return_value_8);
            }
        }
    }

    public static final class VkCreateGraphicsPipelines
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEGRAPHICSPIPELINES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentDevice(functionCall);
                Handle arg_pipelineCache = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPipelineCache(functionCall);
                Long arg_createInfoCount = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentCreateInfoCount(functionCall);
                List<@NonNull VULKAN.Structs.VkGraphicsPipelineCreateInfo> arg_pCreateInfos = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPCreateInfos(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPAllocator(functionCall);
                HandleArrayAttachment arg_pPipelines = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPPipelines(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateGraphicsPipelinesDecorator.getReturnValue(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_pPipelines);
                VkCreateGraphicsPipelines.forEachAssetItemID(temp_valueOf_return_value_0, pipelineAsset_id_value -> {
                    VkGraphicsPipelineAsset vkGraphicsPipelineAsset = VkCreateGraphicsPipelines.createNewVkGraphicsPipelineAsset(callbacks, functionCall, pipelineAsset_id_value);
                });
            }
        }
    }

    public static final class VkCreateImage
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateImageDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkImageCreateInfo arg_pCreateInfo = VULKAN.VkCreateImageDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateImageDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pImage = VULKAN.VkCreateImageDecorator.getArgumentPImage(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateImageDecorator.getReturnValue(functionCall);
                AssetItemID imageAsset_id_value = AssetItemID.valueOf(arg_pImage);
                Long temp_getArrayLayers_return_value_0 = arg_pCreateInfo.getArrayLayers();
                long temp_longValue_return_value_1 = temp_getArrayLayers_return_value_0;
                VULKAN.Structs.VkExtent3D temp_getExtent_return_value_2 = arg_pCreateInfo.getExtent();
                Bitfield temp_getFlags_return_value_3 = arg_pCreateInfo.getFlags();
                AbstractConstantOrAliasSpecExtended temp_getFormat_return_value_4 = arg_pCreateInfo.getFormat();
                AbstractConstantOrAliasSpecExtended temp_getImageType_return_value_5 = arg_pCreateInfo.getImageType();
                AbstractConstantOrAliasSpecExtended temp_getInitialLayout_return_value_6 = arg_pCreateInfo.getInitialLayout();
                Long temp_getMipLevels_return_value_7 = arg_pCreateInfo.getMipLevels();
                long temp_longValue_return_value_8 = temp_getMipLevels_return_value_7;
                LongsArgAttachment temp_getPQueueFamilyIndices_return_value_9 = arg_pCreateInfo.getPQueueFamilyIndices();
                Bitfield temp_valueOf_return_value_10 = Bitfield.valueOf(arg_pCreateInfo.getSamples());
                AbstractConstantOrAliasSpecExtended temp_getSharingMode_return_value_11 = arg_pCreateInfo.getSharingMode();
                AbstractConstantOrAliasSpecExtended temp_getTiling_return_value_12 = arg_pCreateInfo.getTiling();
                Bitfield temp_getUsage_return_value_13 = arg_pCreateInfo.getUsage();
                VkImageAsset vkImageAsset = VkCreateImage.createNewVkImageAsset(callbacks, functionCall, imageAsset_id_value, temp_longValue_return_value_1, temp_getExtent_return_value_2, temp_getFlags_return_value_3, temp_getFormat_return_value_4, temp_getImageType_return_value_5, temp_getInitialLayout_return_value_6, temp_longValue_return_value_8, temp_getPQueueFamilyIndices_return_value_9, temp_valueOf_return_value_10, temp_getSharingMode_return_value_11, temp_getTiling_return_value_12, temp_getUsage_return_value_13);
            }
        }
    }

    public static final class VkCreateImageView
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEIMAGEVIEW.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateImageViewDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkImageViewCreateInfo arg_pCreateInfo = VULKAN.VkCreateImageViewDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateImageViewDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pView = VULKAN.VkCreateImageViewDecorator.getArgumentPView(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateImageViewDecorator.getReturnValue(functionCall);
                Handle temp_getImage_return_value_0 = arg_pCreateInfo.getImage();
                AssetItemID imageAsset_id_value = AssetItemID.valueOf(temp_getImage_return_value_0);
                VkImageAsset imageAsset = VkCreateImageView.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, callbacks, functionCall, VkCreateImageView.getVkImageAsset(callbacks, functionCall, imageAsset_id_value), imageAsset_id_value);
                AssetItemID imageViewAsset_id_value = AssetItemID.valueOf(arg_pView);
                VULKAN.Structs.VkComponentMapping temp_getComponents_return_value_1 = arg_pCreateInfo.getComponents();
                Bitfield temp_getFlags_return_value_2 = arg_pCreateInfo.getFlags();
                AbstractConstantOrAliasSpecExtended temp_getFormat_return_value_3 = arg_pCreateInfo.getFormat();
                VULKAN.Structs.VkImageSubresourceRange temp_getSubresourceRange_return_value_4 = arg_pCreateInfo.getSubresourceRange();
                AbstractConstantOrAliasSpecExtended temp_getViewType_return_value_5 = arg_pCreateInfo.getViewType();
                VkImageViewAsset vkImageViewAsset = VkCreateImageView.createNewVkImageViewAsset(callbacks, functionCall, imageViewAsset_id_value, temp_getComponents_return_value_1, temp_getFlags_return_value_2, temp_getFormat_return_value_3, imageAsset, temp_getSubresourceRange_return_value_4, temp_getViewType_return_value_5);
            }
        }
    }

    public static final class VkCreatePipelineLayout
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEPIPELINELAYOUT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkPipelineLayoutCreateInfo arg_pCreateInfo = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pPipelineLayout = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPPipelineLayout(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreatePipelineLayoutDecorator.getReturnValue(functionCall);
                AssetItemID pipelineLayout_id_value = AssetItemID.valueOf(arg_pPipelineLayout);
                Bitfield temp_getFlags_return_value_0 = arg_pCreateInfo.getFlags();
                List<VULKAN.Structs.VkPushConstantRange> temp_getPPushConstantRanges_return_value_1 = arg_pCreateInfo.getPPushConstantRanges();
                ArrayList<VkDescriptorSetLayoutAsset> temp_new_list_2 = new ArrayList<VkDescriptorSetLayoutAsset>();
                VkPipelineLayoutAsset vkPipelineLayoutAsset = VkCreatePipelineLayout.createNewVkPipelineLayoutAsset(callbacks, functionCall, pipelineLayout_id_value, temp_getFlags_return_value_0, temp_getPPushConstantRanges_return_value_1, temp_new_list_2);
            }
        }
    }

    public static final class VkCreateRenderPass
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATERENDERPASS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateRenderPassDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkRenderPassCreateInfo arg_pCreateInfo = VULKAN.VkCreateRenderPassDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateRenderPassDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pRenderPass = VULKAN.VkCreateRenderPassDecorator.getArgumentPRenderPass(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateRenderPassDecorator.getReturnValue(functionCall);
                AssetItemID renderPassAsset_id_value = AssetItemID.valueOf(arg_pRenderPass);
                List<IVkAttachmentDescription> temp_map_return_value_1 = ValueTransformHelper.map(arg_pCreateInfo.getPAttachments(), temp_list_xform_value_0 -> ValueTransformHelper.toIvKAttachmentDescription(temp_list_xform_value_0));
                List<IVkSubpassDependency> temp_map_return_value_3 = ValueTransformHelper.map(arg_pCreateInfo.getPDependencies(), temp_list_xform_value_2 -> ValueTransformHelper.toIvKSubpassDependency(temp_list_xform_value_2));
                Bitfield temp_getFlags_return_value_4 = arg_pCreateInfo.getFlags();
                List<IVkSubpassDescription> temp_map_return_value_6 = ValueTransformHelper.map(arg_pCreateInfo.getPSubpasses(), temp_list_xform_value_5 -> ValueTransformHelper.toIvKSubpassDescription(temp_list_xform_value_5));
                VkRenderPassAsset vkRenderPassAsset = VkCreateRenderPass.createNewVkRenderPassAsset(callbacks, functionCall, renderPassAsset_id_value, temp_map_return_value_1, temp_map_return_value_3, temp_getFlags_return_value_4, temp_map_return_value_6);
            }
        }
    }

    public static final class VkCreateRenderPass2
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATERENDERPASS2.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateRenderPass2Decorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkRenderPassCreateInfo2 arg_pCreateInfo = VULKAN.VkCreateRenderPass2Decorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateRenderPass2Decorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pRenderPass = VULKAN.VkCreateRenderPass2Decorator.getArgumentPRenderPass(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateRenderPass2Decorator.getReturnValue(functionCall);
                AssetItemID renderPassAsset_id_value = AssetItemID.valueOf(arg_pRenderPass);
                List<IVkAttachmentDescription> temp_map_return_value_1 = ValueTransformHelper.map(arg_pCreateInfo.getPAttachments(), temp_list_xform_value_0 -> ValueTransformHelper.toIvKAttachmentDescription(temp_list_xform_value_0));
                List<IVkSubpassDependency> temp_map_return_value_3 = ValueTransformHelper.map(arg_pCreateInfo.getPDependencies(), temp_list_xform_value_2 -> ValueTransformHelper.toIvKSubpassDependency(temp_list_xform_value_2));
                Bitfield temp_getFlags_return_value_4 = arg_pCreateInfo.getFlags();
                List<IVkSubpassDescription> temp_map_return_value_6 = ValueTransformHelper.map(arg_pCreateInfo.getPSubpasses(), temp_list_xform_value_5 -> ValueTransformHelper.toIvKSubpassDescription(temp_list_xform_value_5));
                VkRenderPassAsset vkRenderPassAsset = VkCreateRenderPass2.createNewVkRenderPassAsset(callbacks, functionCall, renderPassAsset_id_value, temp_map_return_value_1, temp_map_return_value_3, temp_getFlags_return_value_4, temp_map_return_value_6);
            }
        }
    }

    public static final class VkCreateShaderModule
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATESHADERMODULE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateShaderModuleDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkShaderModuleCreateInfo arg_pCreateInfo = VULKAN.VkCreateShaderModuleDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateShaderModuleDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pShaderModule = VULKAN.VkCreateShaderModuleDecorator.getArgumentPShaderModule(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateShaderModuleDecorator.getReturnValue(functionCall);
                AssetItemID shaderModuleAsset_id_value = AssetItemID.valueOf(arg_pShaderModule);
                VkShaderModuleAsset vkShaderModuleAsset = VkCreateShaderModule.createNewVkShaderModuleAsset(callbacks, functionCall, shaderModuleAsset_id_value);
            }
        }
    }

    public static final class VkCreateSwapchainKhr
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATESWAPCHAINKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkSwapchainCreateInfoKHR arg_pCreateInfo = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pSwapchain = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPSwapchain(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateSwapchainKHRDecorator.getReturnValue(functionCall);
                AssetItemID swapchainAsset_id_value = AssetItemID.valueOf(arg_pSwapchain);
                AbstractConstantOrAliasSpecExtended temp_getClipped_return_value_0 = arg_pCreateInfo.getClipped();
                Bitfield temp_valueOf_return_value_1 = Bitfield.valueOf(arg_pCreateInfo.getCompositeAlpha());
                Long temp_getImageArrayLayers_return_value_2 = arg_pCreateInfo.getImageArrayLayers();
                long temp_longValue_return_value_3 = temp_getImageArrayLayers_return_value_2;
                AbstractConstantOrAliasSpecExtended temp_getImageColorSpace_return_value_4 = arg_pCreateInfo.getImageColorSpace();
                VULKAN.Structs.VkExtent2D temp_getImageExtent_return_value_5 = arg_pCreateInfo.getImageExtent();
                AbstractConstantOrAliasSpecExtended temp_getImageFormat_return_value_6 = arg_pCreateInfo.getImageFormat();
                AbstractConstantOrAliasSpecExtended temp_getImageSharingMode_return_value_7 = arg_pCreateInfo.getImageSharingMode();
                Bitfield temp_getImageUsage_return_value_8 = arg_pCreateInfo.getImageUsage();
                Bitfield temp_valueOf_return_value_9 = Bitfield.valueOf(arg_pCreateInfo.getPreTransform());
                AbstractConstantOrAliasSpecExtended temp_getPresentMode_return_value_10 = arg_pCreateInfo.getPresentMode();
                LongsArgAttachment temp_getPQueueFamilyIndices_return_value_11 = arg_pCreateInfo.getPQueueFamilyIndices();
                Handle temp_getSurface_return_value_12 = arg_pCreateInfo.getSurface();
                VkSwapchainKHRAsset vkSwapchainKHRAsset = VkCreateSwapchainKhr.createNewVkSwapchainKHRAsset(callbacks, functionCall, swapchainAsset_id_value, temp_getClipped_return_value_0, temp_valueOf_return_value_1, temp_longValue_return_value_3, temp_getImageColorSpace_return_value_4, temp_getImageExtent_return_value_5, temp_getImageFormat_return_value_6, temp_getImageSharingMode_return_value_7, temp_getImageUsage_return_value_8, temp_valueOf_return_value_9, temp_getPresentMode_return_value_10, temp_getPQueueFamilyIndices_return_value_11, temp_getSurface_return_value_12);
            }
        }
    }

    public static final class VkDestroyBuffer
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyBufferDecorator.getArgumentDevice(functionCall);
                Handle arg_buffer = VULKAN.VkDestroyBufferDecorator.getArgumentBuffer(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyBufferDecorator.getArgumentPAllocator(functionCall);
                AssetItemID deletedBufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                VkBufferAsset deletedBufferAsset = VkDestroyBuffer.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, callbacks, functionCall, VkDestroyBuffer.getVkBufferAsset(callbacks, functionCall, deletedBufferAsset_id_value), deletedBufferAsset_id_value);
                deletedBufferAsset.addFunctionCall(functionCall);
                AssetItemID bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                VkBufferAsset bufferAsset = VkDestroyBuffer.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, callbacks, functionCall, VkDestroyBuffer.getVkBufferAsset(callbacks, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                if (bufferAsset != null) {
                    bufferAsset.addFunctionCall(functionCall);
                    bufferAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyBufferView
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYBUFFERVIEW.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyBufferViewDecorator.getArgumentDevice(functionCall);
                Handle arg_bufferView = VULKAN.VkDestroyBufferViewDecorator.getArgumentBufferView(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyBufferViewDecorator.getArgumentPAllocator(functionCall);
                AssetItemID bufferView_id_value = AssetItemID.valueOf(arg_bufferView);
                VkBufferViewAsset bufferView = VkDestroyBufferView.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS, callbacks, functionCall, this.getVkBufferViewAsset(callbacks, functionCall, bufferView_id_value), bufferView_id_value, AssetItemID.valueOf(0));
                if (bufferView != null) {
                    bufferView.addFunctionCall(functionCall);
                    bufferView.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyDescriptorPool
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYDESCRIPTORPOOL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyDescriptorPoolDecorator.getArgumentDevice(functionCall);
                Handle arg_descriptorPool = VULKAN.VkDestroyDescriptorPoolDecorator.getArgumentDescriptorPool(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyDescriptorPoolDecorator.getArgumentPAllocator(functionCall);
                AssetItemID descriptorPoolAsset_id_value = AssetItemID.valueOf(arg_descriptorPool);
                VkDescriptorPoolAsset descriptorPoolAsset = VkDestroyDescriptorPool.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, callbacks, functionCall, VkDestroyDescriptorPool.getVkDescriptorPoolAsset(callbacks, functionCall, descriptorPoolAsset_id_value), descriptorPoolAsset_id_value, AssetItemID.valueOf(0));
                if (descriptorPoolAsset != null) {
                    descriptorPoolAsset.addFunctionCall(functionCall);
                    descriptorPoolAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyDescriptorSetLayout
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYDESCRIPTORSETLAYOUT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyDescriptorSetLayoutDecorator.getArgumentDevice(functionCall);
                Handle arg_descriptorSetLayout = VULKAN.VkDestroyDescriptorSetLayoutDecorator.getArgumentDescriptorSetLayout(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyDescriptorSetLayoutDecorator.getArgumentPAllocator(functionCall);
                AssetItemID descriptorSetLayoutAsset_id_value = AssetItemID.valueOf(arg_descriptorSetLayout);
                VkDescriptorSetLayoutAsset descriptorSetLayoutAsset = VkDestroyDescriptorSetLayout.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS, callbacks, functionCall, this.getVkDescriptorSetLayoutAsset(callbacks, functionCall, descriptorSetLayoutAsset_id_value), descriptorSetLayoutAsset_id_value, AssetItemID.valueOf(0));
                if (descriptorSetLayoutAsset != null) {
                    descriptorSetLayoutAsset.addFunctionCall(functionCall);
                    descriptorSetLayoutAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyFramebuffer
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyFramebufferDecorator.getArgumentDevice(functionCall);
                Handle arg_framebuffer = VULKAN.VkDestroyFramebufferDecorator.getArgumentFramebuffer(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyFramebufferDecorator.getArgumentPAllocator(functionCall);
                AssetItemID framebufferAsset_id_value = AssetItemID.valueOf(arg_framebuffer);
                VkFramebufferAsset framebufferAsset = VkDestroyFramebuffer.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, VkDestroyFramebuffer.getVkFramebufferAsset(callbacks, functionCall, framebufferAsset_id_value), framebufferAsset_id_value);
                if (framebufferAsset != null) {
                    framebufferAsset.addFunctionCall(functionCall);
                    framebufferAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyImage
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyImageDecorator.getArgumentDevice(functionCall);
                Handle arg_image = VULKAN.VkDestroyImageDecorator.getArgumentImage(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyImageDecorator.getArgumentPAllocator(functionCall);
                AssetItemID deletedImageAsset_id_value = AssetItemID.valueOf(arg_image);
                VkImageAsset deletedImageAsset = VkDestroyImage.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, callbacks, functionCall, VkDestroyImage.getVkImageAsset(callbacks, functionCall, deletedImageAsset_id_value), deletedImageAsset_id_value);
                deletedImageAsset.addFunctionCall(functionCall);
                AssetItemID imageAsset_id_value = AssetItemID.valueOf(arg_image);
                VkImageAsset imageAsset = VkDestroyImage.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, callbacks, functionCall, VkDestroyImage.getVkImageAsset(callbacks, functionCall, imageAsset_id_value), imageAsset_id_value, AssetItemID.valueOf(0));
                if (imageAsset != null) {
                    imageAsset.addFunctionCall(functionCall);
                    imageAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyImageView
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYIMAGEVIEW.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyImageViewDecorator.getArgumentDevice(functionCall);
                Handle arg_imageView = VULKAN.VkDestroyImageViewDecorator.getArgumentImageView(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyImageViewDecorator.getArgumentPAllocator(functionCall);
                AssetItemID imageViewAsset_id_value = AssetItemID.valueOf(arg_imageView);
                VkImageViewAsset imageViewAsset = VkDestroyImageView.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS, callbacks, functionCall, VkDestroyImageView.getVkImageViewAsset(callbacks, functionCall, imageViewAsset_id_value), imageViewAsset_id_value, AssetItemID.valueOf(0));
                if (imageViewAsset != null) {
                    imageViewAsset.addFunctionCall(functionCall);
                    imageViewAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyPipeline
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYPIPELINE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyPipelineDecorator.getArgumentDevice(functionCall);
                Handle arg_pipeline = VULKAN.VkDestroyPipelineDecorator.getArgumentPipeline(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyPipelineDecorator.getArgumentPAllocator(functionCall);
                AssetItemID pipelineAsset_id_value = AssetItemID.valueOf(arg_pipeline);
                VkPipelineAsset<?, ?> pipelineAsset = VkDestroyPipeline.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS, callbacks, functionCall, VkDestroyPipeline.getVkPipelineAsset(callbacks, functionCall, pipelineAsset_id_value), pipelineAsset_id_value, AssetItemID.valueOf(0));
                if (pipelineAsset != null) {
                    pipelineAsset.addFunctionCall(functionCall);
                    pipelineAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyPipelineLayout
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYPIPELINELAYOUT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyPipelineLayoutDecorator.getArgumentDevice(functionCall);
                Handle arg_pipelineLayout = VULKAN.VkDestroyPipelineLayoutDecorator.getArgumentPipelineLayout(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyPipelineLayoutDecorator.getArgumentPAllocator(functionCall);
                AssetItemID pipelineLayoutAsset_id_value = AssetItemID.valueOf(arg_pipelineLayout);
                VkPipelineLayoutAsset pipelineLayoutAsset = VkDestroyPipelineLayout.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS, callbacks, functionCall, VkDestroyPipelineLayout.getVkPipelineLayoutAsset(callbacks, functionCall, pipelineLayoutAsset_id_value), pipelineLayoutAsset_id_value, AssetItemID.valueOf(0));
                if (pipelineLayoutAsset != null) {
                    pipelineLayoutAsset.addFunctionCall(functionCall);
                    pipelineLayoutAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyRenderPass
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYRENDERPASS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyRenderPassDecorator.getArgumentDevice(functionCall);
                Handle arg_renderPass = VULKAN.VkDestroyRenderPassDecorator.getArgumentRenderPass(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyRenderPassDecorator.getArgumentPAllocator(functionCall);
                AssetItemID renderPassAsset_id_value = AssetItemID.valueOf(arg_renderPass);
                VkRenderPassAsset renderPassAsset = VkDestroyRenderPass.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, callbacks, functionCall, VkDestroyRenderPass.getVkRenderPassAsset(callbacks, functionCall, renderPassAsset_id_value), renderPassAsset_id_value);
                if (renderPassAsset != null) {
                    renderPassAsset.addFunctionCall(functionCall);
                    renderPassAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroyShaderModule
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYSHADERMODULE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyShaderModuleDecorator.getArgumentDevice(functionCall);
                Handle arg_shaderModule = VULKAN.VkDestroyShaderModuleDecorator.getArgumentShaderModule(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyShaderModuleDecorator.getArgumentPAllocator(functionCall);
                AssetItemID shaderModuleAsset_id_value = AssetItemID.valueOf(arg_shaderModule);
                VkShaderModuleAsset shaderModuleAsset = VkDestroyShaderModule.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS, callbacks, functionCall, VkDestroyShaderModule.getVkShaderModuleAsset(callbacks, functionCall, shaderModuleAsset_id_value), shaderModuleAsset_id_value, AssetItemID.valueOf(0));
                if (shaderModuleAsset != null) {
                    shaderModuleAsset.addFunctionCall(functionCall);
                    shaderModuleAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkDestroySwapchainKhr
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYSWAPCHAINKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroySwapchainKHRDecorator.getArgumentDevice(functionCall);
                Handle arg_swapchain = VULKAN.VkDestroySwapchainKHRDecorator.getArgumentSwapchain(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroySwapchainKHRDecorator.getArgumentPAllocator(functionCall);
                AssetItemID swapchainAsset_id_value = AssetItemID.valueOf(arg_swapchain);
                VkSwapchainKHRAsset swapchainAsset = VkDestroySwapchainKhr.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS, callbacks, functionCall, VkDestroySwapchainKhr.getVkSwapchainKHRAsset(callbacks, functionCall, swapchainAsset_id_value), swapchainAsset_id_value, AssetItemID.valueOf(0));
                if (swapchainAsset != null) {
                    swapchainAsset.addFunctionCall(functionCall);
                    swapchainAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkEndCommandBuffer
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKENDCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_commandBuffer = VULKAN.VkEndCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkEndCommandBufferDecorator.getReturnValue(functionCall);
                AssetItemID commandBufferAsset_id_value = AssetItemID.valueOf(arg_commandBuffer);
                VkCommandBufferAsset commandBufferAsset = VkEndCommandBuffer.requireAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, callbacks, functionCall, VkEndCommandBuffer.getVkCommandBufferAsset(callbacks, functionCall, commandBufferAsset_id_value), commandBufferAsset_id_value);
                commandBufferAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class VkFreeCommandBuffers
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKFREECOMMANDBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkFreeCommandBuffersDecorator.getArgumentDevice(functionCall);
                Handle arg_commandPool = VULKAN.VkFreeCommandBuffersDecorator.getArgumentCommandPool(functionCall);
                Long arg_commandBufferCount = VULKAN.VkFreeCommandBuffersDecorator.getArgumentCommandBufferCount(functionCall);
                LongsArgAttachment arg_pCommandBuffers = VULKAN.VkFreeCommandBuffersDecorator.getArgumentPCommandBuffers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_pCommandBuffers);
                VkFreeCommandBuffers.forEachAssetItemID(temp_valueOf_return_value_0, allocatedCommandBuffer_id_value -> {
                    VkCommandBufferAsset allocatedCommandBuffer = VkFreeCommandBuffers.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, callbacks, functionCall, VkFreeCommandBuffers.getVkCommandBufferAsset(callbacks, functionCall, allocatedCommandBuffer_id_value), allocatedCommandBuffer_id_value);
                    if (allocatedCommandBuffer != null) {
                        allocatedCommandBuffer.addFunctionCall(functionCall);
                        allocatedCommandBuffer.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class VkFreeDescriptorSets
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKFREEDESCRIPTORSETS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkFreeDescriptorSetsDecorator.getArgumentDevice(functionCall);
                Handle arg_descriptorPool = VULKAN.VkFreeDescriptorSetsDecorator.getArgumentDescriptorPool(functionCall);
                Long arg_descriptorSetCount = VULKAN.VkFreeDescriptorSetsDecorator.getArgumentDescriptorSetCount(functionCall);
                HandleArrayAttachment arg_pDescriptorSets = VULKAN.VkFreeDescriptorSetsDecorator.getArgumentPDescriptorSets(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkFreeDescriptorSetsDecorator.getReturnValue(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_pDescriptorSets);
                VkFreeDescriptorSets.forEachAssetItemID(temp_valueOf_return_value_0, allocatedDescriptorSet_id_value -> {
                    VkDescriptorSetAsset allocatedDescriptorSet = VkFreeDescriptorSets.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS, callbacks, functionCall, VkFreeDescriptorSets.getVkDescriptorSetAsset(callbacks, functionCall, allocatedDescriptorSet_id_value), allocatedDescriptorSet_id_value, AssetItemID.valueOf(0));
                    if (allocatedDescriptorSet != null) {
                        allocatedDescriptorSet.addFunctionCall(functionCall);
                        allocatedDescriptorSet.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class VkFreeMemory
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKFREEMEMORY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkFreeMemoryDecorator.getArgumentDevice(functionCall);
                Handle arg_memory = VULKAN.VkFreeMemoryDecorator.getArgumentMemory(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkFreeMemoryDecorator.getArgumentPAllocator(functionCall);
                AssetItemID memoryAsset_id_value = AssetItemID.valueOf(arg_memory);
                VkDeviceMemoryAsset memoryAsset = VkFreeMemory.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, callbacks, functionCall, VkFreeMemory.getVkDeviceMemoryAsset(callbacks, functionCall, memoryAsset_id_value), memoryAsset_id_value, AssetItemID.valueOf(0));
                if (memoryAsset != null) {
                    memoryAsset.addFunctionCall(functionCall);
                    memoryAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class VkGetSwapchainImagesKhr
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKGETSWAPCHAINIMAGESKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentDevice(functionCall);
                Handle arg_swapchain = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentSwapchain(functionCall);
                LongPtrArgAttachment arg_pSwapchainImageCount = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentPSwapchainImageCount(functionCall);
                HandleArrayAttachment arg_pSwapchainImages = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentPSwapchainImages(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkGetSwapchainImagesKHRDecorator.getReturnValue(functionCall);
                AssetItemID swapchainAsset_id_value = AssetItemID.valueOf(arg_swapchain);
                VkSwapchainKHRAsset swapchainAsset = VkGetSwapchainImagesKhr.requireAsset(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS, callbacks, functionCall, VkGetSwapchainImagesKhr.getVkSwapchainKHRAsset(callbacks, functionCall, swapchainAsset_id_value), swapchainAsset_id_value);
                swapchainAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class VkResetCommandBuffer
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKRESETCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_commandBuffer = VULKAN.VkResetCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                Bitfield arg_flags = VULKAN.VkResetCommandBufferDecorator.getArgumentFlags(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkResetCommandBufferDecorator.getReturnValue(functionCall);
                AssetItemID commandBufferAsset_id_value = AssetItemID.valueOf(arg_commandBuffer);
                VkCommandBufferAsset commandBufferAsset = VkResetCommandBuffer.requireAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, callbacks, functionCall, VkResetCommandBuffer.getVkCommandBufferAsset(callbacks, functionCall, commandBufferAsset_id_value), commandBufferAsset_id_value);
                commandBufferAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class VkResetDescriptorPool
    extends AbstractVulkanAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKRESETDESCRIPTORPOOL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkResetDescriptorPoolDecorator.getArgumentDevice(functionCall);
                Handle arg_descriptorPool = VULKAN.VkResetDescriptorPoolDecorator.getArgumentDescriptorPool(functionCall);
                Bitfield arg_flags = VULKAN.VkResetDescriptorPoolDecorator.getArgumentFlags(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkResetDescriptorPoolDecorator.getReturnValue(functionCall);
                AssetItemID descriptorPoolAsset_id_value = AssetItemID.valueOf(arg_descriptorPool);
                VkDescriptorPoolAsset descriptorPoolAsset = VkResetDescriptorPool.requireAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, callbacks, functionCall, VkResetDescriptorPool.getVkDescriptorPoolAsset(callbacks, functionCall, descriptorPoolAsset_id_value), descriptorPoolAsset_id_value);
                descriptorPoolAsset.addFunctionCall(functionCall);
            }
        }
    }
}

