/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.gles;

import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TextureArgAttachment;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.gles.GlAtomicCounterBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlBufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferRenderbufferAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferTextureAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferZeroAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlImageUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramPipelineAsset;
import com.arm.mgd.lightweight.asset.gles.GlQueryObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlRenderbufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlSamplerAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderStorageBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlSyncObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureImageAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureSurfaceAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlUniformBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexArrayObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexBufferBindingAsset;
import com.arm.mgd.lightweight.asset.gles.ShaderUniform;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlAtomicCounterBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlBufferAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlFramebufferAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlFramebufferAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlImageUnitAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlProgramPipelineAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlQueryObjectAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlRenderbufferAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlSamplerAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlShaderAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlShaderStorageBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlSyncObjectAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlTextureAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlTextureImageAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlTextureUnitAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlTransformFeedbackAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlTransformFeedbackBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlUniformBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlVertexArrayObjectAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlVertexAttributeAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlVertexBufferBindingAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetValueProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.ProvidedAssetProcessors;
import com.arm.mgd.lightweight.asset.processor.gles.AbstractGlesAssetValueProcessorBase;
import com.arm.mgd.lightweight.asset.properties.ByteArrayPropertyValue;
import com.arm.mgd.lightweight.asset.properties.IAssetProperty;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.ListPropertyValue;
import com.arm.mgd.lightweight.asset.properties.MapPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ShaderUniformValuePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimplePropertyValue;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.lightweight.state.IStateItemValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GlesAssetValueProcessor {

    private static class Constants {
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_0 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_READ_WRITE, KapiSpec.GLES.constants.GL_READ_ONLY, KapiSpec.GLES.constants.GL_WRITE_ONLY));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_1 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_RGBA32I, KapiSpec.GLES.constants.GL_RGBA8I, KapiSpec.GLES.constants.GL_R32F, KapiSpec.GLES.constants.GL_RGBA8UI, KapiSpec.GLES.constants.GL_R32I, KapiSpec.GLES.constants.GL_RGBA8, KapiSpec.GLES.constants.GL_R32UI, KapiSpec.GLES.constants.GL_RGBA32UI, KapiSpec.GLES.constants.GL_RGBA16F, KapiSpec.GLES.constants.GL_RGBA8_SNORM, KapiSpec.GLES.constants.GL_RGBA16I, KapiSpec.GLES.constants.GL_RGBA16UI, KapiSpec.GLES.constants.GL_RGBA32F));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_2 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_ANY_SAMPLES_PASSED, KapiSpec.GLES.constants.GL_TIME_ELAPSED_EXT, KapiSpec.GLES.constants.GL_ANY_SAMPLES_PASSED_CONSERVATIVE, KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, KapiSpec.GLES.constants.GL_TIMESTAMP_EXT, KapiSpec.GLES.constants.GL_PRIMITIVES_GENERATED));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_3 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_SYNC_GPU_COMMANDS_COMPLETE));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_4 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_ARRAY, KapiSpec.GLES.constants.GL_TEXTURE_2D, KapiSpec.GLES.constants.GL_TEXTURE_BUFFER, KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE, KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP, KapiSpec.GLES.constants.GL_TEXTURE_3D, KapiSpec.GLES.constants.GL_TEXTURE_EXTERNAL_OES, KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE_ARRAY, KapiSpec.GLES.constants.GL_TEXTURE_2D_ARRAY));

        private Constants() {
        }
    }

    public static final class GlAtomicCounterBufferBindingPointAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlAtomicCounterBufferBindingPointAsset, GlAtomicCounterBufferBindingPointAsset.Value> {
        public static final @NonNull GlAtomicCounterBufferBindingPointAssetValueProcessor INSTANCE = new GlAtomicCounterBufferBindingPointAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERBASE, GlBindBufferBase.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERRANGE, GlBindBufferRange.HELPER_INSTANCE);
            }
        };

        private GlAtomicCounterBufferBindingPointAssetValueProcessor() {
        }

        @Override
        public @NonNull GlAtomicCounterBufferBindingPointAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlAtomicCounterBufferBindingPointAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlAtomicCounterBufferBindingPointAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> buffer = new SimplePropertyValue<Object>(assetObject, AbstractGlAtomicCounterBufferBindingPointAsset.GlAtomicCounterBufferBindingPointAssetProperties.PROPERTY_BUFFER, null);
            SimplePropertyValue<@NonNull Long> length = new SimplePropertyValue<Long>(assetObject, AbstractGlAtomicCounterBufferBindingPointAsset.GlAtomicCounterBufferBindingPointAssetProperties.PROPERTY_LENGTH, 0L);
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(assetObject, AbstractGlAtomicCounterBufferBindingPointAsset.GlAtomicCounterBufferBindingPointAssetProperties.PROPERTY_OFFSET, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(buffer, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, buffer, length, offset)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlAtomicCounterBufferBindingPointAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
        }

        @Override
        public @NonNull GlAtomicCounterBufferBindingPointAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlAtomicCounterBufferBindingPointAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlAtomicCounterBufferBindingPointAsset assetObject = (GlAtomicCounterBufferBindingPointAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlAtomicCounterBufferBindingPointAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable GlBufferAsset> buffer = new SimplePropertyValue<GlBufferAsset>(fromValue.getBuffer());
            SimplePropertyValue<@NonNull Long> length = new SimplePropertyValue<Long>(fromValue.getLength());
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(fromValue.getOffset());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(buffer, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, buffer, length, offset)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlAtomicCounterBufferBindingPointAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlAtomicCounterBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> buffer, @NonNull SimplePropertyValue<@NonNull Long> length, @NonNull SimplePropertyValue<@NonNull Long> offset) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, buffer, length, offset);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlAtomicCounterBufferBindingPointAsset.Value processedValue;
                GlAtomicCounterBufferBindingPointAsset.Value unProcessedValue = new GlAtomicCounterBufferBindingPointAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                buffer.setValueFrom(functionCall, processedValue.getBuffer());
                length.setValueFrom(functionCall, processedValue.getLength());
                offset.setValueFrom(functionCall, processedValue.getOffset());
            }
            return result;
        }

        private static final class GlBindBufferBase
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferBase HELPER_INSTANCE = new GlBindBufferBase();

            private GlBindBufferBase() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlAtomicCounterBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_length, @NonNull SimplePropertyValue<@NonNull Long> property_offset) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERBASE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractAssetItem abstractAssetItem;
                    AssetItemID bindingAsset_id_value;
                    GlBufferAsset bufferAsset;
                    AssetItemID bufferAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferBaseDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        GlAtomicCounterBufferBindingPointAsset bindingAsset = assetObject;
                        property_buffer.setValue(functionCall, bufferAsset);
                        property_offset.setValue(functionCall, 0L);
                        GlBufferAsset.Value temp_safeWaitForValue_return_value_1 = (GlBufferAsset.Value)GlBindBufferBase.safeWaitForValue(callbacks, bufferAsset, functionCall.getID());
                        Long temp_valueOf_return_value_2 = temp_safeWaitForValue_return_value_1 != null ? temp_safeWaitForValue_return_value_1.getSize().getValue() : 0L;
                        property_length.setValue(functionCall, temp_valueOf_return_value_2);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class GlBindBufferRange
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferRange HELPER_INSTANCE = new GlBindBufferRange();

            private GlBindBufferRange() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlAtomicCounterBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_length, @NonNull SimplePropertyValue<@NonNull Long> property_offset) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERRANGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractAssetItem abstractAssetItem;
                    AssetItemID bindingAsset_id_value;
                    GlBufferAsset bufferAsset;
                    AssetItemID bufferAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferRangeDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
                    Long arg_offset = GLES.GlBindBufferRangeDecorator.getArgumentOffset(functionCall);
                    Long arg_size = GLES.GlBindBufferRangeDecorator.getArgumentSize(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        GlAtomicCounterBufferBindingPointAsset bindingAsset = assetObject;
                        property_buffer.setValue(functionCall, bufferAsset);
                        property_offset.setValue(functionCall, arg_offset);
                        property_length.setValue(functionCall, arg_size);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlAtomicCounterBufferBindingPointAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull Long> var6) throws Exception;
        }
    }

    public static final class GlBufferAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlBufferAsset, GlBufferAsset.Value> {
        public static final @NonNull GlBufferAssetValueProcessor INSTANCE = new GlBufferAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDBUFFER, GlBindBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERBASE, GlBindBufferBase.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERRANGE, GlBindBufferRange.HELPER_INSTANCE);
            }
        };

        private GlBufferAssetValueProcessor() {
        }

        @Override
        public @NonNull GlBufferAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlBufferAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlBufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> accessFlags = new SimplePropertyValue<Long>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_ACCESS_FLAGS, 0L);
            ByteArrayPropertyValue data = new ByteArrayPropertyValue((IAssetItem<?, ?>)assetObject, (IAssetProperty<byte[]>)AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_DATA);
            SimplePropertyValue<@Nullable Object> firstBinding = new SimplePropertyValue<Object>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_FIRST_BINDING, null);
            SimplePropertyValue<@Nullable Object> lastBoundTarget = new SimplePropertyValue<Object>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_LAST_BOUND_TARGET, null);
            SimplePropertyValue<@NonNull Long> mapLength = new SimplePropertyValue<Long>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_MAP_LENGTH, 0L);
            SimplePropertyValue<@NonNull Long> mapOffset = new SimplePropertyValue<Long>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_MAP_OFFSET, 0L);
            SimplePropertyValue<@NonNull Pointer> mapPointer = new SimplePropertyValue<Pointer>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_MAP_POINTER, Pointer.valueOf(0L));
            SimplePropertyValue<@NonNull Boolean> mapped = new SimplePropertyValue<Boolean>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_MAPPED, false);
            SimplePropertyValue<@NonNull Long> size = new SimplePropertyValue<Long>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> usage = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlBufferAsset.GlBufferAssetProperties.PROPERTY_USAGE, KapiSpec.GLES.constants.GL_STATIC_DRAW);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, accessFlags, data, firstBinding, lastBoundTarget, mapLength, mapOffset, mapPointer, mapped, size, usage)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlBufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)accessFlags, data, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)firstBinding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)lastBoundTarget, (IAssetPropertyValue<Long>)mapLength, (IAssetPropertyValue<Long>)mapOffset, (IAssetPropertyValue<Pointer>)mapPointer, (IAssetPropertyValue<Boolean>)mapped, (IAssetPropertyValue<Long>)size, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)usage);
        }

        @Override
        public @NonNull GlBufferAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlBufferAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlBufferAsset assetObject = (GlBufferAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlBufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> accessFlags = new SimplePropertyValue<Long>(fromValue.getAccessFlags());
            ByteArrayPropertyValue data = new ByteArrayPropertyValue(fromValue.getData());
            SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> firstBinding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getFirstBinding());
            SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> lastBoundTarget = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getLastBoundTarget());
            SimplePropertyValue<@NonNull Long> mapLength = new SimplePropertyValue<Long>(fromValue.getMapLength());
            SimplePropertyValue<@NonNull Long> mapOffset = new SimplePropertyValue<Long>(fromValue.getMapOffset());
            SimplePropertyValue<@NonNull Pointer> mapPointer = new SimplePropertyValue<Pointer>(fromValue.getMapPointer());
            SimplePropertyValue<@NonNull Boolean> mapped = new SimplePropertyValue<Boolean>(fromValue.getMapped());
            SimplePropertyValue<@NonNull Long> size = new SimplePropertyValue<Long>(fromValue.getSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> usage = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getUsage());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, accessFlags, data, firstBinding, lastBoundTarget, mapLength, mapOffset, mapPointer, mapped, size, usage)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlBufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)accessFlags, data, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)firstBinding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)lastBoundTarget, (IAssetPropertyValue<Long>)mapLength, (IAssetPropertyValue<Long>)mapOffset, (IAssetPropertyValue<Pointer>)mapPointer, (IAssetPropertyValue<Boolean>)mapped, (IAssetPropertyValue<Long>)size, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)usage);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> accessFlags, @NonNull ByteArrayPropertyValue data, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> firstBinding, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> lastBoundTarget, @NonNull SimplePropertyValue<@NonNull Long> mapLength, @NonNull SimplePropertyValue<@NonNull Long> mapOffset, @NonNull SimplePropertyValue<@NonNull Pointer> mapPointer, @NonNull SimplePropertyValue<@NonNull Boolean> mapped, @NonNull SimplePropertyValue<@NonNull Long> size, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> usage) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, accessFlags, data, firstBinding, lastBoundTarget, mapLength, mapOffset, mapPointer, mapped, size, usage);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlBufferAsset.Value processedValue;
                GlBufferAsset.Value unProcessedValue = new GlBufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)accessFlags, data, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)firstBinding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)lastBoundTarget, (IAssetPropertyValue<Long>)mapLength, (IAssetPropertyValue<Long>)mapOffset, (IAssetPropertyValue<Pointer>)mapPointer, (IAssetPropertyValue<Boolean>)mapped, (IAssetPropertyValue<Long>)size, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)usage);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                accessFlags.setValueFrom(functionCall, processedValue.getAccessFlags());
                data.setValueFrom(functionCall, processedValue.getData());
                firstBinding.setValueFrom(functionCall, processedValue.getFirstBinding());
                lastBoundTarget.setValueFrom(functionCall, processedValue.getLastBoundTarget());
                mapLength.setValueFrom(functionCall, processedValue.getMapLength());
                mapOffset.setValueFrom(functionCall, processedValue.getMapOffset());
                mapPointer.setValueFrom(functionCall, processedValue.getMapPointer());
                mapped.setValueFrom(functionCall, processedValue.getMapped());
                size.setValueFrom(functionCall, processedValue.getSize());
                usage.setValueFrom(functionCall, processedValue.getUsage());
            }
            return result;
        }

        private static final class GlBindBuffer
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBuffer HELPER_INSTANCE = new GlBindBuffer();

            private GlBindBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_accessFlags, @NonNull ByteArrayPropertyValue property_data, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_firstBinding, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_lastBoundTarget, @NonNull SimplePropertyValue<@NonNull Long> property_mapLength, @NonNull SimplePropertyValue<@NonNull Long> property_mapOffset, @NonNull SimplePropertyValue<@NonNull Pointer> property_mapPointer, @NonNull SimplePropertyValue<@NonNull Boolean> property_mapped, @NonNull SimplePropertyValue<@NonNull Long> property_size, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_usage) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferDecorator.getArgumentTarget(functionCall);
                    Long arg_buffer = GLES.GlBindBufferDecorator.getArgumentBuffer(functionCall);
                    if (!arg_buffer.equals(0L)) {
                        GlBufferAsset targetAsset = assetObject;
                        property_lastBoundTarget.setValue(functionCall, arg_target);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ELEMENT_ARRAY_BUFFER)) {
                        GlBufferAsset glBufferAsset = assetObject;
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class GlBindBufferBase
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferBase HELPER_INSTANCE = new GlBindBufferBase();

            private GlBindBufferBase() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_accessFlags, @NonNull ByteArrayPropertyValue property_data, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_firstBinding, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_lastBoundTarget, @NonNull SimplePropertyValue<@NonNull Long> property_mapLength, @NonNull SimplePropertyValue<@NonNull Long> property_mapOffset, @NonNull SimplePropertyValue<@NonNull Pointer> property_mapPointer, @NonNull SimplePropertyValue<@NonNull Boolean> property_mapped, @NonNull SimplePropertyValue<@NonNull Long> property_size, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_usage) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERBASE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferBaseDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
                    if (!arg_buffer.equals(0L)) {
                        GlBufferAsset targetAsset = assetObject;
                        property_lastBoundTarget.setValue(functionCall, arg_target);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class GlBindBufferRange
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferRange HELPER_INSTANCE = new GlBindBufferRange();

            private GlBindBufferRange() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlBufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_accessFlags, @NonNull ByteArrayPropertyValue property_data, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_firstBinding, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_lastBoundTarget, @NonNull SimplePropertyValue<@NonNull Long> property_mapLength, @NonNull SimplePropertyValue<@NonNull Long> property_mapOffset, @NonNull SimplePropertyValue<@NonNull Pointer> property_mapPointer, @NonNull SimplePropertyValue<@NonNull Boolean> property_mapped, @NonNull SimplePropertyValue<@NonNull Long> property_size, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_usage) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERRANGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferRangeDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
                    Long arg_offset = GLES.GlBindBufferRangeDecorator.getArgumentOffset(functionCall);
                    Long arg_size = GLES.GlBindBufferRangeDecorator.getArgumentSize(functionCall);
                    if (!arg_buffer.equals(0L)) {
                        GlBufferAsset targetAsset = assetObject;
                        property_lastBoundTarget.setValue(functionCall, arg_target);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlBufferAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull ByteArrayPropertyValue var5, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> var6, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@NonNull Long> var8, @NonNull SimplePropertyValue<@NonNull Long> var9, @NonNull SimplePropertyValue<@NonNull Pointer> var10, @NonNull SimplePropertyValue<@NonNull Boolean> var11, @NonNull SimplePropertyValue<@NonNull Long> var12, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var13) throws Exception;
        }
    }

    public static final class GlFramebufferAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlFramebufferAsset, GlFramebufferAsset.Value> {
        public static final @NonNull GlFramebufferAssetValueProcessor INSTANCE = new GlFramebufferAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLFRAMEBUFFERPARAMETERI, GlFramebufferParameteri.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVR, GlFramebufferTextureMultisampleMultiviewOvr.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTIVIEWOVR, GlFramebufferTextureMultiviewOvr.HELPER_INSTANCE);
            }
        };

        private GlFramebufferAssetValueProcessor() {
        }

        @Override
        public @NonNull GlFramebufferAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull GlFramebufferAttachmentAsset<?, ?>> attachments = new MapPropertyValue((IAssetItem<?, ?>)assetObject, AbstractGlFramebufferAsset.GlFramebufferAssetProperties.PROPERTY_ATTACHMENTS);
            SimplePropertyValue<@NonNull Boolean> defaultFixedSampleLocations = new SimplePropertyValue<Boolean>(assetObject, AbstractGlFramebufferAsset.GlFramebufferAssetProperties.PROPERTY_DEFAULT_FIXED_SAMPLE_LOCATIONS, false);
            SimplePropertyValue<@NonNull Long> defaultHeight = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAsset.GlFramebufferAssetProperties.PROPERTY_DEFAULT_HEIGHT, 0L);
            SimplePropertyValue<@NonNull Long> defaultLayers = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAsset.GlFramebufferAssetProperties.PROPERTY_DEFAULT_LAYERS, 0L);
            SimplePropertyValue<@NonNull Long> defaultSamples = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAsset.GlFramebufferAssetProperties.PROPERTY_DEFAULT_SAMPLES, 0L);
            SimplePropertyValue<@NonNull Long> defaultWidth = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAsset.GlFramebufferAssetProperties.PROPERTY_DEFAULT_WIDTH, 0L);
            ListPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> drawBuffers = new ListPropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAsset.GlFramebufferAssetProperties.PROPERTY_DRAW_BUFFERS, AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlFramebufferAssetDrawBuffers(callbacks, assetObject));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> readBuffer = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAsset.GlFramebufferAssetProperties.PROPERTY_READ_BUFFER, AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlFramebufferAssetReadBuffer(callbacks, assetObject));
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(attachments, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attachments, defaultFixedSampleLocations, defaultHeight, defaultLayers, defaultSamples, defaultWidth, drawBuffers, readBuffer)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferAsset.Value(validRange, assetObject, attachments, (IAssetPropertyValue<Boolean>)defaultFixedSampleLocations, (IAssetPropertyValue<Long>)defaultHeight, (IAssetPropertyValue<Long>)defaultLayers, (IAssetPropertyValue<Long>)defaultSamples, (IAssetPropertyValue<Long>)defaultWidth, (IAssetPropertyValue<List<AbstractConstantOrAliasSpecExtended>>)drawBuffers, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)readBuffer);
        }

        @Override
        public @NonNull GlFramebufferAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlFramebufferAsset assetObject = (GlFramebufferAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull GlFramebufferAttachmentAsset<?, ?>> attachments = new MapPropertyValue(fromValue.getAttachments());
            SimplePropertyValue<@NonNull Boolean> defaultFixedSampleLocations = new SimplePropertyValue<Boolean>(fromValue.getDefaultFixedSampleLocations());
            SimplePropertyValue<@NonNull Long> defaultHeight = new SimplePropertyValue<Long>(fromValue.getDefaultHeight());
            SimplePropertyValue<@NonNull Long> defaultLayers = new SimplePropertyValue<Long>(fromValue.getDefaultLayers());
            SimplePropertyValue<@NonNull Long> defaultSamples = new SimplePropertyValue<Long>(fromValue.getDefaultSamples());
            SimplePropertyValue<@NonNull Long> defaultWidth = new SimplePropertyValue<Long>(fromValue.getDefaultWidth());
            ListPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> drawBuffers = new ListPropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getDrawBuffers());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> readBuffer = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getReadBuffer());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(attachments, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attachments, defaultFixedSampleLocations, defaultHeight, defaultLayers, defaultSamples, defaultWidth, drawBuffers, readBuffer)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferAsset.Value(validRange, assetObject, attachments, (IAssetPropertyValue<Boolean>)defaultFixedSampleLocations, (IAssetPropertyValue<Long>)defaultHeight, (IAssetPropertyValue<Long>)defaultLayers, (IAssetPropertyValue<Long>)defaultSamples, (IAssetPropertyValue<Long>)defaultWidth, (IAssetPropertyValue<List<AbstractConstantOrAliasSpecExtended>>)drawBuffers, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)readBuffer);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlFramebufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull GlFramebufferAttachmentAsset<?, ?>> attachments, @NonNull SimplePropertyValue<@NonNull Boolean> defaultFixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> defaultHeight, @NonNull SimplePropertyValue<@NonNull Long> defaultLayers, @NonNull SimplePropertyValue<@NonNull Long> defaultSamples, @NonNull SimplePropertyValue<@NonNull Long> defaultWidth, @NonNull ListPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> drawBuffers, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> readBuffer) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attachments, defaultFixedSampleLocations, defaultHeight, defaultLayers, defaultSamples, defaultWidth, drawBuffers, readBuffer);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlFramebufferAsset.Value processedValue;
                GlFramebufferAsset.Value unProcessedValue = new GlFramebufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlFramebufferAttachmentAsset<?, ?>>>)attachments, (IAssetPropertyValue<Boolean>)defaultFixedSampleLocations, (IAssetPropertyValue<Long>)defaultHeight, (IAssetPropertyValue<Long>)defaultLayers, (IAssetPropertyValue<Long>)defaultSamples, (IAssetPropertyValue<Long>)defaultWidth, (IAssetPropertyValue<List<AbstractConstantOrAliasSpecExtended>>)drawBuffers, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)readBuffer);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attachments.setValueFrom(functionCall, processedValue.getAttachments());
                defaultFixedSampleLocations.setValueFrom(functionCall, processedValue.getDefaultFixedSampleLocations());
                defaultHeight.setValueFrom(functionCall, processedValue.getDefaultHeight());
                defaultLayers.setValueFrom(functionCall, processedValue.getDefaultLayers());
                defaultSamples.setValueFrom(functionCall, processedValue.getDefaultSamples());
                defaultWidth.setValueFrom(functionCall, processedValue.getDefaultWidth());
                drawBuffers.setValueFrom(functionCall, processedValue.getDrawBuffers());
                readBuffer.setValueFrom(functionCall, processedValue.getReadBuffer());
            }
            return result;
        }

        private static final class GlFramebufferParameteri
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlFramebufferParameteri HELPER_INSTANCE = new GlFramebufferParameteri();

            private GlFramebufferParameteri() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlFramebufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull GlFramebufferAttachmentAsset<?, ?>> property_attachments, @NonNull SimplePropertyValue<@NonNull Boolean> property_defaultFixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_defaultHeight, @NonNull SimplePropertyValue<@NonNull Long> property_defaultLayers, @NonNull SimplePropertyValue<@NonNull Long> property_defaultSamples, @NonNull SimplePropertyValue<@NonNull Long> property_defaultWidth, @NonNull ListPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_drawBuffers, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_readBuffer) throws Exception {
                assert (KapiSpec.GLES.functions.GLFRAMEBUFFERPARAMETERI.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferParameteriDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlFramebufferParameteriDecorator.getArgumentPname(functionCall);
                    Integer arg_param = GLES.GlFramebufferParameteriDecorator.getArgumentParam(functionCall);
                    GlFramebufferAsset targetAsset = assetObject;
                    if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_WIDTH)) {
                        Long temp_valueOf_return_value_0 = arg_param.longValue();
                        property_defaultWidth.setValue(functionCall, temp_valueOf_return_value_0);
                    }
                    if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_HEIGHT)) {
                        Long temp_valueOf_return_value_1 = arg_param.longValue();
                        property_defaultHeight.setValue(functionCall, temp_valueOf_return_value_1);
                    }
                    if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_LAYERS)) {
                        Long temp_valueOf_return_value_2 = arg_param.longValue();
                        property_defaultLayers.setValue(functionCall, temp_valueOf_return_value_2);
                    }
                    if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_SAMPLES)) {
                        Long temp_valueOf_return_value_3 = arg_param.longValue();
                        property_defaultSamples.setValue(functionCall, temp_valueOf_return_value_3);
                    }
                    if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS)) {
                        Integer temp_temp_arg_param_4 = arg_param;
                        int temp_temp_5 = temp_temp_arg_param_4 != null ? temp_temp_arg_param_4 : 0;
                        property_defaultFixedSampleLocations.setValue(functionCall, temp_temp_5 != 0);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class GlFramebufferTextureMultisampleMultiviewOvr
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlFramebufferTextureMultisampleMultiviewOvr HELPER_INSTANCE = new GlFramebufferTextureMultisampleMultiviewOvr();

            private GlFramebufferTextureMultisampleMultiviewOvr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlFramebufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull GlFramebufferAttachmentAsset<?, ?>> property_attachments, @NonNull SimplePropertyValue<@NonNull Boolean> property_defaultFixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_defaultHeight, @NonNull SimplePropertyValue<@NonNull Long> property_defaultLayers, @NonNull SimplePropertyValue<@NonNull Long> property_defaultSamples, @NonNull SimplePropertyValue<@NonNull Long> property_defaultWidth, @NonNull ListPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_drawBuffers, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_readBuffer) throws Exception {
                assert (KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attachment = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentAttachment(functionCall);
                    Long arg_texture = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentTexture(functionCall);
                    Integer arg_level = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentLevel(functionCall);
                    Integer arg_samples = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentSamples(functionCall);
                    Integer arg_baseViewIndex = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentBaseViewIndex(functionCall);
                    Integer arg_numViews = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentNumViews(functionCall);
                    GlFramebufferAsset framebufferAsset = assetObject;
                    AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                    GlTextureAsset textureAsset = GlFramebufferTextureMultisampleMultiviewOvr.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlFramebufferTextureMultisampleMultiviewOvr.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
                    ProvidedAssetProcessors.processProvidedActionForGlFramebufferAssetOnGlFramebufferTextureMultisampleMultiviewOvr(callbacks, functionCall, framebufferAsset, property_attachments, property_defaultFixedSampleLocations, property_defaultHeight, property_defaultLayers, property_defaultSamples, property_defaultWidth, property_drawBuffers, property_readBuffer, arg_target, arg_attachment, arg_texture, arg_level, arg_samples, arg_baseViewIndex, arg_numViews, textureAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class GlFramebufferTextureMultiviewOvr
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlFramebufferTextureMultiviewOvr HELPER_INSTANCE = new GlFramebufferTextureMultiviewOvr();

            private GlFramebufferTextureMultiviewOvr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlFramebufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull GlFramebufferAttachmentAsset<?, ?>> property_attachments, @NonNull SimplePropertyValue<@NonNull Boolean> property_defaultFixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_defaultHeight, @NonNull SimplePropertyValue<@NonNull Long> property_defaultLayers, @NonNull SimplePropertyValue<@NonNull Long> property_defaultSamples, @NonNull SimplePropertyValue<@NonNull Long> property_defaultWidth, @NonNull ListPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_drawBuffers, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_readBuffer) throws Exception {
                assert (KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTIVIEWOVR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attachment = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentAttachment(functionCall);
                    Long arg_texture = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentTexture(functionCall);
                    Integer arg_level = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentLevel(functionCall);
                    Integer arg_baseViewIndex = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentBaseViewIndex(functionCall);
                    Integer arg_numViews = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentNumViews(functionCall);
                    GlFramebufferAsset framebufferAsset = assetObject;
                    AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                    GlTextureAsset textureAsset = GlFramebufferTextureMultiviewOvr.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlFramebufferTextureMultiviewOvr.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
                    ProvidedAssetProcessors.processProvidedActionForGlFramebufferAssetOnGlFramebufferTextureMultiviewOvr(callbacks, functionCall, framebufferAsset, property_attachments, property_defaultFixedSampleLocations, property_defaultHeight, property_defaultLayers, property_defaultSamples, property_defaultWidth, property_drawBuffers, property_readBuffer, arg_target, arg_attachment, arg_texture, arg_level, arg_baseViewIndex, arg_numViews, textureAsset);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlFramebufferAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull GlFramebufferAttachmentAsset<?, ?>> var4, @NonNull SimplePropertyValue<@NonNull Boolean> var5, @NonNull SimplePropertyValue<@NonNull Long> var6, @NonNull SimplePropertyValue<@NonNull Long> var7, @NonNull SimplePropertyValue<@NonNull Long> var8, @NonNull SimplePropertyValue<@NonNull Long> var9, @NonNull ListPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var10, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var11) throws Exception;
        }
    }

    public static final class GlFramebufferRenderbufferAttachmentAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlFramebufferRenderbufferAttachmentAsset, GlFramebufferRenderbufferAttachmentAsset.Value> {
        public static final @NonNull GlFramebufferRenderbufferAttachmentAssetValueProcessor INSTANCE = new GlFramebufferRenderbufferAttachmentAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private GlFramebufferRenderbufferAttachmentAssetValueProcessor() {
        }

        @Override
        public @NonNull GlFramebufferRenderbufferAttachmentAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferRenderbufferAttachmentAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferRenderbufferAttachmentAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_ALPHA_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_BLUE_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_COLOR_ENCODING, KapiSpec.GLES.constants.GL_LINEAR);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_COMPONENT_TYPE, KapiSpec.GLES.constants.GL_FLOAT);
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_DEPTH_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_GREEN_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_RED_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_STENCIL_SIZE, 0L);
            ImmutablePropertyValue<@NonNull GlRenderbufferAsset> renderbuffer = assetObject.getImmutablePropertyRenderbuffer();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(renderbuffer, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, renderbuffer)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferRenderbufferAttachmentAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlRenderbufferAsset>)renderbuffer);
        }

        @Override
        public @NonNull GlFramebufferRenderbufferAttachmentAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferRenderbufferAttachmentAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlFramebufferRenderbufferAttachmentAsset assetObject = (GlFramebufferRenderbufferAttachmentAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferRenderbufferAttachmentAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(fromValue.getAlphaSize());
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(fromValue.getBlueSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getColorEncoding());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getComponentType());
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(fromValue.getDepthSize());
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(fromValue.getGreenSize());
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(fromValue.getRedSize());
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(fromValue.getStencilSize());
            ImmutablePropertyValue<@NonNull GlRenderbufferAsset> renderbuffer = assetObject.getImmutablePropertyRenderbuffer();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(renderbuffer, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, renderbuffer)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferRenderbufferAttachmentAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlRenderbufferAsset>)renderbuffer);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlFramebufferRenderbufferAttachmentAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> alphaSize, @NonNull SimplePropertyValue<@NonNull Long> blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType, @NonNull SimplePropertyValue<@NonNull Long> depthSize, @NonNull SimplePropertyValue<@NonNull Long> greenSize, @NonNull SimplePropertyValue<@NonNull Long> redSize, @NonNull SimplePropertyValue<@NonNull Long> stencilSize, @NonNull ImmutablePropertyValue<@NonNull GlRenderbufferAsset> renderbuffer) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, renderbuffer);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlFramebufferRenderbufferAttachmentAsset.Value processedValue;
                GlFramebufferRenderbufferAttachmentAsset.Value unProcessedValue = new GlFramebufferRenderbufferAttachmentAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlRenderbufferAsset>)renderbuffer);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                alphaSize.setValueFrom(functionCall, processedValue.getAlphaSize());
                blueSize.setValueFrom(functionCall, processedValue.getBlueSize());
                colorEncoding.setValueFrom(functionCall, processedValue.getColorEncoding());
                componentType.setValueFrom(functionCall, processedValue.getComponentType());
                depthSize.setValueFrom(functionCall, processedValue.getDepthSize());
                greenSize.setValueFrom(functionCall, processedValue.getGreenSize());
                redSize.setValueFrom(functionCall, processedValue.getRedSize());
                stencilSize.setValueFrom(functionCall, processedValue.getStencilSize());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlFramebufferRenderbufferAttachmentAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@NonNull Long> var8, @NonNull SimplePropertyValue<@NonNull Long> var9, @NonNull SimplePropertyValue<@NonNull Long> var10, @NonNull SimplePropertyValue<@NonNull Long> var11, @NonNull ImmutablePropertyValue<@NonNull GlRenderbufferAsset> var12) throws Exception;
        }
    }

    public static final class GlFramebufferTextureAttachmentAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlFramebufferTextureAttachmentAsset, GlFramebufferTextureAttachmentAsset.Value> {
        public static final @NonNull GlFramebufferTextureAttachmentAssetValueProcessor INSTANCE = new GlFramebufferTextureAttachmentAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private GlFramebufferTextureAttachmentAssetValueProcessor() {
        }

        @Override
        public @NonNull GlFramebufferTextureAttachmentAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferTextureAttachmentAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferTextureAttachmentAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_ALPHA_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_BLUE_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_COLOR_ENCODING, KapiSpec.GLES.constants.GL_LINEAR);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_COMPONENT_TYPE, KapiSpec.GLES.constants.GL_FLOAT);
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_DEPTH_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_GREEN_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_RED_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_STENCIL_SIZE, 0L);
            ImmutablePropertyValue<@NonNull GlTextureAsset> texture = assetObject.getImmutablePropertyTexture();
            ImmutablePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> textureCubeMapFace = assetObject.getImmutablePropertyTextureCubeMapFace();
            ImmutablePropertyValue<@Nullable Integer> textureLayer = assetObject.getImmutablePropertyTextureLayer();
            ImmutablePropertyValue<@NonNull Long> textureLevel = assetObject.getImmutablePropertyTextureLevel();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(texture, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, texture, textureCubeMapFace, textureLayer, textureLevel)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferTextureAttachmentAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlTextureAsset>)texture, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)textureCubeMapFace, (IAssetPropertyValue<Integer>)textureLayer, (IAssetPropertyValue<Long>)textureLevel);
        }

        @Override
        public @NonNull GlFramebufferTextureAttachmentAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferTextureAttachmentAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlFramebufferTextureAttachmentAsset assetObject = (GlFramebufferTextureAttachmentAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferTextureAttachmentAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(fromValue.getAlphaSize());
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(fromValue.getBlueSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getColorEncoding());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getComponentType());
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(fromValue.getDepthSize());
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(fromValue.getGreenSize());
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(fromValue.getRedSize());
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(fromValue.getStencilSize());
            ImmutablePropertyValue<@NonNull GlTextureAsset> texture = assetObject.getImmutablePropertyTexture();
            ImmutablePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> textureCubeMapFace = assetObject.getImmutablePropertyTextureCubeMapFace();
            ImmutablePropertyValue<@Nullable Integer> textureLayer = assetObject.getImmutablePropertyTextureLayer();
            ImmutablePropertyValue<@NonNull Long> textureLevel = assetObject.getImmutablePropertyTextureLevel();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(texture, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, texture, textureCubeMapFace, textureLayer, textureLevel)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferTextureAttachmentAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlTextureAsset>)texture, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)textureCubeMapFace, (IAssetPropertyValue<Integer>)textureLayer, (IAssetPropertyValue<Long>)textureLevel);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlFramebufferTextureAttachmentAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> alphaSize, @NonNull SimplePropertyValue<@NonNull Long> blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType, @NonNull SimplePropertyValue<@NonNull Long> depthSize, @NonNull SimplePropertyValue<@NonNull Long> greenSize, @NonNull SimplePropertyValue<@NonNull Long> redSize, @NonNull SimplePropertyValue<@NonNull Long> stencilSize, @NonNull ImmutablePropertyValue<@NonNull GlTextureAsset> texture, @NonNull ImmutablePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> textureCubeMapFace, @NonNull ImmutablePropertyValue<@Nullable Integer> textureLayer, @NonNull ImmutablePropertyValue<@NonNull Long> textureLevel) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, texture, textureCubeMapFace, textureLayer, textureLevel);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlFramebufferTextureAttachmentAsset.Value processedValue;
                GlFramebufferTextureAttachmentAsset.Value unProcessedValue = new GlFramebufferTextureAttachmentAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlTextureAsset>)texture, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)textureCubeMapFace, (IAssetPropertyValue<Integer>)textureLayer, (IAssetPropertyValue<Long>)textureLevel);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                alphaSize.setValueFrom(functionCall, processedValue.getAlphaSize());
                blueSize.setValueFrom(functionCall, processedValue.getBlueSize());
                colorEncoding.setValueFrom(functionCall, processedValue.getColorEncoding());
                componentType.setValueFrom(functionCall, processedValue.getComponentType());
                depthSize.setValueFrom(functionCall, processedValue.getDepthSize());
                greenSize.setValueFrom(functionCall, processedValue.getGreenSize());
                redSize.setValueFrom(functionCall, processedValue.getRedSize());
                stencilSize.setValueFrom(functionCall, processedValue.getStencilSize());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlFramebufferTextureAttachmentAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@NonNull Long> var8, @NonNull SimplePropertyValue<@NonNull Long> var9, @NonNull SimplePropertyValue<@NonNull Long> var10, @NonNull SimplePropertyValue<@NonNull Long> var11, @NonNull ImmutablePropertyValue<@NonNull GlTextureAsset> var12, @NonNull ImmutablePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> var13, @NonNull ImmutablePropertyValue<@Nullable Integer> var14, @NonNull ImmutablePropertyValue<@NonNull Long> var15) throws Exception;
        }
    }

    public static final class GlFramebufferTextureMultiviewAttachmentAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlFramebufferTextureMultiviewAttachmentAsset, GlFramebufferTextureMultiviewAttachmentAsset.Value> {
        public static final @NonNull GlFramebufferTextureMultiviewAttachmentAssetValueProcessor INSTANCE = new GlFramebufferTextureMultiviewAttachmentAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private GlFramebufferTextureMultiviewAttachmentAssetValueProcessor() {
        }

        @Override
        public @NonNull GlFramebufferTextureMultiviewAttachmentAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferTextureMultiviewAttachmentAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferTextureMultiviewAttachmentAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_ALPHA_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_BLUE_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_COLOR_ENCODING, KapiSpec.GLES.constants.GL_LINEAR);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_COMPONENT_TYPE, KapiSpec.GLES.constants.GL_FLOAT);
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_DEPTH_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_GREEN_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_RED_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_STENCIL_SIZE, 0L);
            ImmutablePropertyValue<@NonNull GlTextureAsset> arrayTexture = assetObject.getImmutablePropertyArrayTexture();
            ImmutablePropertyValue<@NonNull Long> arrayTextureLevel = assetObject.getImmutablePropertyArrayTextureLevel();
            ImmutablePropertyValue<@NonNull Long> baseViewIndex = assetObject.getImmutablePropertyBaseViewIndex();
            ImmutablePropertyValue<@NonNull Integer> numViews = assetObject.getImmutablePropertyNumViews();
            ImmutablePropertyValue<@NonNull Integer> samples = assetObject.getImmutablePropertySamples();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(arrayTexture, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, arrayTexture, arrayTextureLevel, baseViewIndex, numViews, samples)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferTextureMultiviewAttachmentAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlTextureAsset>)arrayTexture, (IAssetPropertyValue<Long>)arrayTextureLevel, (IAssetPropertyValue<Long>)baseViewIndex, (IAssetPropertyValue<Integer>)numViews, (IAssetPropertyValue<Integer>)samples);
        }

        @Override
        public @NonNull GlFramebufferTextureMultiviewAttachmentAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferTextureMultiviewAttachmentAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlFramebufferTextureMultiviewAttachmentAsset assetObject = (GlFramebufferTextureMultiviewAttachmentAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferTextureMultiviewAttachmentAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(fromValue.getAlphaSize());
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(fromValue.getBlueSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getColorEncoding());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getComponentType());
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(fromValue.getDepthSize());
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(fromValue.getGreenSize());
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(fromValue.getRedSize());
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(fromValue.getStencilSize());
            ImmutablePropertyValue<@NonNull GlTextureAsset> arrayTexture = assetObject.getImmutablePropertyArrayTexture();
            ImmutablePropertyValue<@NonNull Long> arrayTextureLevel = assetObject.getImmutablePropertyArrayTextureLevel();
            ImmutablePropertyValue<@NonNull Long> baseViewIndex = assetObject.getImmutablePropertyBaseViewIndex();
            ImmutablePropertyValue<@NonNull Integer> numViews = assetObject.getImmutablePropertyNumViews();
            ImmutablePropertyValue<@NonNull Integer> samples = assetObject.getImmutablePropertySamples();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(arrayTexture, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, arrayTexture, arrayTextureLevel, baseViewIndex, numViews, samples)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferTextureMultiviewAttachmentAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlTextureAsset>)arrayTexture, (IAssetPropertyValue<Long>)arrayTextureLevel, (IAssetPropertyValue<Long>)baseViewIndex, (IAssetPropertyValue<Integer>)numViews, (IAssetPropertyValue<Integer>)samples);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlFramebufferTextureMultiviewAttachmentAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> alphaSize, @NonNull SimplePropertyValue<@NonNull Long> blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType, @NonNull SimplePropertyValue<@NonNull Long> depthSize, @NonNull SimplePropertyValue<@NonNull Long> greenSize, @NonNull SimplePropertyValue<@NonNull Long> redSize, @NonNull SimplePropertyValue<@NonNull Long> stencilSize, @NonNull ImmutablePropertyValue<@NonNull GlTextureAsset> arrayTexture, @NonNull ImmutablePropertyValue<@NonNull Long> arrayTextureLevel, @NonNull ImmutablePropertyValue<@NonNull Long> baseViewIndex, @NonNull ImmutablePropertyValue<@NonNull Integer> numViews, @NonNull ImmutablePropertyValue<@NonNull Integer> samples) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize, arrayTexture, arrayTextureLevel, baseViewIndex, numViews, samples);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlFramebufferTextureMultiviewAttachmentAsset.Value processedValue;
                GlFramebufferTextureMultiviewAttachmentAsset.Value unProcessedValue = new GlFramebufferTextureMultiviewAttachmentAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<GlTextureAsset>)arrayTexture, (IAssetPropertyValue<Long>)arrayTextureLevel, (IAssetPropertyValue<Long>)baseViewIndex, (IAssetPropertyValue<Integer>)numViews, (IAssetPropertyValue<Integer>)samples);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                alphaSize.setValueFrom(functionCall, processedValue.getAlphaSize());
                blueSize.setValueFrom(functionCall, processedValue.getBlueSize());
                colorEncoding.setValueFrom(functionCall, processedValue.getColorEncoding());
                componentType.setValueFrom(functionCall, processedValue.getComponentType());
                depthSize.setValueFrom(functionCall, processedValue.getDepthSize());
                greenSize.setValueFrom(functionCall, processedValue.getGreenSize());
                redSize.setValueFrom(functionCall, processedValue.getRedSize());
                stencilSize.setValueFrom(functionCall, processedValue.getStencilSize());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlFramebufferTextureMultiviewAttachmentAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@NonNull Long> var8, @NonNull SimplePropertyValue<@NonNull Long> var9, @NonNull SimplePropertyValue<@NonNull Long> var10, @NonNull SimplePropertyValue<@NonNull Long> var11, @NonNull ImmutablePropertyValue<@NonNull GlTextureAsset> var12, @NonNull ImmutablePropertyValue<@NonNull Long> var13, @NonNull ImmutablePropertyValue<@NonNull Long> var14, @NonNull ImmutablePropertyValue<@NonNull Integer> var15, @NonNull ImmutablePropertyValue<@NonNull Integer> var16) throws Exception;
        }
    }

    public static final class GlFramebufferZeroAttachmentAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlFramebufferZeroAttachmentAsset, GlFramebufferZeroAttachmentAsset.Value> {
        public static final @NonNull GlFramebufferZeroAttachmentAssetValueProcessor INSTANCE = new GlFramebufferZeroAttachmentAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private GlFramebufferZeroAttachmentAssetValueProcessor() {
        }

        @Override
        public @NonNull GlFramebufferZeroAttachmentAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferZeroAttachmentAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferZeroAttachmentAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_ALPHA_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_BLUE_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_COLOR_ENCODING, KapiSpec.GLES.constants.GL_LINEAR);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_COMPONENT_TYPE, KapiSpec.GLES.constants.GL_FLOAT);
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_DEPTH_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_GREEN_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_RED_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(assetObject, AbstractGlFramebufferAttachmentAsset.GlFramebufferAttachmentAssetProperties.PROPERTY_STENCIL_SIZE, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferZeroAttachmentAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize);
        }

        @Override
        public @NonNull GlFramebufferZeroAttachmentAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlFramebufferZeroAttachmentAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlFramebufferZeroAttachmentAsset assetObject = (GlFramebufferZeroAttachmentAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlFramebufferZeroAttachmentAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(fromValue.getAlphaSize());
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(fromValue.getBlueSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getColorEncoding());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getComponentType());
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(fromValue.getDepthSize());
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(fromValue.getGreenSize());
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(fromValue.getRedSize());
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(fromValue.getStencilSize());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlFramebufferZeroAttachmentAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlFramebufferZeroAttachmentAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> alphaSize, @NonNull SimplePropertyValue<@NonNull Long> blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> colorEncoding, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> componentType, @NonNull SimplePropertyValue<@NonNull Long> depthSize, @NonNull SimplePropertyValue<@NonNull Long> greenSize, @NonNull SimplePropertyValue<@NonNull Long> redSize, @NonNull SimplePropertyValue<@NonNull Long> stencilSize) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, alphaSize, blueSize, colorEncoding, componentType, depthSize, greenSize, redSize, stencilSize);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlFramebufferZeroAttachmentAsset.Value processedValue;
                GlFramebufferZeroAttachmentAsset.Value unProcessedValue = new GlFramebufferZeroAttachmentAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)colorEncoding, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)componentType, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)stencilSize);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                alphaSize.setValueFrom(functionCall, processedValue.getAlphaSize());
                blueSize.setValueFrom(functionCall, processedValue.getBlueSize());
                colorEncoding.setValueFrom(functionCall, processedValue.getColorEncoding());
                componentType.setValueFrom(functionCall, processedValue.getComponentType());
                depthSize.setValueFrom(functionCall, processedValue.getDepthSize());
                greenSize.setValueFrom(functionCall, processedValue.getGreenSize());
                redSize.setValueFrom(functionCall, processedValue.getRedSize());
                stencilSize.setValueFrom(functionCall, processedValue.getStencilSize());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlFramebufferZeroAttachmentAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@NonNull Long> var8, @NonNull SimplePropertyValue<@NonNull Long> var9, @NonNull SimplePropertyValue<@NonNull Long> var10, @NonNull SimplePropertyValue<@NonNull Long> var11) throws Exception;
        }
    }

    public static final class GlImageUnitAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlImageUnitAsset, GlImageUnitAsset.Value> {
        public static final @NonNull GlImageUnitAssetValueProcessor INSTANCE = new GlImageUnitAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDIMAGETEXTURE, GlBindImageTexture.HELPER_INSTANCE);
            }
        };

        private GlImageUnitAssetValueProcessor() {
        }

        @Override
        public @NonNull GlImageUnitAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlImageUnitAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlImageUnitAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> access = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlImageUnitAsset.GlImageUnitAssetProperties.PROPERTY_ACCESS, KapiSpec.GLES.constants.GL_READ_ONLY);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlImageUnitAsset.GlImageUnitAssetProperties.PROPERTY_FORMAT, KapiSpec.GLES.constants.GL_R32UI);
            SimplePropertyValue<@NonNull Long> layer = new SimplePropertyValue<Long>(assetObject, AbstractGlImageUnitAsset.GlImageUnitAssetProperties.PROPERTY_LAYER, 0L);
            SimplePropertyValue<@NonNull Boolean> layered = new SimplePropertyValue<Boolean>(assetObject, AbstractGlImageUnitAsset.GlImageUnitAssetProperties.PROPERTY_LAYERED, false);
            SimplePropertyValue<@NonNull Long> level = new SimplePropertyValue<Long>(assetObject, AbstractGlImageUnitAsset.GlImageUnitAssetProperties.PROPERTY_LEVEL, 0L);
            SimplePropertyValue<@Nullable Object> texture = new SimplePropertyValue<Object>(assetObject, AbstractGlImageUnitAsset.GlImageUnitAssetProperties.PROPERTY_TEXTURE, null);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(texture, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, access, format, layer, layered, level, texture)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlImageUnitAsset.Value(validRange, assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)access, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<Long>)layer, (IAssetPropertyValue<Boolean>)layered, (IAssetPropertyValue<Long>)level, (IAssetPropertyValue<GlTextureAsset>)texture);
        }

        @Override
        public @NonNull GlImageUnitAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlImageUnitAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlImageUnitAsset assetObject = (GlImageUnitAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlImageUnitAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> access = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getAccess());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getFormat());
            SimplePropertyValue<@NonNull Long> layer = new SimplePropertyValue<Long>(fromValue.getLayer());
            SimplePropertyValue<@NonNull Boolean> layered = new SimplePropertyValue<Boolean>(fromValue.getLayered());
            SimplePropertyValue<@NonNull Long> level = new SimplePropertyValue<Long>(fromValue.getLevel());
            SimplePropertyValue<@Nullable GlTextureAsset> texture = new SimplePropertyValue<GlTextureAsset>(fromValue.getTexture());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(texture, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, access, format, layer, layered, level, texture)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlImageUnitAsset.Value(validRange, assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)access, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<Long>)layer, (IAssetPropertyValue<Boolean>)layered, (IAssetPropertyValue<Long>)level, (IAssetPropertyValue<GlTextureAsset>)texture);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlImageUnitAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> access, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> format, @NonNull SimplePropertyValue<@NonNull Long> layer, @NonNull SimplePropertyValue<@NonNull Boolean> layered, @NonNull SimplePropertyValue<@NonNull Long> level, @NonNull SimplePropertyValue<@Nullable GlTextureAsset> texture) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, access, format, layer, layered, level, texture);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlImageUnitAsset.Value processedValue;
                GlImageUnitAsset.Value unProcessedValue = new GlImageUnitAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)access, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)format, (IAssetPropertyValue<Long>)layer, (IAssetPropertyValue<Boolean>)layered, (IAssetPropertyValue<Long>)level, (IAssetPropertyValue<GlTextureAsset>)texture);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                access.setValueFrom(functionCall, processedValue.getAccess());
                format.setValueFrom(functionCall, processedValue.getFormat());
                layer.setValueFrom(functionCall, processedValue.getLayer());
                layered.setValueFrom(functionCall, processedValue.getLayered());
                level.setValueFrom(functionCall, processedValue.getLevel());
                texture.setValueFrom(functionCall, processedValue.getTexture());
            }
            return result;
        }

        private static final class GlBindImageTexture
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindImageTexture HELPER_INSTANCE = new GlBindImageTexture();

            private GlBindImageTexture() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlImageUnitAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_access, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_format, @NonNull SimplePropertyValue<@NonNull Long> property_layer, @NonNull SimplePropertyValue<@NonNull Boolean> property_layered, @NonNull SimplePropertyValue<@NonNull Long> property_level, @NonNull SimplePropertyValue<@Nullable GlTextureAsset> property_texture) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDIMAGETEXTURE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_unit = GLES.GlBindImageTextureDecorator.getArgumentUnit(functionCall);
                    Long arg_texture = GLES.GlBindImageTextureDecorator.getArgumentTexture(functionCall);
                    Integer arg_level = GLES.GlBindImageTextureDecorator.getArgumentLevel(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_layered = GLES.GlBindImageTextureDecorator.getArgumentLayered(functionCall);
                    Integer arg_layer = GLES.GlBindImageTextureDecorator.getArgumentLayer(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_access = GLES.GlBindImageTextureDecorator.getArgumentAccess(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_format = GLES.GlBindImageTextureDecorator.getArgumentFormat(functionCall);
                    GlImageUnitAsset imageUnitAsset = assetObject;
                    AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                    GlTextureAsset textureAsset = GlBindImageTexture.warnIfMissingAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlBindImageTexture.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
                    property_texture.setValue(functionCall, textureAsset);
                    Long temp_valueOf_return_value_0 = arg_level.longValue();
                    property_level.setValue(functionCall, temp_valueOf_return_value_0);
                    property_layered.setValue(functionCall, arg_layered.equals(KapiSpec.GLES.constants.GL_TRUE));
                    Long temp_valueOf_return_value_1 = arg_layer.longValue();
                    property_layer.setValue(functionCall, temp_valueOf_return_value_1);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_2 = GlBindImageTexture.validateConstantIsInSetLogError(callbacks, functionCall, arg_access, Constants.CONSTANT_SET_0);
                    assert (temp_validateConstantIsInSetLogError_return_value_2 != null);
                    property_access.setValue(functionCall, temp_validateConstantIsInSetLogError_return_value_2);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_3 = GlBindImageTexture.validateConstantIsInSetLogError(callbacks, functionCall, arg_format, Constants.CONSTANT_SET_1);
                    assert (temp_validateConstantIsInSetLogError_return_value_3 != null);
                    property_format.setValue(functionCall, temp_validateConstantIsInSetLogError_return_value_3);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlImageUnitAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var4, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var5, @NonNull SimplePropertyValue<@NonNull Long> var6, @NonNull SimplePropertyValue<@NonNull Boolean> var7, @NonNull SimplePropertyValue<@NonNull Long> var8, @NonNull SimplePropertyValue<@Nullable GlTextureAsset> var9) throws Exception;
        }
    }

    public static final class GlProgramAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlProgramAsset, GlProgramAsset.Value> {
        public static final @NonNull GlProgramAssetValueProcessor INSTANCE = new GlProgramAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLATTACHSHADER, GlAttachShader.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLCREATESHADERPROGRAMV, GlCreateShaderProgramv.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLCREATESHADERPROGRAMVEXT, GlCreateShaderProgramvExt.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLDETACHSHADER, GlDetachShader.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLLINKPROGRAM, GlLinkProgram.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLPROGRAMPARAMETERI, GlProgramParameteri.HELPER_INSTANCE);
            }
        };

        private GlProgramAssetValueProcessor() {
        }

        @Override
        public @NonNull GlProgramAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlProgramAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlProgramAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> attachedShaders = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlShaderAsset>((IAssetItem<?, ?>)assetObject, AbstractGlProgramAsset.GlProgramAssetProperties.PROPERTY_ATTACHED_SHADERS);
            SimplePropertyValue<@Nullable Object> computeWorkGroupSize = new SimplePropertyValue<Object>(assetObject, AbstractGlProgramAsset.GlProgramAssetProperties.PROPERTY_COMPUTE_WORK_GROUP_SIZE, null);
            SimplePropertyValue<@NonNull Boolean> deleted = new SimplePropertyValue<Boolean>(assetObject, AbstractGlProgramAsset.GlProgramAssetProperties.PROPERTY_DELETED, false);
            SimplePropertyValue<@NonNull Boolean> linked = new SimplePropertyValue<Boolean>(assetObject, AbstractGlProgramAsset.GlProgramAssetProperties.PROPERTY_LINKED, false);
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> linkedShaders = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlShaderAsset>((IAssetItem<?, ?>)assetObject, AbstractGlProgramAsset.GlProgramAssetProperties.PROPERTY_LINKED_SHADERS);
            SimplePropertyValue<@NonNull String> programInfoLog = new SimplePropertyValue<String>(assetObject, AbstractGlProgramAsset.GlProgramAssetProperties.PROPERTY_PROGRAM_INFO_LOG, "");
            SimplePropertyValue<@NonNull Boolean> separable = new SimplePropertyValue<Boolean>(assetObject, AbstractGlProgramAsset.GlProgramAssetProperties.PROPERTY_SEPARABLE, false);
            SimplePropertyValue<@NonNull Boolean> validated = new SimplePropertyValue<Boolean>(assetObject, AbstractGlProgramAsset.GlProgramAssetProperties.PROPERTY_VALIDATED, false);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attachedShaders, computeWorkGroupSize, deleted, linked, linkedShaders, programInfoLog, separable, validated)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlProgramAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset>>)attachedShaders, (IAssetPropertyValue<ComputeWorkgroupSize>)computeWorkGroupSize, (IAssetPropertyValue<Boolean>)deleted, (IAssetPropertyValue<Boolean>)linked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset>>)linkedShaders, (IAssetPropertyValue<String>)programInfoLog, (IAssetPropertyValue<Boolean>)separable, (IAssetPropertyValue<Boolean>)validated);
        }

        @Override
        public @NonNull GlProgramAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlProgramAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlProgramAsset assetObject = (GlProgramAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlProgramAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> attachedShaders = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlShaderAsset>(fromValue.getAttachedShaders());
            SimplePropertyValue<@Nullable ComputeWorkgroupSize> computeWorkGroupSize = new SimplePropertyValue<ComputeWorkgroupSize>(fromValue.getComputeWorkGroupSize());
            SimplePropertyValue<@NonNull Boolean> deleted = new SimplePropertyValue<Boolean>(fromValue.getDeleted());
            SimplePropertyValue<@NonNull Boolean> linked = new SimplePropertyValue<Boolean>(fromValue.getLinked());
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> linkedShaders = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlShaderAsset>(fromValue.getLinkedShaders());
            SimplePropertyValue<@NonNull String> programInfoLog = new SimplePropertyValue<String>(fromValue.getProgramInfoLog());
            SimplePropertyValue<@NonNull Boolean> separable = new SimplePropertyValue<Boolean>(fromValue.getSeparable());
            SimplePropertyValue<@NonNull Boolean> validated = new SimplePropertyValue<Boolean>(fromValue.getValidated());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attachedShaders, computeWorkGroupSize, deleted, linked, linkedShaders, programInfoLog, separable, validated)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlProgramAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset>>)attachedShaders, (IAssetPropertyValue<ComputeWorkgroupSize>)computeWorkGroupSize, (IAssetPropertyValue<Boolean>)deleted, (IAssetPropertyValue<Boolean>)linked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset>>)linkedShaders, (IAssetPropertyValue<String>)programInfoLog, (IAssetPropertyValue<Boolean>)separable, (IAssetPropertyValue<Boolean>)validated);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> attachedShaders, @NonNull SimplePropertyValue<@Nullable ComputeWorkgroupSize> computeWorkGroupSize, @NonNull SimplePropertyValue<@NonNull Boolean> deleted, @NonNull SimplePropertyValue<@NonNull Boolean> linked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> linkedShaders, @NonNull SimplePropertyValue<@NonNull String> programInfoLog, @NonNull SimplePropertyValue<@NonNull Boolean> separable, @NonNull SimplePropertyValue<@NonNull Boolean> validated) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attachedShaders, computeWorkGroupSize, deleted, linked, linkedShaders, programInfoLog, separable, validated);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlProgramAsset.Value processedValue;
                GlProgramAsset.Value unProcessedValue = new GlProgramAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset>>)attachedShaders, (IAssetPropertyValue<ComputeWorkgroupSize>)computeWorkGroupSize, (IAssetPropertyValue<Boolean>)deleted, (IAssetPropertyValue<Boolean>)linked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset>>)linkedShaders, (IAssetPropertyValue<String>)programInfoLog, (IAssetPropertyValue<Boolean>)separable, (IAssetPropertyValue<Boolean>)validated);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attachedShaders.setValueFrom(functionCall, processedValue.getAttachedShaders());
                computeWorkGroupSize.setValueFrom(functionCall, processedValue.getComputeWorkGroupSize());
                deleted.setValueFrom(functionCall, processedValue.getDeleted());
                linked.setValueFrom(functionCall, processedValue.getLinked());
                linkedShaders.setValueFrom(functionCall, processedValue.getLinkedShaders());
                programInfoLog.setValueFrom(functionCall, processedValue.getProgramInfoLog());
                separable.setValueFrom(functionCall, processedValue.getSeparable());
                validated.setValueFrom(functionCall, processedValue.getValidated());
            }
            return result;
        }

        private static final class GlAttachShader
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlAttachShader HELPER_INSTANCE = new GlAttachShader();

            private GlAttachShader() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_attachedShaders, @NonNull SimplePropertyValue<@Nullable ComputeWorkgroupSize> property_computeWorkGroupSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_deleted, @NonNull SimplePropertyValue<@NonNull Boolean> property_linked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_linkedShaders, @NonNull SimplePropertyValue<@NonNull String> property_programInfoLog, @NonNull SimplePropertyValue<@NonNull Boolean> property_separable, @NonNull SimplePropertyValue<@NonNull Boolean> property_validated) throws Exception {
                assert (KapiSpec.GLES.functions.GLATTACHSHADER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_program = GLES.GlAttachShaderDecorator.getArgumentProgram(functionCall);
                    Long arg_shader = GLES.GlAttachShaderDecorator.getArgumentShader(functionCall);
                    GlProgramAsset programAsset = assetObject;
                    AssetItemID shaderAsset_id_value = AssetItemID.valueOf(arg_shader);
                    GlShaderAsset shaderAsset = GlAttachShader.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, callbacks, functionCall, GlAttachShader.getGlShaderAsset(callbacks, functionCall, null, shaderAsset_id_value), shaderAsset_id_value);
                    ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlAttachShader(callbacks, functionCall, programAsset, property_attachedShaders, property_computeWorkGroupSize, property_deleted, property_linked, property_linkedShaders, property_programInfoLog, property_separable, property_validated, arg_program, arg_shader, shaderAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class GlCreateShaderProgramv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlCreateShaderProgramv HELPER_INSTANCE = new GlCreateShaderProgramv();

            private GlCreateShaderProgramv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_attachedShaders, @NonNull SimplePropertyValue<@Nullable ComputeWorkgroupSize> property_computeWorkGroupSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_deleted, @NonNull SimplePropertyValue<@NonNull Boolean> property_linked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_linkedShaders, @NonNull SimplePropertyValue<@NonNull String> property_programInfoLog, @NonNull SimplePropertyValue<@NonNull Boolean> property_separable, @NonNull SimplePropertyValue<@NonNull Boolean> property_validated) throws Exception {
                assert (KapiSpec.GLES.functions.GLCREATESHADERPROGRAMV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_type = GLES.GlCreateShaderProgramvDecorator.getArgumentType(functionCall);
                    Integer arg_count = GLES.GlCreateShaderProgramvDecorator.getArgumentCount(functionCall);
                    StringsArgAttachment arg_strings = GLES.GlCreateShaderProgramvDecorator.getArgumentStrings(functionCall);
                    Long returnValue_ = GLES.GlCreateShaderProgramvDecorator.getReturnValue(functionCall);
                    GlProgramAsset programAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlCreateShaderProgramv(callbacks, functionCall, programAsset, property_attachedShaders, property_computeWorkGroupSize, property_deleted, property_linked, property_linkedShaders, property_programInfoLog, property_separable, property_validated, arg_type, arg_count, arg_strings, returnValue_);
                    return true;
                }
                return false;
            }
        }

        private static final class GlCreateShaderProgramvExt
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlCreateShaderProgramvExt HELPER_INSTANCE = new GlCreateShaderProgramvExt();

            private GlCreateShaderProgramvExt() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_attachedShaders, @NonNull SimplePropertyValue<@Nullable ComputeWorkgroupSize> property_computeWorkGroupSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_deleted, @NonNull SimplePropertyValue<@NonNull Boolean> property_linked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_linkedShaders, @NonNull SimplePropertyValue<@NonNull String> property_programInfoLog, @NonNull SimplePropertyValue<@NonNull Boolean> property_separable, @NonNull SimplePropertyValue<@NonNull Boolean> property_validated) throws Exception {
                assert (KapiSpec.GLES.functions.GLCREATESHADERPROGRAMVEXT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_type = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentType(functionCall);
                    Integer arg_count = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentCount(functionCall);
                    StringsArgAttachment arg_strings = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentStrings(functionCall);
                    Long returnValue_ = GLES.GlCreateShaderProgramvEXTDecorator.getReturnValue(functionCall);
                    GlProgramAsset programAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlCreateShaderProgramvExt(callbacks, functionCall, programAsset, property_attachedShaders, property_computeWorkGroupSize, property_deleted, property_linked, property_linkedShaders, property_programInfoLog, property_separable, property_validated, arg_type, arg_count, arg_strings, returnValue_);
                    return true;
                }
                return false;
            }
        }

        private static final class GlDetachShader
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlDetachShader HELPER_INSTANCE = new GlDetachShader();

            private GlDetachShader() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_attachedShaders, @NonNull SimplePropertyValue<@Nullable ComputeWorkgroupSize> property_computeWorkGroupSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_deleted, @NonNull SimplePropertyValue<@NonNull Boolean> property_linked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_linkedShaders, @NonNull SimplePropertyValue<@NonNull String> property_programInfoLog, @NonNull SimplePropertyValue<@NonNull Boolean> property_separable, @NonNull SimplePropertyValue<@NonNull Boolean> property_validated) throws Exception {
                assert (KapiSpec.GLES.functions.GLDETACHSHADER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_program = GLES.GlDetachShaderDecorator.getArgumentProgram(functionCall);
                    Long arg_shader = GLES.GlDetachShaderDecorator.getArgumentShader(functionCall);
                    GlProgramAsset programAsset = assetObject;
                    AssetItemID shaderAsset_id_value = AssetItemID.valueOf(arg_shader);
                    GlShaderAsset shaderAsset = GlDetachShader.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, callbacks, functionCall, GlDetachShader.getGlShaderAsset(callbacks, functionCall, null, shaderAsset_id_value), shaderAsset_id_value);
                    ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlDetachShader(callbacks, functionCall, programAsset, property_attachedShaders, property_computeWorkGroupSize, property_deleted, property_linked, property_linkedShaders, property_programInfoLog, property_separable, property_validated, arg_program, arg_shader, shaderAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class GlLinkProgram
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlLinkProgram HELPER_INSTANCE = new GlLinkProgram();

            private GlLinkProgram() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_attachedShaders, @NonNull SimplePropertyValue<@Nullable ComputeWorkgroupSize> property_computeWorkGroupSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_deleted, @NonNull SimplePropertyValue<@NonNull Boolean> property_linked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_linkedShaders, @NonNull SimplePropertyValue<@NonNull String> property_programInfoLog, @NonNull SimplePropertyValue<@NonNull Boolean> property_separable, @NonNull SimplePropertyValue<@NonNull Boolean> property_validated) throws Exception {
                assert (KapiSpec.GLES.functions.GLLINKPROGRAM.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_program = GLES.GlLinkProgramDecorator.getArgumentProgram(functionCall);
                    GlProgramAsset programAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlLinkProgram(callbacks, functionCall, programAsset, property_attachedShaders, property_computeWorkGroupSize, property_deleted, property_linked, property_linkedShaders, property_programInfoLog, property_separable, property_validated, arg_program);
                    return true;
                }
                return false;
            }
        }

        private static final class GlProgramParameteri
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlProgramParameteri HELPER_INSTANCE = new GlProgramParameteri();

            private GlProgramParameteri() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_attachedShaders, @NonNull SimplePropertyValue<@Nullable ComputeWorkgroupSize> property_computeWorkGroupSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_deleted, @NonNull SimplePropertyValue<@NonNull Boolean> property_linked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> property_linkedShaders, @NonNull SimplePropertyValue<@NonNull String> property_programInfoLog, @NonNull SimplePropertyValue<@NonNull Boolean> property_separable, @NonNull SimplePropertyValue<@NonNull Boolean> property_validated) throws Exception {
                assert (KapiSpec.GLES.functions.GLPROGRAMPARAMETERI.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_program = GLES.GlProgramParameteriDecorator.getArgumentProgram(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlProgramParameteriDecorator.getArgumentPname(functionCall);
                    Integer arg_value = GLES.GlProgramParameteriDecorator.getArgumentValue(functionCall);
                    GlProgramAsset programAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlProgramParameteri(callbacks, functionCall, programAsset, property_attachedShaders, property_computeWorkGroupSize, property_deleted, property_linked, property_linkedShaders, property_programInfoLog, property_separable, property_validated, arg_program, arg_pname, arg_value);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlProgramAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> var4, @NonNull SimplePropertyValue<@Nullable ComputeWorkgroupSize> var5, @NonNull SimplePropertyValue<@NonNull Boolean> var6, @NonNull SimplePropertyValue<@NonNull Boolean> var7, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlShaderAsset> var8, @NonNull SimplePropertyValue<@NonNull String> var9, @NonNull SimplePropertyValue<@NonNull Boolean> var10, @NonNull SimplePropertyValue<@NonNull Boolean> var11) throws Exception;
        }
    }

    public static final class GlProgramPipelineAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlProgramPipelineAsset, GlProgramPipelineAsset.Value> {
        public static final @NonNull GlProgramPipelineAssetValueProcessor INSTANCE = new GlProgramPipelineAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLACTIVESHADERPROGRAM, GlActiveShaderProgram.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLUSEPROGRAMSTAGES, GlUseProgramStages.HELPER_INSTANCE);
            }
        };

        private GlProgramPipelineAssetValueProcessor() {
        }

        @Override
        public @NonNull GlProgramPipelineAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlProgramPipelineAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlProgramPipelineAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> activeProgram = new SimplePropertyValue<Object>(assetObject, AbstractGlProgramPipelineAsset.GlProgramPipelineAssetProperties.PROPERTY_ACTIVE_PROGRAM, null);
            SimplePropertyValue<@Nullable Object> computeShader = new SimplePropertyValue<Object>(assetObject, AbstractGlProgramPipelineAsset.GlProgramPipelineAssetProperties.PROPERTY_COMPUTE_SHADER, null);
            SimplePropertyValue<@Nullable Object> fragmentShader = new SimplePropertyValue<Object>(assetObject, AbstractGlProgramPipelineAsset.GlProgramPipelineAssetProperties.PROPERTY_FRAGMENT_SHADER, null);
            SimplePropertyValue<@Nullable Object> geometryShader = new SimplePropertyValue<Object>(assetObject, AbstractGlProgramPipelineAsset.GlProgramPipelineAssetProperties.PROPERTY_GEOMETRY_SHADER, null);
            SimplePropertyValue<@Nullable Object> tessControlShader = new SimplePropertyValue<Object>(assetObject, AbstractGlProgramPipelineAsset.GlProgramPipelineAssetProperties.PROPERTY_TESS_CONTROL_SHADER, null);
            SimplePropertyValue<@Nullable Object> tessEvaluationShader = new SimplePropertyValue<Object>(assetObject, AbstractGlProgramPipelineAsset.GlProgramPipelineAssetProperties.PROPERTY_TESS_EVALUATION_SHADER, null);
            SimplePropertyValue<@Nullable Object> vertexShader = new SimplePropertyValue<Object>(assetObject, AbstractGlProgramPipelineAsset.GlProgramPipelineAssetProperties.PROPERTY_VERTEX_SHADER, null);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, activeProgram, computeShader, fragmentShader, geometryShader, tessControlShader, tessEvaluationShader, vertexShader)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlProgramPipelineAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlProgramAsset>)activeProgram, (IAssetPropertyValue<GlProgramAsset>)computeShader, (IAssetPropertyValue<GlProgramAsset>)fragmentShader, (IAssetPropertyValue<GlProgramAsset>)geometryShader, (IAssetPropertyValue<GlProgramAsset>)tessControlShader, (IAssetPropertyValue<GlProgramAsset>)tessEvaluationShader, (IAssetPropertyValue<GlProgramAsset>)vertexShader);
        }

        @Override
        public @NonNull GlProgramPipelineAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlProgramPipelineAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlProgramPipelineAsset assetObject = (GlProgramPipelineAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlProgramPipelineAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable GlProgramAsset> activeProgram = new SimplePropertyValue<GlProgramAsset>(fromValue.getActiveProgram());
            SimplePropertyValue<@Nullable GlProgramAsset> computeShader = new SimplePropertyValue<GlProgramAsset>(fromValue.getComputeShader());
            SimplePropertyValue<@Nullable GlProgramAsset> fragmentShader = new SimplePropertyValue<GlProgramAsset>(fromValue.getFragmentShader());
            SimplePropertyValue<@Nullable GlProgramAsset> geometryShader = new SimplePropertyValue<GlProgramAsset>(fromValue.getGeometryShader());
            SimplePropertyValue<@Nullable GlProgramAsset> tessControlShader = new SimplePropertyValue<GlProgramAsset>(fromValue.getTessControlShader());
            SimplePropertyValue<@Nullable GlProgramAsset> tessEvaluationShader = new SimplePropertyValue<GlProgramAsset>(fromValue.getTessEvaluationShader());
            SimplePropertyValue<@Nullable GlProgramAsset> vertexShader = new SimplePropertyValue<GlProgramAsset>(fromValue.getVertexShader());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, activeProgram, computeShader, fragmentShader, geometryShader, tessControlShader, tessEvaluationShader, vertexShader)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlProgramPipelineAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlProgramAsset>)activeProgram, (IAssetPropertyValue<GlProgramAsset>)computeShader, (IAssetPropertyValue<GlProgramAsset>)fragmentShader, (IAssetPropertyValue<GlProgramAsset>)geometryShader, (IAssetPropertyValue<GlProgramAsset>)tessControlShader, (IAssetPropertyValue<GlProgramAsset>)tessEvaluationShader, (IAssetPropertyValue<GlProgramAsset>)vertexShader);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramPipelineAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> activeProgram, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> computeShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> fragmentShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> geometryShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> tessControlShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> tessEvaluationShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> vertexShader) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, activeProgram, computeShader, fragmentShader, geometryShader, tessControlShader, tessEvaluationShader, vertexShader);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlProgramPipelineAsset.Value processedValue;
                GlProgramPipelineAsset.Value unProcessedValue = new GlProgramPipelineAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<GlProgramAsset>)activeProgram, (IAssetPropertyValue<GlProgramAsset>)computeShader, (IAssetPropertyValue<GlProgramAsset>)fragmentShader, (IAssetPropertyValue<GlProgramAsset>)geometryShader, (IAssetPropertyValue<GlProgramAsset>)tessControlShader, (IAssetPropertyValue<GlProgramAsset>)tessEvaluationShader, (IAssetPropertyValue<GlProgramAsset>)vertexShader);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                activeProgram.setValueFrom(functionCall, processedValue.getActiveProgram());
                computeShader.setValueFrom(functionCall, processedValue.getComputeShader());
                fragmentShader.setValueFrom(functionCall, processedValue.getFragmentShader());
                geometryShader.setValueFrom(functionCall, processedValue.getGeometryShader());
                tessControlShader.setValueFrom(functionCall, processedValue.getTessControlShader());
                tessEvaluationShader.setValueFrom(functionCall, processedValue.getTessEvaluationShader());
                vertexShader.setValueFrom(functionCall, processedValue.getVertexShader());
            }
            return result;
        }

        private static final class GlActiveShaderProgram
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlActiveShaderProgram HELPER_INSTANCE = new GlActiveShaderProgram();

            private GlActiveShaderProgram() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramPipelineAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_activeProgram, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_computeShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_fragmentShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_geometryShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_tessControlShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_tessEvaluationShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_vertexShader) throws Exception {
                assert (KapiSpec.GLES.functions.GLACTIVESHADERPROGRAM.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_pipeline = GLES.GlActiveShaderProgramDecorator.getArgumentPipeline(functionCall);
                    Long arg_program = GLES.GlActiveShaderProgramDecorator.getArgumentProgram(functionCall);
                    GlProgramPipelineAsset programPipelineAsset = assetObject;
                    AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                    GlProgramAsset programAsset = GlActiveShaderProgram.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlActiveShaderProgram.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value), programAsset_id_value, AssetItemID.valueOf(0));
                    property_activeProgram.setValue(functionCall, programAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class GlUseProgramStages
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlUseProgramStages HELPER_INSTANCE = new GlUseProgramStages();

            private GlUseProgramStages() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlProgramPipelineAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_activeProgram, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_computeShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_fragmentShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_geometryShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_tessControlShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_tessEvaluationShader, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> property_vertexShader) throws Exception {
                assert (KapiSpec.GLES.functions.GLUSEPROGRAMSTAGES.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_pipeline = GLES.GlUseProgramStagesDecorator.getArgumentPipeline(functionCall);
                    Bitfield arg_stages = GLES.GlUseProgramStagesDecorator.getArgumentStages(functionCall);
                    Long arg_program = GLES.GlUseProgramStagesDecorator.getArgumentProgram(functionCall);
                    GlProgramPipelineAsset programPipelineAsset = assetObject;
                    AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                    GlProgramAsset programAsset = GlUseProgramStages.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlUseProgramStages.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value), programAsset_id_value, AssetItemID.valueOf(0));
                    ProvidedAssetProcessors.processProvidedActionForGlProgramPipelineAssetOnGlUseProgramStages(callbacks, functionCall, programPipelineAsset, property_activeProgram, property_computeShader, property_fragmentShader, property_geometryShader, property_tessControlShader, property_tessEvaluationShader, property_vertexShader, arg_pipeline, arg_stages, arg_program, programAsset);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlProgramPipelineAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> var4, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> var5, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> var6, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> var7, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> var8, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> var9, @NonNull SimplePropertyValue<@Nullable GlProgramAsset> var10) throws Exception;
        }
    }

    public static final class GlQueryObjectAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlQueryObjectAsset, GlQueryObjectAsset.Value> {
        public static final @NonNull GlQueryObjectAssetValueProcessor INSTANCE = new GlQueryObjectAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBEGINQUERY, GlBeginQuery.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLGETQUERYOBJECTUIV, GlGetQueryObjectuiv.HELPER_INSTANCE);
            }
        };

        private GlQueryObjectAssetValueProcessor() {
        }

        @Override
        public @NonNull GlQueryObjectAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlQueryObjectAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlQueryObjectAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> queryResult = new SimplePropertyValue<Long>(assetObject, AbstractGlQueryObjectAsset.GlQueryObjectAssetProperties.PROPERTY_QUERY_RESULT, 0L);
            SimplePropertyValue<@Nullable Object> queryTarget = new SimplePropertyValue<Object>(assetObject, AbstractGlQueryObjectAsset.GlQueryObjectAssetProperties.PROPERTY_QUERY_TARGET, null);
            SimplePropertyValue<@NonNull Boolean> resultAvailable = new SimplePropertyValue<Boolean>(assetObject, AbstractGlQueryObjectAsset.GlQueryObjectAssetProperties.PROPERTY_RESULT_AVAILABLE, false);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, queryResult, queryTarget, resultAvailable)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlQueryObjectAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)queryResult, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)queryTarget, (IAssetPropertyValue<Boolean>)resultAvailable);
        }

        @Override
        public @NonNull GlQueryObjectAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlQueryObjectAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlQueryObjectAsset assetObject = (GlQueryObjectAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlQueryObjectAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> queryResult = new SimplePropertyValue<Long>(fromValue.getQueryResult());
            SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> queryTarget = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getQueryTarget());
            SimplePropertyValue<@NonNull Boolean> resultAvailable = new SimplePropertyValue<Boolean>(fromValue.getResultAvailable());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, queryResult, queryTarget, resultAvailable)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlQueryObjectAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)queryResult, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)queryTarget, (IAssetPropertyValue<Boolean>)resultAvailable);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlQueryObjectAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> queryResult, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> queryTarget, @NonNull SimplePropertyValue<@NonNull Boolean> resultAvailable) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, queryResult, queryTarget, resultAvailable);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlQueryObjectAsset.Value processedValue;
                GlQueryObjectAsset.Value unProcessedValue = new GlQueryObjectAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)queryResult, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)queryTarget, (IAssetPropertyValue<Boolean>)resultAvailable);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                queryResult.setValueFrom(functionCall, processedValue.getQueryResult());
                queryTarget.setValueFrom(functionCall, processedValue.getQueryTarget());
                resultAvailable.setValueFrom(functionCall, processedValue.getResultAvailable());
            }
            return result;
        }

        private static final class GlBeginQuery
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBeginQuery HELPER_INSTANCE = new GlBeginQuery();

            private GlBeginQuery() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlQueryObjectAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_queryResult, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_queryTarget, @NonNull SimplePropertyValue<@NonNull Boolean> property_resultAvailable) throws Exception {
                assert (KapiSpec.GLES.functions.GLBEGINQUERY.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBeginQueryDecorator.getArgumentTarget(functionCall);
                    Long arg_id = GLES.GlBeginQueryDecorator.getArgumentId(functionCall);
                    GlQueryObjectAsset queryAsset = assetObject;
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_0 = GlBeginQuery.validateConstantIsInSetLogError(callbacks, functionCall, arg_target, Constants.CONSTANT_SET_2);
                    property_queryTarget.setValue(functionCall, temp_validateConstantIsInSetLogError_return_value_0);
                    return true;
                }
                return false;
            }
        }

        private static final class GlGetQueryObjectuiv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlGetQueryObjectuiv HELPER_INSTANCE = new GlGetQueryObjectuiv();

            private GlGetQueryObjectuiv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlQueryObjectAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_queryResult, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_queryTarget, @NonNull SimplePropertyValue<@NonNull Boolean> property_resultAvailable) throws Exception {
                assert (KapiSpec.GLES.functions.GLGETQUERYOBJECTUIV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_id = GLES.GlGetQueryObjectuivDecorator.getArgumentId(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlGetQueryObjectuivDecorator.getArgumentPname(functionCall);
                    LongPtrArgAttachment arg_params = GLES.GlGetQueryObjectuivDecorator.getArgumentParams(functionCall);
                    GlQueryObjectAsset queryAsset = assetObject;
                    if (arg_pname.equals(KapiSpec.GLES.constants.GL_QUERY_RESULT)) {
                        property_queryResult.setValue(functionCall, arg_params.getValue());
                    }
                    if (arg_pname.equals(KapiSpec.GLES.constants.GL_QUERY_RESULT_AVAILABLE)) {
                        property_resultAvailable.setValue(functionCall, arg_params.getValue() != 0L);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlQueryObjectAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> var5, @NonNull SimplePropertyValue<@NonNull Boolean> var6) throws Exception;
        }
    }

    public static final class GlRenderbufferAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlRenderbufferAsset, GlRenderbufferAsset.Value> {
        public static final @NonNull GlRenderbufferAssetValueProcessor INSTANCE = new GlRenderbufferAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGE, GlRenderbufferStorage.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGEMULTISAMPLE, GlRenderbufferStorageMultisample.HELPER_INSTANCE);
            }
        };

        private GlRenderbufferAssetValueProcessor() {
        }

        @Override
        public @NonNull GlRenderbufferAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlRenderbufferAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlRenderbufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_ALPHA_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_BLUE_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_DEPTH_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_GREEN_SIZE, 0L);
            SimplePropertyValue<@NonNull Integer> height = new SimplePropertyValue<Integer>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_HEIGHT, 0);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> internalFormat = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_INTERNAL_FORMAT, KapiSpec.GLES.constants.GL_RGBA4);
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_RED_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> samples = new SimplePropertyValue<Long>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_SAMPLES, 0L);
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_STENCIL_SIZE, 0L);
            SimplePropertyValue<@NonNull Integer> width = new SimplePropertyValue<Integer>(assetObject, AbstractGlRenderbufferAsset.GlRenderbufferAssetProperties.PROPERTY_WIDTH, 0);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, depthSize, greenSize, height, internalFormat, redSize, samples, stencilSize, width)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlRenderbufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Integer>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)internalFormat, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)samples, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<Integer>)width);
        }

        @Override
        public @NonNull GlRenderbufferAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlRenderbufferAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlRenderbufferAsset assetObject = (GlRenderbufferAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlRenderbufferAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(fromValue.getAlphaSize());
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(fromValue.getBlueSize());
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(fromValue.getDepthSize());
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(fromValue.getGreenSize());
            SimplePropertyValue<@NonNull Integer> height = new SimplePropertyValue<Integer>(fromValue.getHeight());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> internalFormat = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getInternalFormat());
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(fromValue.getRedSize());
            SimplePropertyValue<@NonNull Long> samples = new SimplePropertyValue<Long>(fromValue.getSamples());
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(fromValue.getStencilSize());
            SimplePropertyValue<@NonNull Integer> width = new SimplePropertyValue<Integer>(fromValue.getWidth());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, alphaSize, blueSize, depthSize, greenSize, height, internalFormat, redSize, samples, stencilSize, width)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlRenderbufferAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Integer>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)internalFormat, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)samples, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<Integer>)width);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlRenderbufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> alphaSize, @NonNull SimplePropertyValue<@NonNull Long> blueSize, @NonNull SimplePropertyValue<@NonNull Long> depthSize, @NonNull SimplePropertyValue<@NonNull Long> greenSize, @NonNull SimplePropertyValue<@NonNull Integer> height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> internalFormat, @NonNull SimplePropertyValue<@NonNull Long> redSize, @NonNull SimplePropertyValue<@NonNull Long> samples, @NonNull SimplePropertyValue<@NonNull Long> stencilSize, @NonNull SimplePropertyValue<@NonNull Integer> width) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, alphaSize, blueSize, depthSize, greenSize, height, internalFormat, redSize, samples, stencilSize, width);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlRenderbufferAsset.Value processedValue;
                GlRenderbufferAsset.Value unProcessedValue = new GlRenderbufferAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<Integer>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)internalFormat, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<Long>)samples, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<Integer>)width);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                alphaSize.setValueFrom(functionCall, processedValue.getAlphaSize());
                blueSize.setValueFrom(functionCall, processedValue.getBlueSize());
                depthSize.setValueFrom(functionCall, processedValue.getDepthSize());
                greenSize.setValueFrom(functionCall, processedValue.getGreenSize());
                height.setValueFrom(functionCall, processedValue.getHeight());
                internalFormat.setValueFrom(functionCall, processedValue.getInternalFormat());
                redSize.setValueFrom(functionCall, processedValue.getRedSize());
                samples.setValueFrom(functionCall, processedValue.getSamples());
                stencilSize.setValueFrom(functionCall, processedValue.getStencilSize());
                width.setValueFrom(functionCall, processedValue.getWidth());
            }
            return result;
        }

        private static final class GlRenderbufferStorage
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlRenderbufferStorage HELPER_INSTANCE = new GlRenderbufferStorage();

            private GlRenderbufferStorage() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlRenderbufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull Integer> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Integer> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlRenderbufferStorageDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlRenderbufferStorageDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlRenderbufferStorageDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlRenderbufferStorageDecorator.getArgumentHeight(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_RENDERBUFFER)) {
                        GlRenderbufferAsset targetAsset = assetObject;
                        property_internalFormat.setValue(functionCall, arg_internalformat);
                        property_width.setValue(functionCall, arg_width);
                        property_height.setValue(functionCall, arg_height);
                        property_samples.setValue(functionCall, 0L);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class GlRenderbufferStorageMultisample
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlRenderbufferStorageMultisample HELPER_INSTANCE = new GlRenderbufferStorageMultisample();

            private GlRenderbufferStorageMultisample() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlRenderbufferAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull Integer> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Integer> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGEMULTISAMPLE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentTarget(functionCall);
                    Integer arg_samples = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentSamples(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentHeight(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_RENDERBUFFER)) {
                        GlRenderbufferAsset targetAsset = assetObject;
                        property_internalFormat.setValue(functionCall, arg_internalformat);
                        property_width.setValue(functionCall, arg_width);
                        property_height.setValue(functionCall, arg_height);
                        Long temp_valueOf_return_value_0 = arg_samples.longValue();
                        property_samples.setValue(functionCall, temp_valueOf_return_value_0);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlRenderbufferAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull Long> var6, @NonNull SimplePropertyValue<@NonNull Long> var7, @NonNull SimplePropertyValue<@NonNull Integer> var8, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var9, @NonNull SimplePropertyValue<@NonNull Long> var10, @NonNull SimplePropertyValue<@NonNull Long> var11, @NonNull SimplePropertyValue<@NonNull Long> var12, @NonNull SimplePropertyValue<@NonNull Integer> var13) throws Exception;
        }
    }

    public static final class GlSamplerAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlSamplerAsset, GlSamplerAsset.Value> {
        public static final @NonNull GlSamplerAssetValueProcessor INSTANCE = new GlSamplerAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERIIV, GlSamplerParameterIiv.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERIUIV, GlSamplerParameterIuiv.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERF, GlSamplerParameterf.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERFV, GlSamplerParameterfv.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERI, GlSamplerParameteri.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERIV, GlSamplerParameteriv.HELPER_INSTANCE);
            }
        };

        private GlSamplerAssetValueProcessor() {
        }

        @Override
        public @NonNull GlSamplerAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlSamplerAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlSamplerAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<float[]> borderColor = new SimplePropertyValue<float[]>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_BORDER_COLOR, new float[4]);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareFunc = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_COMPARE_FUNC, KapiSpec.GLES.constants.GL_LEQUAL);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_COMPARE_MODE, KapiSpec.GLES.constants.GL_NONE);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> magFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_MAG_FILTER, KapiSpec.GLES.constants.GL_LINEAR);
            SimplePropertyValue<@NonNull Float> maxLod = new SimplePropertyValue<Float>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_MAX_LOD, Float.valueOf(1000.0f));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> minFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_MIN_FILTER, KapiSpec.GLES.constants.GL_NEAREST_MIPMAP_LINEAR);
            SimplePropertyValue<@NonNull Float> minLod = new SimplePropertyValue<Float>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_MIN_LOD, Float.valueOf(-1000.0f));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_WRAP_R, KapiSpec.GLES.constants.GL_REPEAT);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapS = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_WRAP_S, KapiSpec.GLES.constants.GL_REPEAT);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapT = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSamplerAsset.GlSamplerAssetProperties.PROPERTY_WRAP_T, KapiSpec.GLES.constants.GL_REPEAT);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, borderColor, compareFunc, compareMode, magFilter, maxLod, minFilter, minLod, wrapR, wrapS, wrapT)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlSamplerAsset.Value(validRange, assetObject, (IAssetPropertyValue<float[]>)borderColor, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareFunc, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)magFilter, (IAssetPropertyValue<Float>)maxLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)minFilter, (IAssetPropertyValue<Float>)minLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapS, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapT);
        }

        @Override
        public @NonNull GlSamplerAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlSamplerAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlSamplerAsset assetObject = (GlSamplerAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlSamplerAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<float[]> borderColor = new SimplePropertyValue<float[]>(fromValue.getBorderColor());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareFunc = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getCompareFunc());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getCompareMode());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> magFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getMagFilter());
            SimplePropertyValue<@NonNull Float> maxLod = new SimplePropertyValue<Float>(fromValue.getMaxLod());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> minFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getMinFilter());
            SimplePropertyValue<@NonNull Float> minLod = new SimplePropertyValue<Float>(fromValue.getMinLod());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getWrapR());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapS = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getWrapS());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapT = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getWrapT());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, borderColor, compareFunc, compareMode, magFilter, maxLod, minFilter, minLod, wrapR, wrapS, wrapT)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlSamplerAsset.Value(validRange, assetObject, (IAssetPropertyValue<float[]>)borderColor, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareFunc, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)magFilter, (IAssetPropertyValue<Float>)maxLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)minFilter, (IAssetPropertyValue<Float>)minLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapS, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapT);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSamplerAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<float[]> borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> magFilter, @NonNull SimplePropertyValue<@NonNull Float> maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> minFilter, @NonNull SimplePropertyValue<@NonNull Float> minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapT) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, borderColor, compareFunc, compareMode, magFilter, maxLod, minFilter, minLod, wrapR, wrapS, wrapT);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlSamplerAsset.Value processedValue;
                GlSamplerAsset.Value unProcessedValue = new GlSamplerAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<float[]>)borderColor, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareFunc, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)magFilter, (IAssetPropertyValue<Float>)maxLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)minFilter, (IAssetPropertyValue<Float>)minLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapS, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapT);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                borderColor.setValueFrom(functionCall, processedValue.getBorderColor());
                compareFunc.setValueFrom(functionCall, processedValue.getCompareFunc());
                compareMode.setValueFrom(functionCall, processedValue.getCompareMode());
                magFilter.setValueFrom(functionCall, processedValue.getMagFilter());
                maxLod.setValueFrom(functionCall, processedValue.getMaxLod());
                minFilter.setValueFrom(functionCall, processedValue.getMinFilter());
                minLod.setValueFrom(functionCall, processedValue.getMinLod());
                wrapR.setValueFrom(functionCall, processedValue.getWrapR());
                wrapS.setValueFrom(functionCall, processedValue.getWrapS());
                wrapT.setValueFrom(functionCall, processedValue.getWrapT());
            }
            return result;
        }

        private static final class GlSamplerParameterIiv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlSamplerParameterIiv HELPER_INSTANCE = new GlSamplerParameterIiv();

            private GlSamplerParameterIiv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSamplerAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIIV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_sampler = GLES.GlSamplerParameterIivDecorator.getArgumentSampler(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterIivDecorator.getArgumentPname(functionCall);
                    LongsArgAttachment arg_param = GLES.GlSamplerParameterIivDecorator.getArgumentParam(functionCall);
                    GlSamplerAsset samplerAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameterIiv(callbacks, functionCall, samplerAsset, property_borderColor, property_compareFunc, property_compareMode, property_magFilter, property_maxLod, property_minFilter, property_minLod, property_wrapR, property_wrapS, property_wrapT, arg_sampler, arg_pname, arg_param);
                    return true;
                }
                return false;
            }
        }

        private static final class GlSamplerParameterIuiv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlSamplerParameterIuiv HELPER_INSTANCE = new GlSamplerParameterIuiv();

            private GlSamplerParameterIuiv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSamplerAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIUIV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_sampler = GLES.GlSamplerParameterIuivDecorator.getArgumentSampler(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterIuivDecorator.getArgumentPname(functionCall);
                    LongsArgAttachment arg_param = GLES.GlSamplerParameterIuivDecorator.getArgumentParam(functionCall);
                    GlSamplerAsset samplerAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameterIuiv(callbacks, functionCall, samplerAsset, property_borderColor, property_compareFunc, property_compareMode, property_magFilter, property_maxLod, property_minFilter, property_minLod, property_wrapR, property_wrapS, property_wrapT, arg_sampler, arg_pname, arg_param);
                    return true;
                }
                return false;
            }
        }

        private static final class GlSamplerParameterf
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlSamplerParameterf HELPER_INSTANCE = new GlSamplerParameterf();

            private GlSamplerParameterf() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSamplerAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERF.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_sampler = GLES.GlSamplerParameterfDecorator.getArgumentSampler(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterfDecorator.getArgumentPname(functionCall);
                    Float arg_param = GLES.GlSamplerParameterfDecorator.getArgumentParam(functionCall);
                    GlSamplerAsset samplerAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameterf(callbacks, functionCall, samplerAsset, property_borderColor, property_compareFunc, property_compareMode, property_magFilter, property_maxLod, property_minFilter, property_minLod, property_wrapR, property_wrapS, property_wrapT, arg_sampler, arg_pname, arg_param);
                    return true;
                }
                return false;
            }
        }

        private static final class GlSamplerParameterfv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlSamplerParameterfv HELPER_INSTANCE = new GlSamplerParameterfv();

            private GlSamplerParameterfv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSamplerAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERFV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_sampler = GLES.GlSamplerParameterfvDecorator.getArgumentSampler(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterfvDecorator.getArgumentPname(functionCall);
                    FloatsArgAttachment arg_param = GLES.GlSamplerParameterfvDecorator.getArgumentParam(functionCall);
                    GlSamplerAsset samplerAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameterfv(callbacks, functionCall, samplerAsset, property_borderColor, property_compareFunc, property_compareMode, property_magFilter, property_maxLod, property_minFilter, property_minLod, property_wrapR, property_wrapS, property_wrapT, arg_sampler, arg_pname, arg_param);
                    return true;
                }
                return false;
            }
        }

        private static final class GlSamplerParameteri
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlSamplerParameteri HELPER_INSTANCE = new GlSamplerParameteri();

            private GlSamplerParameteri() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSamplerAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERI.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_sampler = GLES.GlSamplerParameteriDecorator.getArgumentSampler(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameteriDecorator.getArgumentPname(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_param = GLES.GlSamplerParameteriDecorator.getArgumentParam(functionCall);
                    GlSamplerAsset samplerAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameteri(callbacks, functionCall, samplerAsset, property_borderColor, property_compareFunc, property_compareMode, property_magFilter, property_maxLod, property_minFilter, property_minLod, property_wrapR, property_wrapS, property_wrapT, arg_sampler, arg_pname, arg_param);
                    return true;
                }
                return false;
            }
        }

        private static final class GlSamplerParameteriv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlSamplerParameteriv HELPER_INSTANCE = new GlSamplerParameteriv();

            private GlSamplerParameteriv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSamplerAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_sampler = GLES.GlSamplerParameterivDecorator.getArgumentSampler(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterivDecorator.getArgumentPname(functionCall);
                    LongsArgAttachment arg_param = GLES.GlSamplerParameterivDecorator.getArgumentParam(functionCall);
                    GlSamplerAsset samplerAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameteriv(callbacks, functionCall, samplerAsset, property_borderColor, property_compareFunc, property_compareMode, property_magFilter, property_maxLod, property_minFilter, property_minLod, property_wrapR, property_wrapS, property_wrapT, arg_sampler, arg_pname, arg_param);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlSamplerAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<float[]> var4, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var5, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@NonNull Float> var8, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var9, @NonNull SimplePropertyValue<@NonNull Float> var10, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var11, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var12, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var13) throws Exception;
        }
    }

    public static final class GlShaderAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlShaderAsset, GlShaderAsset.Value> {
        public static final @NonNull GlShaderAssetValueProcessor INSTANCE = new GlShaderAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLSHADERBINARY, GlShaderBinary.HELPER_INSTANCE);
            }
        };

        private GlShaderAssetValueProcessor() {
        }

        @Override
        public @NonNull GlShaderAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlShaderAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlShaderAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> binaryFormat = new SimplePropertyValue<Object>(assetObject, AbstractGlShaderAsset.GlShaderAssetProperties.PROPERTY_BINARY_FORMAT, null);
            SimplePropertyValue<@NonNull Boolean> compiled = new SimplePropertyValue<Boolean>(assetObject, AbstractGlShaderAsset.GlShaderAssetProperties.PROPERTY_COMPILED, false);
            SimplePropertyValue<@NonNull Boolean> deleted = new SimplePropertyValue<Boolean>(assetObject, AbstractGlShaderAsset.GlShaderAssetProperties.PROPERTY_DELETED, false);
            SimplePropertyValue<@NonNull Boolean> flaggedForDeletion = new SimplePropertyValue<Boolean>(assetObject, AbstractGlShaderAsset.GlShaderAssetProperties.PROPERTY_FLAGGED_FOR_DELETION, false);
            SimplePropertyValue<@NonNull String> shaderInfoLog = new SimplePropertyValue<String>(assetObject, AbstractGlShaderAsset.GlShaderAssetProperties.PROPERTY_SHADER_INFO_LOG, "");
            SimplePropertyValue<@NonNull String> shaderSource = new SimplePropertyValue<String>(assetObject, AbstractGlShaderAsset.GlShaderAssetProperties.PROPERTY_SHADER_SOURCE, "");
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, binaryFormat, compiled, deleted, flaggedForDeletion, shaderInfoLog, shaderSource, type)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlShaderAsset.Value(validRange, assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)binaryFormat, (IAssetPropertyValue<Boolean>)compiled, (IAssetPropertyValue<Boolean>)deleted, (IAssetPropertyValue<Boolean>)flaggedForDeletion, (IAssetPropertyValue<String>)shaderInfoLog, (IAssetPropertyValue<String>)shaderSource, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
        }

        @Override
        public @NonNull GlShaderAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlShaderAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlShaderAsset assetObject = (GlShaderAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlShaderAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> binaryFormat = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getBinaryFormat());
            SimplePropertyValue<@NonNull Boolean> compiled = new SimplePropertyValue<Boolean>(fromValue.getCompiled());
            SimplePropertyValue<@NonNull Boolean> deleted = new SimplePropertyValue<Boolean>(fromValue.getDeleted());
            SimplePropertyValue<@NonNull Boolean> flaggedForDeletion = new SimplePropertyValue<Boolean>(fromValue.getFlaggedForDeletion());
            SimplePropertyValue<@NonNull String> shaderInfoLog = new SimplePropertyValue<String>(fromValue.getShaderInfoLog());
            SimplePropertyValue<@NonNull String> shaderSource = new SimplePropertyValue<String>(fromValue.getShaderSource());
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, binaryFormat, compiled, deleted, flaggedForDeletion, shaderInfoLog, shaderSource, type)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlShaderAsset.Value(validRange, assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)binaryFormat, (IAssetPropertyValue<Boolean>)compiled, (IAssetPropertyValue<Boolean>)deleted, (IAssetPropertyValue<Boolean>)flaggedForDeletion, (IAssetPropertyValue<String>)shaderInfoLog, (IAssetPropertyValue<String>)shaderSource, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlShaderAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> binaryFormat, @NonNull SimplePropertyValue<@NonNull Boolean> compiled, @NonNull SimplePropertyValue<@NonNull Boolean> deleted, @NonNull SimplePropertyValue<@NonNull Boolean> flaggedForDeletion, @NonNull SimplePropertyValue<@NonNull String> shaderInfoLog, @NonNull SimplePropertyValue<@NonNull String> shaderSource, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, binaryFormat, compiled, deleted, flaggedForDeletion, shaderInfoLog, shaderSource, type);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlShaderAsset.Value processedValue;
                GlShaderAsset.Value unProcessedValue = new GlShaderAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)binaryFormat, (IAssetPropertyValue<Boolean>)compiled, (IAssetPropertyValue<Boolean>)deleted, (IAssetPropertyValue<Boolean>)flaggedForDeletion, (IAssetPropertyValue<String>)shaderInfoLog, (IAssetPropertyValue<String>)shaderSource, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                binaryFormat.setValueFrom(functionCall, processedValue.getBinaryFormat());
                compiled.setValueFrom(functionCall, processedValue.getCompiled());
                deleted.setValueFrom(functionCall, processedValue.getDeleted());
                flaggedForDeletion.setValueFrom(functionCall, processedValue.getFlaggedForDeletion());
                shaderInfoLog.setValueFrom(functionCall, processedValue.getShaderInfoLog());
                shaderSource.setValueFrom(functionCall, processedValue.getShaderSource());
            }
            return result;
        }

        private static final class GlShaderBinary
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlShaderBinary HELPER_INSTANCE = new GlShaderBinary();

            private GlShaderBinary() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlShaderAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_binaryFormat, @NonNull SimplePropertyValue<@NonNull Boolean> property_compiled, @NonNull SimplePropertyValue<@NonNull Boolean> property_deleted, @NonNull SimplePropertyValue<@NonNull Boolean> property_flaggedForDeletion, @NonNull SimplePropertyValue<@NonNull String> property_shaderInfoLog, @NonNull SimplePropertyValue<@NonNull String> property_shaderSource, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type) throws Exception {
                assert (KapiSpec.GLES.functions.GLSHADERBINARY.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Integer arg_count = GLES.GlShaderBinaryDecorator.getArgumentCount(functionCall);
                    LongsArgAttachment arg_shaders = GLES.GlShaderBinaryDecorator.getArgumentShaders(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_binaryformat = GLES.GlShaderBinaryDecorator.getArgumentBinaryformat(functionCall);
                    BufferArgAttachment arg_binary = GLES.GlShaderBinaryDecorator.getArgumentBinary(functionCall);
                    Integer arg_length = GLES.GlShaderBinaryDecorator.getArgumentLength(functionCall);
                    GlShaderAsset shaderAsset = assetObject;
                    property_binaryFormat.setValue(functionCall, arg_binaryformat);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlShaderAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> var4, @NonNull SimplePropertyValue<@NonNull Boolean> var5, @NonNull SimplePropertyValue<@NonNull Boolean> var6, @NonNull SimplePropertyValue<@NonNull Boolean> var7, @NonNull SimplePropertyValue<@NonNull String> var8, @NonNull SimplePropertyValue<@NonNull String> var9, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var10) throws Exception;
        }
    }

    public static final class GlShaderStorageBufferBindingPointAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlShaderStorageBufferBindingPointAsset, GlShaderStorageBufferBindingPointAsset.Value> {
        public static final @NonNull GlShaderStorageBufferBindingPointAssetValueProcessor INSTANCE = new GlShaderStorageBufferBindingPointAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERBASE, GlBindBufferBase.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERRANGE, GlBindBufferRange.HELPER_INSTANCE);
            }
        };

        private GlShaderStorageBufferBindingPointAssetValueProcessor() {
        }

        @Override
        public @NonNull GlShaderStorageBufferBindingPointAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlShaderStorageBufferBindingPointAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlShaderStorageBufferBindingPointAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> buffer = new SimplePropertyValue<Object>(assetObject, AbstractGlShaderStorageBufferBindingPointAsset.GlShaderStorageBufferBindingPointAssetProperties.PROPERTY_BUFFER, null);
            SimplePropertyValue<@NonNull Long> length = new SimplePropertyValue<Long>(assetObject, AbstractGlShaderStorageBufferBindingPointAsset.GlShaderStorageBufferBindingPointAssetProperties.PROPERTY_LENGTH, 0L);
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(assetObject, AbstractGlShaderStorageBufferBindingPointAsset.GlShaderStorageBufferBindingPointAssetProperties.PROPERTY_OFFSET, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(buffer, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, buffer, length, offset)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlShaderStorageBufferBindingPointAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
        }

        @Override
        public @NonNull GlShaderStorageBufferBindingPointAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlShaderStorageBufferBindingPointAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlShaderStorageBufferBindingPointAsset assetObject = (GlShaderStorageBufferBindingPointAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlShaderStorageBufferBindingPointAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable GlBufferAsset> buffer = new SimplePropertyValue<GlBufferAsset>(fromValue.getBuffer());
            SimplePropertyValue<@NonNull Long> length = new SimplePropertyValue<Long>(fromValue.getLength());
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(fromValue.getOffset());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(buffer, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, buffer, length, offset)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlShaderStorageBufferBindingPointAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlShaderStorageBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> buffer, @NonNull SimplePropertyValue<@NonNull Long> length, @NonNull SimplePropertyValue<@NonNull Long> offset) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, buffer, length, offset);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlShaderStorageBufferBindingPointAsset.Value processedValue;
                GlShaderStorageBufferBindingPointAsset.Value unProcessedValue = new GlShaderStorageBufferBindingPointAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                buffer.setValueFrom(functionCall, processedValue.getBuffer());
                length.setValueFrom(functionCall, processedValue.getLength());
                offset.setValueFrom(functionCall, processedValue.getOffset());
            }
            return result;
        }

        private static final class GlBindBufferBase
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferBase HELPER_INSTANCE = new GlBindBufferBase();

            private GlBindBufferBase() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlShaderStorageBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_length, @NonNull SimplePropertyValue<@NonNull Long> property_offset) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERBASE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractAssetItem abstractAssetItem;
                    AssetItemID bindingAsset_id_value;
                    GlBufferAsset bufferAsset;
                    AssetItemID bufferAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferBaseDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        GlShaderStorageBufferBindingPointAsset bindingAsset = assetObject;
                        property_buffer.setValue(functionCall, bufferAsset);
                        property_offset.setValue(functionCall, 0L);
                        GlBufferAsset.Value temp_safeWaitForValue_return_value_4 = (GlBufferAsset.Value)GlBindBufferBase.safeWaitForValue(callbacks, bufferAsset, functionCall.getID());
                        Long temp_valueOf_return_value_5 = temp_safeWaitForValue_return_value_4 != null ? temp_safeWaitForValue_return_value_4.getSize().getValue() : 0L;
                        property_length.setValue(functionCall, temp_valueOf_return_value_5);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class GlBindBufferRange
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferRange HELPER_INSTANCE = new GlBindBufferRange();

            private GlBindBufferRange() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlShaderStorageBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_length, @NonNull SimplePropertyValue<@NonNull Long> property_offset) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERRANGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractAssetItem abstractAssetItem;
                    AssetItemID bindingAsset_id_value;
                    GlBufferAsset bufferAsset;
                    AssetItemID bufferAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferRangeDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
                    Long arg_offset = GLES.GlBindBufferRangeDecorator.getArgumentOffset(functionCall);
                    Long arg_size = GLES.GlBindBufferRangeDecorator.getArgumentSize(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        GlShaderStorageBufferBindingPointAsset bindingAsset = assetObject;
                        property_buffer.setValue(functionCall, bufferAsset);
                        property_offset.setValue(functionCall, arg_offset);
                        property_length.setValue(functionCall, arg_size);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlShaderStorageBufferBindingPointAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull Long> var6) throws Exception;
        }
    }

    public static final class GlSyncObjectAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlSyncObjectAsset, GlSyncObjectAsset.Value> {
        public static final @NonNull GlSyncObjectAssetValueProcessor INSTANCE = new GlSyncObjectAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLFENCESYNC, GlFenceSync.HELPER_INSTANCE);
            }
        };

        private GlSyncObjectAssetValueProcessor() {
        }

        @Override
        public @NonNull GlSyncObjectAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlSyncObjectAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlSyncObjectAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> condition = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSyncObjectAsset.GlSyncObjectAssetProperties.PROPERTY_CONDITION, KapiSpec.GLES.constants.GL_SYNC_GPU_COMMANDS_COMPLETE);
            SimplePropertyValue<@NonNull Bitfield> flags = new SimplePropertyValue<Bitfield>(assetObject, AbstractGlSyncObjectAsset.GlSyncObjectAssetProperties.PROPERTY_FLAGS, new Bitfield());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> status = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlSyncObjectAsset.GlSyncObjectAssetProperties.PROPERTY_STATUS, KapiSpec.GLES.constants.GL_UNSIGNALED);
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, condition, flags, status, type)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlSyncObjectAsset.Value(validRange, assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)condition, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)status, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
        }

        @Override
        public @NonNull GlSyncObjectAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlSyncObjectAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlSyncObjectAsset assetObject = (GlSyncObjectAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlSyncObjectAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> condition = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getCondition());
            SimplePropertyValue<@NonNull Bitfield> flags = new SimplePropertyValue<Bitfield>(fromValue.getFlags());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> status = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getStatus());
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, condition, flags, status, type)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlSyncObjectAsset.Value(validRange, assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)condition, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)status, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSyncObjectAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> condition, @NonNull SimplePropertyValue<@NonNull Bitfield> flags, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> status, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, condition, flags, status, type);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlSyncObjectAsset.Value processedValue;
                GlSyncObjectAsset.Value unProcessedValue = new GlSyncObjectAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)condition, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)status, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                condition.setValueFrom(functionCall, processedValue.getCondition());
                flags.setValueFrom(functionCall, processedValue.getFlags());
                status.setValueFrom(functionCall, processedValue.getStatus());
            }
            return result;
        }

        private static final class GlFenceSync
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlFenceSync HELPER_INSTANCE = new GlFenceSync();

            private GlFenceSync() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlSyncObjectAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_condition, @NonNull SimplePropertyValue<@NonNull Bitfield> property_flags, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_status, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type) throws Exception {
                assert (KapiSpec.GLES.functions.GLFENCESYNC.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_condition = GLES.GlFenceSyncDecorator.getArgumentCondition(functionCall);
                    Bitfield arg_flags = GLES.GlFenceSyncDecorator.getArgumentFlags(functionCall);
                    Pointer returnValue_ = GLES.GlFenceSyncDecorator.getReturnValue(functionCall);
                    GlSyncObjectAsset syncObjectAsset = assetObject;
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = GlFenceSync.validateConstantIsInSet(callbacks, functionCall, arg_condition, Constants.CONSTANT_SET_3);
                    assert (temp_validateConstantIsInSet_return_value_0 != null);
                    property_condition.setValue(functionCall, temp_validateConstantIsInSet_return_value_0);
                    property_flags.setValue(functionCall, arg_flags);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlSyncObjectAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var4, @NonNull SimplePropertyValue<@NonNull Bitfield> var5, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7) throws Exception;
        }
    }

    public static final class GlTextureAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlTextureAsset, GlTextureAsset.Value> {
        public static final @NonNull GlTextureAssetValueProcessor INSTANCE = new GlTextureAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDTEXTURE, GlBindTexture.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXSTORAGEEXT, GlEgliMageTargetTexStorageExt.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURE2DOES, GlEgliMageTargetTexture2Does.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURESTORAGEEXT, GlEgliMageTargetTextureStorageExt.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLGENERATEMIPMAP, GlGenerateMipmap.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXPARAMETERIIV, GlTexParameterIiv.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXPARAMETERIUIV, GlTexParameterIuiv.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXPARAMETERF, GlTexParameterf.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXPARAMETERFV, GlTexParameterfv.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXPARAMETERI, GlTexParameteri.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXPARAMETERIV, GlTexParameteriv.HELPER_INSTANCE);
            }
        };

        private GlTextureAssetValueProcessor() {
        }

        @Override
        public @NonNull GlTextureAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTextureAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTextureAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> baseLevel = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_BASE_LEVEL, 0L);
            SimplePropertyValue<float[]> borderColor = new SimplePropertyValue<float[]>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_BORDER_COLOR, new float[4]);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareFunc = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_COMPARE_FUNC, KapiSpec.GLES.constants.GL_LEQUAL);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_COMPARE_MODE, KapiSpec.GLES.constants.GL_NONE);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthStencilTextureMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_DEPTH_STENCIL_TEXTURE_MODE, KapiSpec.GLES.constants.GL_DEPTH_COMPONENT);
            SimplePropertyValue<@Nullable Object> eglImage = new SimplePropertyValue<Object>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_EGL_IMAGE, null);
            SimplePropertyValue<@NonNull Boolean> everBoundToFramebuffer = new SimplePropertyValue<Boolean>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_EVER_BOUND_TO_FRAMEBUFFER, false);
            SimplePropertyValue<@NonNull Boolean> immutableFormat = new SimplePropertyValue<Boolean>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_IMMUTABLE_FORMAT, false);
            SimplePropertyValue<@NonNull Long> immutableLevels = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_IMMUTABLE_LEVELS, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> magFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_MAG_FILTER, KapiSpec.GLES.constants.GL_LINEAR);
            SimplePropertyValue<@NonNull Long> maxLevel = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_MAX_LEVEL, 1000L);
            SimplePropertyValue<@NonNull Float> maxLod = new SimplePropertyValue<Float>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_MAX_LOD, Float.valueOf(1000.0f));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> minFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_MIN_FILTER, KapiSpec.GLES.constants.GL_NEAREST_MIPMAP_LINEAR);
            SimplePropertyValue<@NonNull Float> minLod = new SimplePropertyValue<Float>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_MIN_LOD, Float.valueOf(-1000.0f));
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleA = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_SWIZZLE_A, KapiSpec.GLES.constants.GL_ALPHA);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleB = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_SWIZZLE_B, KapiSpec.GLES.constants.GL_BLUE);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleG = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_SWIZZLE_G, KapiSpec.GLES.constants.GL_GREEN);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_SWIZZLE_R, KapiSpec.GLES.constants.GL_RED);
            SimplePropertyValue<@Nullable Object> textureTarget = new SimplePropertyValue<Object>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_TEXTURE_TARGET, null);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_WRAP_R, KapiSpec.GLES.constants.GL_REPEAT);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapS = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_WRAP_S, KapiSpec.GLES.constants.GL_REPEAT);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapT = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureAsset.GlTextureAssetProperties.PROPERTY_WRAP_T, KapiSpec.GLES.constants.GL_REPEAT);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, baseLevel, borderColor, compareFunc, compareMode, depthStencilTextureMode, eglImage, everBoundToFramebuffer, immutableFormat, immutableLevels, magFilter, maxLevel, maxLod, minFilter, minLod, swizzleA, swizzleB, swizzleG, swizzleR, textureTarget, wrapR, wrapS, wrapT)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTextureAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)baseLevel, (IAssetPropertyValue<float[]>)borderColor, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareFunc, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)depthStencilTextureMode, (IAssetPropertyValue<Pointer>)eglImage, (IAssetPropertyValue<Boolean>)everBoundToFramebuffer, (IAssetPropertyValue<Boolean>)immutableFormat, (IAssetPropertyValue<Long>)immutableLevels, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)magFilter, (IAssetPropertyValue<Long>)maxLevel, (IAssetPropertyValue<Float>)maxLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)minFilter, (IAssetPropertyValue<Float>)minLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleA, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleB, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleG, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)textureTarget, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapS, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapT);
        }

        @Override
        public @NonNull GlTextureAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTextureAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlTextureAsset assetObject = (GlTextureAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTextureAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> baseLevel = new SimplePropertyValue<Long>(fromValue.getBaseLevel());
            SimplePropertyValue<float[]> borderColor = new SimplePropertyValue<float[]>(fromValue.getBorderColor());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareFunc = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getCompareFunc());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getCompareMode());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthStencilTextureMode = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getDepthStencilTextureMode());
            SimplePropertyValue<@Nullable Pointer> eglImage = new SimplePropertyValue<Pointer>(fromValue.getEglImage());
            SimplePropertyValue<@NonNull Boolean> everBoundToFramebuffer = new SimplePropertyValue<Boolean>(fromValue.getEverBoundToFramebuffer());
            SimplePropertyValue<@NonNull Boolean> immutableFormat = new SimplePropertyValue<Boolean>(fromValue.getImmutableFormat());
            SimplePropertyValue<@NonNull Long> immutableLevels = new SimplePropertyValue<Long>(fromValue.getImmutableLevels());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> magFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getMagFilter());
            SimplePropertyValue<@NonNull Long> maxLevel = new SimplePropertyValue<Long>(fromValue.getMaxLevel());
            SimplePropertyValue<@NonNull Float> maxLod = new SimplePropertyValue<Float>(fromValue.getMaxLod());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> minFilter = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getMinFilter());
            SimplePropertyValue<@NonNull Float> minLod = new SimplePropertyValue<Float>(fromValue.getMinLod());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleA = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getSwizzleA());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleB = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getSwizzleB());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleG = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getSwizzleG());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getSwizzleR());
            SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> textureTarget = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getTextureTarget());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapR = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getWrapR());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapS = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getWrapS());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapT = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getWrapT());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, baseLevel, borderColor, compareFunc, compareMode, depthStencilTextureMode, eglImage, everBoundToFramebuffer, immutableFormat, immutableLevels, magFilter, maxLevel, maxLod, minFilter, minLod, swizzleA, swizzleB, swizzleG, swizzleR, textureTarget, wrapR, wrapS, wrapT)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTextureAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)baseLevel, (IAssetPropertyValue<float[]>)borderColor, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareFunc, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)depthStencilTextureMode, (IAssetPropertyValue<Pointer>)eglImage, (IAssetPropertyValue<Boolean>)everBoundToFramebuffer, (IAssetPropertyValue<Boolean>)immutableFormat, (IAssetPropertyValue<Long>)immutableLevels, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)magFilter, (IAssetPropertyValue<Long>)maxLevel, (IAssetPropertyValue<Float>)maxLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)minFilter, (IAssetPropertyValue<Float>)minLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleA, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleB, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleG, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)textureTarget, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapS, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapT);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> baseLevel, @NonNull SimplePropertyValue<float[]> borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> magFilter, @NonNull SimplePropertyValue<@NonNull Long> maxLevel, @NonNull SimplePropertyValue<@NonNull Float> maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> minFilter, @NonNull SimplePropertyValue<@NonNull Float> minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> wrapT) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, baseLevel, borderColor, compareFunc, compareMode, depthStencilTextureMode, eglImage, everBoundToFramebuffer, immutableFormat, immutableLevels, magFilter, maxLevel, maxLod, minFilter, minLod, swizzleA, swizzleB, swizzleG, swizzleR, textureTarget, wrapR, wrapS, wrapT);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlTextureAsset.Value processedValue;
                GlTextureAsset.Value unProcessedValue = new GlTextureAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)baseLevel, (IAssetPropertyValue<float[]>)borderColor, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareFunc, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)compareMode, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)depthStencilTextureMode, (IAssetPropertyValue<Pointer>)eglImage, (IAssetPropertyValue<Boolean>)everBoundToFramebuffer, (IAssetPropertyValue<Boolean>)immutableFormat, (IAssetPropertyValue<Long>)immutableLevels, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)magFilter, (IAssetPropertyValue<Long>)maxLevel, (IAssetPropertyValue<Float>)maxLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)minFilter, (IAssetPropertyValue<Float>)minLod, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleA, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleB, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleG, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)swizzleR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)textureTarget, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapR, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapS, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)wrapT);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                baseLevel.setValueFrom(functionCall, processedValue.getBaseLevel());
                borderColor.setValueFrom(functionCall, processedValue.getBorderColor());
                compareFunc.setValueFrom(functionCall, processedValue.getCompareFunc());
                compareMode.setValueFrom(functionCall, processedValue.getCompareMode());
                depthStencilTextureMode.setValueFrom(functionCall, processedValue.getDepthStencilTextureMode());
                eglImage.setValueFrom(functionCall, processedValue.getEglImage());
                everBoundToFramebuffer.setValueFrom(functionCall, processedValue.getEverBoundToFramebuffer());
                immutableFormat.setValueFrom(functionCall, processedValue.getImmutableFormat());
                immutableLevels.setValueFrom(functionCall, processedValue.getImmutableLevels());
                magFilter.setValueFrom(functionCall, processedValue.getMagFilter());
                maxLevel.setValueFrom(functionCall, processedValue.getMaxLevel());
                maxLod.setValueFrom(functionCall, processedValue.getMaxLod());
                minFilter.setValueFrom(functionCall, processedValue.getMinFilter());
                minLod.setValueFrom(functionCall, processedValue.getMinLod());
                swizzleA.setValueFrom(functionCall, processedValue.getSwizzleA());
                swizzleB.setValueFrom(functionCall, processedValue.getSwizzleB());
                swizzleG.setValueFrom(functionCall, processedValue.getSwizzleG());
                swizzleR.setValueFrom(functionCall, processedValue.getSwizzleR());
                textureTarget.setValueFrom(functionCall, processedValue.getTextureTarget());
                wrapR.setValueFrom(functionCall, processedValue.getWrapR());
                wrapS.setValueFrom(functionCall, processedValue.getWrapS());
                wrapT.setValueFrom(functionCall, processedValue.getWrapT());
            }
            return result;
        }

        private static final class GlBindTexture
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindTexture HELPER_INSTANCE = new GlBindTexture();

            private GlBindTexture() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDTEXTURE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindTextureDecorator.getArgumentTarget(functionCall);
                    Long arg_texture = GLES.GlBindTextureDecorator.getArgumentTexture(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    property_textureTarget.setValue(functionCall, arg_target);
                    return true;
                }
                return false;
            }
        }

        private static final class GlEgliMageTargetTexStorageExt
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlEgliMageTargetTexStorageExt HELPER_INSTANCE = new GlEgliMageTargetTexStorageExt();

            private GlEgliMageTargetTexStorageExt() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXSTORAGEEXT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentTarget(functionCall);
                    Pointer arg_image = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentImage(functionCall);
                    Pointer arg_attrib_list = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentAttrib_list(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    property_eglImage.setValue(functionCall, arg_image);
                    return true;
                }
                return false;
            }
        }

        private static final class GlEgliMageTargetTexture2Does
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlEgliMageTargetTexture2Does HELPER_INSTANCE = new GlEgliMageTargetTexture2Does();

            private GlEgliMageTargetTexture2Does() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURE2DOES.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlEGLImageTargetTexture2DOESDecorator.getArgumentTarget(functionCall);
                    Pointer arg_image = GLES.GlEGLImageTargetTexture2DOESDecorator.getArgumentImage(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    property_eglImage.setValue(functionCall, arg_image);
                    return true;
                }
                return false;
            }
        }

        private static final class GlEgliMageTargetTextureStorageExt
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlEgliMageTargetTextureStorageExt HELPER_INSTANCE = new GlEgliMageTargetTextureStorageExt();

            private GlEgliMageTargetTextureStorageExt() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURESTORAGEEXT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_texture = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentTexture(functionCall);
                    Pointer arg_image = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentImage(functionCall);
                    Pointer arg_attrib_list = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentAttrib_list(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    property_eglImage.setValue(functionCall, arg_image);
                    return true;
                }
                return false;
            }
        }

        private static final class GlGenerateMipmap
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlGenerateMipmap HELPER_INSTANCE = new GlGenerateMipmap();

            private GlGenerateMipmap() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLGENERATEMIPMAP.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlGenerateMipmapDecorator.getArgumentTarget(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlGenerateMipmap(callbacks, functionCall, textureAsset, property_baseLevel, property_borderColor, property_compareFunc, property_compareMode, property_depthStencilTextureMode, property_eglImage, property_everBoundToFramebuffer, property_immutableFormat, property_immutableLevels, property_magFilter, property_maxLevel, property_maxLod, property_minFilter, property_minLod, property_swizzleA, property_swizzleB, property_swizzleG, property_swizzleR, property_textureTarget, property_wrapR, property_wrapS, property_wrapT, arg_target);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexParameterIiv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexParameterIiv HELPER_INSTANCE = new GlTexParameterIiv();

            private GlTexParameterIiv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXPARAMETERIIV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterIivDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterIivDecorator.getArgumentPname(functionCall);
                    LongsArgAttachment arg_params = GLES.GlTexParameterIivDecorator.getArgumentParams(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameterIiv(callbacks, functionCall, textureAsset, property_baseLevel, property_borderColor, property_compareFunc, property_compareMode, property_depthStencilTextureMode, property_eglImage, property_everBoundToFramebuffer, property_immutableFormat, property_immutableLevels, property_magFilter, property_maxLevel, property_maxLod, property_minFilter, property_minLod, property_swizzleA, property_swizzleB, property_swizzleG, property_swizzleR, property_textureTarget, property_wrapR, property_wrapS, property_wrapT, arg_target, arg_pname, arg_params);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexParameterIuiv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexParameterIuiv HELPER_INSTANCE = new GlTexParameterIuiv();

            private GlTexParameterIuiv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXPARAMETERIUIV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterIuivDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterIuivDecorator.getArgumentPname(functionCall);
                    LongsArgAttachment arg_params = GLES.GlTexParameterIuivDecorator.getArgumentParams(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameterIuiv(callbacks, functionCall, textureAsset, property_baseLevel, property_borderColor, property_compareFunc, property_compareMode, property_depthStencilTextureMode, property_eglImage, property_everBoundToFramebuffer, property_immutableFormat, property_immutableLevels, property_magFilter, property_maxLevel, property_maxLod, property_minFilter, property_minLod, property_swizzleA, property_swizzleB, property_swizzleG, property_swizzleR, property_textureTarget, property_wrapR, property_wrapS, property_wrapT, arg_target, arg_pname, arg_params);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexParameterf
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexParameterf HELPER_INSTANCE = new GlTexParameterf();

            private GlTexParameterf() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXPARAMETERF.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterfDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterfDecorator.getArgumentPname(functionCall);
                    Float arg_param = GLES.GlTexParameterfDecorator.getArgumentParam(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameterf(callbacks, functionCall, textureAsset, property_baseLevel, property_borderColor, property_compareFunc, property_compareMode, property_depthStencilTextureMode, property_eglImage, property_everBoundToFramebuffer, property_immutableFormat, property_immutableLevels, property_magFilter, property_maxLevel, property_maxLod, property_minFilter, property_minLod, property_swizzleA, property_swizzleB, property_swizzleG, property_swizzleR, property_textureTarget, property_wrapR, property_wrapS, property_wrapT, arg_target, arg_pname, arg_param);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexParameterfv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexParameterfv HELPER_INSTANCE = new GlTexParameterfv();

            private GlTexParameterfv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXPARAMETERFV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterfvDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterfvDecorator.getArgumentPname(functionCall);
                    FloatsArgAttachment arg_params = GLES.GlTexParameterfvDecorator.getArgumentParams(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameterfv(callbacks, functionCall, textureAsset, property_baseLevel, property_borderColor, property_compareFunc, property_compareMode, property_depthStencilTextureMode, property_eglImage, property_everBoundToFramebuffer, property_immutableFormat, property_immutableLevels, property_magFilter, property_maxLevel, property_maxLod, property_minFilter, property_minLod, property_swizzleA, property_swizzleB, property_swizzleG, property_swizzleR, property_textureTarget, property_wrapR, property_wrapS, property_wrapT, arg_target, arg_pname, arg_params);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexParameteri
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexParameteri HELPER_INSTANCE = new GlTexParameteri();

            private GlTexParameteri() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXPARAMETERI.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameteriDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameteriDecorator.getArgumentPname(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_param = GLES.GlTexParameteriDecorator.getArgumentParam(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameteri(callbacks, functionCall, textureAsset, property_baseLevel, property_borderColor, property_compareFunc, property_compareMode, property_depthStencilTextureMode, property_eglImage, property_everBoundToFramebuffer, property_immutableFormat, property_immutableLevels, property_magFilter, property_maxLevel, property_maxLod, property_minFilter, property_minLod, property_swizzleA, property_swizzleB, property_swizzleG, property_swizzleR, property_textureTarget, property_wrapR, property_wrapS, property_wrapT, arg_target, arg_pname, arg_param);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexParameteriv
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexParameteriv HELPER_INSTANCE = new GlTexParameteriv();

            private GlTexParameteriv() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_baseLevel, @NonNull SimplePropertyValue<float[]> property_borderColor, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareFunc, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_compareMode, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthStencilTextureMode, @NonNull SimplePropertyValue<@Nullable Pointer> property_eglImage, @NonNull SimplePropertyValue<@NonNull Boolean> property_everBoundToFramebuffer, @NonNull SimplePropertyValue<@NonNull Boolean> property_immutableFormat, @NonNull SimplePropertyValue<@NonNull Long> property_immutableLevels, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_magFilter, @NonNull SimplePropertyValue<@NonNull Long> property_maxLevel, @NonNull SimplePropertyValue<@NonNull Float> property_maxLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_minFilter, @NonNull SimplePropertyValue<@NonNull Float> property_minLod, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleA, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleB, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleG, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_swizzleR, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> property_textureTarget, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapR, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapS, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_wrapT) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXPARAMETERIV.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterivDecorator.getArgumentTarget(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterivDecorator.getArgumentPname(functionCall);
                    LongsArgAttachment arg_params = GLES.GlTexParameterivDecorator.getArgumentParams(functionCall);
                    GlTextureAsset textureAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameteriv(callbacks, functionCall, textureAsset, property_baseLevel, property_borderColor, property_compareFunc, property_compareMode, property_depthStencilTextureMode, property_eglImage, property_everBoundToFramebuffer, property_immutableFormat, property_immutableLevels, property_magFilter, property_maxLevel, property_maxLod, property_minFilter, property_minLod, property_swizzleA, property_swizzleB, property_swizzleG, property_swizzleR, property_textureTarget, property_wrapR, property_wrapS, property_wrapT, arg_target, arg_pname, arg_params);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlTextureAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull SimplePropertyValue<float[]> var5, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var8, @NonNull SimplePropertyValue<@Nullable Pointer> var9, @NonNull SimplePropertyValue<@NonNull Boolean> var10, @NonNull SimplePropertyValue<@NonNull Boolean> var11, @NonNull SimplePropertyValue<@NonNull Long> var12, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var13, @NonNull SimplePropertyValue<@NonNull Long> var14, @NonNull SimplePropertyValue<@NonNull Float> var15, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var16, @NonNull SimplePropertyValue<@NonNull Float> var17, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var18, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var19, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var20, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var21, @NonNull SimplePropertyValue<@Nullable AbstractConstantOrAliasSpecExtended> var22, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var23, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var24, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var25) throws Exception;
        }
    }

    public static final class GlTextureImageAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlTextureImageAsset, GlTextureImageAsset.Value> {
        public static final @NonNull GlTextureImageAssetValueProcessor INSTANCE = new GlTextureImageAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D, GlCompressedTexImage2D.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE3D, GlCompressedTexImage3D.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXIMAGE2D, GlTexImage2D.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXIMAGE3D, GlTexImage3D.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXIMAGE3DOES, GlTexImage3Does.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXSTORAGE2D, GlTexStorage2D.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXSTORAGE2DMULTISAMPLE, GlTexStorage2DmUltisample.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXSTORAGE3D, GlTexStorage3D.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLTEXSTORAGE3DMULTISAMPLE, GlTexStorage3DmUltisample.HELPER_INSTANCE);
            }
        };

        private GlTextureImageAssetValueProcessor() {
        }

        @Override
        public @NonNull GlTextureImageAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTextureImageAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_ALPHA_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> alphaType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_ALPHA_TYPE, KapiSpec.GLES.constants.GL_NONE);
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_BLUE_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> blueType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_BLUE_TYPE, KapiSpec.GLES.constants.GL_NONE);
            SimplePropertyValue<@Nullable Object> bufferDataStoreBinding = new SimplePropertyValue<Object>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_BUFFER_DATA_STORE_BINDING, null);
            SimplePropertyValue<@NonNull Long> bufferOffset = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_BUFFER_OFFSET, 0L);
            SimplePropertyValue<@NonNull Long> bufferSize = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_BUFFER_SIZE, 0L);
            SimplePropertyValue<@NonNull Boolean> compressed = new SimplePropertyValue<Boolean>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_COMPRESSED, false);
            SimplePropertyValue<@NonNull Long> depth = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_DEPTH, 0L);
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_DEPTH_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_DEPTH_TYPE, KapiSpec.GLES.constants.GL_NONE);
            SimplePropertyValue<@NonNull Boolean> fixedSampleLocations = new SimplePropertyValue<Boolean>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_FIXED_SAMPLE_LOCATIONS, true);
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_GREEN_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> greenType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_GREEN_TYPE, KapiSpec.GLES.constants.GL_NONE);
            SimplePropertyValue<@NonNull Long> height = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_HEIGHT, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> internalFormat = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_INTERNAL_FORMAT, KapiSpec.GLES.constants.GL_RGBA);
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_RED_SIZE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> redType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_RED_TYPE, KapiSpec.GLES.constants.GL_NONE);
            SimplePropertyValue<@NonNull Long> samples = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_SAMPLES, 0L);
            SimplePropertyValue<@NonNull Long> sharedSize = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_SHARED_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_STENCIL_SIZE, 0L);
            SimplePropertyValue<@NonNull Long> width = new SimplePropertyValue<Long>(assetObject, AbstractGlTextureImageAsset.GlTextureImageAssetProperties.PROPERTY_WIDTH, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(bufferDataStoreBinding, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, alphaSize, alphaType, blueSize, blueType, bufferDataStoreBinding, bufferOffset, bufferSize, compressed, depth, depthSize, depthType, fixedSampleLocations, greenSize, greenType, height, internalFormat, redSize, redType, samples, sharedSize, stencilSize, width)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTextureImageAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)alphaType, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)blueType, (IAssetPropertyValue<GlBufferAsset>)bufferDataStoreBinding, (IAssetPropertyValue<Long>)bufferOffset, (IAssetPropertyValue<Long>)bufferSize, (IAssetPropertyValue<Boolean>)compressed, (IAssetPropertyValue<Long>)depth, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)depthType, (IAssetPropertyValue<Boolean>)fixedSampleLocations, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)greenType, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)internalFormat, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)redType, (IAssetPropertyValue<Long>)samples, (IAssetPropertyValue<Long>)sharedSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<Long>)width);
        }

        @Override
        public @NonNull GlTextureImageAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTextureImageAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlTextureImageAsset assetObject = (GlTextureImageAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTextureImageAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Long> alphaSize = new SimplePropertyValue<Long>(fromValue.getAlphaSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> alphaType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getAlphaType());
            SimplePropertyValue<@NonNull Long> blueSize = new SimplePropertyValue<Long>(fromValue.getBlueSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> blueType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getBlueType());
            SimplePropertyValue<@Nullable GlBufferAsset> bufferDataStoreBinding = new SimplePropertyValue<GlBufferAsset>(fromValue.getBufferDataStoreBinding());
            SimplePropertyValue<@NonNull Long> bufferOffset = new SimplePropertyValue<Long>(fromValue.getBufferOffset());
            SimplePropertyValue<@NonNull Long> bufferSize = new SimplePropertyValue<Long>(fromValue.getBufferSize());
            SimplePropertyValue<@NonNull Boolean> compressed = new SimplePropertyValue<Boolean>(fromValue.getCompressed());
            SimplePropertyValue<@NonNull Long> depth = new SimplePropertyValue<Long>(fromValue.getDepth());
            SimplePropertyValue<@NonNull Long> depthSize = new SimplePropertyValue<Long>(fromValue.getDepthSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getDepthType());
            SimplePropertyValue<@NonNull Boolean> fixedSampleLocations = new SimplePropertyValue<Boolean>(fromValue.getFixedSampleLocations());
            SimplePropertyValue<@NonNull Long> greenSize = new SimplePropertyValue<Long>(fromValue.getGreenSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> greenType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getGreenType());
            SimplePropertyValue<@NonNull Long> height = new SimplePropertyValue<Long>(fromValue.getHeight());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> internalFormat = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getInternalFormat());
            SimplePropertyValue<@NonNull Long> redSize = new SimplePropertyValue<Long>(fromValue.getRedSize());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> redType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getRedType());
            SimplePropertyValue<@NonNull Long> samples = new SimplePropertyValue<Long>(fromValue.getSamples());
            SimplePropertyValue<@NonNull Long> sharedSize = new SimplePropertyValue<Long>(fromValue.getSharedSize());
            SimplePropertyValue<@NonNull Long> stencilSize = new SimplePropertyValue<Long>(fromValue.getStencilSize());
            SimplePropertyValue<@NonNull Long> width = new SimplePropertyValue<Long>(fromValue.getWidth());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(bufferDataStoreBinding, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, alphaSize, alphaType, blueSize, blueType, bufferDataStoreBinding, bufferOffset, bufferSize, compressed, depth, depthSize, depthType, fixedSampleLocations, greenSize, greenType, height, internalFormat, redSize, redType, samples, sharedSize, stencilSize, width)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTextureImageAsset.Value(validRange, assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)alphaType, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)blueType, (IAssetPropertyValue<GlBufferAsset>)bufferDataStoreBinding, (IAssetPropertyValue<Long>)bufferOffset, (IAssetPropertyValue<Long>)bufferSize, (IAssetPropertyValue<Boolean>)compressed, (IAssetPropertyValue<Long>)depth, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)depthType, (IAssetPropertyValue<Boolean>)fixedSampleLocations, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)greenType, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)internalFormat, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)redType, (IAssetPropertyValue<Long>)samples, (IAssetPropertyValue<Long>)sharedSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<Long>)width);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> alphaType, @NonNull SimplePropertyValue<@NonNull Long> blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> compressed, @NonNull SimplePropertyValue<@NonNull Long> depth, @NonNull SimplePropertyValue<@NonNull Long> depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> depthType, @NonNull SimplePropertyValue<@NonNull Boolean> fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> greenType, @NonNull SimplePropertyValue<@NonNull Long> height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> internalFormat, @NonNull SimplePropertyValue<@NonNull Long> redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> redType, @NonNull SimplePropertyValue<@NonNull Long> samples, @NonNull SimplePropertyValue<@NonNull Long> sharedSize, @NonNull SimplePropertyValue<@NonNull Long> stencilSize, @NonNull SimplePropertyValue<@NonNull Long> width) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, alphaSize, alphaType, blueSize, blueType, bufferDataStoreBinding, bufferOffset, bufferSize, compressed, depth, depthSize, depthType, fixedSampleLocations, greenSize, greenType, height, internalFormat, redSize, redType, samples, sharedSize, stencilSize, width);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlTextureImageAsset.Value processedValue;
                GlTextureImageAsset.Value unProcessedValue = new GlTextureImageAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Long>)alphaSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)alphaType, (IAssetPropertyValue<Long>)blueSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)blueType, (IAssetPropertyValue<GlBufferAsset>)bufferDataStoreBinding, (IAssetPropertyValue<Long>)bufferOffset, (IAssetPropertyValue<Long>)bufferSize, (IAssetPropertyValue<Boolean>)compressed, (IAssetPropertyValue<Long>)depth, (IAssetPropertyValue<Long>)depthSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)depthType, (IAssetPropertyValue<Boolean>)fixedSampleLocations, (IAssetPropertyValue<Long>)greenSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)greenType, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)internalFormat, (IAssetPropertyValue<Long>)redSize, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)redType, (IAssetPropertyValue<Long>)samples, (IAssetPropertyValue<Long>)sharedSize, (IAssetPropertyValue<Long>)stencilSize, (IAssetPropertyValue<Long>)width);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                alphaSize.setValueFrom(functionCall, processedValue.getAlphaSize());
                alphaType.setValueFrom(functionCall, processedValue.getAlphaType());
                blueSize.setValueFrom(functionCall, processedValue.getBlueSize());
                blueType.setValueFrom(functionCall, processedValue.getBlueType());
                bufferDataStoreBinding.setValueFrom(functionCall, processedValue.getBufferDataStoreBinding());
                bufferOffset.setValueFrom(functionCall, processedValue.getBufferOffset());
                bufferSize.setValueFrom(functionCall, processedValue.getBufferSize());
                compressed.setValueFrom(functionCall, processedValue.getCompressed());
                depth.setValueFrom(functionCall, processedValue.getDepth());
                depthSize.setValueFrom(functionCall, processedValue.getDepthSize());
                depthType.setValueFrom(functionCall, processedValue.getDepthType());
                fixedSampleLocations.setValueFrom(functionCall, processedValue.getFixedSampleLocations());
                greenSize.setValueFrom(functionCall, processedValue.getGreenSize());
                greenType.setValueFrom(functionCall, processedValue.getGreenType());
                height.setValueFrom(functionCall, processedValue.getHeight());
                internalFormat.setValueFrom(functionCall, processedValue.getInternalFormat());
                redSize.setValueFrom(functionCall, processedValue.getRedSize());
                redType.setValueFrom(functionCall, processedValue.getRedType());
                samples.setValueFrom(functionCall, processedValue.getSamples());
                sharedSize.setValueFrom(functionCall, processedValue.getSharedSize());
                stencilSize.setValueFrom(functionCall, processedValue.getStencilSize());
                width.setValueFrom(functionCall, processedValue.getWidth());
            }
            return result;
        }

        private static final class GlCompressedTexImage2D
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlCompressedTexImage2D HELPER_INSTANCE = new GlCompressedTexImage2D();

            private GlCompressedTexImage2D() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlCompressedTexImage2DDecorator.getArgumentTarget(functionCall);
                    Integer arg_level = GLES.GlCompressedTexImage2DDecorator.getArgumentLevel(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlCompressedTexImage2DDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlCompressedTexImage2DDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlCompressedTexImage2DDecorator.getArgumentHeight(functionCall);
                    Integer arg_border = GLES.GlCompressedTexImage2DDecorator.getArgumentBorder(functionCall);
                    Integer arg_imageSize = GLES.GlCompressedTexImage2DDecorator.getArgumentImageSize(functionCall);
                    TextureArgAttachment arg_data = GLES.GlCompressedTexImage2DDecorator.getArgumentData(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlCompressedTexImage2D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlCompressedTexImage2D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlCompressedTexImage2D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlCompressedTexImage2D(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_border, arg_imageSize, arg_data);
                    GlTextureImageAsset textureImageAsset = assetObject;
                    Long temp_valueOf_return_value_3 = arg_width.longValue();
                    property_width.setValue(functionCall, temp_valueOf_return_value_3);
                    Long temp_valueOf_return_value_4 = arg_height.longValue();
                    property_height.setValue(functionCall, temp_valueOf_return_value_4);
                    property_depth.setValue(functionCall, 1L);
                    property_internalFormat.setValue(functionCall, arg_internalformat);
                    return true;
                }
                return false;
            }
        }

        private static final class GlCompressedTexImage3D
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlCompressedTexImage3D HELPER_INSTANCE = new GlCompressedTexImage3D();

            private GlCompressedTexImage3D() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE3D.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlCompressedTexImage3DDecorator.getArgumentTarget(functionCall);
                    Integer arg_level = GLES.GlCompressedTexImage3DDecorator.getArgumentLevel(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlCompressedTexImage3DDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlCompressedTexImage3DDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlCompressedTexImage3DDecorator.getArgumentHeight(functionCall);
                    Integer arg_depth = GLES.GlCompressedTexImage3DDecorator.getArgumentDepth(functionCall);
                    Integer arg_border = GLES.GlCompressedTexImage3DDecorator.getArgumentBorder(functionCall);
                    Integer arg_imageSize = GLES.GlCompressedTexImage3DDecorator.getArgumentImageSize(functionCall);
                    TextureArgAttachment arg_data = GLES.GlCompressedTexImage3DDecorator.getArgumentData(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlCompressedTexImage3D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlCompressedTexImage3D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlCompressedTexImage3D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlCompressedTexImage3D(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_imageSize, arg_data);
                    GlTextureImageAsset textureImageAsset = assetObject;
                    Long temp_valueOf_return_value_3 = arg_width.longValue();
                    property_width.setValue(functionCall, temp_valueOf_return_value_3);
                    Long temp_valueOf_return_value_4 = arg_height.longValue();
                    property_height.setValue(functionCall, temp_valueOf_return_value_4);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D)) {
                        Long temp_valueOf_return_value_5 = arg_depth.longValue();
                        property_depth.setValue(functionCall, temp_valueOf_return_value_5);
                    }
                    if (!arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D)) {
                        property_depth.setValue(functionCall, 1L);
                    }
                    property_depth.setValue(functionCall, 1L);
                    property_internalFormat.setValue(functionCall, arg_internalformat);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexImage2D
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexImage2D HELPER_INSTANCE = new GlTexImage2D();

            private GlTexImage2D() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXIMAGE2D.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage2DDecorator.getArgumentTarget(functionCall);
                    Integer arg_level = GLES.GlTexImage2DDecorator.getArgumentLevel(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage2DDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlTexImage2DDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlTexImage2DDecorator.getArgumentHeight(functionCall);
                    Integer arg_border = GLES.GlTexImage2DDecorator.getArgumentBorder(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage2DDecorator.getArgumentFormat(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage2DDecorator.getArgumentType(functionCall);
                    TextureArgAttachment arg_pixels = GLES.GlTexImage2DDecorator.getArgumentPixels(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexImage2D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexImage2D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlTexImage2D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage2D(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_border, arg_format, arg_type, arg_pixels);
                    GlTextureImageAsset textureImageAsset = assetObject;
                    Long temp_valueOf_return_value_3 = arg_width.longValue();
                    property_width.setValue(functionCall, temp_valueOf_return_value_3);
                    Long temp_valueOf_return_value_4 = arg_height.longValue();
                    property_height.setValue(functionCall, temp_valueOf_return_value_4);
                    property_depth.setValue(functionCall, 1L);
                    property_internalFormat.setValue(functionCall, arg_internalformat);
                    property_compressed.setValue(functionCall, false);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexImage3D
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexImage3D HELPER_INSTANCE = new GlTexImage3D();

            private GlTexImage3D() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXIMAGE3D.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage3DDecorator.getArgumentTarget(functionCall);
                    Integer arg_level = GLES.GlTexImage3DDecorator.getArgumentLevel(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage3DDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlTexImage3DDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlTexImage3DDecorator.getArgumentHeight(functionCall);
                    Integer arg_depth = GLES.GlTexImage3DDecorator.getArgumentDepth(functionCall);
                    Integer arg_border = GLES.GlTexImage3DDecorator.getArgumentBorder(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage3DDecorator.getArgumentFormat(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage3DDecorator.getArgumentType(functionCall);
                    TextureArgAttachment arg_pixels = GLES.GlTexImage3DDecorator.getArgumentPixels(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexImage3D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexImage3D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlTexImage3D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage3D(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_format, arg_type, arg_pixels);
                    GlTextureImageAsset textureImageAsset = assetObject;
                    Long temp_valueOf_return_value_3 = arg_width.longValue();
                    property_width.setValue(functionCall, temp_valueOf_return_value_3);
                    Long temp_valueOf_return_value_4 = arg_height.longValue();
                    property_height.setValue(functionCall, temp_valueOf_return_value_4);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D)) {
                        Long temp_valueOf_return_value_5 = arg_depth.longValue();
                        property_depth.setValue(functionCall, temp_valueOf_return_value_5);
                    }
                    if (!arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D)) {
                        property_depth.setValue(functionCall, 1L);
                    }
                    property_internalFormat.setValue(functionCall, arg_internalformat);
                    property_compressed.setValue(functionCall, false);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexImage3Does
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexImage3Does HELPER_INSTANCE = new GlTexImage3Does();

            private GlTexImage3Does() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXIMAGE3DOES.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage3DOESDecorator.getArgumentTarget(functionCall);
                    Integer arg_level = GLES.GlTexImage3DOESDecorator.getArgumentLevel(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage3DOESDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlTexImage3DOESDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlTexImage3DOESDecorator.getArgumentHeight(functionCall);
                    Integer arg_depth = GLES.GlTexImage3DOESDecorator.getArgumentDepth(functionCall);
                    Integer arg_border = GLES.GlTexImage3DOESDecorator.getArgumentBorder(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage3DOESDecorator.getArgumentFormat(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage3DOESDecorator.getArgumentType(functionCall);
                    TextureArgAttachment arg_pixels = GLES.GlTexImage3DOESDecorator.getArgumentPixels(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexImage3Does.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexImage3Does.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlTexImage3Does.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage3Does(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_format, arg_type, arg_pixels);
                    GlTextureImageAsset textureImageAsset = assetObject;
                    Long temp_valueOf_return_value_3 = arg_width.longValue();
                    property_width.setValue(functionCall, temp_valueOf_return_value_3);
                    Long temp_valueOf_return_value_4 = arg_height.longValue();
                    property_height.setValue(functionCall, temp_valueOf_return_value_4);
                    Long temp_valueOf_return_value_5 = arg_depth.longValue();
                    property_depth.setValue(functionCall, temp_valueOf_return_value_5);
                    property_internalFormat.setValue(functionCall, arg_internalformat);
                    property_compressed.setValue(functionCall, false);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexStorage2D
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexStorage2D HELPER_INSTANCE = new GlTexStorage2D();

            private GlTexStorage2D() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXSTORAGE2D.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage2DDecorator.getArgumentTarget(functionCall);
                    Integer arg_levels = GLES.GlTexStorage2DDecorator.getArgumentLevels(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage2DDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlTexStorage2DDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlTexStorage2DDecorator.getArgumentHeight(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexStorage2D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexStorage2D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlTexStorage2D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTexStorage2D.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage2D(callbacks, functionCall, textureAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height), textureSurfaceAsset_asset_value -> {
                        GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                        GlTextureImageAsset textureImageAsset = assetObject;
                        ProvidedAssetProcessors.processProvidedActionForGlTextureImageAssetOnGlTexStorage2D(callbacks, functionCall, textureImageAsset, property_alphaSize, property_alphaType, property_blueSize, property_blueType, property_bufferDataStoreBinding, property_bufferOffset, property_bufferSize, property_compressed, property_depth, property_depthSize, property_depthType, property_fixedSampleLocations, property_greenSize, property_greenType, property_height, property_internalFormat, property_redSize, property_redType, property_samples, property_sharedSize, property_stencilSize, property_width, arg_target, arg_levels, arg_internalformat, arg_width, arg_height);
                    });
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexStorage2DmUltisample
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexStorage2DmUltisample HELPER_INSTANCE = new GlTexStorage2DmUltisample();

            private GlTexStorage2DmUltisample() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXSTORAGE2DMULTISAMPLE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage2DMultisampleDecorator.getArgumentTarget(functionCall);
                    Integer arg_samples = GLES.GlTexStorage2DMultisampleDecorator.getArgumentSamples(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage2DMultisampleDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlTexStorage2DMultisampleDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlTexStorage2DMultisampleDecorator.getArgumentHeight(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations = GLES.GlTexStorage2DMultisampleDecorator.getArgumentFixedsamplelocations(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexStorage2DmUltisample.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexStorage2DmUltisample.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlTexStorage2DmUltisample.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage2DmUltisample(callbacks, functionCall, textureAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_fixedsamplelocations);
                    GlTextureImageAsset textureImageAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForGlTextureImageAssetOnGlTexStorage2DmUltisample(callbacks, functionCall, textureImageAsset, property_alphaSize, property_alphaType, property_blueSize, property_blueType, property_bufferDataStoreBinding, property_bufferOffset, property_bufferSize, property_compressed, property_depth, property_depthSize, property_depthType, property_fixedSampleLocations, property_greenSize, property_greenType, property_height, property_internalFormat, property_redSize, property_redType, property_samples, property_sharedSize, property_stencilSize, property_width, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_fixedsamplelocations);
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexStorage3D
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexStorage3D HELPER_INSTANCE = new GlTexStorage3D();

            private GlTexStorage3D() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXSTORAGE3D.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage3DDecorator.getArgumentTarget(functionCall);
                    Integer arg_levels = GLES.GlTexStorage3DDecorator.getArgumentLevels(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage3DDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlTexStorage3DDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlTexStorage3DDecorator.getArgumentHeight(functionCall);
                    Integer arg_depth = GLES.GlTexStorage3DDecorator.getArgumentDepth(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexStorage3D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexStorage3D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlTexStorage3D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTexStorage3D.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage3D(callbacks, functionCall, textureAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height, arg_depth), textureSurfaceAsset_asset_value -> {
                        GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                        GlTextureImageAsset textureImageAsset = assetObject;
                        ProvidedAssetProcessors.processProvidedActionForGlTextureImageAssetOnGlTexStorage3D(callbacks, functionCall, textureImageAsset, property_alphaSize, property_alphaType, property_blueSize, property_blueType, property_bufferDataStoreBinding, property_bufferOffset, property_bufferSize, property_compressed, property_depth, property_depthSize, property_depthType, property_fixedSampleLocations, property_greenSize, property_greenType, property_height, property_internalFormat, property_redSize, property_redType, property_samples, property_sharedSize, property_stencilSize, property_width, arg_target, arg_levels, arg_internalformat, arg_width, arg_height, arg_depth);
                    });
                    return true;
                }
                return false;
            }
        }

        private static final class GlTexStorage3DmUltisample
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlTexStorage3DmUltisample HELPER_INSTANCE = new GlTexStorage3DmUltisample();

            private GlTexStorage3DmUltisample() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Long> property_alphaSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_alphaType, @NonNull SimplePropertyValue<@NonNull Long> property_blueSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_blueType, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_bufferDataStoreBinding, @NonNull SimplePropertyValue<@NonNull Long> property_bufferOffset, @NonNull SimplePropertyValue<@NonNull Long> property_bufferSize, @NonNull SimplePropertyValue<@NonNull Boolean> property_compressed, @NonNull SimplePropertyValue<@NonNull Long> property_depth, @NonNull SimplePropertyValue<@NonNull Long> property_depthSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_depthType, @NonNull SimplePropertyValue<@NonNull Boolean> property_fixedSampleLocations, @NonNull SimplePropertyValue<@NonNull Long> property_greenSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_greenType, @NonNull SimplePropertyValue<@NonNull Long> property_height, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_internalFormat, @NonNull SimplePropertyValue<@NonNull Long> property_redSize, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_redType, @NonNull SimplePropertyValue<@NonNull Long> property_samples, @NonNull SimplePropertyValue<@NonNull Long> property_sharedSize, @NonNull SimplePropertyValue<@NonNull Long> property_stencilSize, @NonNull SimplePropertyValue<@NonNull Long> property_width) throws Exception {
                assert (KapiSpec.GLES.functions.GLTEXSTORAGE3DMULTISAMPLE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage3DMultisampleDecorator.getArgumentTarget(functionCall);
                    Integer arg_samples = GLES.GlTexStorage3DMultisampleDecorator.getArgumentSamples(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage3DMultisampleDecorator.getArgumentInternalformat(functionCall);
                    Integer arg_width = GLES.GlTexStorage3DMultisampleDecorator.getArgumentWidth(functionCall);
                    Integer arg_height = GLES.GlTexStorage3DMultisampleDecorator.getArgumentHeight(functionCall);
                    Integer arg_depth = GLES.GlTexStorage3DMultisampleDecorator.getArgumentDepth(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations = GLES.GlTexStorage3DMultisampleDecorator.getArgumentFixedsamplelocations(functionCall);
                    IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexStorage3DmUltisample.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                    GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexStorage3DmUltisample.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                    GlTextureAsset textureAsset = GlTexStorage3DmUltisample.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlTexStorage3DmUltisample.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage3DmUltisample(callbacks, functionCall, textureAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_depth, arg_fixedsamplelocations), textureSurfaceAsset_asset_value -> {
                        GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                        GlTextureImageAsset textureImageAsset = assetObject;
                        ProvidedAssetProcessors.processProvidedActionForGlTextureImageAssetOnGlTexStorage3DmUltisample(callbacks, functionCall, textureImageAsset, property_alphaSize, property_alphaType, property_blueSize, property_blueType, property_bufferDataStoreBinding, property_bufferOffset, property_bufferSize, property_compressed, property_depth, property_depthSize, property_depthType, property_fixedSampleLocations, property_greenSize, property_greenType, property_height, property_internalFormat, property_redSize, property_redType, property_samples, property_sharedSize, property_stencilSize, property_width, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_depth, arg_fixedsamplelocations);
                    });
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlTextureImageAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Long> var4, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var5, @NonNull SimplePropertyValue<@NonNull Long> var6, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> var8, @NonNull SimplePropertyValue<@NonNull Long> var9, @NonNull SimplePropertyValue<@NonNull Long> var10, @NonNull SimplePropertyValue<@NonNull Boolean> var11, @NonNull SimplePropertyValue<@NonNull Long> var12, @NonNull SimplePropertyValue<@NonNull Long> var13, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var14, @NonNull SimplePropertyValue<@NonNull Boolean> var15, @NonNull SimplePropertyValue<@NonNull Long> var16, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var17, @NonNull SimplePropertyValue<@NonNull Long> var18, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var19, @NonNull SimplePropertyValue<@NonNull Long> var20, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var21, @NonNull SimplePropertyValue<@NonNull Long> var22, @NonNull SimplePropertyValue<@NonNull Long> var23, @NonNull SimplePropertyValue<@NonNull Long> var24, @NonNull SimplePropertyValue<@NonNull Long> var25) throws Exception;
        }
    }

    public static final class GlTextureSurfaceAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlTextureSurfaceAsset, GlTextureSurfaceAsset.Value> {
        public static final @NonNull GlTextureSurfaceAssetValueProcessor INSTANCE = new GlTextureSurfaceAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private GlTextureSurfaceAssetValueProcessor() {
        }

        @Override
        public @NonNull GlTextureSurfaceAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTextureSurfaceAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTextureSurfaceAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTextureSurfaceAsset.Value(validRange, assetObject);
        }

        @Override
        public @NonNull GlTextureSurfaceAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTextureSurfaceAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlTextureSurfaceAsset assetObject = (GlTextureSurfaceAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTextureSurfaceAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTextureSurfaceAsset.Value(validRange, assetObject);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureSurfaceAsset assetObject, @NonNull FunctionCall functionCall) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlTextureSurfaceAsset.Value processedValue;
                GlTextureSurfaceAsset.Value unProcessedValue = new GlTextureSurfaceAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlTextureSurfaceAsset var2, @NonNull FunctionCall var3) throws Exception;
        }
    }

    public static final class GlTextureUnitAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlTextureUnitAsset, GlTextureUnitAsset.Value> {
        public static final @NonNull GlTextureUnitAssetValueProcessor INSTANCE = new GlTextureUnitAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDSAMPLER, GlBindSampler.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLBINDTEXTURE, GlBindTexture.HELPER_INSTANCE);
            }
        };

        private GlTextureUnitAssetValueProcessor() {
        }

        @Override
        public @NonNull GlTextureUnitAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTextureUnitAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTextureUnitAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> sampler = new SimplePropertyValue<Object>(assetObject, AbstractGlTextureUnitAsset.GlTextureUnitAssetProperties.PROPERTY_SAMPLER, null);
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlTextureAsset> textureTargets = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlTextureAsset>((IAssetItem<?, ?>)assetObject, AbstractGlTextureUnitAsset.GlTextureUnitAssetProperties.PROPERTY_TEXTURE_TARGETS);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(sampler, functionCall);
                this.ensureAssetReferencesValidAt(textureTargets, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, sampler, textureTargets)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTextureUnitAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlSamplerAsset>)sampler, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlTextureAsset>>)textureTargets);
        }

        @Override
        public @NonNull GlTextureUnitAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTextureUnitAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlTextureUnitAsset assetObject = (GlTextureUnitAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTextureUnitAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable GlSamplerAsset> sampler = new SimplePropertyValue<GlSamplerAsset>(fromValue.getSampler());
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlTextureAsset> textureTargets = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, GlTextureAsset>(fromValue.getTextureTargets());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(sampler, functionCall);
                    this.ensureAssetReferencesValidAt(textureTargets, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, sampler, textureTargets)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTextureUnitAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlSamplerAsset>)sampler, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlTextureAsset>>)textureTargets);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureUnitAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlSamplerAsset> sampler, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlTextureAsset> textureTargets) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, sampler, textureTargets);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlTextureUnitAsset.Value processedValue;
                GlTextureUnitAsset.Value unProcessedValue = new GlTextureUnitAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<GlSamplerAsset>)sampler, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, GlTextureAsset>>)textureTargets);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                sampler.setValueFrom(functionCall, processedValue.getSampler());
                textureTargets.setValueFrom(functionCall, processedValue.getTextureTargets());
            }
            return result;
        }

        private static final class GlBindSampler
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindSampler HELPER_INSTANCE = new GlBindSampler();

            private GlBindSampler() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureUnitAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlSamplerAsset> property_sampler, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlTextureAsset> property_textureTargets) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDSAMPLER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_unit = GLES.GlBindSamplerDecorator.getArgumentUnit(functionCall);
                    Long arg_sampler = GLES.GlBindSamplerDecorator.getArgumentSampler(functionCall);
                    GlTextureUnitAsset unitAsset = assetObject;
                    AssetItemID samplerAsset_id_value = AssetItemID.valueOf(arg_sampler);
                    GlSamplerAsset samplerAsset = GlBindSampler.warnIfMissingAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlBindSampler.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value, AssetItemID.valueOf(0));
                    property_sampler.setValue(functionCall, samplerAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class GlBindTexture
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindTexture HELPER_INSTANCE = new GlBindTexture();

            private GlBindTexture() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTextureUnitAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlSamplerAsset> property_sampler, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlTextureAsset> property_textureTargets) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDTEXTURE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindTextureDecorator.getArgumentTarget(functionCall);
                    Long arg_texture = GLES.GlBindTextureDecorator.getArgumentTexture(functionCall);
                    GlTextureUnitAsset textureUnitAsset = assetObject;
                    AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                    GlTextureAsset textureAsset = GlBindTexture.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlBindTexture.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = GlBindTexture.validateConstantIsInSet(callbacks, functionCall, arg_target, Constants.CONSTANT_SET_4);
                    assert (temp_validateConstantIsInSet_return_value_0 != null);
                    property_textureTargets.setValue(functionCall, temp_validateConstantIsInSet_return_value_0, textureAsset);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlTextureUnitAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable GlSamplerAsset> var4, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable GlTextureAsset> var5) throws Exception;
        }
    }

    public static final class GlTransformFeedbackAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlTransformFeedbackAsset, GlTransformFeedbackAsset.Value> {
        public static final @NonNull GlTransformFeedbackAssetValueProcessor INSTANCE = new GlTransformFeedbackAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBEGINTRANSFORMFEEDBACK, GlBeginTransformFeedback.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLENDTRANSFORMFEEDBACK, GlEndTransformFeedback.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLPAUSETRANSFORMFEEDBACK, GlPauseTransformFeedback.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLRESUMETRANSFORMFEEDBACK, GlResumeTransformFeedback.HELPER_INSTANCE);
            }
        };

        private GlTransformFeedbackAssetValueProcessor() {
        }

        @Override
        public @NonNull GlTransformFeedbackAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTransformFeedbackAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTransformFeedbackAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Boolean> active = new SimplePropertyValue<Boolean>(assetObject, AbstractGlTransformFeedbackAsset.GlTransformFeedbackAssetProperties.PROPERTY_ACTIVE, false);
            SimplePropertyValue<@NonNull Boolean> paused = new SimplePropertyValue<Boolean>(assetObject, AbstractGlTransformFeedbackAsset.GlTransformFeedbackAssetProperties.PROPERTY_PAUSED, false);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, active, paused)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTransformFeedbackAsset.Value(validRange, assetObject, (IAssetPropertyValue<Boolean>)active, (IAssetPropertyValue<Boolean>)paused);
        }

        @Override
        public @NonNull GlTransformFeedbackAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTransformFeedbackAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlTransformFeedbackAsset assetObject = (GlTransformFeedbackAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTransformFeedbackAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Boolean> active = new SimplePropertyValue<Boolean>(fromValue.getActive());
            SimplePropertyValue<@NonNull Boolean> paused = new SimplePropertyValue<Boolean>(fromValue.getPaused());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, active, paused)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTransformFeedbackAsset.Value(validRange, assetObject, (IAssetPropertyValue<Boolean>)active, (IAssetPropertyValue<Boolean>)paused);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTransformFeedbackAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> active, @NonNull SimplePropertyValue<@NonNull Boolean> paused) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, active, paused);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlTransformFeedbackAsset.Value processedValue;
                GlTransformFeedbackAsset.Value unProcessedValue = new GlTransformFeedbackAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Boolean>)active, (IAssetPropertyValue<Boolean>)paused);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                active.setValueFrom(functionCall, processedValue.getActive());
                paused.setValueFrom(functionCall, processedValue.getPaused());
            }
            return result;
        }

        private static final class GlBeginTransformFeedback
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBeginTransformFeedback HELPER_INSTANCE = new GlBeginTransformFeedback();

            private GlBeginTransformFeedback() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTransformFeedbackAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> property_active, @NonNull SimplePropertyValue<@NonNull Boolean> property_paused) throws Exception {
                assert (KapiSpec.GLES.functions.GLBEGINTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractConstantOrAliasSpecExtended arg_primitiveMode = GLES.GlBeginTransformFeedbackDecorator.getArgumentPrimitiveMode(functionCall);
                    GlTransformFeedbackAsset targetAsset = assetObject;
                    property_active.setValue(functionCall, KapiSpec.GLES.constants.GL_TRUE.equals(KapiSpec.GLES.constants.GL_TRUE));
                    return true;
                }
                return false;
            }
        }

        private static final class GlEndTransformFeedback
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlEndTransformFeedback HELPER_INSTANCE = new GlEndTransformFeedback();

            private GlEndTransformFeedback() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTransformFeedbackAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> property_active, @NonNull SimplePropertyValue<@NonNull Boolean> property_paused) throws Exception {
                assert (KapiSpec.GLES.functions.GLENDTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    GlTransformFeedbackAsset targetAsset = assetObject;
                    property_active.setValue(functionCall, KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
                    property_paused.setValue(functionCall, KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
                    return true;
                }
                return false;
            }
        }

        private static final class GlPauseTransformFeedback
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlPauseTransformFeedback HELPER_INSTANCE = new GlPauseTransformFeedback();

            private GlPauseTransformFeedback() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTransformFeedbackAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> property_active, @NonNull SimplePropertyValue<@NonNull Boolean> property_paused) throws Exception {
                assert (KapiSpec.GLES.functions.GLPAUSETRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    GlTransformFeedbackAsset targetAsset = assetObject;
                    property_paused.setValue(functionCall, KapiSpec.GLES.constants.GL_TRUE.equals(KapiSpec.GLES.constants.GL_TRUE));
                    return true;
                }
                return false;
            }
        }

        private static final class GlResumeTransformFeedback
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlResumeTransformFeedback HELPER_INSTANCE = new GlResumeTransformFeedback();

            private GlResumeTransformFeedback() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTransformFeedbackAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> property_active, @NonNull SimplePropertyValue<@NonNull Boolean> property_paused) throws Exception {
                assert (KapiSpec.GLES.functions.GLRESUMETRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    GlTransformFeedbackAsset targetAsset = assetObject;
                    property_paused.setValue(functionCall, KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlTransformFeedbackAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Boolean> var4, @NonNull SimplePropertyValue<@NonNull Boolean> var5) throws Exception;
        }
    }

    public static final class GlTransformFeedbackBufferBindingPointAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlTransformFeedbackBufferBindingPointAsset, GlTransformFeedbackBufferBindingPointAsset.Value> {
        public static final @NonNull GlTransformFeedbackBufferBindingPointAssetValueProcessor INSTANCE = new GlTransformFeedbackBufferBindingPointAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERBASE, GlBindBufferBase.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERRANGE, GlBindBufferRange.HELPER_INSTANCE);
            }
        };

        private GlTransformFeedbackBufferBindingPointAssetValueProcessor() {
        }

        @Override
        public @NonNull GlTransformFeedbackBufferBindingPointAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTransformFeedbackBufferBindingPointAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTransformFeedbackBufferBindingPointAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> buffer = new SimplePropertyValue<Object>(assetObject, AbstractGlTransformFeedbackBufferBindingPointAsset.GlTransformFeedbackBufferBindingPointAssetProperties.PROPERTY_BUFFER, null);
            SimplePropertyValue<@NonNull Long> length = new SimplePropertyValue<Long>(assetObject, AbstractGlTransformFeedbackBufferBindingPointAsset.GlTransformFeedbackBufferBindingPointAssetProperties.PROPERTY_LENGTH, 0L);
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(assetObject, AbstractGlTransformFeedbackBufferBindingPointAsset.GlTransformFeedbackBufferBindingPointAssetProperties.PROPERTY_OFFSET, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(buffer, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, buffer, length, offset)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTransformFeedbackBufferBindingPointAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
        }

        @Override
        public @NonNull GlTransformFeedbackBufferBindingPointAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlTransformFeedbackBufferBindingPointAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlTransformFeedbackBufferBindingPointAsset assetObject = (GlTransformFeedbackBufferBindingPointAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlTransformFeedbackBufferBindingPointAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable GlBufferAsset> buffer = new SimplePropertyValue<GlBufferAsset>(fromValue.getBuffer());
            SimplePropertyValue<@NonNull Long> length = new SimplePropertyValue<Long>(fromValue.getLength());
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(fromValue.getOffset());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(buffer, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, buffer, length, offset)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlTransformFeedbackBufferBindingPointAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTransformFeedbackBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> buffer, @NonNull SimplePropertyValue<@NonNull Long> length, @NonNull SimplePropertyValue<@NonNull Long> offset) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, buffer, length, offset);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlTransformFeedbackBufferBindingPointAsset.Value processedValue;
                GlTransformFeedbackBufferBindingPointAsset.Value unProcessedValue = new GlTransformFeedbackBufferBindingPointAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                buffer.setValueFrom(functionCall, processedValue.getBuffer());
                length.setValueFrom(functionCall, processedValue.getLength());
                offset.setValueFrom(functionCall, processedValue.getOffset());
            }
            return result;
        }

        private static final class GlBindBufferBase
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferBase HELPER_INSTANCE = new GlBindBufferBase();

            private GlBindBufferBase() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTransformFeedbackBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_length, @NonNull SimplePropertyValue<@NonNull Long> property_offset) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERBASE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractAssetItem abstractAssetItem;
                    AssetItemID bindingAsset_id_value;
                    GlBufferAsset bufferAsset;
                    AssetItemID bufferAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferBaseDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        GlTransformFeedbackBufferBindingPointAsset bindingAsset = assetObject;
                        property_buffer.setValue(functionCall, bufferAsset);
                        property_offset.setValue(functionCall, 0L);
                        GlBufferAsset.Value temp_safeWaitForValue_return_value_7 = (GlBufferAsset.Value)GlBindBufferBase.safeWaitForValue(callbacks, bufferAsset, functionCall.getID());
                        Long temp_valueOf_return_value_8 = temp_safeWaitForValue_return_value_7 != null ? temp_safeWaitForValue_return_value_7.getSize().getValue() : 0L;
                        property_length.setValue(functionCall, temp_valueOf_return_value_8);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class GlBindBufferRange
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferRange HELPER_INSTANCE = new GlBindBufferRange();

            private GlBindBufferRange() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlTransformFeedbackBufferBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_length, @NonNull SimplePropertyValue<@NonNull Long> property_offset) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERRANGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractAssetItem abstractAssetItem;
                    AssetItemID bindingAsset_id_value;
                    GlBufferAsset bufferAsset;
                    AssetItemID bufferAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferRangeDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
                    Long arg_offset = GLES.GlBindBufferRangeDecorator.getArgumentOffset(functionCall);
                    Long arg_size = GLES.GlBindBufferRangeDecorator.getArgumentSize(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        GlTransformFeedbackBufferBindingPointAsset bindingAsset = assetObject;
                        property_buffer.setValue(functionCall, bufferAsset);
                        property_offset.setValue(functionCall, arg_offset);
                        property_length.setValue(functionCall, arg_size);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlTransformFeedbackBufferBindingPointAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull Long> var6) throws Exception;
        }
    }

    public static final class GlUniformBindingPointAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlUniformBindingPointAsset, GlUniformBindingPointAsset.Value> {
        public static final @NonNull GlUniformBindingPointAssetValueProcessor INSTANCE = new GlUniformBindingPointAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERBASE, GlBindBufferBase.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLBINDBUFFERRANGE, GlBindBufferRange.HELPER_INSTANCE);
            }
        };

        private GlUniformBindingPointAssetValueProcessor() {
        }

        @Override
        public @NonNull GlUniformBindingPointAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlUniformBindingPointAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlUniformBindingPointAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> buffer = new SimplePropertyValue<Object>(assetObject, AbstractGlUniformBindingPointAsset.GlUniformBindingPointAssetProperties.PROPERTY_BUFFER, null);
            SimplePropertyValue<@NonNull Long> length = new SimplePropertyValue<Long>(assetObject, AbstractGlUniformBindingPointAsset.GlUniformBindingPointAssetProperties.PROPERTY_LENGTH, 0L);
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(assetObject, AbstractGlUniformBindingPointAsset.GlUniformBindingPointAssetProperties.PROPERTY_OFFSET, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(buffer, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, buffer, length, offset)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlUniformBindingPointAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
        }

        @Override
        public @NonNull GlUniformBindingPointAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlUniformBindingPointAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlUniformBindingPointAsset assetObject = (GlUniformBindingPointAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlUniformBindingPointAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable GlBufferAsset> buffer = new SimplePropertyValue<GlBufferAsset>(fromValue.getBuffer());
            SimplePropertyValue<@NonNull Long> length = new SimplePropertyValue<Long>(fromValue.getLength());
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(fromValue.getOffset());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(buffer, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, buffer, length, offset)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlUniformBindingPointAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlUniformBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> buffer, @NonNull SimplePropertyValue<@NonNull Long> length, @NonNull SimplePropertyValue<@NonNull Long> offset) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, buffer, length, offset);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlUniformBindingPointAsset.Value processedValue;
                GlUniformBindingPointAsset.Value unProcessedValue = new GlUniformBindingPointAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)length, (IAssetPropertyValue<Long>)offset);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                buffer.setValueFrom(functionCall, processedValue.getBuffer());
                length.setValueFrom(functionCall, processedValue.getLength());
                offset.setValueFrom(functionCall, processedValue.getOffset());
            }
            return result;
        }

        private static final class GlBindBufferBase
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferBase HELPER_INSTANCE = new GlBindBufferBase();

            private GlBindBufferBase() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlUniformBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_length, @NonNull SimplePropertyValue<@NonNull Long> property_offset) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERBASE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractAssetItem abstractAssetItem;
                    AssetItemID bindingAsset_id_value;
                    GlBufferAsset bufferAsset;
                    AssetItemID bufferAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferBaseDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        GlUniformBindingPointAsset bindingAsset = assetObject;
                        property_buffer.setValue(functionCall, bufferAsset);
                        property_offset.setValue(functionCall, 0L);
                        GlBufferAsset.Value temp_safeWaitForValue_return_value_10 = (GlBufferAsset.Value)GlBindBufferBase.safeWaitForValue(callbacks, bufferAsset, functionCall.getID());
                        Long temp_valueOf_return_value_11 = temp_safeWaitForValue_return_value_10 != null ? temp_safeWaitForValue_return_value_10.getSize().getValue() : 0L;
                        property_length.setValue(functionCall, temp_valueOf_return_value_11);
                        ProvidedAssetProcessors.processProvidedActionForGlUniformBindingPointAssetOnGlBindBufferBase(callbacks, functionCall, bindingAsset, property_buffer, property_length, property_offset, arg_target, arg_index, arg_buffer, bufferAsset);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class GlBindBufferRange
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBufferRange HELPER_INSTANCE = new GlBindBufferRange();

            private GlBindBufferRange() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlUniformBindingPointAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_length, @NonNull SimplePropertyValue<@NonNull Long> property_offset) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFERRANGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AbstractAssetItem abstractAssetItem;
                    AssetItemID bindingAsset_id_value;
                    GlBufferAsset bufferAsset;
                    AssetItemID bufferAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
                    Long arg_index = GLES.GlBindBufferRangeDecorator.getArgumentIndex(functionCall);
                    Long arg_buffer = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
                    Long arg_offset = GLES.GlBindBufferRangeDecorator.getArgumentOffset(functionCall);
                    Long arg_size = GLES.GlBindBufferRangeDecorator.getArgumentSize(functionCall);
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                        abstractAssetItem = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                        bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                        GlUniformBindingPointAsset bindingAsset = assetObject;
                        property_buffer.setValue(functionCall, bufferAsset);
                        property_offset.setValue(functionCall, arg_offset);
                        property_length.setValue(functionCall, arg_size);
                        ProvidedAssetProcessors.processProvidedActionForGlUniformBindingPointAssetOnGlBindBufferRange(callbacks, functionCall, bindingAsset, property_buffer, property_length, property_offset, arg_target, arg_index, arg_buffer, arg_offset, arg_size, bufferAsset);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlUniformBindingPointAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull Long> var6) throws Exception;
        }
    }

    public static final class GlVertexArrayObjectAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlVertexArrayObjectAsset, GlVertexArrayObjectAsset.Value> {
        public static final @NonNull GlVertexArrayObjectAssetValueProcessor INSTANCE = new GlVertexArrayObjectAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDBUFFER, GlBindBuffer.HELPER_INSTANCE);
            }
        };

        private GlVertexArrayObjectAssetValueProcessor() {
        }

        @Override
        public @NonNull GlVertexArrayObjectAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlVertexArrayObjectAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlVertexArrayObjectAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> elementArrayBufferBinding = new SimplePropertyValue<Object>(assetObject, AbstractGlVertexArrayObjectAsset.GlVertexArrayObjectAssetProperties.PROPERTY_ELEMENT_ARRAY_BUFFER_BINDING, null);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(elementArrayBufferBinding, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, elementArrayBufferBinding)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlVertexArrayObjectAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)elementArrayBufferBinding);
        }

        @Override
        public @NonNull GlVertexArrayObjectAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlVertexArrayObjectAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlVertexArrayObjectAsset assetObject = (GlVertexArrayObjectAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlVertexArrayObjectAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable GlBufferAsset> elementArrayBufferBinding = new SimplePropertyValue<GlBufferAsset>(fromValue.getElementArrayBufferBinding());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(elementArrayBufferBinding, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, elementArrayBufferBinding)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlVertexArrayObjectAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)elementArrayBufferBinding);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexArrayObjectAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> elementArrayBufferBinding) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, elementArrayBufferBinding);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlVertexArrayObjectAsset.Value processedValue;
                GlVertexArrayObjectAsset.Value unProcessedValue = new GlVertexArrayObjectAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<GlBufferAsset>)elementArrayBufferBinding);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                elementArrayBufferBinding.setValueFrom(functionCall, processedValue.getElementArrayBufferBinding());
            }
            return result;
        }

        private static final class GlBindBuffer
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindBuffer HELPER_INSTANCE = new GlBindBuffer();

            private GlBindBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexArrayObjectAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_elementArrayBufferBinding) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    AssetItemID targetAsset_id_value;
                    AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferDecorator.getArgumentTarget(functionCall);
                    Long arg_buffer = GLES.GlBindBufferDecorator.getArgumentBuffer(functionCall);
                    if (!arg_buffer.equals(0L)) {
                        targetAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        GlBufferAsset glBufferAsset = GlBindBuffer.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBuffer.getGlBufferAsset(callbacks, functionCall, null, targetAsset_id_value), targetAsset_id_value);
                    }
                    if (arg_target.equals(KapiSpec.GLES.constants.GL_ELEMENT_ARRAY_BUFFER)) {
                        targetAsset_id_value = AssetItemID.valueOf(arg_buffer);
                        GlBufferAsset targetAsset = GlBindBuffer.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBuffer.getGlBufferAsset(callbacks, functionCall, null, targetAsset_id_value), targetAsset_id_value, AssetItemID.valueOf(0));
                        GlVertexArrayObjectAsset currentVAOAsset = assetObject;
                        property_elementArrayBufferBinding.setValue(functionCall, targetAsset);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlVertexArrayObjectAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> var4) throws Exception;
        }
    }

    public static final class GlVertexAttributeAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlVertexAttributeAsset, GlVertexAttributeAsset.Value> {
        public static final @NonNull GlVertexAttributeAssetValueProcessor INSTANCE = new GlVertexAttributeAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBBINDING, GlVertexAttribBinding.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBDIVISOR, GlVertexAttribDivisor.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBFORMAT, GlVertexAttribFormat.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBIFORMAT, GlVertexAttribIfOrmat.HELPER_INSTANCE);
            }
        };

        private GlVertexAttributeAssetValueProcessor() {
        }

        @Override
        public @NonNull GlVertexAttributeAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlVertexAttributeAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlVertexAttributeAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Boolean> arrayEnabled = new SimplePropertyValue<Boolean>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_ARRAY_ENABLED, false);
            SimplePropertyValue<@NonNull Boolean> arrayInteger = new SimplePropertyValue<Boolean>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_ARRAY_INTEGER, false);
            SimplePropertyValue<@NonNull Boolean> arrayNormalized = new SimplePropertyValue<Boolean>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_ARRAY_NORMALIZED, false);
            SimplePropertyValue<@Nullable Pointer> arrayPointer = new SimplePropertyValue<Pointer>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_ARRAY_POINTER, Pointer.valueOf(0L));
            SimplePropertyValue<@NonNull Long> arraySize = new SimplePropertyValue<Long>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_ARRAY_SIZE, 4L);
            SimplePropertyValue<@NonNull Long> arrayStride = new SimplePropertyValue<Long>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_ARRAY_STRIDE, 0L);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> arrayType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_ARRAY_TYPE, KapiSpec.GLES.constants.GL_FLOAT);
            ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> nonArrayDataSource = assetObject.getImmutablePropertyNonArrayDataSource();
            SimplePropertyValue<@Nullable Object> vboBinding = new SimplePropertyValue<Object>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_VBO_BINDING, null);
            SimplePropertyValue<@NonNull Long> vboRelativeOffset = new SimplePropertyValue<Long>(assetObject, AbstractGlVertexAttributeAsset.GlVertexAttributeAssetProperties.PROPERTY_VBO_RELATIVE_OFFSET, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, arrayEnabled, arrayInteger, arrayNormalized, arrayPointer, arraySize, arrayStride, arrayType, nonArrayDataSource, vboBinding, vboRelativeOffset)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlVertexAttributeAsset.Value(validRange, assetObject, arrayEnabled, arrayInteger, (IAssetPropertyValue<Boolean>)arrayNormalized, arrayPointer, arraySize, arrayStride, arrayType, nonArrayDataSource, (IAssetPropertyValue<GlVertexBufferBindingAsset>)vboBinding, (IAssetPropertyValue<Long>)vboRelativeOffset);
        }

        @Override
        public @NonNull GlVertexAttributeAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlVertexAttributeAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlVertexAttributeAsset assetObject = (GlVertexAttributeAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlVertexAttributeAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@NonNull Boolean> arrayEnabled = new SimplePropertyValue<Boolean>(fromValue.getArrayEnabled());
            SimplePropertyValue<@NonNull Boolean> arrayInteger = new SimplePropertyValue<Boolean>(fromValue.getArrayInteger());
            SimplePropertyValue<@NonNull Boolean> arrayNormalized = new SimplePropertyValue<Boolean>(fromValue.getArrayNormalized());
            SimplePropertyValue<@Nullable Pointer> arrayPointer = new SimplePropertyValue<Pointer>(fromValue.getArrayPointer());
            SimplePropertyValue<@NonNull Long> arraySize = new SimplePropertyValue<Long>(fromValue.getArraySize());
            SimplePropertyValue<@NonNull Long> arrayStride = new SimplePropertyValue<Long>(fromValue.getArrayStride());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> arrayType = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getArrayType());
            ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> nonArrayDataSource = assetObject.getImmutablePropertyNonArrayDataSource();
            SimplePropertyValue<@Nullable GlVertexBufferBindingAsset> vboBinding = new SimplePropertyValue<GlVertexBufferBindingAsset>(fromValue.getVboBinding());
            SimplePropertyValue<@NonNull Long> vboRelativeOffset = new SimplePropertyValue<Long>(fromValue.getVboRelativeOffset());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, arrayEnabled, arrayInteger, arrayNormalized, arrayPointer, arraySize, arrayStride, arrayType, nonArrayDataSource, vboBinding, vboRelativeOffset)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlVertexAttributeAsset.Value(validRange, assetObject, arrayEnabled, arrayInteger, (IAssetPropertyValue<Boolean>)arrayNormalized, arrayPointer, arraySize, arrayStride, arrayType, nonArrayDataSource, (IAssetPropertyValue<GlVertexBufferBindingAsset>)vboBinding, (IAssetPropertyValue<Long>)vboRelativeOffset);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexAttributeAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> arrayEnabled, @NonNull SimplePropertyValue<@NonNull Boolean> arrayInteger, @NonNull SimplePropertyValue<@NonNull Boolean> arrayNormalized, @NonNull SimplePropertyValue<@Nullable Pointer> arrayPointer, @NonNull SimplePropertyValue<@NonNull Long> arraySize, @NonNull SimplePropertyValue<@NonNull Long> arrayStride, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> arrayType, @NonNull ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> nonArrayDataSource, @NonNull SimplePropertyValue<@Nullable GlVertexBufferBindingAsset> vboBinding, @NonNull SimplePropertyValue<@NonNull Long> vboRelativeOffset) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, arrayEnabled, arrayInteger, arrayNormalized, arrayPointer, arraySize, arrayStride, arrayType, nonArrayDataSource, vboBinding, vboRelativeOffset);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlVertexAttributeAsset.Value processedValue;
                GlVertexAttributeAsset.Value unProcessedValue = new GlVertexAttributeAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, arrayEnabled, arrayInteger, (IAssetPropertyValue<Boolean>)arrayNormalized, arrayPointer, arraySize, arrayStride, arrayType, nonArrayDataSource, (IAssetPropertyValue<GlVertexBufferBindingAsset>)vboBinding, (IAssetPropertyValue<Long>)vboRelativeOffset);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                arrayEnabled.setValueFrom(functionCall, processedValue.getArrayEnabled());
                arrayInteger.setValueFrom(functionCall, processedValue.getArrayInteger());
                arrayNormalized.setValueFrom(functionCall, processedValue.getArrayNormalized());
                arrayPointer.setValueFrom(functionCall, processedValue.getArrayPointer());
                arraySize.setValueFrom(functionCall, processedValue.getArraySize());
                arrayStride.setValueFrom(functionCall, processedValue.getArrayStride());
                arrayType.setValueFrom(functionCall, processedValue.getArrayType());
                vboBinding.setValueFrom(functionCall, processedValue.getVboBinding());
                vboRelativeOffset.setValueFrom(functionCall, processedValue.getVboRelativeOffset());
            }
            return result;
        }

        private static final class GlVertexAttribBinding
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlVertexAttribBinding HELPER_INSTANCE = new GlVertexAttribBinding();

            private GlVertexAttribBinding() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexAttributeAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayEnabled, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayInteger, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayNormalized, @NonNull SimplePropertyValue<@Nullable Pointer> property_arrayPointer, @NonNull SimplePropertyValue<@NonNull Long> property_arraySize, @NonNull SimplePropertyValue<@NonNull Long> property_arrayStride, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_arrayType, @NonNull ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> property_nonArrayDataSource, @NonNull SimplePropertyValue<@Nullable GlVertexBufferBindingAsset> property_vboBinding, @NonNull SimplePropertyValue<@NonNull Long> property_vboRelativeOffset) throws Exception {
                assert (KapiSpec.GLES.functions.GLVERTEXATTRIBBINDING.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_attribindex = GLES.GlVertexAttribBindingDecorator.getArgumentAttribindex(functionCall);
                    Long arg_bindingindex = GLES.GlVertexAttribBindingDecorator.getArgumentBindingindex(functionCall);
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexAttribBinding.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexAttribBinding.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribBinding.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlVertexAttributeAsset vertexAttributeAsset = assetObject;
                    AssetItemID vertexBindingAsset_id_value = AssetItemID.valueOf(arg_bindingindex);
                    GlVertexBufferBindingAsset vertexBindingAsset = GlVertexAttribBinding.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, callbacks, functionCall, GlVertexAttribBinding.getOrCreateNewGlVertexBufferBindingAsset(callbacks, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                    property_vboBinding.setValue(functionCall, vertexBindingAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class GlVertexAttribDivisor
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlVertexAttribDivisor HELPER_INSTANCE = new GlVertexAttribDivisor();

            private GlVertexAttribDivisor() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexAttributeAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayEnabled, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayInteger, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayNormalized, @NonNull SimplePropertyValue<@Nullable Pointer> property_arrayPointer, @NonNull SimplePropertyValue<@NonNull Long> property_arraySize, @NonNull SimplePropertyValue<@NonNull Long> property_arrayStride, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_arrayType, @NonNull ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> property_nonArrayDataSource, @NonNull SimplePropertyValue<@Nullable GlVertexBufferBindingAsset> property_vboBinding, @NonNull SimplePropertyValue<@NonNull Long> property_vboRelativeOffset) throws Exception {
                assert (KapiSpec.GLES.functions.GLVERTEXATTRIBDIVISOR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_index = GLES.GlVertexAttribDivisorDecorator.getArgumentIndex(functionCall);
                    Long arg_divisor = GLES.GlVertexAttribDivisorDecorator.getArgumentDivisor(functionCall);
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexAttribDivisor.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexAttribDivisor.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlVertexAttributeAsset vertexAttributeAsset = assetObject;
                    AssetItemID vertexBindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    GlVertexBufferBindingAsset vertexBindingAsset = GlVertexAttribDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, callbacks, functionCall, GlVertexAttribDivisor.getOrCreateNewGlVertexBufferBindingAsset(callbacks, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                    property_vboBinding.setValue(functionCall, vertexBindingAsset);
                    return true;
                }
                return false;
            }
        }

        private static final class GlVertexAttribFormat
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlVertexAttribFormat HELPER_INSTANCE = new GlVertexAttribFormat();

            private GlVertexAttribFormat() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexAttributeAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayEnabled, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayInteger, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayNormalized, @NonNull SimplePropertyValue<@Nullable Pointer> property_arrayPointer, @NonNull SimplePropertyValue<@NonNull Long> property_arraySize, @NonNull SimplePropertyValue<@NonNull Long> property_arrayStride, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_arrayType, @NonNull ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> property_nonArrayDataSource, @NonNull SimplePropertyValue<@Nullable GlVertexBufferBindingAsset> property_vboBinding, @NonNull SimplePropertyValue<@NonNull Long> property_vboRelativeOffset) throws Exception {
                assert (KapiSpec.GLES.functions.GLVERTEXATTRIBFORMAT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_attribindex = GLES.GlVertexAttribFormatDecorator.getArgumentAttribindex(functionCall);
                    Integer arg_size = GLES.GlVertexAttribFormatDecorator.getArgumentSize(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_type = GLES.GlVertexAttribFormatDecorator.getArgumentType(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_normalized = GLES.GlVertexAttribFormatDecorator.getArgumentNormalized(functionCall);
                    Long arg_relativeoffset = GLES.GlVertexAttribFormatDecorator.getArgumentRelativeoffset(functionCall);
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexAttribFormat.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexAttribFormat.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribFormat.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlVertexAttributeAsset vertexAttributeAsset = assetObject;
                    Long temp_valueOf_return_value_3 = arg_size.longValue();
                    property_arraySize.setValue(functionCall, temp_valueOf_return_value_3);
                    property_arrayType.setValue(functionCall, arg_type);
                    property_arrayNormalized.setValue(functionCall, arg_normalized.equals(KapiSpec.GLES.constants.GL_TRUE));
                    property_vboRelativeOffset.setValue(functionCall, arg_relativeoffset);
                    property_arrayInteger.setValue(functionCall, KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
                    return true;
                }
                return false;
            }
        }

        private static final class GlVertexAttribIfOrmat
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlVertexAttribIfOrmat HELPER_INSTANCE = new GlVertexAttribIfOrmat();

            private GlVertexAttribIfOrmat() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexAttributeAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayEnabled, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayInteger, @NonNull SimplePropertyValue<@NonNull Boolean> property_arrayNormalized, @NonNull SimplePropertyValue<@Nullable Pointer> property_arrayPointer, @NonNull SimplePropertyValue<@NonNull Long> property_arraySize, @NonNull SimplePropertyValue<@NonNull Long> property_arrayStride, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_arrayType, @NonNull ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> property_nonArrayDataSource, @NonNull SimplePropertyValue<@Nullable GlVertexBufferBindingAsset> property_vboBinding, @NonNull SimplePropertyValue<@NonNull Long> property_vboRelativeOffset) throws Exception {
                assert (KapiSpec.GLES.functions.GLVERTEXATTRIBIFORMAT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_attribindex = GLES.GlVertexAttribIFormatDecorator.getArgumentAttribindex(functionCall);
                    Integer arg_size = GLES.GlVertexAttribIFormatDecorator.getArgumentSize(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_type = GLES.GlVertexAttribIFormatDecorator.getArgumentType(functionCall);
                    Long arg_relativeoffset = GLES.GlVertexAttribIFormatDecorator.getArgumentRelativeoffset(functionCall);
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexAttribIfOrmat.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexAttribIfOrmat.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribIfOrmat.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlVertexAttributeAsset vertexAttributeAsset = assetObject;
                    Long temp_valueOf_return_value_3 = arg_size.longValue();
                    property_arraySize.setValue(functionCall, temp_valueOf_return_value_3);
                    property_arrayType.setValue(functionCall, arg_type);
                    property_vboRelativeOffset.setValue(functionCall, arg_relativeoffset);
                    property_arrayInteger.setValue(functionCall, KapiSpec.GLES.constants.GL_TRUE.equals(KapiSpec.GLES.constants.GL_TRUE));
                    property_arrayNormalized.setValue(functionCall, KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlVertexAttributeAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@NonNull Boolean> var4, @NonNull SimplePropertyValue<@NonNull Boolean> var5, @NonNull SimplePropertyValue<@NonNull Boolean> var6, @NonNull SimplePropertyValue<@Nullable Pointer> var7, @NonNull SimplePropertyValue<@NonNull Long> var8, @NonNull SimplePropertyValue<@NonNull Long> var9, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var10, @NonNull ImmutablePropertyValue<@NonNull GlVertexAttributeNonArrayValueAsset> var11, @NonNull SimplePropertyValue<@Nullable GlVertexBufferBindingAsset> var12, @NonNull SimplePropertyValue<@NonNull Long> var13) throws Exception;
        }
    }

    public static final class GlVertexAttributeNonArrayValueAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlVertexAttributeNonArrayValueAsset, GlVertexAttributeNonArrayValueAsset.Value> {
        public static final @NonNull GlVertexAttributeNonArrayValueAssetValueProcessor INSTANCE = new GlVertexAttributeNonArrayValueAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private GlVertexAttributeNonArrayValueAssetValueProcessor() {
        }

        @Override
        public @NonNull GlVertexAttributeNonArrayValueAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlVertexAttributeNonArrayValueAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlVertexAttributeNonArrayValueAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<Number[]> value = new SimplePropertyValue<Number[]>(assetObject, AbstractGlVertexAttributeNonArrayValueAsset.GlVertexAttributeNonArrayValueAssetProperties.PROPERTY_VALUE, AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlVertexAttributeNonArrayValueAssetValue(callbacks, assetObject));
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, value)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlVertexAttributeNonArrayValueAsset.Value(validRange, assetObject, (IAssetPropertyValue<Number[]>)value);
        }

        @Override
        public @NonNull GlVertexAttributeNonArrayValueAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlVertexAttributeNonArrayValueAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlVertexAttributeNonArrayValueAsset assetObject = (GlVertexAttributeNonArrayValueAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlVertexAttributeNonArrayValueAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<Number[]> value = new SimplePropertyValue<Number[]>(fromValue.getValue());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, value)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlVertexAttributeNonArrayValueAsset.Value(validRange, assetObject, (IAssetPropertyValue<Number[]>)value);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexAttributeNonArrayValueAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<Number[]> value) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, value);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlVertexAttributeNonArrayValueAsset.Value processedValue;
                GlVertexAttributeNonArrayValueAsset.Value unProcessedValue = new GlVertexAttributeNonArrayValueAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Number[]>)value);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                value.setValueFrom(functionCall, processedValue.getValue());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlVertexAttributeNonArrayValueAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<Number[]> var4) throws Exception;
        }
    }

    public static final class GlVertexBufferBindingAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, GlVertexBufferBindingAsset, GlVertexBufferBindingAsset.Value> {
        public static final @NonNull GlVertexBufferBindingAssetValueProcessor INSTANCE = new GlVertexBufferBindingAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.GLES.functions.GLBINDVERTEXBUFFER, GlBindVertexBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBDIVISOR, GlVertexAttribDivisor.HELPER_INSTANCE);
                this.put(KapiSpec.GLES.functions.GLVERTEXBINDINGDIVISOR, GlVertexBindingDivisor.HELPER_INSTANCE);
            }
        };

        private GlVertexBufferBindingAssetValueProcessor() {
        }

        @Override
        public @NonNull GlVertexBufferBindingAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlVertexBufferBindingAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlVertexBufferBindingAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> buffer = new SimplePropertyValue<Object>(assetObject, AbstractGlVertexBufferBindingAsset.GlVertexBufferBindingAssetProperties.PROPERTY_BUFFER, null);
            SimplePropertyValue<@NonNull Long> divisor = new SimplePropertyValue<Long>(assetObject, AbstractGlVertexBufferBindingAsset.GlVertexBufferBindingAssetProperties.PROPERTY_DIVISOR, 0L);
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(assetObject, AbstractGlVertexBufferBindingAsset.GlVertexBufferBindingAssetProperties.PROPERTY_OFFSET, 0L);
            SimplePropertyValue<@NonNull Long> stride = new SimplePropertyValue<Long>(assetObject, AbstractGlVertexBufferBindingAsset.GlVertexBufferBindingAssetProperties.PROPERTY_STRIDE, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                this.ensureAssetReferencesValidAt(buffer, functionCall);
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, buffer, divisor, offset, stride)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlVertexBufferBindingAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)divisor, (IAssetPropertyValue<Long>)offset, (IAssetPropertyValue<Long>)stride);
        }

        @Override
        public @NonNull GlVertexBufferBindingAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull GlVertexBufferBindingAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull GlVertexBufferBindingAsset assetObject = (GlVertexBufferBindingAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get GlVertexBufferBindingAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable GlBufferAsset> buffer = new SimplePropertyValue<GlBufferAsset>(fromValue.getBuffer());
            SimplePropertyValue<@NonNull Long> divisor = new SimplePropertyValue<Long>(fromValue.getDivisor());
            SimplePropertyValue<@NonNull Long> offset = new SimplePropertyValue<Long>(fromValue.getOffset());
            SimplePropertyValue<@NonNull Long> stride = new SimplePropertyValue<Long>(fromValue.getStride());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    this.ensureAssetReferencesValidAt(buffer, functionCall);
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, buffer, divisor, offset, stride)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new GlVertexBufferBindingAsset.Value(validRange, assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)divisor, (IAssetPropertyValue<Long>)offset, (IAssetPropertyValue<Long>)stride);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexBufferBindingAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> buffer, @NonNull SimplePropertyValue<@NonNull Long> divisor, @NonNull SimplePropertyValue<@NonNull Long> offset, @NonNull SimplePropertyValue<@NonNull Long> stride) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, true)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, buffer, divisor, offset, stride);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                GlVertexBufferBindingAsset.Value processedValue;
                GlVertexBufferBindingAsset.Value unProcessedValue = new GlVertexBufferBindingAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<GlBufferAsset>)buffer, (IAssetPropertyValue<Long>)divisor, (IAssetPropertyValue<Long>)offset, (IAssetPropertyValue<Long>)stride);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                buffer.setValueFrom(functionCall, processedValue.getBuffer());
                divisor.setValueFrom(functionCall, processedValue.getDivisor());
                offset.setValueFrom(functionCall, processedValue.getOffset());
                stride.setValueFrom(functionCall, processedValue.getStride());
            }
            return result;
        }

        private static final class GlBindVertexBuffer
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlBindVertexBuffer HELPER_INSTANCE = new GlBindVertexBuffer();

            private GlBindVertexBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexBufferBindingAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_divisor, @NonNull SimplePropertyValue<@NonNull Long> property_offset, @NonNull SimplePropertyValue<@NonNull Long> property_stride) throws Exception {
                assert (KapiSpec.GLES.functions.GLBINDVERTEXBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_bindingindex = GLES.GlBindVertexBufferDecorator.getArgumentBindingindex(functionCall);
                    Long arg_buffer = GLES.GlBindVertexBufferDecorator.getArgumentBuffer(functionCall);
                    Long arg_offset = GLES.GlBindVertexBufferDecorator.getArgumentOffset(functionCall);
                    Integer arg_stride = GLES.GlBindVertexBufferDecorator.getArgumentStride(functionCall);
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlBindVertexBuffer.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlBindVertexBuffer.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlVertexArrayObjectAsset vertexArrayAsset = GlBindVertexBuffer.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlVertexBufferBindingAsset vertexBindingAsset = assetObject;
                    AssetItemID bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    GlBufferAsset bufferAsset = GlBindVertexBuffer.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindVertexBuffer.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value);
                    property_buffer.setValue(functionCall, bufferAsset);
                    property_offset.setValue(functionCall, arg_offset);
                    Long temp_valueOf_return_value_3 = arg_stride.longValue();
                    property_stride.setValue(functionCall, temp_valueOf_return_value_3);
                    return true;
                }
                return false;
            }
        }

        private static final class GlVertexAttribDivisor
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlVertexAttribDivisor HELPER_INSTANCE = new GlVertexAttribDivisor();

            private GlVertexAttribDivisor() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexBufferBindingAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_divisor, @NonNull SimplePropertyValue<@NonNull Long> property_offset, @NonNull SimplePropertyValue<@NonNull Long> property_stride) throws Exception {
                assert (KapiSpec.GLES.functions.GLVERTEXATTRIBDIVISOR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_index = GLES.GlVertexAttribDivisorDecorator.getArgumentIndex(functionCall);
                    Long arg_divisor = GLES.GlVertexAttribDivisorDecorator.getArgumentDivisor(functionCall);
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_3 = GlVertexAttribDivisor.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_4 = GlVertexAttribDivisor.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_3);
                    AssetItemID temp_valueOf_return_value_5 = AssetItemID.valueOf(temp_getStateItemValue_return_value_3);
                    GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_4, temp_valueOf_return_value_5);
                    GlVertexBufferBindingAsset vertexBindingAsset = assetObject;
                    property_divisor.setValue(functionCall, arg_divisor);
                    return true;
                }
                return false;
            }
        }

        private static final class GlVertexBindingDivisor
        extends AbstractGlesAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final GlVertexBindingDivisor HELPER_INSTANCE = new GlVertexBindingDivisor();

            private GlVertexBindingDivisor() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull GlVertexBufferBindingAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> property_buffer, @NonNull SimplePropertyValue<@NonNull Long> property_divisor, @NonNull SimplePropertyValue<@NonNull Long> property_offset, @NonNull SimplePropertyValue<@NonNull Long> property_stride) throws Exception {
                assert (KapiSpec.GLES.functions.GLVERTEXBINDINGDIVISOR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Long arg_bindingindex = GLES.GlVertexBindingDivisorDecorator.getArgumentBindingindex(functionCall);
                    Long arg_divisor = GLES.GlVertexBindingDivisorDecorator.getArgumentDivisor(functionCall);
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexBindingDivisor.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexBindingDivisor.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlVertexArrayObjectAsset vertexArrayAsset = GlVertexBindingDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    GlVertexBufferBindingAsset vertexBindingAsset = assetObject;
                    property_divisor.setValue(functionCall, arg_divisor);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull GlVertexBufferBindingAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable GlBufferAsset> var4, @NonNull SimplePropertyValue<@NonNull Long> var5, @NonNull SimplePropertyValue<@NonNull Long> var6, @NonNull SimplePropertyValue<@NonNull Long> var7) throws Exception;
        }
    }

    public static final class ShaderUniformValueProcessor
    extends AbstractLightweightAssetValueProcessor<GLESApi, ShaderUniform, ShaderUniform.Value> {
        public static final @NonNull ShaderUniformValueProcessor INSTANCE = new ShaderUniformValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private ShaderUniformValueProcessor() {
        }

        @Override
        public @NonNull ShaderUniform.Value execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ShaderUniform assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ShaderUniform value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Integer> arrayLength = assetObject.getImmutablePropertyArrayLength();
            ImmutablePropertyValue<@NonNull String> blockName = assetObject.getImmutablePropertyBlockName();
            ImmutablePropertyValue<@NonNull Integer> elementLength = assetObject.getImmutablePropertyElementLength();
            ImmutablePropertyValue<@NonNull Integer> location = assetObject.getImmutablePropertyLocation();
            ImmutablePropertyValue<@NonNull String> name = assetObject.getImmutablePropertyName();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            ShaderUniformValuePropertyValue value = new ShaderUniformValuePropertyValue(assetObject);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, arrayLength, blockName, elementLength, location, name, type, value)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ShaderUniform.Value(validRange, assetObject, (IAssetPropertyValue<Integer>)arrayLength, (IAssetPropertyValue<String>)blockName, (IAssetPropertyValue<Integer>)elementLength, (IAssetPropertyValue<Integer>)location, (IAssetPropertyValue<String>)name, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type, value);
        }

        @Override
        public @NonNull ShaderUniform.Value update(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ShaderUniform.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull ShaderUniform assetObject = (ShaderUniform)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ShaderUniform value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull Integer> arrayLength = assetObject.getImmutablePropertyArrayLength();
            ImmutablePropertyValue<@NonNull String> blockName = assetObject.getImmutablePropertyBlockName();
            ImmutablePropertyValue<@NonNull Integer> elementLength = assetObject.getImmutablePropertyElementLength();
            ImmutablePropertyValue<@NonNull Integer> location = assetObject.getImmutablePropertyLocation();
            ImmutablePropertyValue<@NonNull String> name = assetObject.getImmutablePropertyName();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            ShaderUniformValuePropertyValue value = new ShaderUniformValuePropertyValue(fromValue.getValue());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, arrayLength, blockName, elementLength, location, name, type, value)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ShaderUniform.Value(validRange, assetObject, (IAssetPropertyValue<Integer>)arrayLength, (IAssetPropertyValue<String>)blockName, (IAssetPropertyValue<Integer>)elementLength, (IAssetPropertyValue<Integer>)location, (IAssetPropertyValue<String>)name, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type, value);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull ShaderUniform assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull Integer> arrayLength, @NonNull ImmutablePropertyValue<@NonNull String> blockName, @NonNull ImmutablePropertyValue<@NonNull Integer> elementLength, @NonNull ImmutablePropertyValue<@NonNull Integer> location, @NonNull ImmutablePropertyValue<@NonNull String> name, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type, @NonNull ShaderUniformValuePropertyValue value) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, arrayLength, blockName, elementLength, location, name, type, value);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                ShaderUniform.Value processedValue;
                ShaderUniform.Value unProcessedValue = new ShaderUniform.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Integer>)arrayLength, (IAssetPropertyValue<String>)blockName, (IAssetPropertyValue<Integer>)elementLength, (IAssetPropertyValue<Integer>)location, (IAssetPropertyValue<String>)name, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type, value);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                value.setValueFrom(functionCall, processedValue.getValue());
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> var1, @NonNull ShaderUniform var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull Integer> var4, @NonNull ImmutablePropertyValue<@NonNull String> var5, @NonNull ImmutablePropertyValue<@NonNull Integer> var6, @NonNull ImmutablePropertyValue<@NonNull Integer> var7, @NonNull ImmutablePropertyValue<@NonNull String> var8, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var9, @NonNull ShaderUniformValuePropertyValue var10) throws Exception;
        }
    }
}

