/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.gles;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TextureArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.gles.GlBufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlImageUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramPipelineAsset;
import com.arm.mgd.lightweight.asset.gles.GlQueryObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlRenderbufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlSamplerAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderAsset;
import com.arm.mgd.lightweight.asset.gles.GlSyncObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureImageAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureSurfaceAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexArrayObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexBufferBindingAsset;
import com.arm.mgd.lightweight.asset.gles.gen.AbstractGlProgramPipelineAsset;
import com.arm.mgd.lightweight.asset.internal.AbstractAssetItem;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.ProvidedAssetProcessors;
import com.arm.mgd.lightweight.asset.processor.gles.AbstractGlesAssetCallProcessorBase;
import com.arm.mgd.lightweight.asset.processor.gles.AbstractGlesAssetValueProcessorBase;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.lightweight.state.IStateItemValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GlesAssetCallProcessor {
    private static final Map<IFunctionOrAliasSpecExtended, AbstractLightweightAssetFunctionCallProcessor> ASSET_PROCESSORS = new HashMap<IFunctionOrAliasSpecExtended, AbstractLightweightAssetFunctionCallProcessor>(){
        {
            this.put(KapiSpec.GLES.functions.GLACTIVESHADERPROGRAM, new GlActiveShaderProgram());
            this.put(KapiSpec.GLES.functions.GLACTIVETEXTURE, new GlActiveTexture());
            this.put(KapiSpec.GLES.functions.GLATTACHSHADER, new GlAttachShader());
            this.put(KapiSpec.GLES.functions.GLBEGINQUERY, new GlBeginQuery());
            this.put(KapiSpec.GLES.functions.GLBEGINTRANSFORMFEEDBACK, new GlBeginTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLBINDBUFFER, new GlBindBuffer());
            this.put(KapiSpec.GLES.functions.GLBINDBUFFERBASE, new GlBindBufferBase());
            this.put(KapiSpec.GLES.functions.GLBINDBUFFERRANGE, new GlBindBufferRange());
            this.put(KapiSpec.GLES.functions.GLBINDFRAMEBUFFER, new GlBindFramebuffer());
            this.put(KapiSpec.GLES.functions.GLBINDIMAGETEXTURE, new GlBindImageTexture());
            this.put(KapiSpec.GLES.functions.GLBINDPROGRAMPIPELINE, new GlBindProgramPipeline());
            this.put(KapiSpec.GLES.functions.GLBINDRENDERBUFFER, new GlBindRenderbuffer());
            this.put(KapiSpec.GLES.functions.GLBINDSAMPLER, new GlBindSampler());
            this.put(KapiSpec.GLES.functions.GLBINDTEXTURE, new GlBindTexture());
            this.put(KapiSpec.GLES.functions.GLBINDTRANSFORMFEEDBACK, new GlBindTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLBINDVERTEXBUFFER, new GlBindVertexBuffer());
            this.put(KapiSpec.GLES.functions.GLCLIENTWAITSYNC, new GlClientWaitSync());
            this.put(KapiSpec.GLES.functions.GLCOMPILESHADER, new GlCompileShader());
            this.put(KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D, new GlCompressedTexImage2D());
            this.put(KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE3D, new GlCompressedTexImage3D());
            this.put(KapiSpec.GLES.functions.GLCREATEPROGRAM, new GlCreateProgram());
            this.put(KapiSpec.GLES.functions.GLCREATESHADER, new GlCreateShader());
            this.put(KapiSpec.GLES.functions.GLCREATESHADERPROGRAMV, new GlCreateShaderProgramv());
            this.put(KapiSpec.GLES.functions.GLCREATESHADERPROGRAMVEXT, new GlCreateShaderProgramvExt());
            this.put(KapiSpec.GLES.functions.GLDELETEBUFFERS, new GlDeleteBuffers());
            this.put(KapiSpec.GLES.functions.GLDELETEFRAMEBUFFERS, new GlDeleteFramebuffers());
            this.put(KapiSpec.GLES.functions.GLDELETEPROGRAM, new GlDeleteProgram());
            this.put(KapiSpec.GLES.functions.GLDELETEPROGRAMPIPELINES, new GlDeleteProgramPipelines());
            this.put(KapiSpec.GLES.functions.GLDELETEQUERIES, new GlDeleteQueries());
            this.put(KapiSpec.GLES.functions.GLDELETERENDERBUFFERS, new GlDeleteRenderbuffers());
            this.put(KapiSpec.GLES.functions.GLDELETESAMPLERS, new GlDeleteSamplers());
            this.put(KapiSpec.GLES.functions.GLDELETESHADER, new GlDeleteShader());
            this.put(KapiSpec.GLES.functions.GLDELETESYNC, new GlDeleteSync());
            this.put(KapiSpec.GLES.functions.GLDELETETEXTURES, new GlDeleteTextures());
            this.put(KapiSpec.GLES.functions.GLDELETETRANSFORMFEEDBACKS, new GlDeleteTransformFeedbacks());
            this.put(KapiSpec.GLES.functions.GLDELETEVERTEXARRAYS, new GlDeleteVertexArrays());
            this.put(KapiSpec.GLES.functions.GLDETACHSHADER, new GlDetachShader());
            this.put(KapiSpec.GLES.functions.GLDISCARDFRAMEBUFFEREXT, new GlDiscardFramebufferExt());
            this.put(KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXSTORAGEEXT, new GlEgliMageTargetTexStorageExt());
            this.put(KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURE2DOES, new GlEgliMageTargetTexture2Does());
            this.put(KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURESTORAGEEXT, new GlEgliMageTargetTextureStorageExt());
            this.put(KapiSpec.GLES.functions.GLENDQUERY, new GlEndQuery());
            this.put(KapiSpec.GLES.functions.GLENDTRANSFORMFEEDBACK, new GlEndTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLFENCESYNC, new GlFenceSync());
            this.put(KapiSpec.GLES.functions.GLFRAMEBUFFERPARAMETERI, new GlFramebufferParameteri());
            this.put(KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVR, new GlFramebufferTextureMultisampleMultiviewOvr());
            this.put(KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTIVIEWOVR, new GlFramebufferTextureMultiviewOvr());
            this.put(KapiSpec.GLES.functions.GLGENBUFFERS, new GlGenBuffers());
            this.put(KapiSpec.GLES.functions.GLGENFRAMEBUFFERS, new GlGenFramebuffers());
            this.put(KapiSpec.GLES.functions.GLGENPROGRAMPIPELINES, new GlGenProgramPipelines());
            this.put(KapiSpec.GLES.functions.GLGENQUERIES, new GlGenQueries());
            this.put(KapiSpec.GLES.functions.GLGENRENDERBUFFERS, new GlGenRenderbuffers());
            this.put(KapiSpec.GLES.functions.GLGENSAMPLERS, new GlGenSamplers());
            this.put(KapiSpec.GLES.functions.GLGENTEXTURES, new GlGenTextures());
            this.put(KapiSpec.GLES.functions.GLGENTRANSFORMFEEDBACKS, new GlGenTransformFeedbacks());
            this.put(KapiSpec.GLES.functions.GLGENVERTEXARRAYS, new GlGenVertexArrays());
            this.put(KapiSpec.GLES.functions.GLGENERATEMIPMAP, new GlGenerateMipmap());
            this.put(KapiSpec.GLES.functions.GLGETQUERYOBJECTUIV, new GlGetQueryObjectuiv());
            this.put(KapiSpec.GLES.functions.GLINVALIDATEFRAMEBUFFER, new GlInvalidateFramebuffer());
            this.put(KapiSpec.GLES.functions.GLINVALIDATESUBFRAMEBUFFER, new GlInvalidateSubFramebuffer());
            this.put(KapiSpec.GLES.functions.GLLINKPROGRAM, new GlLinkProgram());
            this.put(KapiSpec.GLES.functions.GLPAUSETRANSFORMFEEDBACK, new GlPauseTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLPROGRAMPARAMETERI, new GlProgramParameteri());
            this.put(KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGE, new GlRenderbufferStorage());
            this.put(KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGEMULTISAMPLE, new GlRenderbufferStorageMultisample());
            this.put(KapiSpec.GLES.functions.GLRESUMETRANSFORMFEEDBACK, new GlResumeTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERIIV, new GlSamplerParameterIiv());
            this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERIUIV, new GlSamplerParameterIuiv());
            this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERF, new GlSamplerParameterf());
            this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERFV, new GlSamplerParameterfv());
            this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERI, new GlSamplerParameteri());
            this.put(KapiSpec.GLES.functions.GLSAMPLERPARAMETERIV, new GlSamplerParameteriv());
            this.put(KapiSpec.GLES.functions.GLSHADERBINARY, new GlShaderBinary());
            this.put(KapiSpec.GLES.functions.GLTEXIMAGE2D, new GlTexImage2D());
            this.put(KapiSpec.GLES.functions.GLTEXIMAGE3D, new GlTexImage3D());
            this.put(KapiSpec.GLES.functions.GLTEXIMAGE3DOES, new GlTexImage3Does());
            this.put(KapiSpec.GLES.functions.GLTEXPARAMETERIIV, new GlTexParameterIiv());
            this.put(KapiSpec.GLES.functions.GLTEXPARAMETERIUIV, new GlTexParameterIuiv());
            this.put(KapiSpec.GLES.functions.GLTEXPARAMETERF, new GlTexParameterf());
            this.put(KapiSpec.GLES.functions.GLTEXPARAMETERFV, new GlTexParameterfv());
            this.put(KapiSpec.GLES.functions.GLTEXPARAMETERI, new GlTexParameteri());
            this.put(KapiSpec.GLES.functions.GLTEXPARAMETERIV, new GlTexParameteriv());
            this.put(KapiSpec.GLES.functions.GLTEXSTORAGE2D, new GlTexStorage2D());
            this.put(KapiSpec.GLES.functions.GLTEXSTORAGE2DMULTISAMPLE, new GlTexStorage2DmUltisample());
            this.put(KapiSpec.GLES.functions.GLTEXSTORAGE3D, new GlTexStorage3D());
            this.put(KapiSpec.GLES.functions.GLTEXSTORAGE3DMULTISAMPLE, new GlTexStorage3DmUltisample());
            this.put(KapiSpec.GLES.functions.GLUSEPROGRAM, new GlUseProgram());
            this.put(KapiSpec.GLES.functions.GLUSEPROGRAMSTAGES, new GlUseProgramStages());
            this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBBINDING, new GlVertexAttribBinding());
            this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBDIVISOR, new GlVertexAttribDivisor());
            this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBFORMAT, new GlVertexAttribFormat());
            this.put(KapiSpec.GLES.functions.GLVERTEXATTRIBIFORMAT, new GlVertexAttribIfOrmat());
            this.put(KapiSpec.GLES.functions.GLVERTEXBINDINGDIVISOR, new GlVertexBindingDivisor());
            this.put(KapiSpec.GLES.functions.GLWAITSYNC, new GlWaitSync());
        }
    };

    public static @Nullable AbstractLightweightAssetFunctionCallProcessor forFunctionCall(@NonNull FunctionCall functionCall) {
        if (functionCall.hasError()) {
            return null;
        }
        return ASSET_PROCESSORS.get(functionCall.getFunctionSpec());
    }

    private static class Constants {
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_0 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER, KapiSpec.GLES.constants.GL_COMPUTE_SHADER, KapiSpec.GLES.constants.GL_GEOMETRY_SHADER, KapiSpec.GLES.constants.GL_FRAGMENT_SHADER, KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER, KapiSpec.GLES.constants.GL_VERTEX_SHADER));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_1 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_SYNC_FENCE));

        private Constants() {
        }
    }

    public static final class GlActiveShaderProgram
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLACTIVESHADERPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_pipeline = GLES.GlActiveShaderProgramDecorator.getArgumentPipeline(functionCall);
                Long arg_program = GLES.GlActiveShaderProgramDecorator.getArgumentProgram(functionCall);
                AssetItemID programPipelineAsset_id_value = AssetItemID.valueOf(arg_pipeline);
                GlProgramPipelineAsset programPipelineAsset = GlActiveShaderProgram.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, callbacks, functionCall, GlActiveShaderProgram.getGlProgramPipelineAsset(callbacks, functionCall, null, programPipelineAsset_id_value), programPipelineAsset_id_value);
                programPipelineAsset.addFunctionCall(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                GlProgramAsset programAsset = GlActiveShaderProgram.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlActiveShaderProgram.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value), programAsset_id_value, AssetItemID.valueOf(0));
                programPipelineAsset.getLifecycleManager().trackPropertyValueChanged(AbstractGlProgramPipelineAsset.GlProgramPipelineAssetProperties.PROPERTY_ACTIVE_PROGRAM, functionCall, programAsset);
            }
        }
    }

    public static final class GlActiveTexture
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLACTIVETEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_texture = GLES.GlActiveTextureDecorator.getArgumentTexture(functionCall);
                GlTextureUnitAsset textureUnitAsset = ProvidedAssetProcessors.provideGlTextureUnitAssetForGlActiveTexture(callbacks, functionCall, arg_texture);
                textureUnitAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlAttachShader
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLATTACHSHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlAttachShaderDecorator.getArgumentProgram(functionCall);
                Long arg_shader = GLES.GlAttachShaderDecorator.getArgumentShader(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                GlProgramAsset programAsset = GlAttachShader.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlAttachShader.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value), programAsset_id_value);
                programAsset.addFunctionCall(functionCall);
                AssetItemID shaderAsset_id_value = AssetItemID.valueOf(arg_shader);
                GlShaderAsset shaderAsset = GlAttachShader.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, callbacks, functionCall, GlAttachShader.getGlShaderAsset(callbacks, functionCall, null, shaderAsset_id_value), shaderAsset_id_value);
                shaderAsset.addFunctionCall(functionCall);
                ProvidedAssetProcessors.processProvidedCallProcessorActionForGlProgramAssetOnGlAttachShader(callbacks, functionCall, programAsset, arg_program, arg_shader, shaderAsset);
            }
        }
    }

    public static final class GlBeginQuery
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBEGINQUERY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBeginQueryDecorator.getArgumentTarget(functionCall);
                Long arg_id = GLES.GlBeginQueryDecorator.getArgumentId(functionCall);
                AssetItemID queryAsset_id_value = AssetItemID.valueOf(arg_id);
                GlQueryObjectAsset queryAsset = GlBeginQuery.requireAsset(KapiSpec.GLES.assetTables.QUERY_TRAITS, callbacks, functionCall, GlBeginQuery.getGlQueryObjectAsset(callbacks, functionCall, null, queryAsset_id_value), queryAsset_id_value);
                queryAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlBeginTransformFeedback
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBEGINTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_primitiveMode = GLES.GlBeginTransformFeedbackDecorator.getArgumentPrimitiveMode(functionCall);
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlBeginTransformFeedback.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_TRANSFORM_FEEDBACK_BINDING);
                GlTransformFeedbackAsset temp_mapStateValueToAssetObject_return_value_1 = GlBeginTransformFeedback.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlTransformFeedbackAsset targetAsset = GlBeginTransformFeedback.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                targetAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlBindBuffer
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                GlBufferAsset targetAsset;
                AssetItemID targetAsset_id_value;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferDecorator.getArgumentTarget(functionCall);
                Long arg_buffer = GLES.GlBindBufferDecorator.getArgumentBuffer(functionCall);
                if (!arg_buffer.equals(0L)) {
                    targetAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    targetAsset = GlBindBuffer.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBuffer.getGlBufferAsset(callbacks, functionCall, null, targetAsset_id_value), targetAsset_id_value);
                    targetAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_ELEMENT_ARRAY_BUFFER)) {
                    targetAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    targetAsset = GlBindBuffer.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBuffer.getGlBufferAsset(callbacks, functionCall, null, targetAsset_id_value), targetAsset_id_value, AssetItemID.valueOf(0));
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlBindBuffer.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlBindBuffer.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlVertexArrayObjectAsset currentVAOAsset = GlBindBuffer.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    currentVAOAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class GlBindBufferBase
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDBUFFERBASE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractAssetItem bindingAsset;
                AssetItemID bindingAsset_id_value;
                GlBufferAsset bufferAsset;
                AssetItemID bufferAsset_id_value;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlBindBufferBaseDecorator.getArgumentIndex(functionCall);
                Long arg_buffer = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
                if (!arg_buffer.equals(0L)) {
                    AssetItemID targetAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    GlBufferAsset targetAsset = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, targetAsset_id_value), targetAsset_id_value);
                    targetAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                    bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    bindingAsset = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                    bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    bindingAsset = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                    bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    bindingAsset = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                    bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    bufferAsset = GlBindBufferBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferBase.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    bindingAsset = GlBindBufferBase.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, callbacks, functionCall, GlBindBufferBase.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class GlBindBufferRange
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDBUFFERRANGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractAssetItem bindingAsset;
                AssetItemID bindingAsset_id_value;
                GlBufferAsset bufferAsset;
                AssetItemID bufferAsset_id_value;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlBindBufferRangeDecorator.getArgumentIndex(functionCall);
                Long arg_buffer = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
                Long arg_offset = GLES.GlBindBufferRangeDecorator.getArgumentOffset(functionCall);
                Long arg_size = GLES.GlBindBufferRangeDecorator.getArgumentSize(functionCall);
                if (!arg_buffer.equals(0L)) {
                    AssetItemID targetAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    GlBufferAsset targetAsset = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, targetAsset_id_value), targetAsset_id_value);
                    targetAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                    bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    bindingAsset = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                    bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    bindingAsset = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                    bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    bindingAsset = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                    bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                    bufferAsset = GlBindBufferRange.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindBufferRange.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    bindingAsset_id_value = AssetItemID.valueOf(arg_index);
                    bindingAsset = GlBindBufferRange.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, callbacks, functionCall, GlBindBufferRange.getOrCreateNewGlUniformBindingPointAsset(callbacks, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class GlBindFramebuffer
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindFramebufferDecorator.getArgumentTarget(functionCall);
                Long arg_framebuffer = GLES.GlBindFramebufferDecorator.getArgumentFramebuffer(functionCall);
                AssetItemID framebufferAsset_id_value = AssetItemID.valueOf(arg_framebuffer);
                GlFramebufferAsset glFramebufferAsset = GlBindFramebuffer.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, GlBindFramebuffer.getGlFramebufferAsset(callbacks, functionCall, null, framebufferAsset_id_value, AssetItemID.valueOf(0)), framebufferAsset_id_value);
            }
        }
    }

    public static final class GlBindImageTexture
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDIMAGETEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_unit = GLES.GlBindImageTextureDecorator.getArgumentUnit(functionCall);
                Long arg_texture = GLES.GlBindImageTextureDecorator.getArgumentTexture(functionCall);
                Integer arg_level = GLES.GlBindImageTextureDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_layered = GLES.GlBindImageTextureDecorator.getArgumentLayered(functionCall);
                Integer arg_layer = GLES.GlBindImageTextureDecorator.getArgumentLayer(functionCall);
                AbstractConstantOrAliasSpecExtended arg_access = GLES.GlBindImageTextureDecorator.getArgumentAccess(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlBindImageTextureDecorator.getArgumentFormat(functionCall);
                AssetItemID imageUnitAsset_id_value = AssetItemID.valueOf(arg_unit);
                GlImageUnitAsset imageUnitAsset = GlBindImageTexture.requireAsset(KapiSpec.GLES.assetTables.IMAGE_UNIT_TRAITS, callbacks, functionCall, GlBindImageTexture.getOrCreateNewGlImageUnitAsset(callbacks, functionCall, imageUnitAsset_id_value), imageUnitAsset_id_value);
                imageUnitAsset.addFunctionCall(functionCall);
                AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                GlTextureAsset glTextureAsset = GlBindImageTexture.warnIfMissingAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlBindImageTexture.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
            }
        }
    }

    public static final class GlBindProgramPipeline
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_pipeline;
            assert (KapiSpec.GLES.functions.GLBINDPROGRAMPIPELINE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && !(arg_pipeline = GLES.GlBindProgramPipelineDecorator.getArgumentPipeline(functionCall)).equals(0L)) {
                AssetItemID programPipelineAsset_id_value = AssetItemID.valueOf(arg_pipeline);
                GlProgramPipelineAsset programPipelineAsset = GlBindProgramPipeline.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, callbacks, functionCall, GlBindProgramPipeline.getGlProgramPipelineAsset(callbacks, functionCall, null, programPipelineAsset_id_value), programPipelineAsset_id_value);
                programPipelineAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlBindRenderbuffer
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDRENDERBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindRenderbufferDecorator.getArgumentTarget(functionCall);
                Long arg_renderbuffer = GLES.GlBindRenderbufferDecorator.getArgumentRenderbuffer(functionCall);
                if (!arg_renderbuffer.equals(0L)) {
                    AssetItemID renderbufferAsset_id_value = AssetItemID.valueOf(arg_renderbuffer);
                    GlRenderbufferAsset glRenderbufferAsset = GlBindRenderbuffer.requireAsset(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, callbacks, functionCall, GlBindRenderbuffer.getGlRenderbufferAsset(callbacks, functionCall, null, renderbufferAsset_id_value), renderbufferAsset_id_value);
                }
            }
        }
    }

    public static final class GlBindSampler
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDSAMPLER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_unit = GLES.GlBindSamplerDecorator.getArgumentUnit(functionCall);
                Long arg_sampler = GLES.GlBindSamplerDecorator.getArgumentSampler(functionCall);
                AssetItemID unitAsset_id_value = AssetItemID.valueOf(arg_unit);
                GlTextureUnitAsset unitAsset = GlBindSampler.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS, callbacks, functionCall, GlBindSampler.getOrCreateNewGlTextureUnitAsset(callbacks, functionCall, unitAsset_id_value), unitAsset_id_value);
                unitAsset.addFunctionCall(functionCall);
                AssetItemID samplerAsset_id_value = AssetItemID.valueOf(arg_sampler);
                GlSamplerAsset glSamplerAsset = GlBindSampler.warnIfMissingAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlBindSampler.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value, AssetItemID.valueOf(0));
            }
        }
    }

    public static final class GlBindTexture
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDTEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindTextureDecorator.getArgumentTarget(functionCall);
                Long arg_texture = GLES.GlBindTextureDecorator.getArgumentTexture(functionCall);
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlBindTexture.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_ACTIVE_TEXTURE);
                GlTextureUnitAsset temp_mapStateValueToAssetObject_return_value_1 = GlBindTexture.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlTextureUnitAsset textureUnitAsset = GlBindTexture.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureUnitAsset.addFunctionCall(functionCall);
                AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                GlTextureAsset textureAsset = GlBindTexture.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlBindTexture.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlBindTransformFeedback
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindTransformFeedbackDecorator.getArgumentTarget(functionCall);
                Long arg_id = GLES.GlBindTransformFeedbackDecorator.getArgumentId(functionCall);
                AssetItemID targetAsset_id_value = AssetItemID.valueOf(arg_id);
                GlTransformFeedbackAsset targetAsset = GlBindTransformFeedback.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, GlBindTransformFeedback.getGlTransformFeedbackAsset(callbacks, functionCall, null, targetAsset_id_value, AssetItemID.valueOf(0)), targetAsset_id_value);
                targetAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlBindVertexBuffer
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDVERTEXBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_bindingindex = GLES.GlBindVertexBufferDecorator.getArgumentBindingindex(functionCall);
                Long arg_buffer = GLES.GlBindVertexBufferDecorator.getArgumentBuffer(functionCall);
                Long arg_offset = GLES.GlBindVertexBufferDecorator.getArgumentOffset(functionCall);
                Integer arg_stride = GLES.GlBindVertexBufferDecorator.getArgumentStride(functionCall);
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlBindVertexBuffer.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlBindVertexBuffer.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = GlBindVertexBuffer.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                AssetItemID vertexBindingAsset_id_value = AssetItemID.valueOf(arg_bindingindex);
                GlVertexBufferBindingAsset vertexBindingAsset = GlBindVertexBuffer.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, callbacks, functionCall, GlBindVertexBuffer.getOrCreateNewGlVertexBufferBindingAsset(callbacks, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                vertexBindingAsset.addFunctionCall(functionCall);
                AssetItemID bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                GlBufferAsset glBufferAsset = GlBindVertexBuffer.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlBindVertexBuffer.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value);
            }
        }
    }

    public static final class GlClientWaitSync
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCLIENTWAITSYNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_sync = GLES.GlClientWaitSyncDecorator.getArgumentSync(functionCall);
                AbstractConstantOrAliasSpecExtended arg_flags = GLES.GlClientWaitSyncDecorator.getArgumentFlags(functionCall);
                Long arg_timeout = GLES.GlClientWaitSyncDecorator.getArgumentTimeout(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = GLES.GlClientWaitSyncDecorator.getReturnValue(functionCall);
                AssetItemID syncObjectAsset_id_value = AssetItemID.valueOf(arg_sync);
                GlSyncObjectAsset syncObjectAsset = GlClientWaitSync.requireAsset(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS, callbacks, functionCall, GlClientWaitSync.getGlSyncObjectAsset(callbacks, functionCall, null, syncObjectAsset_id_value), syncObjectAsset_id_value);
                syncObjectAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlCompileShader
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCOMPILESHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_shader = GLES.GlCompileShaderDecorator.getArgumentShader(functionCall);
                AssetItemID shaderAsset_id_value = AssetItemID.valueOf(arg_shader);
                GlShaderAsset shaderAsset = GlCompileShader.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, callbacks, functionCall, GlCompileShader.getGlShaderAsset(callbacks, functionCall, null, shaderAsset_id_value), shaderAsset_id_value);
                shaderAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlCompressedTexImage2D
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlCompressedTexImage2DDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlCompressedTexImage2DDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlCompressedTexImage2DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlCompressedTexImage2DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlCompressedTexImage2DDecorator.getArgumentHeight(functionCall);
                Integer arg_border = GLES.GlCompressedTexImage2DDecorator.getArgumentBorder(functionCall);
                Integer arg_imageSize = GLES.GlCompressedTexImage2DDecorator.getArgumentImageSize(functionCall);
                TextureArgAttachment arg_data = GLES.GlCompressedTexImage2DDecorator.getArgumentData(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlCompressedTexImage2D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlCompressedTexImage2D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlCompressedTexImage2D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlCompressedTexImage2D(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_border, arg_imageSize, arg_data);
                AssetItemID textureImageAsset_id_value = AssetItemID.valueOf(arg_level);
                GlTextureImageAsset textureImageAsset = GlCompressedTexImage2D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, callbacks, functionCall, GlCompressedTexImage2D.getGlTextureImageAsset(callbacks, functionCall, null, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlCompressedTexImage3D
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE3D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlCompressedTexImage3DDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlCompressedTexImage3DDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlCompressedTexImage3DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlCompressedTexImage3DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlCompressedTexImage3DDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlCompressedTexImage3DDecorator.getArgumentDepth(functionCall);
                Integer arg_border = GLES.GlCompressedTexImage3DDecorator.getArgumentBorder(functionCall);
                Integer arg_imageSize = GLES.GlCompressedTexImage3DDecorator.getArgumentImageSize(functionCall);
                TextureArgAttachment arg_data = GLES.GlCompressedTexImage3DDecorator.getArgumentData(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlCompressedTexImage3D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlCompressedTexImage3D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlCompressedTexImage3D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlCompressedTexImage3D(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_imageSize, arg_data);
                AssetItemID textureImageAsset_id_value = AssetItemID.valueOf(arg_level);
                GlTextureImageAsset textureImageAsset = GlCompressedTexImage3D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, callbacks, functionCall, GlCompressedTexImage3D.getGlTextureImageAsset(callbacks, functionCall, null, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.addFunctionCall(functionCall);
                arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D);
                arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D);
            }
        }
    }

    public static final class GlCreateProgram
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCREATEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long returnValue_ = GLES.GlCreateProgramDecorator.getReturnValue(functionCall);
                AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                GlProgramAsset returnedAsset = GlCreateProgram.createNewGlProgramAsset(callbacks, functionCall, returnedAsset_id_value);
                GlCreateProgram.processPossibleReplayOverrideAsset(callbacks, functionCall, returnedAsset);
            }
        }
    }

    public static final class GlCreateShader
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCREATESHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlCreateShaderDecorator.getArgumentType(functionCall);
                Long returnValue_ = GLES.GlCreateShaderDecorator.getReturnValue(functionCall);
                AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = GlCreateShader.validateConstantIsInSet(callbacks, functionCall, arg_type, Constants.CONSTANT_SET_0);
                GlShaderAsset returnedAsset = GlCreateShader.createNewGlShaderAsset(callbacks, functionCall, returnedAsset_id_value, temp_validateConstantIsInSet_return_value_0);
                GlCreateShader.processPossibleReplayOverrideAsset(callbacks, functionCall, returnedAsset);
            }
        }
    }

    public static final class GlCreateShaderProgramv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCREATESHADERPROGRAMV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlCreateShaderProgramvDecorator.getArgumentType(functionCall);
                Integer arg_count = GLES.GlCreateShaderProgramvDecorator.getArgumentCount(functionCall);
                StringsArgAttachment arg_strings = GLES.GlCreateShaderProgramvDecorator.getArgumentStrings(functionCall);
                Long returnValue_ = GLES.GlCreateShaderProgramvDecorator.getReturnValue(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(returnValue_);
                GlProgramAsset glProgramAsset = GlCreateShaderProgramv.createNewGlProgramAsset(callbacks, functionCall, programAsset_id_value);
            }
        }
    }

    public static final class GlCreateShaderProgramvExt
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCREATESHADERPROGRAMVEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentType(functionCall);
                Integer arg_count = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentCount(functionCall);
                StringsArgAttachment arg_strings = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentStrings(functionCall);
                Long returnValue_ = GLES.GlCreateShaderProgramvEXTDecorator.getReturnValue(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(returnValue_);
                GlProgramAsset glProgramAsset = GlCreateShaderProgramvExt.createNewGlProgramAsset(callbacks, functionCall, programAsset_id_value);
            }
        }
    }

    public static final class GlDeleteBuffers
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteBuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_buffers = GLES.GlDeleteBuffersDecorator.getArgumentBuffers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_buffers);
                GlDeleteBuffers.forEachAssetItemID(temp_valueOf_return_value_0, bufferAsset_id_value -> {
                    GlBufferAsset bufferAsset = GlDeleteBuffers.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, callbacks, functionCall, GlDeleteBuffers.getGlBufferAsset(callbacks, functionCall, null, bufferAsset_id_value), bufferAsset_id_value, AssetItemID.valueOf(0));
                    if (bufferAsset != null) {
                        bufferAsset.addFunctionCall(functionCall);
                        bufferAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDeleteFramebuffers
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEFRAMEBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteFramebuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_framebuffers = GLES.GlDeleteFramebuffersDecorator.getArgumentFramebuffers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_framebuffers);
                GlDeleteFramebuffers.forEachAssetItemID(temp_valueOf_return_value_0, framebuffersAsset_id_value -> {
                    GlFramebufferAsset framebuffersAsset = GlDeleteFramebuffers.warnIfMissingAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, GlDeleteFramebuffers.getGlFramebufferAsset(callbacks, functionCall, null, framebuffersAsset_id_value, AssetItemID.valueOf(0)), framebuffersAsset_id_value);
                    if (framebuffersAsset != null && !framebuffersAsset.getId().equals(AssetItemID.valueOf(0))) {
                        framebuffersAsset.addFunctionCall(functionCall);
                        framebuffersAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDeleteProgram
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_program;
            AssetItemID programAsset_id_value;
            GlProgramAsset programAsset;
            assert (KapiSpec.GLES.functions.GLDELETEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (programAsset = GlDeleteProgram.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlDeleteProgram.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value = AssetItemID.valueOf(arg_program = GLES.GlDeleteProgramDecorator.getArgumentProgram(functionCall))), programAsset_id_value, AssetItemID.valueOf(0))) != null) {
                programAsset.addFunctionCall(functionCall);
                programAsset.getLifecycleManager().delete(functionCall);
            }
        }
    }

    public static final class GlDeleteProgramPipelines
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEPROGRAMPIPELINES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteProgramPipelinesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_pipelines = GLES.GlDeleteProgramPipelinesDecorator.getArgumentPipelines(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_pipelines);
                GlDeleteProgramPipelines.forEachAssetItemID(temp_valueOf_return_value_0, programPipelineAsset_id_value -> {
                    GlProgramPipelineAsset programPipelineAsset = GlDeleteProgramPipelines.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, callbacks, functionCall, GlDeleteProgramPipelines.getGlProgramPipelineAsset(callbacks, functionCall, null, programPipelineAsset_id_value), programPipelineAsset_id_value, AssetItemID.valueOf(0));
                    if (programPipelineAsset != null) {
                        programPipelineAsset.addFunctionCall(functionCall);
                        programPipelineAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDeleteQueries
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEQUERIES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteQueriesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_ids = GLES.GlDeleteQueriesDecorator.getArgumentIds(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_ids);
                GlDeleteQueries.forEachAssetItemID(temp_valueOf_return_value_0, queryAsset_id_value -> {
                    GlQueryObjectAsset queryAsset = GlDeleteQueries.warnIfMissingAsset(KapiSpec.GLES.assetTables.QUERY_TRAITS, callbacks, functionCall, GlDeleteQueries.getGlQueryObjectAsset(callbacks, functionCall, null, queryAsset_id_value), queryAsset_id_value, AssetItemID.valueOf(0));
                    if (queryAsset != null) {
                        queryAsset.addFunctionCall(functionCall);
                        queryAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDeleteRenderbuffers
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETERENDERBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteRenderbuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_renderbuffers = GLES.GlDeleteRenderbuffersDecorator.getArgumentRenderbuffers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_renderbuffers);
                GlDeleteRenderbuffers.forEachAssetItemID(temp_valueOf_return_value_0, renderbuffersAsset_id_value -> {
                    GlRenderbufferAsset renderbuffersAsset = GlDeleteRenderbuffers.warnIfMissingAsset(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, callbacks, functionCall, GlDeleteRenderbuffers.getGlRenderbufferAsset(callbacks, functionCall, null, renderbuffersAsset_id_value), renderbuffersAsset_id_value, AssetItemID.valueOf(0));
                    if (renderbuffersAsset != null) {
                        renderbuffersAsset.addFunctionCall(functionCall);
                        renderbuffersAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDeleteSamplers
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETESAMPLERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_count = GLES.GlDeleteSamplersDecorator.getArgumentCount(functionCall);
                LongsArgAttachment arg_samplers = GLES.GlDeleteSamplersDecorator.getArgumentSamplers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_samplers);
                GlDeleteSamplers.forEachAssetItemID(temp_valueOf_return_value_0, samplerAsset_id_value -> {
                    GlSamplerAsset samplerAsset = GlDeleteSamplers.warnIfMissingAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlDeleteSamplers.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value, AssetItemID.valueOf(0));
                    if (samplerAsset != null) {
                        samplerAsset.addFunctionCall(functionCall);
                        samplerAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDeleteShader
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_shader;
            AssetItemID shaderAsset_id_value;
            GlShaderAsset shaderAsset;
            assert (KapiSpec.GLES.functions.GLDELETESHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderAsset = GlDeleteShader.warnIfMissingAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, callbacks, functionCall, GlDeleteShader.getGlShaderAsset(callbacks, functionCall, null, shaderAsset_id_value = AssetItemID.valueOf(arg_shader = GLES.GlDeleteShaderDecorator.getArgumentShader(functionCall))), shaderAsset_id_value, AssetItemID.valueOf(0))) != null) {
                shaderAsset.addFunctionCall(functionCall);
                shaderAsset.getLifecycleManager().delete(functionCall);
            }
        }
    }

    public static final class GlDeleteSync
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            Pointer arg_sync;
            AssetItemID syncObjectAsset_id_value;
            GlSyncObjectAsset syncObjectAsset;
            assert (KapiSpec.GLES.functions.GLDELETESYNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (syncObjectAsset = GlDeleteSync.warnIfMissingAsset(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS, callbacks, functionCall, GlDeleteSync.getGlSyncObjectAsset(callbacks, functionCall, null, syncObjectAsset_id_value = AssetItemID.valueOf(arg_sync = GLES.GlDeleteSyncDecorator.getArgumentSync(functionCall))), syncObjectAsset_id_value, AssetItemID.valueOf(0))) != null) {
                syncObjectAsset.addFunctionCall(functionCall);
                syncObjectAsset.getLifecycleManager().delete(functionCall);
            }
        }
    }

    public static final class GlDeleteTextures
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETETEXTURES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteTexturesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_textures = GLES.GlDeleteTexturesDecorator.getArgumentTextures(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_textures);
                GlDeleteTextures.forEachAssetItemID(temp_valueOf_return_value_0, textureAsset_id_value -> {
                    GlTextureAsset textureAsset = GlDeleteTextures.warnIfMissingAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlDeleteTextures.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
                    if (textureAsset != null && !textureAsset.getId().equals(AssetItemID.valueOf(0))) {
                        textureAsset.addFunctionCall(functionCall);
                        textureAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDeleteTransformFeedbacks
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETETRANSFORMFEEDBACKS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteTransformFeedbacksDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_ids = GLES.GlDeleteTransformFeedbacksDecorator.getArgumentIds(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_ids);
                GlDeleteTransformFeedbacks.forEachAssetItemID(temp_valueOf_return_value_0, transformFeedbackAsset_id_value -> {
                    GlTransformFeedbackAsset transformFeedbackAsset = GlDeleteTransformFeedbacks.warnIfMissingAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, GlDeleteTransformFeedbacks.getGlTransformFeedbackAsset(callbacks, functionCall, null, transformFeedbackAsset_id_value, AssetItemID.valueOf(0)), transformFeedbackAsset_id_value);
                    if (transformFeedbackAsset != null && !transformFeedbackAsset.getId().equals(AssetItemID.valueOf(0))) {
                        transformFeedbackAsset.addFunctionCall(functionCall);
                        transformFeedbackAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDeleteVertexArrays
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEVERTEXARRAYS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteVertexArraysDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_arrays = GLES.GlDeleteVertexArraysDecorator.getArgumentArrays(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_arrays);
                GlDeleteVertexArrays.forEachAssetItemID(temp_valueOf_return_value_0, deletedAsset_id_value -> {
                    GlVertexArrayObjectAsset deletedAsset = GlDeleteVertexArrays.warnIfMissingAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, GlDeleteVertexArrays.getGlVertexArrayObjectAsset(callbacks, functionCall, null, deletedAsset_id_value, AssetItemID.valueOf(0)), deletedAsset_id_value);
                    if (deletedAsset != null && !deletedAsset.getId().equals(AssetItemID.valueOf(0))) {
                        deletedAsset.addFunctionCall(functionCall);
                        deletedAsset.getLifecycleManager().delete(functionCall);
                    }
                });
            }
        }
    }

    public static final class GlDetachShader
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDETACHSHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlDetachShaderDecorator.getArgumentProgram(functionCall);
                Long arg_shader = GLES.GlDetachShaderDecorator.getArgumentShader(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                GlProgramAsset programAsset = GlDetachShader.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlDetachShader.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value), programAsset_id_value);
                programAsset.addFunctionCall(functionCall);
                AssetItemID shaderAsset_id_value = AssetItemID.valueOf(arg_shader);
                GlShaderAsset shaderAsset = GlDetachShader.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, callbacks, functionCall, GlDetachShader.getGlShaderAsset(callbacks, functionCall, null, shaderAsset_id_value), shaderAsset_id_value);
                shaderAsset.addFunctionCall(functionCall);
                ProvidedAssetProcessors.processProvidedCallProcessorActionForGlProgramAssetOnGlDetachShader(callbacks, functionCall, programAsset, arg_program, arg_shader, shaderAsset);
            }
        }
    }

    public static final class GlDiscardFramebufferExt
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDISCARDFRAMEBUFFEREXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlDiscardFramebufferEXTDecorator.getArgumentTarget(functionCall);
                Integer arg_numAttachments = GLES.GlDiscardFramebufferEXTDecorator.getArgumentNumAttachments(functionCall);
                LongsArgAttachment arg_attachments = GLES.GlDiscardFramebufferEXTDecorator.getArgumentAttachments(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlDiscardFramebufferExt.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = GlDiscardFramebufferExt.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset targetAsset = GlDiscardFramebufferExt.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                targetAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlEgliMageTargetTexStorageExt
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXSTORAGEEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentTarget(functionCall);
                Pointer arg_image = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentImage(functionCall);
                Pointer arg_attrib_list = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentAttrib_list(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlEgliMageTargetTexStorageExt.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlEgliMageTargetTexStorageExt.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlEgliMageTargetTexStorageExt.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlEgliMageTargetTexture2Does
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURE2DOES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlEGLImageTargetTexture2DOESDecorator.getArgumentTarget(functionCall);
                Pointer arg_image = GLES.GlEGLImageTargetTexture2DOESDecorator.getArgumentImage(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlEgliMageTargetTexture2Does.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlEgliMageTargetTexture2Does.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlEgliMageTargetTexture2Does.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlEgliMageTargetTextureStorageExt
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURESTORAGEEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_texture = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentTexture(functionCall);
                Pointer arg_image = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentImage(functionCall);
                Pointer arg_attrib_list = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentAttrib_list(functionCall);
                AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                GlTextureAsset textureAsset = GlEgliMageTargetTextureStorageExt.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlEgliMageTargetTextureStorageExt.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlEndQuery
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLENDQUERY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlEndQueryDecorator.getArgumentTarget(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlEndQuery.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.QUERY_TARGETS.specObject, arg_target);
                GlQueryObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlEndQuery.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.QUERY_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlQueryObjectAsset queryAsset = GlEndQuery.requireAsset(KapiSpec.GLES.assetTables.QUERY_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                queryAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlEndTransformFeedback
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLENDTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlEndTransformFeedback.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_TRANSFORM_FEEDBACK_BINDING);
                GlTransformFeedbackAsset temp_mapStateValueToAssetObject_return_value_1 = GlEndTransformFeedback.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlTransformFeedbackAsset targetAsset = GlEndTransformFeedback.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                targetAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlFenceSync
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLFENCESYNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_condition = GLES.GlFenceSyncDecorator.getArgumentCondition(functionCall);
                Bitfield arg_flags = GLES.GlFenceSyncDecorator.getArgumentFlags(functionCall);
                Pointer returnValue_ = GLES.GlFenceSyncDecorator.getReturnValue(functionCall);
                AssetItemID syncObjectAsset_id_value = AssetItemID.valueOf(returnValue_);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = GlFenceSync.validateConstantIsInSet(callbacks, functionCall, KapiSpec.GLES.constants.GL_SYNC_FENCE, Constants.CONSTANT_SET_1);
                GlSyncObjectAsset glSyncObjectAsset = GlFenceSync.createNewGlSyncObjectAsset(callbacks, functionCall, syncObjectAsset_id_value, temp_validateConstantIsInSet_return_value_0);
            }
        }
    }

    public static final class GlFramebufferParameteri
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLFRAMEBUFFERPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferParameteriDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlFramebufferParameteriDecorator.getArgumentPname(functionCall);
                Integer arg_param = GLES.GlFramebufferParameteriDecorator.getArgumentParam(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlFramebufferParameteri.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = GlFramebufferParameteri.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset targetAsset = GlFramebufferParameteri.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                targetAsset.addFunctionCall(functionCall);
                arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_WIDTH);
                arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_HEIGHT);
                arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_LAYERS);
                arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_SAMPLES);
                arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS);
            }
        }
    }

    public static final class GlFramebufferTextureMultisampleMultiviewOvr
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attachment = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentAttachment(functionCall);
                Long arg_texture = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentTexture(functionCall);
                Integer arg_level = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentLevel(functionCall);
                Integer arg_samples = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentSamples(functionCall);
                Integer arg_baseViewIndex = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentBaseViewIndex(functionCall);
                Integer arg_numViews = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentNumViews(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlFramebufferTextureMultisampleMultiviewOvr.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = GlFramebufferTextureMultisampleMultiviewOvr.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset framebufferAsset = GlFramebufferTextureMultisampleMultiviewOvr.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                framebufferAsset.addFunctionCall(functionCall);
                AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                GlTextureAsset glTextureAsset = GlFramebufferTextureMultisampleMultiviewOvr.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlFramebufferTextureMultisampleMultiviewOvr.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
            }
        }
    }

    public static final class GlFramebufferTextureMultiviewOvr
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTIVIEWOVR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attachment = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentAttachment(functionCall);
                Long arg_texture = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentTexture(functionCall);
                Integer arg_level = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentLevel(functionCall);
                Integer arg_baseViewIndex = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentBaseViewIndex(functionCall);
                Integer arg_numViews = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentNumViews(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlFramebufferTextureMultiviewOvr.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = GlFramebufferTextureMultiviewOvr.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset framebufferAsset = GlFramebufferTextureMultiviewOvr.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                framebufferAsset.addFunctionCall(functionCall);
                AssetItemID textureAsset_id_value = AssetItemID.valueOf(arg_texture);
                GlTextureAsset glTextureAsset = GlFramebufferTextureMultiviewOvr.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, GlFramebufferTextureMultiviewOvr.getGlTextureAsset(callbacks, functionCall, null, textureAsset_id_value, AssetItemID.valueOf(0)), textureAsset_id_value);
            }
        }
    }

    public static final class GlGenBuffers
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenBuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_buffers = GLES.GlGenBuffersDecorator.getArgumentBuffers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_buffers);
                GlGenBuffers.forEachAssetItemID(temp_valueOf_return_value_0, newBufferAsset_id_value -> {
                    GlBufferAsset glBufferAsset = GlGenBuffers.createNewGlBufferAsset(callbacks, functionCall, newBufferAsset_id_value);
                });
            }
        }
    }

    public static final class GlGenFramebuffers
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENFRAMEBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenFramebuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_framebuffers = GLES.GlGenFramebuffersDecorator.getArgumentFramebuffers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_framebuffers);
                GlGenFramebuffers.forEachAssetItemID(temp_valueOf_return_value_0, framebuffersAsset_id_value -> {
                    GlFramebufferAsset glFramebufferAsset = GlGenFramebuffers.createNewGlFramebufferAsset(callbacks, functionCall, framebuffersAsset_id_value, AssetItemID.valueOf(0));
                });
            }
        }
    }

    public static final class GlGenProgramPipelines
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENPROGRAMPIPELINES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenProgramPipelinesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_pipelines = GLES.GlGenProgramPipelinesDecorator.getArgumentPipelines(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_pipelines);
                GlGenProgramPipelines.forEachAssetItemID(temp_valueOf_return_value_0, programPipelineAsset_id_value -> {
                    GlProgramPipelineAsset glProgramPipelineAsset = GlGenProgramPipelines.createNewGlProgramPipelineAsset(callbacks, functionCall, programPipelineAsset_id_value);
                });
            }
        }
    }

    public static final class GlGenQueries
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENQUERIES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenQueriesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_ids = GLES.GlGenQueriesDecorator.getArgumentIds(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_ids);
                GlGenQueries.forEachAssetItemID(temp_valueOf_return_value_0, queryAsset_id_value -> {
                    GlQueryObjectAsset glQueryObjectAsset = GlGenQueries.createNewGlQueryObjectAsset(callbacks, functionCall, queryAsset_id_value);
                });
            }
        }
    }

    public static final class GlGenRenderbuffers
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENRENDERBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenRenderbuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_renderbuffers = GLES.GlGenRenderbuffersDecorator.getArgumentRenderbuffers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_renderbuffers);
                GlGenRenderbuffers.forEachAssetItemID(temp_valueOf_return_value_0, renderbuffersAsset_id_value -> {
                    GlRenderbufferAsset glRenderbufferAsset = GlGenRenderbuffers.createNewGlRenderbufferAsset(callbacks, functionCall, renderbuffersAsset_id_value);
                });
            }
        }
    }

    public static final class GlGenSamplers
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENSAMPLERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_count = GLES.GlGenSamplersDecorator.getArgumentCount(functionCall);
                LongsArgAttachment arg_samplers = GLES.GlGenSamplersDecorator.getArgumentSamplers(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_samplers);
                GlGenSamplers.forEachAssetItemID(temp_valueOf_return_value_0, samplerAsset_id_value -> {
                    GlSamplerAsset glSamplerAsset = GlGenSamplers.createNewGlSamplerAsset(callbacks, functionCall, samplerAsset_id_value);
                });
            }
        }
    }

    public static final class GlGenTextures
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENTEXTURES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenTexturesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_textures = GLES.GlGenTexturesDecorator.getArgumentTextures(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_textures);
                GlGenTextures.forEachAssetItemID(temp_valueOf_return_value_0, textureAsset_id_value -> {
                    GlTextureAsset glTextureAsset = GlGenTextures.createNewGlTextureAsset(callbacks, functionCall, textureAsset_id_value, AssetItemID.valueOf(0));
                });
            }
        }
    }

    public static final class GlGenTransformFeedbacks
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENTRANSFORMFEEDBACKS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenTransformFeedbacksDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_ids = GLES.GlGenTransformFeedbacksDecorator.getArgumentIds(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_ids);
                GlGenTransformFeedbacks.forEachAssetItemID(temp_valueOf_return_value_0, transformFeedbackAsset_id_value -> {
                    GlTransformFeedbackAsset glTransformFeedbackAsset = GlGenTransformFeedbacks.createNewGlTransformFeedbackAsset(callbacks, functionCall, transformFeedbackAsset_id_value, AssetItemID.valueOf(0));
                });
            }
        }
    }

    public static final class GlGenVertexArrays
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENVERTEXARRAYS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenVertexArraysDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_arrays = GLES.GlGenVertexArraysDecorator.getArgumentArrays(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_arrays);
                GlGenVertexArrays.forEachAssetItemID(temp_valueOf_return_value_0, createdAsset_id_value -> {
                    GlVertexArrayObjectAsset glVertexArrayObjectAsset = GlGenVertexArrays.createNewGlVertexArrayObjectAsset(callbacks, functionCall, createdAsset_id_value, AssetItemID.valueOf(0));
                });
            }
        }
    }

    public static final class GlGenerateMipmap
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENERATEMIPMAP.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlGenerateMipmapDecorator.getArgumentTarget(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlGenerateMipmap.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlGenerateMipmap.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlGenerateMipmap.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlGetQueryObjectuiv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGETQUERYOBJECTUIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_id = GLES.GlGetQueryObjectuivDecorator.getArgumentId(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlGetQueryObjectuivDecorator.getArgumentPname(functionCall);
                LongPtrArgAttachment arg_params = GLES.GlGetQueryObjectuivDecorator.getArgumentParams(functionCall);
                AssetItemID queryAsset_id_value = AssetItemID.valueOf(arg_id);
                GlQueryObjectAsset queryAsset = GlGetQueryObjectuiv.requireAsset(KapiSpec.GLES.assetTables.QUERY_TRAITS, callbacks, functionCall, GlGetQueryObjectuiv.getGlQueryObjectAsset(callbacks, functionCall, null, queryAsset_id_value), queryAsset_id_value);
                queryAsset.addFunctionCall(functionCall);
                arg_pname.equals(KapiSpec.GLES.constants.GL_QUERY_RESULT);
                arg_pname.equals(KapiSpec.GLES.constants.GL_QUERY_RESULT_AVAILABLE);
            }
        }
    }

    public static final class GlInvalidateFramebuffer
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLINVALIDATEFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlInvalidateFramebufferDecorator.getArgumentTarget(functionCall);
                Integer arg_numAttachments = GLES.GlInvalidateFramebufferDecorator.getArgumentNumAttachments(functionCall);
                LongsArgAttachment arg_attachments = GLES.GlInvalidateFramebufferDecorator.getArgumentAttachments(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlInvalidateFramebuffer.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = GlInvalidateFramebuffer.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset targetAsset = GlInvalidateFramebuffer.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                targetAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlInvalidateSubFramebuffer
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLINVALIDATESUBFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlInvalidateSubFramebufferDecorator.getArgumentTarget(functionCall);
                Integer arg_numAttachments = GLES.GlInvalidateSubFramebufferDecorator.getArgumentNumAttachments(functionCall);
                LongsArgAttachment arg_attachments = GLES.GlInvalidateSubFramebufferDecorator.getArgumentAttachments(functionCall);
                Integer arg_x = GLES.GlInvalidateSubFramebufferDecorator.getArgumentX(functionCall);
                Integer arg_y = GLES.GlInvalidateSubFramebufferDecorator.getArgumentY(functionCall);
                Integer arg_width = GLES.GlInvalidateSubFramebufferDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlInvalidateSubFramebufferDecorator.getArgumentHeight(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlInvalidateSubFramebuffer.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = GlInvalidateSubFramebuffer.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset targetAsset = GlInvalidateSubFramebuffer.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                targetAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlLinkProgram
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLLINKPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlLinkProgramDecorator.getArgumentProgram(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                GlProgramAsset programAsset = GlLinkProgram.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlLinkProgram.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value), programAsset_id_value);
                programAsset.addFunctionCall(functionCall);
                ProvidedAssetProcessors.processProvidedCallProcessorActionForGlProgramAssetOnGlLinkProgram(callbacks, functionCall, programAsset, arg_program);
            }
        }
    }

    public static final class GlPauseTransformFeedback
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLPAUSETRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlPauseTransformFeedback.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_TRANSFORM_FEEDBACK_BINDING);
                GlTransformFeedbackAsset temp_mapStateValueToAssetObject_return_value_1 = GlPauseTransformFeedback.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlTransformFeedbackAsset targetAsset = GlPauseTransformFeedback.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                targetAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlProgramParameteri
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLPROGRAMPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlProgramParameteriDecorator.getArgumentProgram(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlProgramParameteriDecorator.getArgumentPname(functionCall);
                Integer arg_value = GLES.GlProgramParameteriDecorator.getArgumentValue(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                GlProgramAsset programAsset = GlProgramParameteri.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlProgramParameteri.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value), programAsset_id_value);
                programAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlRenderbufferStorage
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlRenderbufferStorageDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlRenderbufferStorageDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlRenderbufferStorageDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlRenderbufferStorageDecorator.getArgumentHeight(functionCall);
                if (arg_target.equals(KapiSpec.GLES.constants.GL_RENDERBUFFER)) {
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlRenderbufferStorage.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_RENDERBUFFER_BINDING);
                    GlRenderbufferAsset temp_mapStateValueToAssetObject_return_value_1 = GlRenderbufferStorage.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlRenderbufferAsset targetAsset = GlRenderbufferStorage.requireAsset(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    targetAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class GlRenderbufferStorageMultisample
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGEMULTISAMPLE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentTarget(functionCall);
                Integer arg_samples = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentSamples(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentHeight(functionCall);
                if (arg_target.equals(KapiSpec.GLES.constants.GL_RENDERBUFFER)) {
                    IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlRenderbufferStorageMultisample.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_RENDERBUFFER_BINDING);
                    GlRenderbufferAsset temp_mapStateValueToAssetObject_return_value_1 = GlRenderbufferStorageMultisample.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    GlRenderbufferAsset targetAsset = GlRenderbufferStorageMultisample.requireAsset(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    targetAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class GlResumeTransformFeedback
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLRESUMETRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlResumeTransformFeedback.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_TRANSFORM_FEEDBACK_BINDING);
                GlTransformFeedbackAsset temp_mapStateValueToAssetObject_return_value_1 = GlResumeTransformFeedback.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlTransformFeedbackAsset targetAsset = GlResumeTransformFeedback.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                targetAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlSamplerParameterIiv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterIivDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterIivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_param = GLES.GlSamplerParameterIivDecorator.getArgumentParam(functionCall);
                AssetItemID samplerAsset_id_value = AssetItemID.valueOf(arg_sampler);
                GlSamplerAsset samplerAsset = GlSamplerParameterIiv.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlSamplerParameterIiv.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlSamplerParameterIuiv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIUIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterIuivDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterIuivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_param = GLES.GlSamplerParameterIuivDecorator.getArgumentParam(functionCall);
                AssetItemID samplerAsset_id_value = AssetItemID.valueOf(arg_sampler);
                GlSamplerAsset samplerAsset = GlSamplerParameterIuiv.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlSamplerParameterIuiv.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlSamplerParameterf
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERF.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterfDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterfDecorator.getArgumentPname(functionCall);
                Float arg_param = GLES.GlSamplerParameterfDecorator.getArgumentParam(functionCall);
                AssetItemID samplerAsset_id_value = AssetItemID.valueOf(arg_sampler);
                GlSamplerAsset samplerAsset = GlSamplerParameterf.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlSamplerParameterf.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlSamplerParameterfv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERFV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterfvDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterfvDecorator.getArgumentPname(functionCall);
                FloatsArgAttachment arg_param = GLES.GlSamplerParameterfvDecorator.getArgumentParam(functionCall);
                AssetItemID samplerAsset_id_value = AssetItemID.valueOf(arg_sampler);
                GlSamplerAsset samplerAsset = GlSamplerParameterfv.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlSamplerParameterfv.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlSamplerParameteri
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameteriDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameteriDecorator.getArgumentPname(functionCall);
                AbstractConstantOrAliasSpecExtended arg_param = GLES.GlSamplerParameteriDecorator.getArgumentParam(functionCall);
                AssetItemID samplerAsset_id_value = AssetItemID.valueOf(arg_sampler);
                GlSamplerAsset samplerAsset = GlSamplerParameteri.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlSamplerParameteri.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlSamplerParameteriv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterivDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_param = GLES.GlSamplerParameterivDecorator.getArgumentParam(functionCall);
                AssetItemID samplerAsset_id_value = AssetItemID.valueOf(arg_sampler);
                GlSamplerAsset samplerAsset = GlSamplerParameteriv.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, callbacks, functionCall, GlSamplerParameteriv.getGlSamplerAsset(callbacks, functionCall, null, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlShaderBinary
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSHADERBINARY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_count = GLES.GlShaderBinaryDecorator.getArgumentCount(functionCall);
                LongsArgAttachment arg_shaders = GLES.GlShaderBinaryDecorator.getArgumentShaders(functionCall);
                AbstractConstantOrAliasSpecExtended arg_binaryformat = GLES.GlShaderBinaryDecorator.getArgumentBinaryformat(functionCall);
                BufferArgAttachment arg_binary = GLES.GlShaderBinaryDecorator.getArgumentBinary(functionCall);
                Integer arg_length = GLES.GlShaderBinaryDecorator.getArgumentLength(functionCall);
                List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_shaders);
                GlShaderBinary.forEachAssetItemID(temp_valueOf_return_value_0, shaderAsset_id_value -> {
                    GlShaderAsset shaderAsset = GlShaderBinary.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, callbacks, functionCall, GlShaderBinary.getGlShaderAsset(callbacks, functionCall, null, shaderAsset_id_value), shaderAsset_id_value);
                    shaderAsset.addFunctionCall(functionCall);
                });
            }
        }
    }

    public static final class GlTexImage2D
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXIMAGE2D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage2DDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlTexImage2DDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage2DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexImage2DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexImage2DDecorator.getArgumentHeight(functionCall);
                Integer arg_border = GLES.GlTexImage2DDecorator.getArgumentBorder(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage2DDecorator.getArgumentFormat(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage2DDecorator.getArgumentType(functionCall);
                TextureArgAttachment arg_pixels = GLES.GlTexImage2DDecorator.getArgumentPixels(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexImage2D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexImage2D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexImage2D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage2D(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_border, arg_format, arg_type, arg_pixels);
                AssetItemID textureImageAsset_id_value = AssetItemID.valueOf(arg_level);
                GlTextureImageAsset textureImageAsset = GlTexImage2D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, callbacks, functionCall, GlTexImage2D.getGlTextureImageAsset(callbacks, functionCall, null, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexImage3D
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXIMAGE3D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage3DDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlTexImage3DDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage3DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexImage3DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexImage3DDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlTexImage3DDecorator.getArgumentDepth(functionCall);
                Integer arg_border = GLES.GlTexImage3DDecorator.getArgumentBorder(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage3DDecorator.getArgumentFormat(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage3DDecorator.getArgumentType(functionCall);
                TextureArgAttachment arg_pixels = GLES.GlTexImage3DDecorator.getArgumentPixels(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexImage3D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexImage3D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexImage3D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage3D(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_format, arg_type, arg_pixels);
                AssetItemID textureImageAsset_id_value = AssetItemID.valueOf(arg_level);
                GlTextureImageAsset textureImageAsset = GlTexImage3D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, callbacks, functionCall, GlTexImage3D.getGlTextureImageAsset(callbacks, functionCall, null, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.addFunctionCall(functionCall);
                arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D);
                arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D);
            }
        }
    }

    public static final class GlTexImage3Does
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXIMAGE3DOES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage3DOESDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlTexImage3DOESDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage3DOESDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexImage3DOESDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexImage3DOESDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlTexImage3DOESDecorator.getArgumentDepth(functionCall);
                Integer arg_border = GLES.GlTexImage3DOESDecorator.getArgumentBorder(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage3DOESDecorator.getArgumentFormat(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage3DOESDecorator.getArgumentType(functionCall);
                TextureArgAttachment arg_pixels = GLES.GlTexImage3DOESDecorator.getArgumentPixels(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexImage3Does.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexImage3Does.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexImage3Does.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage3Does(callbacks, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_format, arg_type, arg_pixels);
                AssetItemID textureImageAsset_id_value = AssetItemID.valueOf(arg_level);
                GlTextureImageAsset textureImageAsset = GlTexImage3Does.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, callbacks, functionCall, GlTexImage3Does.getGlTextureImageAsset(callbacks, functionCall, null, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexParameterIiv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERIIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterIivDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterIivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_params = GLES.GlTexParameterIivDecorator.getArgumentParams(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexParameterIiv.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexParameterIiv.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexParameterIiv.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexParameterIuiv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERIUIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterIuivDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterIuivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_params = GLES.GlTexParameterIuivDecorator.getArgumentParams(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexParameterIuiv.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexParameterIuiv.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexParameterIuiv.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexParameterf
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERF.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterfDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterfDecorator.getArgumentPname(functionCall);
                Float arg_param = GLES.GlTexParameterfDecorator.getArgumentParam(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexParameterf.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexParameterf.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexParameterf.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexParameterfv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERFV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterfvDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterfvDecorator.getArgumentPname(functionCall);
                FloatsArgAttachment arg_params = GLES.GlTexParameterfvDecorator.getArgumentParams(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexParameterfv.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexParameterfv.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexParameterfv.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexParameteri
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameteriDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameteriDecorator.getArgumentPname(functionCall);
                AbstractConstantOrAliasSpecExtended arg_param = GLES.GlTexParameteriDecorator.getArgumentParam(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexParameteri.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexParameteri.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexParameteri.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexParameteriv
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterivDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_params = GLES.GlTexParameterivDecorator.getArgumentParams(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexParameteriv.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexParameteriv.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexParameteriv.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexStorage2D
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXSTORAGE2D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage2DDecorator.getArgumentTarget(functionCall);
                Integer arg_levels = GLES.GlTexStorage2DDecorator.getArgumentLevels(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage2DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexStorage2DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexStorage2DDecorator.getArgumentHeight(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexStorage2D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexStorage2D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexStorage2D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
                GlTexStorage2D.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage2D(callbacks, functionCall, textureAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height), textureSurfaceAsset_asset_value -> {
                    GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                    GlTexStorage2D.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureImageAssetForGlTexStorage2D(callbacks, functionCall, textureSurfaceAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height), textureImageAsset_asset_value -> {
                        GlTextureImageAsset textureImageAsset = textureImageAsset_asset_value;
                        textureImageAsset.addFunctionCall(functionCall);
                    });
                });
            }
        }
    }

    public static final class GlTexStorage2DmUltisample
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXSTORAGE2DMULTISAMPLE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage2DMultisampleDecorator.getArgumentTarget(functionCall);
                Integer arg_samples = GLES.GlTexStorage2DMultisampleDecorator.getArgumentSamples(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage2DMultisampleDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexStorage2DMultisampleDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexStorage2DMultisampleDecorator.getArgumentHeight(functionCall);
                AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations = GLES.GlTexStorage2DMultisampleDecorator.getArgumentFixedsamplelocations(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexStorage2DmUltisample.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexStorage2DmUltisample.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexStorage2DmUltisample.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage2DmUltisample(callbacks, functionCall, textureAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_fixedsamplelocations);
                GlTextureImageAsset textureImageAsset = ProvidedAssetProcessors.provideGlTextureImageAssetForGlTexStorage2DmUltisample(callbacks, functionCall, textureSurfaceAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_fixedsamplelocations);
                textureImageAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlTexStorage3D
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXSTORAGE3D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage3DDecorator.getArgumentTarget(functionCall);
                Integer arg_levels = GLES.GlTexStorage3DDecorator.getArgumentLevels(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage3DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexStorage3DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexStorage3DDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlTexStorage3DDecorator.getArgumentDepth(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexStorage3D.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexStorage3D.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexStorage3D.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
                GlTexStorage3D.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage3D(callbacks, functionCall, textureAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height, arg_depth), textureSurfaceAsset_asset_value -> {
                    GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                    GlTexStorage3D.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureImageAssetForGlTexStorage3D(callbacks, functionCall, textureSurfaceAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height, arg_depth), textureImageAsset_asset_value -> {
                        GlTextureImageAsset textureImageAsset = textureImageAsset_asset_value;
                        textureImageAsset.addFunctionCall(functionCall);
                    });
                });
            }
        }
    }

    public static final class GlTexStorage3DmUltisample
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXSTORAGE3DMULTISAMPLE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage3DMultisampleDecorator.getArgumentTarget(functionCall);
                Integer arg_samples = GLES.GlTexStorage3DMultisampleDecorator.getArgumentSamples(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage3DMultisampleDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexStorage3DMultisampleDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexStorage3DMultisampleDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlTexStorage3DMultisampleDecorator.getArgumentDepth(functionCall);
                AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations = GLES.GlTexStorage3DMultisampleDecorator.getArgumentFixedsamplelocations(functionCall);
                IStateItemValue<GLESApi> temp_mapTargetToStateValue_return_value_0 = GlTexStorage3DmUltisample.mapTargetToStateValue(callbacks, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = GlTexStorage3DmUltisample.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapTargetToStateValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = GlTexStorage3DmUltisample.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                textureAsset.addFunctionCall(functionCall);
                GlTexStorage3DmUltisample.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage3DmUltisample(callbacks, functionCall, textureAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_depth, arg_fixedsamplelocations), textureSurfaceAsset_asset_value -> {
                    GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                    GlTextureImageAsset textureImageAsset = ProvidedAssetProcessors.provideGlTextureImageAssetForGlTexStorage3DmUltisample(callbacks, functionCall, textureSurfaceAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_depth, arg_fixedsamplelocations);
                    textureImageAsset.addFunctionCall(functionCall);
                });
            }
        }
    }

    public static final class GlUseProgram
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_program;
            AssetItemID programAsset_id_value;
            GlProgramAsset programAsset;
            assert (KapiSpec.GLES.functions.GLUSEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (programAsset = GlUseProgram.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlUseProgram.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value = AssetItemID.valueOf(arg_program = GLES.GlUseProgramDecorator.getArgumentProgram(functionCall))), programAsset_id_value, AssetItemID.valueOf(0))) != null) {
                programAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlUseProgramStages
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLUSEPROGRAMSTAGES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_pipeline = GLES.GlUseProgramStagesDecorator.getArgumentPipeline(functionCall);
                Bitfield arg_stages = GLES.GlUseProgramStagesDecorator.getArgumentStages(functionCall);
                Long arg_program = GLES.GlUseProgramStagesDecorator.getArgumentProgram(functionCall);
                AssetItemID programPipelineAsset_id_value = AssetItemID.valueOf(arg_pipeline);
                GlProgramPipelineAsset programPipelineAsset = GlUseProgramStages.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, callbacks, functionCall, GlUseProgramStages.getGlProgramPipelineAsset(callbacks, functionCall, null, programPipelineAsset_id_value), programPipelineAsset_id_value);
                programPipelineAsset.addFunctionCall(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                GlProgramAsset glProgramAsset = GlUseProgramStages.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, callbacks, functionCall, GlUseProgramStages.getGlProgramAsset(callbacks, functionCall, null, programAsset_id_value), programAsset_id_value, AssetItemID.valueOf(0));
            }
        }
    }

    public static final class GlVertexAttribBinding
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXATTRIBBINDING.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_attribindex = GLES.GlVertexAttribBindingDecorator.getArgumentAttribindex(functionCall);
                Long arg_bindingindex = GLES.GlVertexAttribBindingDecorator.getArgumentBindingindex(functionCall);
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexAttribBinding.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexAttribBinding.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribBinding.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                AssetItemID vertexAttributeAsset_id_value = AssetItemID.valueOf(arg_attribindex);
                GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 = AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(callbacks, functionCall, vertexAttributeAsset_id_value);
                assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 != null);
                GlVertexAttributeAsset temp_temp_4 = !vertexAttributeAsset_id_value.equals(AssetItemID.valueOf(-1)) ? GlVertexAttribBinding.getOrCreateNewGlVertexAttributeAsset(callbacks, functionCall, vertexArrayAsset, vertexAttributeAsset_id_value, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3) : null;
                GlVertexAttributeAsset vertexAttributeAsset = GlVertexAttribBinding.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_TRAITS, callbacks, functionCall, temp_temp_4, vertexAttributeAsset_id_value);
                vertexAttributeAsset.addFunctionCall(functionCall);
                AssetItemID vertexBindingAsset_id_value = AssetItemID.valueOf(arg_bindingindex);
                GlVertexBufferBindingAsset glVertexBufferBindingAsset = GlVertexAttribBinding.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, callbacks, functionCall, GlVertexAttribBinding.getOrCreateNewGlVertexBufferBindingAsset(callbacks, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
            }
        }
    }

    public static final class GlVertexAttribDivisor
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXATTRIBDIVISOR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_index = GLES.GlVertexAttribDivisorDecorator.getArgumentIndex(functionCall);
                Long arg_divisor = GLES.GlVertexAttribDivisorDecorator.getArgumentDivisor(functionCall);
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexAttribDivisor.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexAttribDivisor.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                AssetItemID vertexAttributeAsset_id_value = AssetItemID.valueOf(arg_index);
                GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 = AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(callbacks, functionCall, vertexAttributeAsset_id_value);
                assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 != null);
                GlVertexAttributeAsset temp_temp_4 = !vertexAttributeAsset_id_value.equals(AssetItemID.valueOf(-1)) ? GlVertexAttribDivisor.getOrCreateNewGlVertexAttributeAsset(callbacks, functionCall, vertexArrayAsset, vertexAttributeAsset_id_value, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3) : null;
                GlVertexAttributeAsset vertexAttributeAsset = GlVertexAttribDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_TRAITS, callbacks, functionCall, temp_temp_4, vertexAttributeAsset_id_value);
                vertexAttributeAsset.addFunctionCall(functionCall);
                AssetItemID vertexBindingAsset_id_value = AssetItemID.valueOf(arg_index);
                GlVertexBufferBindingAsset vertexBindingAsset = GlVertexAttribDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, callbacks, functionCall, GlVertexAttribDivisor.getOrCreateNewGlVertexBufferBindingAsset(callbacks, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                vertexBindingAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlVertexAttribFormat
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXATTRIBFORMAT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_attribindex = GLES.GlVertexAttribFormatDecorator.getArgumentAttribindex(functionCall);
                Integer arg_size = GLES.GlVertexAttribFormatDecorator.getArgumentSize(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlVertexAttribFormatDecorator.getArgumentType(functionCall);
                AbstractConstantOrAliasSpecExtended arg_normalized = GLES.GlVertexAttribFormatDecorator.getArgumentNormalized(functionCall);
                Long arg_relativeoffset = GLES.GlVertexAttribFormatDecorator.getArgumentRelativeoffset(functionCall);
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexAttribFormat.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexAttribFormat.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribFormat.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                AssetItemID vertexAttributeAsset_id_value = AssetItemID.valueOf(arg_attribindex);
                GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 = AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(callbacks, functionCall, vertexAttributeAsset_id_value);
                assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 != null);
                GlVertexAttributeAsset temp_temp_4 = !vertexAttributeAsset_id_value.equals(AssetItemID.valueOf(-1)) ? GlVertexAttribFormat.getOrCreateNewGlVertexAttributeAsset(callbacks, functionCall, vertexArrayAsset, vertexAttributeAsset_id_value, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3) : null;
                GlVertexAttributeAsset vertexAttributeAsset = GlVertexAttribFormat.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_TRAITS, callbacks, functionCall, temp_temp_4, vertexAttributeAsset_id_value);
                vertexAttributeAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlVertexAttribIfOrmat
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXATTRIBIFORMAT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_attribindex = GLES.GlVertexAttribIFormatDecorator.getArgumentAttribindex(functionCall);
                Integer arg_size = GLES.GlVertexAttribIFormatDecorator.getArgumentSize(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlVertexAttribIFormatDecorator.getArgumentType(functionCall);
                Long arg_relativeoffset = GLES.GlVertexAttribIFormatDecorator.getArgumentRelativeoffset(functionCall);
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexAttribIfOrmat.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexAttribIfOrmat.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = GlVertexAttribIfOrmat.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                AssetItemID vertexAttributeAsset_id_value = AssetItemID.valueOf(arg_attribindex);
                GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 = AbstractGlesAssetValueProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(callbacks, functionCall, vertexAttributeAsset_id_value);
                assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 != null);
                GlVertexAttributeAsset temp_temp_4 = !vertexAttributeAsset_id_value.equals(AssetItemID.valueOf(-1)) ? GlVertexAttribIfOrmat.getOrCreateNewGlVertexAttributeAsset(callbacks, functionCall, vertexArrayAsset, vertexAttributeAsset_id_value, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3) : null;
                GlVertexAttributeAsset vertexAttributeAsset = GlVertexAttribIfOrmat.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_TRAITS, callbacks, functionCall, temp_temp_4, vertexAttributeAsset_id_value);
                vertexAttributeAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlVertexBindingDivisor
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXBINDINGDIVISOR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_bindingindex = GLES.GlVertexBindingDivisorDecorator.getArgumentBindingindex(functionCall);
                Long arg_divisor = GLES.GlVertexBindingDivisorDecorator.getArgumentDivisor(functionCall);
                IStateItemValue<GLESApi> temp_getStateItemValue_return_value_0 = GlVertexBindingDivisor.getStateItemValue(callbacks, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = GlVertexBindingDivisor.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = GlVertexBindingDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                AssetItemID vertexBindingAsset_id_value = AssetItemID.valueOf(arg_bindingindex);
                GlVertexBufferBindingAsset vertexBindingAsset = GlVertexBindingDivisor.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, callbacks, functionCall, GlVertexBindingDivisor.getOrCreateNewGlVertexBufferBindingAsset(callbacks, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                vertexBindingAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class GlWaitSync
    extends AbstractGlesAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLWAITSYNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_sync = GLES.GlWaitSyncDecorator.getArgumentSync(functionCall);
                AbstractConstantOrAliasSpecExtended arg_flags = GLES.GlWaitSyncDecorator.getArgumentFlags(functionCall);
                AbstractConstantOrAliasSpecExtended arg_timeout = GLES.GlWaitSyncDecorator.getArgumentTimeout(functionCall);
                AssetItemID syncObjectAsset_id_value = AssetItemID.valueOf(arg_sync);
                GlSyncObjectAsset syncObjectAsset = GlWaitSync.requireAsset(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS, callbacks, functionCall, GlWaitSync.getGlSyncObjectAsset(callbacks, functionCall, null, syncObjectAsset_id_value), syncObjectAsset_id_value);
                syncObjectAsset.addFunctionCall(functionCall);
            }
        }
    }
}

