/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.egl;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.EGL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.egl.EglConfigAsset;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.egl.EglImageAsset;
import com.arm.mgd.lightweight.asset.egl.EglPbufferSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglPixmapSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglSyncAsset;
import com.arm.mgd.lightweight.asset.egl.EglWindowSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglConfigAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglContextAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglImageAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglPbufferSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglSyncAsset;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetValueProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.ProvidedAssetProcessors;
import com.arm.mgd.lightweight.asset.processor.egl.AbstractEglAssetValueProcessorBase;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.MapPropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimplePropertyValue;
import com.arm.mgd.lightweight.model.api.EGLApi;
import com.arm.mgd.lightweight.state.IStateItemValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class EglAssetValueProcessor {

    private static class Constants {
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_0 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_GREEN_SIZE, KapiSpec.EGL.constants.EGL_NATIVE_VISUAL_ID, KapiSpec.EGL.constants.EGL_NATIVE_VISUAL_TYPE, KapiSpec.EGL.constants.EGL_DEPTH_SIZE, KapiSpec.EGL.constants.EGL_CONFIG_CAVEAT, KapiSpec.EGL.constants.EGL_ALPHA_SIZE, KapiSpec.EGL.constants.EGL_LEVEL, KapiSpec.EGL.constants.EGL_MIN_SWAP_INTERVAL, KapiSpec.EGL.constants.EGL_SURFACE_TYPE, KapiSpec.EGL.constants.EGL_TRANSPARENT_GREEN_VALUE, KapiSpec.EGL.constants.EGL_NONE, KapiSpec.EGL.constants.EGL_RECORDABLE_ANDROID, KapiSpec.EGL.constants.EGL_LUMINANCE_SIZE, KapiSpec.EGL.constants.EGL_FRAMEBUFFER_TARGET_ANDROID, KapiSpec.EGL.constants.EGL_MATCH_NATIVE_PIXMAP, KapiSpec.EGL.constants.EGL_MAX_SWAP_INTERVAL, KapiSpec.EGL.constants.EGL_RED_SIZE, KapiSpec.EGL.constants.EGL_BUFFER_SIZE, KapiSpec.EGL.constants.EGL_TRANSPARENT_BLUE_VALUE, KapiSpec.EGL.constants.EGL_BLUE_SIZE, KapiSpec.EGL.constants.EGL_BIND_TO_TEXTURE_RGBA, KapiSpec.EGL.constants.EGL_SAMPLES, KapiSpec.EGL.constants.EGL_ALPHA_MASK_SIZE, KapiSpec.EGL.constants.EGL_TRANSPARENT_RED_VALUE, KapiSpec.EGL.constants.EGL_TRANSPARENT_TYPE, KapiSpec.EGL.constants.EGL_NATIVE_RENDERABLE, KapiSpec.EGL.constants.EGL_MATCH_FORMAT_KHR, KapiSpec.EGL.constants.EGL_BIND_TO_TEXTURE_RGB, KapiSpec.EGL.constants.EGL_CONFORMANT, KapiSpec.EGL.constants.EGL_MAX_PBUFFER_PIXELS, KapiSpec.EGL.constants.EGL_MAX_PBUFFER_WIDTH, KapiSpec.EGL.constants.EGL_SAMPLE_BUFFERS, KapiSpec.EGL.constants.EGL_RENDERABLE_TYPE, KapiSpec.EGL.constants.EGL_MAX_PBUFFER_HEIGHT, KapiSpec.EGL.constants.EGL_CONFIG_ID, KapiSpec.EGL.constants.EGL_COLOR_BUFFER_TYPE, KapiSpec.EGL.constants.EGL_STENCIL_SIZE));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_1 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_NONE, KapiSpec.EGL.constants.EGL_CONTEXT_MINOR_VERSION_KHR, KapiSpec.EGL.constants.EGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY_KHR, KapiSpec.EGL.constants.EGL_CONTEXT_CLIENT_TYPE, KapiSpec.EGL.constants.EGL_CONTEXT_CLIENT_VERSION, KapiSpec.EGL.constants.EGL_CONTEXT_OPENGL_PROFILE_MASK_KHR, KapiSpec.EGL.constants.EGL_CONFIG_ID, KapiSpec.EGL.constants.EGL_RENDER_BUFFER, KapiSpec.EGL.constants.EGL_CONTEXT_PRIORITY_LEVEL_IMG, KapiSpec.EGL.constants.EGL_CONTEXT_FLAGS_KHR));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_2 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_IMAGE_CROP_LEFT_ANDROID, KapiSpec.EGL.constants.EGL_IMAGE_CROP_TOP_ANDROID, KapiSpec.EGL.constants.EGL_DRM_BUFFER_FORMAT_MESA, KapiSpec.EGL.constants.EGL_HEIGHT, KapiSpec.EGL.constants.EGL_WIDTH, KapiSpec.EGL.constants.EGL_IMAGE_CROP_RIGHT_ANDROID, KapiSpec.EGL.constants.EGL_IMAGE_PRESERVED_KHR, KapiSpec.EGL.constants.EGL_WAYLAND_PLANE_WL, KapiSpec.EGL.constants.EGL_GL_TEXTURE_ZOFFSET_KHR, KapiSpec.EGL.constants.EGL_DRM_BUFFER_STRIDE_MESA, KapiSpec.EGL.constants.EGL_GL_TEXTURE_LEVEL_KHR, KapiSpec.EGL.constants.EGL_IMAGE_CROP_BOTTOM_ANDROID));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_3 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_SYNC_CONDITION_KHR, KapiSpec.EGL.constants.EGL_SYNC_STATUS_KHR, KapiSpec.EGL.constants.EGL_SYNC_TYPE_KHR, KapiSpec.EGL.constants.EGL_SYNC_NATIVE_FENCE_FD_ANDROID));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_4 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_UNSIGNALED_KHR, KapiSpec.EGL.constants.EGL_SIGNALED_KHR));
        public static final Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_5 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_FRONT_BUFFER_AUTO_REFRESH_ANDROID, KapiSpec.EGL.constants.EGL_MIPMAP_TEXTURE, KapiSpec.EGL.constants.EGL_RENDER_BUFFER, KapiSpec.EGL.constants.EGL_TEXTURE_FORMAT, KapiSpec.EGL.constants.EGL_LARGEST_PBUFFER, KapiSpec.EGL.constants.EGL_PIXEL_ASPECT_RATIO, KapiSpec.EGL.constants.EGL_HORIZONTAL_RESOLUTION, KapiSpec.EGL.constants.EGL_VG_ALPHA_FORMAT, KapiSpec.EGL.constants.EGL_NONE, KapiSpec.EGL.constants.EGL_SWAP_BEHAVIOR, KapiSpec.EGL.constants.EGL_MIPMAP_LEVEL, KapiSpec.EGL.constants.EGL_TEXTURE_TARGET, KapiSpec.EGL.constants.EGL_HEIGHT, KapiSpec.EGL.constants.EGL_WIDTH, KapiSpec.EGL.constants.EGL_VERTICAL_RESOLUTION, KapiSpec.EGL.constants.EGL_MULTISAMPLE_RESOLVE, KapiSpec.EGL.constants.ALIAS_EGL_GL_COLORSPACE_KHR, KapiSpec.EGL.constants.EGL_VG_COLORSPACE));

        private Constants() {
        }
    }

    public static final class EglConfigAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<EGLApi, EglConfigAsset, EglConfigAsset.Value> {
        public static final @NonNull EglConfigAssetValueProcessor INSTANCE = new EglConfigAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.EGL.functions.EGLCHOOSECONFIG, EglChooseConfig.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLGETCONFIGATTRIB, EglGetConfigAttrib.HELPER_INSTANCE);
            }
        };

        private EglConfigAssetValueProcessor() {
        }

        @Override
        public @NonNull EglConfigAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglConfigAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglConfigAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglConfigAsset.EglConfigAssetProperties.PROPERTY_ATTRIBUTES);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attributes)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglConfigAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes);
        }

        @Override
        public @NonNull EglConfigAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglConfigAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull EglConfigAsset assetObject = (EglConfigAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglConfigAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getAttributes());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attributes)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglConfigAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglConfigAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attributes);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                EglConfigAsset.Value processedValue;
                EglConfigAsset.Value unProcessedValue = new EglConfigAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attributes.setValueFrom(functionCall, processedValue.getAttributes());
            }
            return result;
        }

        private static final class EglChooseConfig
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglChooseConfig HELPER_INSTANCE = new EglChooseConfig();

            private EglChooseConfig() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglConfigAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCHOOSECONFIG.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglChooseConfigDecorator.getArgumentDpy(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglChooseConfigDecorator.getArgumentAttrib_list(functionCall);
                    LongsArgAttachment arg_configs = EGL.EglChooseConfigDecorator.getArgumentConfigs(functionCall);
                    Integer arg_config_size = EGL.EglChooseConfigDecorator.getArgumentConfig_size(functionCall);
                    LongPtrArgAttachment arg_num_config = EGL.EglChooseConfigDecorator.getArgumentNum_config(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglChooseConfigDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglChooseConfig.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglChooseConfig.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglConfigAsset configsAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglChooseConfig.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_0);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglGetConfigAttrib
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglGetConfigAttrib HELPER_INSTANCE = new EglGetConfigAttrib();

            private EglGetConfigAttrib() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglConfigAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes) throws Exception {
                assert (KapiSpec.EGL.functions.EGLGETCONFIGATTRIB.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglGetConfigAttribDecorator.getArgumentDpy(functionCall);
                    Pointer arg_config = EGL.EglGetConfigAttribDecorator.getArgumentConfig(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglGetConfigAttribDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglGetConfigAttribDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglGetConfigAttribDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglGetConfigAttrib.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglGetConfigAttrib.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglConfigAsset configAsset = assetObject;
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = EglGetConfigAttrib.validateConstantIsInSet(callbacks, functionCall, arg_attribute, Constants.CONSTANT_SET_0);
                        assert (temp_validateConstantIsInSet_return_value_0 != null);
                        property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_0, arg_value.getValue());
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> var1, @NonNull EglConfigAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> var4) throws Exception;
        }
    }

    public static final class EglContextAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<EGLApi, EglContextAsset, EglContextAsset.Value> {
        public static final @NonNull EglContextAssetValueProcessor INSTANCE = new EglContextAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.EGL.functions.EGLCREATECONTEXT, EglCreateContext.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLQUERYCONTEXT, EglQueryContext.HELPER_INSTANCE);
            }
        };

        private EglContextAssetValueProcessor() {
        }

        @Override
        public @NonNull EglContextAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglContextAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglContextAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglContextAsset.EglContextAssetProperties.PROPERTY_ATTRIBUTES);
            ImmutablePropertyValue<@NonNull EglConfigAsset> config = assetObject.getImmutablePropertyConfig();
            ImmutablePropertyValue<@Nullable EglContextAsset> sharedContext = assetObject.getImmutablePropertySharedContext();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attributes, config, sharedContext)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglContextAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<EglContextAsset>)sharedContext);
        }

        @Override
        public @NonNull EglContextAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglContextAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull EglContextAsset assetObject = (EglContextAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglContextAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getAttributes());
            ImmutablePropertyValue<@NonNull EglConfigAsset> config = assetObject.getImmutablePropertyConfig();
            ImmutablePropertyValue<@Nullable EglContextAsset> sharedContext = assetObject.getImmutablePropertySharedContext();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attributes, config, sharedContext)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglContextAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<EglContextAsset>)sharedContext);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglContextAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> config, @NonNull ImmutablePropertyValue<@Nullable EglContextAsset> sharedContext) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attributes, config, sharedContext);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                EglContextAsset.Value processedValue;
                EglContextAsset.Value unProcessedValue = new EglContextAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<EglContextAsset>)sharedContext);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attributes.setValueFrom(functionCall, processedValue.getAttributes());
            }
            return result;
        }

        private static final class EglCreateContext
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreateContext HELPER_INSTANCE = new EglCreateContext();

            private EglCreateContext() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglContextAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull ImmutablePropertyValue<@Nullable EglContextAsset> property_sharedContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATECONTEXT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreateContextDecorator.getArgumentDpy(functionCall);
                    Pointer arg_config = EGL.EglCreateContextDecorator.getArgumentConfig(functionCall);
                    Pointer arg_share_context = EGL.EglCreateContextDecorator.getArgumentShare_context(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreateContextDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreateContextDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreateContext.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateContext.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglContextAsset share_contextAsset = assetObject;
                        EglContextAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreateContext.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_1);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglQueryContext
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglQueryContext HELPER_INSTANCE = new EglQueryContext();

            private EglQueryContext() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglContextAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull ImmutablePropertyValue<@Nullable EglContextAsset> property_sharedContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLQUERYCONTEXT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglQueryContextDecorator.getArgumentDpy(functionCall);
                    Pointer arg_ctx = EGL.EglQueryContextDecorator.getArgumentCtx(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQueryContextDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglQueryContextDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQueryContextDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglQueryContext.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQueryContext.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglContextAsset ctxAsset = assetObject;
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = EglQueryContext.validateConstantIsInSet(callbacks, functionCall, arg_attribute, Constants.CONSTANT_SET_1);
                        assert (temp_validateConstantIsInSet_return_value_0 != null);
                        property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_0, arg_value.getValue());
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> var1, @NonNull EglContextAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> var4, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> var5, @NonNull ImmutablePropertyValue<@Nullable EglContextAsset> var6) throws Exception;
        }
    }

    public static final class EglDisplayAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<EGLApi, EglDisplayAsset, EglDisplayAsset.Value> {
        public static final @NonNull EglDisplayAssetValueProcessor INSTANCE = new EglDisplayAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private EglDisplayAssetValueProcessor() {
        }

        @Override
        public @NonNull EglDisplayAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglDisplayAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglDisplayAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@Nullable Pointer> nativeDisplayID = assetObject.getImmutablePropertyNativeDisplayId();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, nativeDisplayID)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglDisplayAsset.Value(validRange, assetObject, (IAssetPropertyValue<Pointer>)nativeDisplayID);
        }

        @Override
        public @NonNull EglDisplayAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglDisplayAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull EglDisplayAsset assetObject = (EglDisplayAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglDisplayAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@Nullable Pointer> nativeDisplayID = assetObject.getImmutablePropertyNativeDisplayId();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, nativeDisplayID)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglDisplayAsset.Value(validRange, assetObject, (IAssetPropertyValue<Pointer>)nativeDisplayID);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglDisplayAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@Nullable Pointer> nativeDisplayID) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, nativeDisplayID);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                EglDisplayAsset.Value processedValue;
                EglDisplayAsset.Value unProcessedValue = new EglDisplayAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Pointer>)nativeDisplayID);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> var1, @NonNull EglDisplayAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@Nullable Pointer> var4) throws Exception;
        }
    }

    public static final class EglImageAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<EGLApi, EglImageAsset, EglImageAsset.Value> {
        public static final @NonNull EglImageAssetValueProcessor INSTANCE = new EglImageAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.EGL.functions.EGLCREATEIMAGEKHR, EglCreateImageKhr.HELPER_INSTANCE);
            }
        };

        private EglImageAssetValueProcessor() {
        }

        @Override
        public @NonNull EglImageAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglImageAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglImageAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglImageAsset.EglImageAssetProperties.PROPERTY_ATTRIBUTES);
            ImmutablePropertyValue<@Nullable Pointer> clientObjectID = assetObject.getImmutablePropertyClientObjectId();
            ImmutablePropertyValue<@Nullable EglContextAsset> sourceContext = assetObject.getImmutablePropertySourceContext();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> target = assetObject.getImmutablePropertyTarget();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attributes, clientObjectID, sourceContext, target)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglImageAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<Pointer>)clientObjectID, (IAssetPropertyValue<EglContextAsset>)sourceContext, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)target);
        }

        @Override
        public @NonNull EglImageAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglImageAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull EglImageAsset assetObject = (EglImageAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglImageAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getAttributes());
            ImmutablePropertyValue<@Nullable Pointer> clientObjectID = assetObject.getImmutablePropertyClientObjectId();
            ImmutablePropertyValue<@Nullable EglContextAsset> sourceContext = assetObject.getImmutablePropertySourceContext();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> target = assetObject.getImmutablePropertyTarget();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attributes, clientObjectID, sourceContext, target)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglImageAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<Pointer>)clientObjectID, (IAssetPropertyValue<EglContextAsset>)sourceContext, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)target);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> clientObjectID, @NonNull ImmutablePropertyValue<@Nullable EglContextAsset> sourceContext, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> target) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attributes, clientObjectID, sourceContext, target);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                EglImageAsset.Value processedValue;
                EglImageAsset.Value unProcessedValue = new EglImageAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<Pointer>)clientObjectID, (IAssetPropertyValue<EglContextAsset>)sourceContext, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)target);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attributes.setValueFrom(functionCall, processedValue.getAttributes());
            }
            return result;
        }

        private static final class EglCreateImageKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreateImageKhr HELPER_INSTANCE = new EglCreateImageKhr();

            private EglCreateImageKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglImageAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_clientObjectID, @NonNull ImmutablePropertyValue<@Nullable EglContextAsset> property_sourceContext, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_target) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATEIMAGEKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreateImageKHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_ctx = EGL.EglCreateImageKHRDecorator.getArgumentCtx(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_target = EGL.EglCreateImageKHRDecorator.getArgumentTarget(functionCall);
                    Pointer arg_buffer = EGL.EglCreateImageKHRDecorator.getArgumentBuffer(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreateImageKHRDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreateImageKHRDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreateImageKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateImageKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        AssetItemID ctxAsset_id_value = AssetItemID.valueOf(arg_ctx);
                        EglContextAsset ctxAsset = EglCreateImageKhr.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, EglCreateImageKhr.getEglContextAsset(callbacks, functionCall, null, dpyAsset, ctxAsset_id_value), ctxAsset_id_value, AssetItemID.valueOf(0));
                        EglImageAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreateImageKhr.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_2);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> var1, @NonNull EglImageAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> var4, @NonNull ImmutablePropertyValue<@Nullable Pointer> var5, @NonNull ImmutablePropertyValue<@Nullable EglContextAsset> var6, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7) throws Exception;
        }
    }

    public static final class EglPbufferSurfaceAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<EGLApi, EglPbufferSurfaceAsset, EglPbufferSurfaceAsset.Value> {
        public static final @NonNull EglPbufferSurfaceAssetValueProcessor INSTANCE = new EglPbufferSurfaceAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.EGL.functions.EGLBINDTEXIMAGE, EglBindTexImage.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLCREATEPBUFFERFROMCLIENTBUFFER, EglCreatePbufferFromClientBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLCREATEPBUFFERSURFACE, EglCreatePbufferSurface.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLLOCKSURFACEKHR, EglLockSurfaceKhr.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLQUERYSURFACE, EglQuerySurface.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR, EglQuerySurface64Khr.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLRELEASETEXIMAGE, EglReleaseTexImage.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLSURFACEATTRIB, EglSurfaceAttrib.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLSWAPBUFFERS, EglSwapBuffers.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR, EglUnlockSurfaceKhr.HELPER_INSTANCE);
            }
        };

        private EglPbufferSurfaceAssetValueProcessor() {
        }

        @Override
        public @NonNull EglPbufferSurfaceAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglPbufferSurfaceAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_ATTRIBUTES);
            ImmutablePropertyValue<@NonNull EglConfigAsset> config = assetObject.getImmutablePropertyConfig();
            SimplePropertyValue<@Nullable Boolean> locked = new SimplePropertyValue<Boolean>(assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_LOCKED, Boolean.FALSE);
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_PENDING_ATTRIBUTES);
            SimplePropertyValue<@Nullable Integer> boundTexture = new SimplePropertyValue<Integer>(assetObject, AbstractEglPbufferSurfaceAsset.EglPbufferSurfaceAssetProperties.PROPERTY_BOUND_TEXTURE, 0);
            SimplePropertyValue<@Nullable Object> sourceContext = new SimplePropertyValue<Object>(assetObject, AbstractEglPbufferSurfaceAsset.EglPbufferSurfaceAssetProperties.PROPERTY_SOURCE_CONTEXT, null);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, boundTexture, sourceContext)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglPbufferSurfaceAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Integer>)boundTexture, (IAssetPropertyValue<EglContextAsset>)sourceContext);
        }

        @Override
        public @NonNull EglPbufferSurfaceAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglPbufferSurfaceAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull EglPbufferSurfaceAsset assetObject = (EglPbufferSurfaceAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglPbufferSurfaceAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getAttributes());
            ImmutablePropertyValue<@NonNull EglConfigAsset> config = assetObject.getImmutablePropertyConfig();
            SimplePropertyValue<@Nullable Boolean> locked = new SimplePropertyValue<Boolean>(fromValue.getLocked());
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getPendingAttributes());
            SimplePropertyValue<@Nullable Integer> boundTexture = new SimplePropertyValue<Integer>(fromValue.getBoundTexture());
            SimplePropertyValue<@Nullable EglContextAsset> sourceContext = new SimplePropertyValue<EglContextAsset>(fromValue.getSourceContext());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, boundTexture, sourceContext)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglPbufferSurfaceAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Integer>)boundTexture, (IAssetPropertyValue<EglContextAsset>)sourceContext);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> config, @NonNull SimplePropertyValue<@Nullable Boolean> locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> sourceContext) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, boundTexture, sourceContext);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                EglPbufferSurfaceAsset.Value processedValue;
                EglPbufferSurfaceAsset.Value unProcessedValue = new EglPbufferSurfaceAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Integer>)boundTexture, (IAssetPropertyValue<EglContextAsset>)sourceContext);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attributes.setValueFrom(functionCall, processedValue.getAttributes());
                locked.setValueFrom(functionCall, processedValue.getLocked());
                pendingAttributes.setValueFrom(functionCall, processedValue.getPendingAttributes());
                boundTexture.setValueFrom(functionCall, processedValue.getBoundTexture());
                sourceContext.setValueFrom(functionCall, processedValue.getSourceContext());
            }
            return result;
        }

        private static final class EglBindTexImage
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglBindTexImage HELPER_INSTANCE = new EglBindTexImage();

            private EglBindTexImage() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLBINDTEXIMAGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglBindTexImageDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglBindTexImageDecorator.getArgumentSurface(functionCall);
                    Integer arg_buffer = EGL.EglBindTexImageDecorator.getArgumentBuffer(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglBindTexImageDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglBindTexImage.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglBindTexImage.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset surfaceAsset = assetObject;
                        IStateItemValue<EGLApi> temp_getStateItemValue_return_value_0 = EglBindTexImage.getStateItemValue(callbacks, functionCall, KapiSpec.EGL.states.EGL_CURRENT_CONTEXT);
                        EglContextAsset temp_mapStateValueToAssetObject_return_value_1 = EglBindTexImage.mapStateValueToAssetObject(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                        AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                        EglContextAsset currentContextAsset = EglBindTexImage.requireAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                        property_sourceContext.setValue(functionCall, currentContextAsset);
                        property_boundTexture.setValue(functionCall, arg_buffer);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglCreatePbufferFromClientBuffer
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreatePbufferFromClientBuffer HELPER_INSTANCE = new EglCreatePbufferFromClientBuffer();

            private EglCreatePbufferFromClientBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATEPBUFFERFROMCLIENTBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentDpy(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_buftype = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentBuftype(functionCall);
                    Pointer arg_buffer = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentBuffer(functionCall);
                    Pointer arg_config = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentConfig(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreatePbufferFromClientBufferDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreatePbufferFromClientBuffer.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreatePbufferFromClientBuffer.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreatePbufferFromClientBuffer.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_5);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglCreatePbufferSurface
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreatePbufferSurface HELPER_INSTANCE = new EglCreatePbufferSurface();

            private EglCreatePbufferSurface() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATEPBUFFERSURFACE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreatePbufferSurfaceDecorator.getArgumentDpy(functionCall);
                    Pointer arg_config = EGL.EglCreatePbufferSurfaceDecorator.getArgumentConfig(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreatePbufferSurfaceDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreatePbufferSurfaceDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreatePbufferSurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreatePbufferSurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreatePbufferSurface.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_5);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglLockSurfaceKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglLockSurfaceKhr HELPER_INSTANCE = new EglLockSurfaceKhr();

            private EglLockSurfaceKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglLockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglLockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglLockSurfaceKHRDecorator.getArgumentAttrib_list(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglLockSurfaceKHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglLockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglLockSurfaceKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset surfaceAsset = assetObject;
                        property_locked.setValue(functionCall, true);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglQuerySurface
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglQuerySurface HELPER_INSTANCE = new EglQuerySurface();

            private EglQuerySurface() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLQUERYSURFACE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglQuerySurfaceDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglQuerySurfaceDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurfaceDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglQuerySurfaceDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurfaceDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglQuerySurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQuerySurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset surfaceAsset = assetObject;
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = EglQuerySurface.validateConstantIsInSet(callbacks, functionCall, arg_attribute, Constants.CONSTANT_SET_5);
                        assert (temp_validateConstantIsInSet_return_value_0 != null);
                        property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_0, arg_value.getValue());
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglQuerySurface64Khr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglQuerySurface64Khr HELPER_INSTANCE = new EglQuerySurface64Khr();

            private EglQuerySurface64Khr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglQuerySurface64KHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglQuerySurface64KHRDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurface64KHRDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglQuerySurface64KHRDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurface64KHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglQuerySurface64Khr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQuerySurface64Khr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset surfaceAsset = assetObject;
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = EglQuerySurface64Khr.validateConstantIsInSet(callbacks, functionCall, arg_attribute, Constants.CONSTANT_SET_5);
                        assert (temp_validateConstantIsInSet_return_value_0 != null);
                        property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_0, arg_value.getValue());
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglReleaseTexImage
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglReleaseTexImage HELPER_INSTANCE = new EglReleaseTexImage();

            private EglReleaseTexImage() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLRELEASETEXIMAGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglReleaseTexImageDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglReleaseTexImageDecorator.getArgumentSurface(functionCall);
                    Integer arg_buffer = EGL.EglReleaseTexImageDecorator.getArgumentBuffer(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglReleaseTexImageDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglReleaseTexImage.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglReleaseTexImage.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset surfaceAsset = assetObject;
                        property_sourceContext.setValue(functionCall, null);
                        property_boundTexture.setValue(functionCall, 0);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglSurfaceAttrib
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglSurfaceAttrib HELPER_INSTANCE = new EglSurfaceAttrib();

            private EglSurfaceAttrib() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLSURFACEATTRIB.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglSurfaceAttribDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglSurfaceAttribDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglSurfaceAttribDecorator.getArgumentAttribute(functionCall);
                    Integer arg_value = EGL.EglSurfaceAttribDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSurfaceAttribDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglSurfaceAttrib.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglSurfaceAttrib.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset surfaceAsset = assetObject;
                        ProvidedAssetProcessors.processProvidedActionForEglSurfaceAssetOnEglSurfaceAttrib(callbacks, functionCall, surfaceAsset, property_attributes, property_locked, property_pendingAttributes, arg_dpy, arg_surface, arg_attribute, arg_value, returnValue_);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglSwapBuffers
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglSwapBuffers HELPER_INSTANCE = new EglSwapBuffers();

            private EglSwapBuffers() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLSWAPBUFFERS.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglSwapBuffersDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglSwapBuffersDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSwapBuffersDecorator.getReturnValue(functionCall);
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglSwapBuffers.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglSwapBuffers.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    EglPbufferSurfaceAsset surfaceAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForEglSurfaceAssetOnEglSwapBuffers(callbacks, functionCall, surfaceAsset, property_attributes, property_locked, property_pendingAttributes, arg_dpy, arg_surface, returnValue_);
                    return true;
                }
                return false;
            }
        }

        private static final class EglUnlockSurfaceKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglUnlockSurfaceKhr HELPER_INSTANCE = new EglUnlockSurfaceKhr();

            private EglUnlockSurfaceKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPbufferSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull SimplePropertyValue<@Nullable Integer> property_boundTexture, @NonNull SimplePropertyValue<@Nullable EglContextAsset> property_sourceContext) throws Exception {
                assert (KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglUnlockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglUnlockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglUnlockSurfaceKHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglUnlockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglUnlockSurfaceKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPbufferSurfaceAsset surfaceAsset = assetObject;
                        property_locked.setValue(functionCall, false);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> var1, @NonNull EglPbufferSurfaceAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> var4, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> var5, @NonNull SimplePropertyValue<@Nullable Boolean> var6, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> var7, @NonNull SimplePropertyValue<@Nullable Integer> var8, @NonNull SimplePropertyValue<@Nullable EglContextAsset> var9) throws Exception;
        }
    }

    public static final class EglPixmapSurfaceAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<EGLApi, EglPixmapSurfaceAsset, EglPixmapSurfaceAsset.Value> {
        public static final @NonNull EglPixmapSurfaceAssetValueProcessor INSTANCE = new EglPixmapSurfaceAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.EGL.functions.EGLCREATEPIXMAPSURFACE, EglCreatePixmapSurface.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLLOCKSURFACEKHR, EglLockSurfaceKhr.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLQUERYSURFACE, EglQuerySurface.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR, EglQuerySurface64Khr.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLSURFACEATTRIB, EglSurfaceAttrib.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLSWAPBUFFERS, EglSwapBuffers.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR, EglUnlockSurfaceKhr.HELPER_INSTANCE);
            }
        };

        private EglPixmapSurfaceAssetValueProcessor() {
        }

        @Override
        public @NonNull EglPixmapSurfaceAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglPixmapSurfaceAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_ATTRIBUTES);
            ImmutablePropertyValue<@NonNull EglConfigAsset> config = assetObject.getImmutablePropertyConfig();
            SimplePropertyValue<@Nullable Boolean> locked = new SimplePropertyValue<Boolean>(assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_LOCKED, Boolean.FALSE);
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_PENDING_ATTRIBUTES);
            ImmutablePropertyValue<@Nullable Pointer> nativePixmap = assetObject.getImmutablePropertyNativePixmap();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, nativePixmap)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglPixmapSurfaceAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Pointer>)nativePixmap);
        }

        @Override
        public @NonNull EglPixmapSurfaceAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglPixmapSurfaceAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull EglPixmapSurfaceAsset assetObject = (EglPixmapSurfaceAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglPixmapSurfaceAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getAttributes());
            ImmutablePropertyValue<@NonNull EglConfigAsset> config = assetObject.getImmutablePropertyConfig();
            SimplePropertyValue<@Nullable Boolean> locked = new SimplePropertyValue<Boolean>(fromValue.getLocked());
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getPendingAttributes());
            ImmutablePropertyValue<@Nullable Pointer> nativePixmap = assetObject.getImmutablePropertyNativePixmap();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, nativePixmap)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglPixmapSurfaceAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Pointer>)nativePixmap);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> config, @NonNull SimplePropertyValue<@Nullable Boolean> locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> nativePixmap) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, nativePixmap);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                EglPixmapSurfaceAsset.Value processedValue;
                EglPixmapSurfaceAsset.Value unProcessedValue = new EglPixmapSurfaceAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Pointer>)nativePixmap);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attributes.setValueFrom(functionCall, processedValue.getAttributes());
                locked.setValueFrom(functionCall, processedValue.getLocked());
                pendingAttributes.setValueFrom(functionCall, processedValue.getPendingAttributes());
            }
            return result;
        }

        private static final class EglCreatePixmapSurface
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreatePixmapSurface HELPER_INSTANCE = new EglCreatePixmapSurface();

            private EglCreatePixmapSurface() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativePixmap) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATEPIXMAPSURFACE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreatePixmapSurfaceDecorator.getArgumentDpy(functionCall);
                    Pointer arg_config = EGL.EglCreatePixmapSurfaceDecorator.getArgumentConfig(functionCall);
                    Pointer arg_pixmap = EGL.EglCreatePixmapSurfaceDecorator.getArgumentPixmap(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreatePixmapSurfaceDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreatePixmapSurfaceDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreatePixmapSurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreatePixmapSurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPixmapSurfaceAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreatePixmapSurface.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_5);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglLockSurfaceKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglLockSurfaceKhr HELPER_INSTANCE = new EglLockSurfaceKhr();

            private EglLockSurfaceKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativePixmap) throws Exception {
                assert (KapiSpec.EGL.functions.EGLLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglLockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglLockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglLockSurfaceKHRDecorator.getArgumentAttrib_list(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglLockSurfaceKHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglLockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglLockSurfaceKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPixmapSurfaceAsset surfaceAsset = assetObject;
                        property_locked.setValue(functionCall, true);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglQuerySurface
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglQuerySurface HELPER_INSTANCE = new EglQuerySurface();

            private EglQuerySurface() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativePixmap) throws Exception {
                assert (KapiSpec.EGL.functions.EGLQUERYSURFACE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglQuerySurfaceDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglQuerySurfaceDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurfaceDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglQuerySurfaceDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurfaceDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglQuerySurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQuerySurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPixmapSurfaceAsset surfaceAsset = assetObject;
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglQuerySurface.validateConstantIsInSet(callbacks, functionCall, arg_attribute, Constants.CONSTANT_SET_5);
                        assert (temp_validateConstantIsInSet_return_value_1 != null);
                        property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, arg_value.getValue());
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglQuerySurface64Khr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglQuerySurface64Khr HELPER_INSTANCE = new EglQuerySurface64Khr();

            private EglQuerySurface64Khr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativePixmap) throws Exception {
                assert (KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglQuerySurface64KHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglQuerySurface64KHRDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurface64KHRDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglQuerySurface64KHRDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurface64KHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglQuerySurface64Khr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQuerySurface64Khr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPixmapSurfaceAsset surfaceAsset = assetObject;
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglQuerySurface64Khr.validateConstantIsInSet(callbacks, functionCall, arg_attribute, Constants.CONSTANT_SET_5);
                        assert (temp_validateConstantIsInSet_return_value_1 != null);
                        property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, arg_value.getValue());
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglSurfaceAttrib
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglSurfaceAttrib HELPER_INSTANCE = new EglSurfaceAttrib();

            private EglSurfaceAttrib() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativePixmap) throws Exception {
                assert (KapiSpec.EGL.functions.EGLSURFACEATTRIB.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglSurfaceAttribDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglSurfaceAttribDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglSurfaceAttribDecorator.getArgumentAttribute(functionCall);
                    Integer arg_value = EGL.EglSurfaceAttribDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSurfaceAttribDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglSurfaceAttrib.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglSurfaceAttrib.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPixmapSurfaceAsset surfaceAsset = assetObject;
                        ProvidedAssetProcessors.processProvidedActionForEglSurfaceAssetOnEglSurfaceAttrib(callbacks, functionCall, surfaceAsset, property_attributes, property_locked, property_pendingAttributes, arg_dpy, arg_surface, arg_attribute, arg_value, returnValue_);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglSwapBuffers
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglSwapBuffers HELPER_INSTANCE = new EglSwapBuffers();

            private EglSwapBuffers() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativePixmap) throws Exception {
                assert (KapiSpec.EGL.functions.EGLSWAPBUFFERS.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglSwapBuffersDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglSwapBuffersDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSwapBuffersDecorator.getReturnValue(functionCall);
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglSwapBuffers.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglSwapBuffers.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    EglPixmapSurfaceAsset surfaceAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForEglSurfaceAssetOnEglSwapBuffers(callbacks, functionCall, surfaceAsset, property_attributes, property_locked, property_pendingAttributes, arg_dpy, arg_surface, returnValue_);
                    return true;
                }
                return false;
            }
        }

        private static final class EglUnlockSurfaceKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglUnlockSurfaceKhr HELPER_INSTANCE = new EglUnlockSurfaceKhr();

            private EglUnlockSurfaceKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglPixmapSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativePixmap) throws Exception {
                assert (KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglUnlockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglUnlockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglUnlockSurfaceKHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglUnlockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglUnlockSurfaceKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglPixmapSurfaceAsset surfaceAsset = assetObject;
                        property_locked.setValue(functionCall, false);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> var1, @NonNull EglPixmapSurfaceAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> var4, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> var5, @NonNull SimplePropertyValue<@Nullable Boolean> var6, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> var7, @NonNull ImmutablePropertyValue<@Nullable Pointer> var8) throws Exception;
        }
    }

    public static final class EglSyncAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<EGLApi, EglSyncAsset, EglSyncAsset.Value> {
        public static final @NonNull EglSyncAssetValueProcessor INSTANCE = new EglSyncAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.EGL.functions.EGLCREATESYNC64KHR, EglCreateSync64Khr.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLCREATESYNCKHR, EglCreateSyncKhr.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLGETSYNCATTRIBKHR, EglGetSyncAttribKhr.HELPER_INSTANCE);
            }
        };

        private EglSyncAssetValueProcessor() {
        }

        @Override
        public @NonNull EglSyncAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglSyncAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglSyncAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglSyncAsset.EglSyncAssetProperties.PROPERTY_ATTRIBUTES);
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> status = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(assetObject, AbstractEglSyncAsset.EglSyncAssetProperties.PROPERTY_STATUS, KapiSpec.EGL.constants.EGL_UNSIGNALED_KHR);
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attributes, status, type)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglSyncAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)status, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
        }

        @Override
        public @NonNull EglSyncAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglSyncAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull EglSyncAsset assetObject = (EglSyncAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglSyncAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getAttributes());
            SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> status = new SimplePropertyValue<AbstractConstantOrAliasSpecExtended>(fromValue.getStatus());
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attributes, status, type)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglSyncAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)status, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglSyncAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> status, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attributes, status, type);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                EglSyncAsset.Value processedValue;
                EglSyncAsset.Value unProcessedValue = new EglSyncAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)status, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attributes.setValueFrom(functionCall, processedValue.getAttributes());
                status.setValueFrom(functionCall, processedValue.getStatus());
            }
            return result;
        }

        private static final class EglCreateSync64Khr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreateSync64Khr HELPER_INSTANCE = new EglCreateSync64Khr();

            private EglCreateSync64Khr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglSyncAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_status, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATESYNC64KHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreateSync64KHRDecorator.getArgumentDpy(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_type = EGL.EglCreateSync64KHRDecorator.getArgumentType(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreateSync64KHRDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreateSync64KHRDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreateSync64Khr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateSync64Khr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglSyncAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreateSync64Khr.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_3);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglCreateSyncKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreateSyncKhr HELPER_INSTANCE = new EglCreateSyncKhr();

            private EglCreateSyncKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglSyncAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_status, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATESYNCKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreateSyncKHRDecorator.getArgumentDpy(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_type = EGL.EglCreateSyncKHRDecorator.getArgumentType(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreateSyncKHRDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreateSyncKHRDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreateSyncKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateSyncKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglSyncAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreateSyncKhr.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_3);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglGetSyncAttribKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglGetSyncAttribKhr HELPER_INSTANCE = new EglGetSyncAttribKhr();

            private EglGetSyncAttribKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglSyncAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_status, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type) throws Exception {
                assert (KapiSpec.EGL.functions.EGLGETSYNCATTRIBKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglGetSyncAttribKHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_sync = EGL.EglGetSyncAttribKHRDecorator.getArgumentSync(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglGetSyncAttribKHRDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglGetSyncAttribKHRDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglGetSyncAttribKHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglGetSyncAttribKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglGetSyncAttribKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglSyncAsset syncAsset = assetObject;
                        if (arg_attribute.equals(KapiSpec.EGL.constants.EGL_SYNC_STATUS_KHR)) {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = EglGetSyncAttribKhr.validateConstantIsInSet(callbacks, functionCall, KapiSpec.EGL.getConstantSpecByValue(arg_value.getValue()), Constants.CONSTANT_SET_4);
                            assert (temp_validateConstantIsInSet_return_value_0 != null);
                            property_status.setValue(functionCall, temp_validateConstantIsInSet_return_value_0);
                        }
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> var1, @NonNull EglSyncAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> var4, @NonNull SimplePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var5, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6) throws Exception;
        }
    }

    public static final class EglWindowSurfaceAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<EGLApi, EglWindowSurfaceAsset, EglWindowSurfaceAsset.Value> {
        public static final @NonNull EglWindowSurfaceAssetValueProcessor INSTANCE = new EglWindowSurfaceAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.EGL.functions.EGLCREATEPLATFORMWINDOWSURFACEEXT, EglCreatePlatformWindowSurfaceExt.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLCREATEWINDOWSURFACE, EglCreateWindowSurface.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLLOCKSURFACEKHR, EglLockSurfaceKhr.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLQUERYSURFACE, EglQuerySurface.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR, EglQuerySurface64Khr.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLSURFACEATTRIB, EglSurfaceAttrib.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLSWAPBUFFERS, EglSwapBuffers.HELPER_INSTANCE);
                this.put(KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR, EglUnlockSurfaceKhr.HELPER_INSTANCE);
            }
        };

        private EglWindowSurfaceAssetValueProcessor() {
        }

        @Override
        public @NonNull EglWindowSurfaceAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglWindowSurfaceAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_ATTRIBUTES);
            ImmutablePropertyValue<@NonNull EglConfigAsset> config = assetObject.getImmutablePropertyConfig();
            SimplePropertyValue<@Nullable Boolean> locked = new SimplePropertyValue<Boolean>(assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_LOCKED, Boolean.FALSE);
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>((IAssetItem<?, ?>)assetObject, AbstractEglSurfaceAsset.EglSurfaceAssetProperties.PROPERTY_PENDING_ATTRIBUTES);
            ImmutablePropertyValue<@Nullable Pointer> nativeWindow = assetObject.getImmutablePropertyNativeWindow();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, nativeWindow)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglWindowSurfaceAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Pointer>)nativeWindow);
        }

        @Override
        public @NonNull EglWindowSurfaceAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull EglWindowSurfaceAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull EglWindowSurfaceAsset assetObject = (EglWindowSurfaceAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get EglWindowSurfaceAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getAttributes());
            ImmutablePropertyValue<@NonNull EglConfigAsset> config = assetObject.getImmutablePropertyConfig();
            SimplePropertyValue<@Nullable Boolean> locked = new SimplePropertyValue<Boolean>(fromValue.getLocked());
            MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes = new MapPropertyValue<AbstractConstantOrAliasSpecExtended, Long>(fromValue.getPendingAttributes());
            ImmutablePropertyValue<@Nullable Pointer> nativeWindow = assetObject.getImmutablePropertyNativeWindow();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, nativeWindow)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new EglWindowSurfaceAsset.Value(validRange, assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Pointer>)nativeWindow);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> config, @NonNull SimplePropertyValue<@Nullable Boolean> locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> nativeWindow) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, attributes, config, locked, pendingAttributes, nativeWindow);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                EglWindowSurfaceAsset.Value processedValue;
                EglWindowSurfaceAsset.Value unProcessedValue = new EglWindowSurfaceAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)attributes, (IAssetPropertyValue<EglConfigAsset>)config, (IAssetPropertyValue<Boolean>)locked, (IAssetPropertyValue<Map<AbstractConstantOrAliasSpecExtended, Long>>)pendingAttributes, (IAssetPropertyValue<Pointer>)nativeWindow);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                attributes.setValueFrom(functionCall, processedValue.getAttributes());
                locked.setValueFrom(functionCall, processedValue.getLocked());
                pendingAttributes.setValueFrom(functionCall, processedValue.getPendingAttributes());
            }
            return result;
        }

        private static final class EglCreatePlatformWindowSurfaceExt
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreatePlatformWindowSurfaceExt HELPER_INSTANCE = new EglCreatePlatformWindowSurfaceExt();

            private EglCreatePlatformWindowSurfaceExt() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATEPLATFORMWINDOWSURFACEEXT.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentDpy(functionCall);
                    Pointer arg_config = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentConfig(functionCall);
                    Pointer arg_native_window = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentNative_window(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreatePlatformWindowSurfaceExt.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreatePlatformWindowSurfaceExt.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglWindowSurfaceAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreatePlatformWindowSurfaceExt.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_5);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglCreateWindowSurface
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglCreateWindowSurface HELPER_INSTANCE = new EglCreateWindowSurface();

            private EglCreateWindowSurface() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow) throws Exception {
                assert (KapiSpec.EGL.functions.EGLCREATEWINDOWSURFACE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    long temp_temp_2;
                    Pointer arg_dpy = EGL.EglCreateWindowSurfaceDecorator.getArgumentDpy(functionCall);
                    Pointer arg_config = EGL.EglCreateWindowSurfaceDecorator.getArgumentConfig(functionCall);
                    Pointer arg_win = EGL.EglCreateWindowSurfaceDecorator.getArgumentWin(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglCreateWindowSurfaceDecorator.getArgumentAttrib_list(functionCall);
                    Pointer returnValue_ = EGL.EglCreateWindowSurfaceDecorator.getReturnValue(functionCall);
                    long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                    if (temp_temp_2 != 0L) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglCreateWindowSurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateWindowSurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglWindowSurfaceAsset returnedAsset = assetObject;
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = this.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = EglCreateWindowSurface.validateConstantIsInSet(callbacks, functionCall, mapEntryKey, Constants.CONSTANT_SET_5);
                            property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglLockSurfaceKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglLockSurfaceKhr HELPER_INSTANCE = new EglLockSurfaceKhr();

            private EglLockSurfaceKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow) throws Exception {
                assert (KapiSpec.EGL.functions.EGLLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglLockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglLockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                    LongsArgAttachment arg_attrib_list = EGL.EglLockSurfaceKHRDecorator.getArgumentAttrib_list(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglLockSurfaceKHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglLockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglLockSurfaceKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglWindowSurfaceAsset surfaceAsset = assetObject;
                        property_locked.setValue(functionCall, true);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglQuerySurface
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglQuerySurface HELPER_INSTANCE = new EglQuerySurface();

            private EglQuerySurface() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow) throws Exception {
                assert (KapiSpec.EGL.functions.EGLQUERYSURFACE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglQuerySurfaceDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglQuerySurfaceDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurfaceDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglQuerySurfaceDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurfaceDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglQuerySurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQuerySurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglWindowSurfaceAsset surfaceAsset = assetObject;
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_2 = EglQuerySurface.validateConstantIsInSet(callbacks, functionCall, arg_attribute, Constants.CONSTANT_SET_5);
                        assert (temp_validateConstantIsInSet_return_value_2 != null);
                        property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_2, arg_value.getValue());
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglQuerySurface64Khr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglQuerySurface64Khr HELPER_INSTANCE = new EglQuerySurface64Khr();

            private EglQuerySurface64Khr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow) throws Exception {
                assert (KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglQuerySurface64KHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglQuerySurface64KHRDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurface64KHRDecorator.getArgumentAttribute(functionCall);
                    LongPtrArgAttachment arg_value = EGL.EglQuerySurface64KHRDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurface64KHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglQuerySurface64Khr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQuerySurface64Khr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglWindowSurfaceAsset surfaceAsset = assetObject;
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_2 = EglQuerySurface64Khr.validateConstantIsInSet(callbacks, functionCall, arg_attribute, Constants.CONSTANT_SET_5);
                        assert (temp_validateConstantIsInSet_return_value_2 != null);
                        property_attributes.setValue(functionCall, temp_validateConstantIsInSet_return_value_2, arg_value.getValue());
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglSurfaceAttrib
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglSurfaceAttrib HELPER_INSTANCE = new EglSurfaceAttrib();

            private EglSurfaceAttrib() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow) throws Exception {
                assert (KapiSpec.EGL.functions.EGLSURFACEATTRIB.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglSurfaceAttribDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglSurfaceAttribDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglSurfaceAttribDecorator.getArgumentAttribute(functionCall);
                    Integer arg_value = EGL.EglSurfaceAttribDecorator.getArgumentValue(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSurfaceAttribDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglSurfaceAttrib.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglSurfaceAttrib.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglWindowSurfaceAsset surfaceAsset = assetObject;
                        ProvidedAssetProcessors.processProvidedActionForEglSurfaceAssetOnEglSurfaceAttrib(callbacks, functionCall, surfaceAsset, property_attributes, property_locked, property_pendingAttributes, arg_dpy, arg_surface, arg_attribute, arg_value, returnValue_);
                    }
                    return true;
                }
                return false;
            }
        }

        private static final class EglSwapBuffers
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglSwapBuffers HELPER_INSTANCE = new EglSwapBuffers();

            private EglSwapBuffers() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow) throws Exception {
                assert (KapiSpec.EGL.functions.EGLSWAPBUFFERS.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglSwapBuffersDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglSwapBuffersDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSwapBuffersDecorator.getReturnValue(functionCall);
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglSwapBuffers.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglSwapBuffers.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    EglWindowSurfaceAsset surfaceAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForEglSurfaceAssetOnEglSwapBuffers(callbacks, functionCall, surfaceAsset, property_attributes, property_locked, property_pendingAttributes, arg_dpy, arg_surface, returnValue_);
                    return true;
                }
                return false;
            }
        }

        private static final class EglUnlockSurfaceKhr
        extends AbstractEglAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final EglUnlockSurfaceKhr HELPER_INSTANCE = new EglUnlockSurfaceKhr();

            private EglUnlockSurfaceKhr() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull EglWindowSurfaceAsset assetObject, @NonNull FunctionCall functionCall, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> property_attributes, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> property_config, @NonNull SimplePropertyValue<@Nullable Boolean> property_locked, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> property_pendingAttributes, @NonNull ImmutablePropertyValue<@Nullable Pointer> property_nativeWindow) throws Exception {
                assert (KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_dpy = EGL.EglUnlockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                    Pointer arg_surface = EGL.EglUnlockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglUnlockSurfaceKHRDecorator.getReturnValue(functionCall);
                    if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                        AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                        EglDisplayAsset dpyAsset = EglUnlockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglUnlockSurfaceKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                        EglWindowSurfaceAsset surfaceAsset = assetObject;
                        property_locked.setValue(functionCall, false);
                    }
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> var1, @NonNull EglWindowSurfaceAsset var2, @NonNull FunctionCall var3, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull Long> var4, @NonNull ImmutablePropertyValue<@NonNull EglConfigAsset> var5, @NonNull SimplePropertyValue<@Nullable Boolean> var6, @NonNull MapPropertyValue<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> var7, @NonNull ImmutablePropertyValue<@Nullable Pointer> var8) throws Exception;
        }
    }
}

