/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.egl;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.EGL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.egl.EglConfigAsset;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.egl.EglImageAsset;
import com.arm.mgd.lightweight.asset.egl.EglPbufferSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglPixmapSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglSyncAsset;
import com.arm.mgd.lightweight.asset.egl.EglWindowSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglContextAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglImageAsset;
import com.arm.mgd.lightweight.asset.egl.gen.AbstractEglPbufferSurfaceAsset;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.egl.AbstractEglAssetCallProcessorBase;
import com.arm.mgd.lightweight.model.api.EGLApi;
import com.arm.mgd.lightweight.state.IStateItemValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class EglAssetCallProcessor {
    private static final Map<IFunctionOrAliasSpecExtended, AbstractLightweightAssetFunctionCallProcessor> ASSET_PROCESSORS = new HashMap<IFunctionOrAliasSpecExtended, AbstractLightweightAssetFunctionCallProcessor>(){
        {
            this.put(KapiSpec.EGL.functions.EGLBINDTEXIMAGE, new EglBindTexImage());
            this.put(KapiSpec.EGL.functions.EGLCHOOSECONFIG, new EglChooseConfig());
            this.put(KapiSpec.EGL.functions.EGLCOPYBUFFERS, new EglCopyBuffers());
            this.put(KapiSpec.EGL.functions.EGLCREATECONTEXT, new EglCreateContext());
            this.put(KapiSpec.EGL.functions.EGLCREATEIMAGEKHR, new EglCreateImageKhr());
            this.put(KapiSpec.EGL.functions.EGLCREATEPBUFFERFROMCLIENTBUFFER, new EglCreatePbufferFromClientBuffer());
            this.put(KapiSpec.EGL.functions.EGLCREATEPBUFFERSURFACE, new EglCreatePbufferSurface());
            this.put(KapiSpec.EGL.functions.EGLCREATEPIXMAPSURFACE, new EglCreatePixmapSurface());
            this.put(KapiSpec.EGL.functions.EGLCREATEPLATFORMWINDOWSURFACEEXT, new EglCreatePlatformWindowSurfaceExt());
            this.put(KapiSpec.EGL.functions.EGLCREATESYNC64KHR, new EglCreateSync64Khr());
            this.put(KapiSpec.EGL.functions.EGLCREATESYNCKHR, new EglCreateSyncKhr());
            this.put(KapiSpec.EGL.functions.EGLCREATEWINDOWSURFACE, new EglCreateWindowSurface());
            this.put(KapiSpec.EGL.functions.EGLDESTROYCONTEXT, new EglDestroyContext());
            this.put(KapiSpec.EGL.functions.EGLDESTROYIMAGEKHR, new EglDestroyImageKhr());
            this.put(KapiSpec.EGL.functions.EGLDESTROYSURFACE, new EglDestroySurface());
            this.put(KapiSpec.EGL.functions.EGLDESTROYSYNCKHR, new EglDestroySyncKhr());
            this.put(KapiSpec.EGL.functions.EGLGETCONFIGATTRIB, new EglGetConfigAttrib());
            this.put(KapiSpec.EGL.functions.EGLGETCONFIGS, new EglGetConfigs());
            this.put(KapiSpec.EGL.functions.EGLGETDISPLAY, new EglGetDisplay());
            this.put(KapiSpec.EGL.functions.EGLGETSYNCATTRIBKHR, new EglGetSyncAttribKhr());
            this.put(KapiSpec.EGL.functions.EGLINITIALIZE, new EglInitialize());
            this.put(KapiSpec.EGL.functions.EGLLOCKSURFACEKHR, new EglLockSurfaceKhr());
            this.put(KapiSpec.EGL.functions.EGLMAKECURRENT, new EglMakeCurrent());
            this.put(KapiSpec.EGL.functions.EGLQUERYCONTEXT, new EglQueryContext());
            this.put(KapiSpec.EGL.functions.EGLQUERYSURFACE, new EglQuerySurface());
            this.put(KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR, new EglQuerySurface64Khr());
            this.put(KapiSpec.EGL.functions.EGLRELEASETEXIMAGE, new EglReleaseTexImage());
            this.put(KapiSpec.EGL.functions.EGLSURFACEATTRIB, new EglSurfaceAttrib());
            this.put(KapiSpec.EGL.functions.EGLSWAPBUFFERS, new EglSwapBuffers());
            this.put(KapiSpec.EGL.functions.EGLTERMINATE, new EglTerminate());
            this.put(KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR, new EglUnlockSurfaceKhr());
        }
    };

    public static @Nullable AbstractLightweightAssetFunctionCallProcessor forFunctionCall(@NonNull FunctionCall functionCall) {
        if (functionCall.hasError()) {
            return null;
        }
        return ASSET_PROCESSORS.get(functionCall.getFunctionSpec());
    }

    private static class Constants {
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_0 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_GL_RENDERBUFFER_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_2D_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_KHR, KapiSpec.EGL.constants.EGL_NATIVE_BUFFER_ANDROID, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_3D_KHR));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_1 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_SYNC_NATIVE_FENCE_ANDROID, KapiSpec.EGL.constants.EGL_SYNC_REUSABLE_KHR, KapiSpec.EGL.constants.EGL_SYNC_CL_EVENT_KHR, KapiSpec.EGL.constants.EGL_SYNC_FENCE_KHR));

        private Constants() {
        }
    }

    public static final class EglBindTexImage
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLBINDTEXIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglBindTexImageDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglBindTexImageDecorator.getArgumentSurface(functionCall);
                Integer arg_buffer = EGL.EglBindTexImageDecorator.getArgumentBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglBindTexImageDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglBindTexImage.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglBindTexImage.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID surfaceAsset_id_value = AssetItemID.valueOf(arg_surface);
                    EglPbufferSurfaceAsset surfaceAsset = EglBindTexImage.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglBindTexImage.getEglPbufferSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.addFunctionCall(functionCall);
                    IStateItemValue<EGLApi> temp_getStateItemValue_return_value_0 = EglBindTexImage.getStateItemValue(callbacks, functionCall, KapiSpec.EGL.states.EGL_CURRENT_CONTEXT);
                    EglContextAsset temp_mapStateValueToAssetObject_return_value_1 = EglBindTexImage.mapStateValueToAssetObject(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, temp_getStateItemValue_return_value_0);
                    AssetItemID temp_valueOf_return_value_2 = AssetItemID.valueOf(temp_getStateItemValue_return_value_0);
                    EglContextAsset currentContextAsset = EglBindTexImage.requireAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_valueOf_return_value_2);
                    surfaceAsset.getLifecycleManager().trackPropertyValueChanged(AbstractEglPbufferSurfaceAsset.EglPbufferSurfaceAssetProperties.PROPERTY_SOURCE_CONTEXT, functionCall, currentContextAsset);
                }
            }
        }
    }

    public static final class EglChooseConfig
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCHOOSECONFIG.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglChooseConfigDecorator.getArgumentDpy(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglChooseConfigDecorator.getArgumentAttrib_list(functionCall);
                LongsArgAttachment arg_configs = EGL.EglChooseConfigDecorator.getArgumentConfigs(functionCall);
                Integer arg_config_size = EGL.EglChooseConfigDecorator.getArgumentConfig_size(functionCall);
                LongPtrArgAttachment arg_num_config = EGL.EglChooseConfigDecorator.getArgumentNum_config(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglChooseConfigDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglChooseConfig.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglChooseConfig.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_configs);
                    EglChooseConfig.forEachAssetItemID(temp_valueOf_return_value_0, configsAsset_id_value -> {
                        EglConfigAsset eglConfigAsset = EglChooseConfig.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configsAsset_id_value);
                    });
                }
            }
        }
    }

    public static final class EglCopyBuffers
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCOPYBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglCopyBuffersDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglCopyBuffersDecorator.getArgumentSurface(functionCall);
                Pointer arg_target = EGL.EglCopyBuffersDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglCopyBuffersDecorator.getReturnValue(functionCall);
                AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                EglDisplayAsset dpyAsset = EglCopyBuffers.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCopyBuffers.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                AssetItemID surfaceAsset_id_value = AssetItemID.valueOf(arg_surface);
                EglSurfaceAsset<?, ?> surfaceAsset = EglCopyBuffers.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglCopyBuffers.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value), surfaceAsset_id_value);
                surfaceAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class EglCreateContext
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATECONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_0;
                Pointer arg_dpy = EGL.EglCreateContextDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreateContextDecorator.getArgumentConfig(functionCall);
                Pointer arg_share_context = EGL.EglCreateContextDecorator.getArgumentShare_context(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateContextDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateContextDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_0 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreateContext.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateContext.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID configAsset_id_value = AssetItemID.valueOf(arg_config);
                    EglConfigAsset configAsset = EglCreateContext.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, callbacks, functionCall, EglCreateContext.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configAsset_id_value), configAsset_id_value);
                    AssetItemID share_contextAsset_id_value = AssetItemID.valueOf(arg_share_context);
                    EglContextAsset share_contextAsset = EglCreateContext.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, EglCreateContext.getEglContextAsset(callbacks, functionCall, null, dpyAsset, share_contextAsset_id_value), share_contextAsset_id_value, AssetItemID.valueOf(0));
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    EglContextAsset returnedAsset = this.createNewEglContextAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, configAsset, share_contextAsset);
                    returnedAsset.getLifecycleManager().trackPropertyValueChanged(AbstractEglContextAsset.EglContextAssetProperties.PROPERTY_SHARED_CONTEXT, functionCall, share_contextAsset);
                }
            }
        }
    }

    public static final class EglCreateImageKhr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEIMAGEKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_1;
                Pointer arg_dpy = EGL.EglCreateImageKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_ctx = EGL.EglCreateImageKHRDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended arg_target = EGL.EglCreateImageKHRDecorator.getArgumentTarget(functionCall);
                Pointer arg_buffer = EGL.EglCreateImageKHRDecorator.getArgumentBuffer(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateImageKHRDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateImageKHRDecorator.getReturnValue(functionCall);
                long l = temp_temp_1 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_1 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreateImageKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateImageKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID ctxAsset_id_value = AssetItemID.valueOf(arg_ctx);
                    EglContextAsset ctxAsset = EglCreateImageKhr.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, EglCreateImageKhr.getEglContextAsset(callbacks, functionCall, null, dpyAsset, ctxAsset_id_value), ctxAsset_id_value, AssetItemID.valueOf(0));
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = EglCreateImageKhr.validateConstantIsInSet(callbacks, functionCall, arg_target, Constants.CONSTANT_SET_0);
                    EglImageAsset returnedAsset = this.createNewEglImageAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, arg_buffer, ctxAsset, temp_validateConstantIsInSet_return_value_0);
                    returnedAsset.getLifecycleManager().trackPropertyValueChanged(AbstractEglImageAsset.EglImageAssetProperties.PROPERTY_SOURCE_CONTEXT, functionCall, ctxAsset);
                }
            }
        }
    }

    public static final class EglCreatePbufferFromClientBuffer
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEPBUFFERFROMCLIENTBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_0;
                Pointer arg_dpy = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentDpy(functionCall);
                AbstractConstantOrAliasSpecExtended arg_buftype = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentBuftype(functionCall);
                Pointer arg_buffer = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentBuffer(functionCall);
                Pointer arg_config = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentConfig(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreatePbufferFromClientBufferDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_0 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreatePbufferFromClientBuffer.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreatePbufferFromClientBuffer.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID configAsset_id_value = AssetItemID.valueOf(arg_config);
                    EglConfigAsset configAsset = EglCreatePbufferFromClientBuffer.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, callbacks, functionCall, EglCreatePbufferFromClientBuffer.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configAsset_id_value), configAsset_id_value);
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    EglPbufferSurfaceAsset eglPbufferSurfaceAsset = this.createNewEglPbufferSurfaceAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, configAsset);
                }
            }
        }
    }

    public static final class EglCreatePbufferSurface
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEPBUFFERSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_0;
                Pointer arg_dpy = EGL.EglCreatePbufferSurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreatePbufferSurfaceDecorator.getArgumentConfig(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreatePbufferSurfaceDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreatePbufferSurfaceDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_0 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreatePbufferSurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreatePbufferSurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID configAsset_id_value = AssetItemID.valueOf(arg_config);
                    EglConfigAsset configAsset = EglCreatePbufferSurface.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, callbacks, functionCall, EglCreatePbufferSurface.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configAsset_id_value), configAsset_id_value);
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    EglPbufferSurfaceAsset eglPbufferSurfaceAsset = this.createNewEglPbufferSurfaceAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, configAsset);
                }
            }
        }
    }

    public static final class EglCreatePixmapSurface
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEPIXMAPSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_0;
                Pointer arg_dpy = EGL.EglCreatePixmapSurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreatePixmapSurfaceDecorator.getArgumentConfig(functionCall);
                Pointer arg_pixmap = EGL.EglCreatePixmapSurfaceDecorator.getArgumentPixmap(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreatePixmapSurfaceDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreatePixmapSurfaceDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_0 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreatePixmapSurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreatePixmapSurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID configAsset_id_value = AssetItemID.valueOf(arg_config);
                    EglConfigAsset configAsset = EglCreatePixmapSurface.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, callbacks, functionCall, EglCreatePixmapSurface.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configAsset_id_value), configAsset_id_value);
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    EglPixmapSurfaceAsset eglPixmapSurfaceAsset = this.createNewEglPixmapSurfaceAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, configAsset, arg_pixmap);
                }
            }
        }
    }

    public static final class EglCreatePlatformWindowSurfaceExt
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEPLATFORMWINDOWSURFACEEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_0;
                Pointer arg_dpy = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentConfig(functionCall);
                Pointer arg_native_window = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentNative_window(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_0 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreatePlatformWindowSurfaceExt.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreatePlatformWindowSurfaceExt.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID configAsset_id_value = AssetItemID.valueOf(arg_config);
                    EglConfigAsset configAsset = EglCreatePlatformWindowSurfaceExt.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, callbacks, functionCall, EglCreatePlatformWindowSurfaceExt.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configAsset_id_value), configAsset_id_value);
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    EglWindowSurfaceAsset eglWindowSurfaceAsset = this.createNewEglWindowSurfaceAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, configAsset, arg_native_window);
                }
            }
        }
    }

    public static final class EglCreateSync64Khr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATESYNC64KHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_1;
                Pointer arg_dpy = EGL.EglCreateSync64KHRDecorator.getArgumentDpy(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = EGL.EglCreateSync64KHRDecorator.getArgumentType(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateSync64KHRDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateSync64KHRDecorator.getReturnValue(functionCall);
                long l = temp_temp_1 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_1 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreateSync64Khr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateSync64Khr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = EglCreateSync64Khr.validateConstantIsInSet(callbacks, functionCall, arg_type, Constants.CONSTANT_SET_1);
                    EglSyncAsset eglSyncAsset = this.createNewEglSyncAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, temp_validateConstantIsInSet_return_value_0);
                }
            }
        }
    }

    public static final class EglCreateSyncKhr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATESYNCKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_1;
                Pointer arg_dpy = EGL.EglCreateSyncKHRDecorator.getArgumentDpy(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = EGL.EglCreateSyncKHRDecorator.getArgumentType(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateSyncKHRDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateSyncKHRDecorator.getReturnValue(functionCall);
                long l = temp_temp_1 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_1 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreateSyncKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateSyncKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = EglCreateSyncKhr.validateConstantIsInSet(callbacks, functionCall, arg_type, Constants.CONSTANT_SET_1);
                    EglSyncAsset eglSyncAsset = this.createNewEglSyncAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, temp_validateConstantIsInSet_return_value_0);
                }
            }
        }
    }

    public static final class EglCreateWindowSurface
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEWINDOWSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_0;
                Pointer arg_dpy = EGL.EglCreateWindowSurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreateWindowSurfaceDecorator.getArgumentConfig(functionCall);
                Pointer arg_win = EGL.EglCreateWindowSurfaceDecorator.getArgumentWin(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateWindowSurfaceDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateWindowSurfaceDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_0 != 0L) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglCreateWindowSurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglCreateWindowSurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID configAsset_id_value = AssetItemID.valueOf(arg_config);
                    EglConfigAsset configAsset = EglCreateWindowSurface.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, callbacks, functionCall, EglCreateWindowSurface.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configAsset_id_value), configAsset_id_value);
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    EglWindowSurfaceAsset eglWindowSurfaceAsset = this.createNewEglWindowSurfaceAsset(callbacks, functionCall, dpyAsset, returnedAsset_id_value, configAsset, arg_win);
                }
            }
        }
    }

    public static final class EglDestroyContext
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLDESTROYCONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AssetItemID ctxAsset_id_value;
                AssetItemID dpyAsset_id_value;
                EglDisplayAsset dpyAsset;
                EglContextAsset ctxAsset;
                Pointer arg_dpy = EGL.EglDestroyContextDecorator.getArgumentDpy(functionCall);
                Pointer arg_ctx = EGL.EglDestroyContextDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglDestroyContextDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && (ctxAsset = EglDestroyContext.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, EglDestroyContext.getEglContextAsset(callbacks, functionCall, null, dpyAsset = EglDestroyContext.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglDestroyContext.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value = AssetItemID.valueOf(arg_dpy)), dpyAsset_id_value), ctxAsset_id_value = AssetItemID.valueOf(arg_ctx)), ctxAsset_id_value, AssetItemID.valueOf(0))) != null) {
                    ctxAsset.addFunctionCall(functionCall);
                    ctxAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class EglDestroyImageKhr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLDESTROYIMAGEKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AssetItemID imageAsset_id_value;
                AssetItemID dpyAsset_id_value;
                EglDisplayAsset dpyAsset;
                EglImageAsset imageAsset;
                Pointer arg_dpy = EGL.EglDestroyImageKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_image = EGL.EglDestroyImageKHRDecorator.getArgumentImage(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglDestroyImageKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && (imageAsset = EglDestroyImageKhr.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS, callbacks, functionCall, EglDestroyImageKhr.getEglImageAsset(callbacks, functionCall, null, dpyAsset = EglDestroyImageKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglDestroyImageKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value = AssetItemID.valueOf(arg_dpy)), dpyAsset_id_value), imageAsset_id_value = AssetItemID.valueOf(arg_image)), imageAsset_id_value, AssetItemID.valueOf(0))) != null) {
                    imageAsset.addFunctionCall(functionCall);
                    imageAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class EglDestroySurface
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLDESTROYSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AssetItemID surfaceAsset_id_value;
                AssetItemID dpyAsset_id_value;
                EglDisplayAsset dpyAsset;
                EglSurfaceAsset<?, ?> surfaceAsset;
                Pointer arg_dpy = EGL.EglDestroySurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglDestroySurfaceDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglDestroySurfaceDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && (surfaceAsset = EglDestroySurface.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglDestroySurface.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset = EglDestroySurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglDestroySurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value = AssetItemID.valueOf(arg_dpy)), dpyAsset_id_value), surfaceAsset_id_value = AssetItemID.valueOf(arg_surface)), surfaceAsset_id_value, AssetItemID.valueOf(0))) != null) {
                    surfaceAsset.addFunctionCall(functionCall);
                    surfaceAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class EglDestroySyncKhr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLDESTROYSYNCKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AssetItemID syncAsset_id_value;
                AssetItemID dpyAsset_id_value;
                EglDisplayAsset dpyAsset;
                EglSyncAsset syncAsset;
                Pointer arg_dpy = EGL.EglDestroySyncKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_sync = EGL.EglDestroySyncKHRDecorator.getArgumentSync(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglDestroySyncKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && (syncAsset = EglDestroySyncKhr.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS, callbacks, functionCall, EglDestroySyncKhr.getEglSyncAsset(callbacks, functionCall, null, dpyAsset = EglDestroySyncKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglDestroySyncKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value = AssetItemID.valueOf(arg_dpy)), dpyAsset_id_value), syncAsset_id_value = AssetItemID.valueOf(arg_sync)), syncAsset_id_value, AssetItemID.valueOf(0))) != null) {
                    syncAsset.addFunctionCall(functionCall);
                    syncAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class EglGetConfigAttrib
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLGETCONFIGATTRIB.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglGetConfigAttribDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglGetConfigAttribDecorator.getArgumentConfig(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglGetConfigAttribDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglGetConfigAttribDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglGetConfigAttribDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglGetConfigAttrib.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglGetConfigAttrib.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID configAsset_id_value = AssetItemID.valueOf(arg_config);
                    EglConfigAsset configAsset = EglGetConfigAttrib.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, callbacks, functionCall, EglGetConfigAttrib.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configAsset_id_value), configAsset_id_value);
                    configAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class EglGetConfigs
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLGETCONFIGS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglGetConfigsDecorator.getArgumentDpy(functionCall);
                LongsArgAttachment arg_configs = EGL.EglGetConfigsDecorator.getArgumentConfigs(functionCall);
                Integer arg_config_size = EGL.EglGetConfigsDecorator.getArgumentConfig_size(functionCall);
                LongPtrArgAttachment arg_num_config = EGL.EglGetConfigsDecorator.getArgumentNum_config(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglGetConfigsDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglGetConfigs.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglGetConfigs.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    List<AssetItemID> temp_valueOf_return_value_0 = AssetItemID.valueOf(arg_configs);
                    EglGetConfigs.forEachAssetItemID(temp_valueOf_return_value_0, configsAsset_id_value -> {
                        EglConfigAsset eglConfigAsset = EglGetConfigs.getOrCreateNewEglConfigAsset(callbacks, functionCall, dpyAsset, configsAsset_id_value);
                    });
                }
            }
        }
    }

    public static final class EglGetDisplay
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLGETDISPLAY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_0;
                Pointer arg_display_id = EGL.EglGetDisplayDecorator.getArgumentDisplay_id(functionCall);
                Pointer returnValue_ = EGL.EglGetDisplayDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_0 != 0L) {
                    AssetItemID returnedAsset_id_value = AssetItemID.valueOf(returnValue_);
                    EglDisplayAsset eglDisplayAsset = this.createNewEglDisplayAsset(callbacks, functionCall, returnedAsset_id_value, arg_display_id);
                }
            }
        }
    }

    public static final class EglGetSyncAttribKhr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLGETSYNCATTRIBKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglGetSyncAttribKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_sync = EGL.EglGetSyncAttribKHRDecorator.getArgumentSync(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglGetSyncAttribKHRDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglGetSyncAttribKHRDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglGetSyncAttribKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglGetSyncAttribKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglGetSyncAttribKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID syncAsset_id_value = AssetItemID.valueOf(arg_sync);
                    EglSyncAsset syncAsset = EglGetSyncAttribKhr.requireAsset(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS, callbacks, functionCall, EglGetSyncAttribKhr.getEglSyncAsset(callbacks, functionCall, null, dpyAsset, syncAsset_id_value), syncAsset_id_value);
                    syncAsset.addFunctionCall(functionCall);
                    arg_attribute.equals(KapiSpec.EGL.constants.EGL_SYNC_STATUS_KHR);
                }
            }
        }
    }

    public static final class EglInitialize
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLINITIALIZE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglInitializeDecorator.getArgumentDpy(functionCall);
                LongPtrArgAttachment arg_major = EGL.EglInitializeDecorator.getArgumentMajor(functionCall);
                LongPtrArgAttachment arg_minor = EGL.EglInitializeDecorator.getArgumentMinor(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglInitializeDecorator.getReturnValue(functionCall);
                AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                EglDisplayAsset dpyAsset = EglInitialize.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglInitialize.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                dpyAsset.addFunctionCall(functionCall);
                dpyAsset.getLifecycleManager().retain(functionCall);
            }
        }
    }

    public static final class EglLockSurfaceKhr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglLockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglLockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglLockSurfaceKHRDecorator.getArgumentAttrib_list(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglLockSurfaceKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglLockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglLockSurfaceKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID surfaceAsset_id_value = AssetItemID.valueOf(arg_surface);
                    EglSurfaceAsset<?, ?> surfaceAsset = EglLockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglLockSurfaceKhr.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class EglMakeCurrent
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLMAKECURRENT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglMakeCurrentDecorator.getArgumentDpy(functionCall);
                Pointer arg_draw = EGL.EglMakeCurrentDecorator.getArgumentDraw(functionCall);
                Pointer arg_read = EGL.EglMakeCurrentDecorator.getArgumentRead(functionCall);
                Pointer arg_ctx = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglMakeCurrentDecorator.getReturnValue(functionCall);
                AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                EglDisplayAsset dpyAsset = EglMakeCurrent.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglMakeCurrent.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value, AssetItemID.valueOf(0));
                if (dpyAsset != null) {
                    AssetItemID readAsset_id_value;
                    EglSurfaceAsset<?, ?> readAsset;
                    AssetItemID drawAsset_id_value;
                    EglSurfaceAsset<?, ?> drawAsset;
                    AssetItemID ctxAsset_id_value = AssetItemID.valueOf(arg_ctx);
                    EglContextAsset ctxAsset = EglMakeCurrent.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, EglMakeCurrent.getEglContextAsset(callbacks, functionCall, null, dpyAsset, ctxAsset_id_value), ctxAsset_id_value, AssetItemID.valueOf(0));
                    if (ctxAsset != null) {
                        ctxAsset.addFunctionCall(functionCall);
                    }
                    if ((drawAsset = EglMakeCurrent.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglMakeCurrent.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, drawAsset_id_value = AssetItemID.valueOf(arg_draw)), drawAsset_id_value, AssetItemID.valueOf(0))) != null) {
                        drawAsset.addFunctionCall(functionCall);
                    }
                    if ((readAsset = EglMakeCurrent.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglMakeCurrent.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, readAsset_id_value = AssetItemID.valueOf(arg_read)), readAsset_id_value, AssetItemID.valueOf(0))) != null) {
                        readAsset.addFunctionCall(functionCall);
                    }
                }
            }
        }
    }

    public static final class EglQueryContext
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLQUERYCONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglQueryContextDecorator.getArgumentDpy(functionCall);
                Pointer arg_ctx = EGL.EglQueryContextDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQueryContextDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglQueryContextDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQueryContextDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglQueryContext.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQueryContext.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID ctxAsset_id_value = AssetItemID.valueOf(arg_ctx);
                    EglContextAsset ctxAsset = EglQueryContext.requireAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, callbacks, functionCall, EglQueryContext.getEglContextAsset(callbacks, functionCall, null, dpyAsset, ctxAsset_id_value), ctxAsset_id_value);
                    ctxAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class EglQuerySurface
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLQUERYSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglQuerySurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglQuerySurfaceDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurfaceDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglQuerySurfaceDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurfaceDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglQuerySurface.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQuerySurface.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID surfaceAsset_id_value = AssetItemID.valueOf(arg_surface);
                    EglSurfaceAsset<?, ?> surfaceAsset = EglQuerySurface.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglQuerySurface.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class EglQuerySurface64Khr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglQuerySurface64KHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglQuerySurface64KHRDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurface64KHRDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglQuerySurface64KHRDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurface64KHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglQuerySurface64Khr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglQuerySurface64Khr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID surfaceAsset_id_value = AssetItemID.valueOf(arg_surface);
                    EglSurfaceAsset<?, ?> surfaceAsset = EglQuerySurface64Khr.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglQuerySurface64Khr.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class EglReleaseTexImage
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLRELEASETEXIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglReleaseTexImageDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglReleaseTexImageDecorator.getArgumentSurface(functionCall);
                Integer arg_buffer = EGL.EglReleaseTexImageDecorator.getArgumentBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglReleaseTexImageDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglReleaseTexImage.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglReleaseTexImage.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID surfaceAsset_id_value = AssetItemID.valueOf(arg_surface);
                    EglPbufferSurfaceAsset surfaceAsset = EglReleaseTexImage.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglReleaseTexImage.getEglPbufferSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.addFunctionCall(functionCall);
                    surfaceAsset.getLifecycleManager().trackPropertyValueChanged(AbstractEglPbufferSurfaceAsset.EglPbufferSurfaceAssetProperties.PROPERTY_SOURCE_CONTEXT, functionCall, null);
                }
            }
        }
    }

    public static final class EglSurfaceAttrib
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLSURFACEATTRIB.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglSurfaceAttribDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglSurfaceAttribDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglSurfaceAttribDecorator.getArgumentAttribute(functionCall);
                Integer arg_value = EGL.EglSurfaceAttribDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSurfaceAttribDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglSurfaceAttrib.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglSurfaceAttrib.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID surfaceAsset_id_value = AssetItemID.valueOf(arg_surface);
                    EglSurfaceAsset<?, ?> surfaceAsset = EglSurfaceAttrib.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglSurfaceAttrib.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class EglSwapBuffers
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLSWAPBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AssetItemID surfaceAsset_id_value;
                Pointer arg_dpy = EGL.EglSwapBuffersDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglSwapBuffersDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSwapBuffersDecorator.getReturnValue(functionCall);
                AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                EglDisplayAsset dpyAsset = EglSwapBuffers.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglSwapBuffers.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                EglSurfaceAsset<?, ?> surfaceAsset = EglSwapBuffers.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglSwapBuffers.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value = AssetItemID.valueOf(arg_surface)), surfaceAsset_id_value, AssetItemID.valueOf(0));
                if (surfaceAsset != null) {
                    surfaceAsset.addFunctionCall(functionCall);
                }
            }
        }
    }

    public static final class EglTerminate
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLTERMINATE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AssetItemID dpyAsset_id_value;
                EglDisplayAsset dpyAsset;
                Pointer arg_dpy = EGL.EglTerminateDecorator.getArgumentDpy(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglTerminateDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && (dpyAsset = EglTerminate.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglTerminate.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value = AssetItemID.valueOf(arg_dpy)), dpyAsset_id_value, AssetItemID.valueOf(0))) != null) {
                    dpyAsset.addFunctionCall(functionCall);
                    dpyAsset.getLifecycleManager().delete(functionCall);
                }
            }
        }
    }

    public static final class EglUnlockSurfaceKhr
    extends AbstractEglAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglUnlockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglUnlockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglUnlockSurfaceKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    AssetItemID dpyAsset_id_value = AssetItemID.valueOf(arg_dpy);
                    EglDisplayAsset dpyAsset = EglUnlockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, callbacks, functionCall, EglUnlockSurfaceKhr.getEglDisplayAsset(callbacks, functionCall, null, dpyAsset_id_value), dpyAsset_id_value);
                    AssetItemID surfaceAsset_id_value = AssetItemID.valueOf(arg_surface);
                    EglSurfaceAsset<?, ?> surfaceAsset = EglUnlockSurfaceKhr.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, callbacks, functionCall, EglUnlockSurfaceKhr.getEglSurfaceAsset(callbacks, functionCall, null, dpyAsset, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.addFunctionCall(functionCall);
                }
            }
        }
    }
}

