/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.cl;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.CL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.cl.ClBufferMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClContextAsset;
import com.arm.mgd.lightweight.asset.cl.ClImageMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClKernelAsset;
import com.arm.mgd.lightweight.asset.cl.ClMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClProgramAsset;
import com.arm.mgd.lightweight.asset.cl.ClSubBufferMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.gen.AbstractClBufferMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.gen.AbstractClImageMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.gen.AbstractClProgramAsset;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetValueProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.ProvidedAssetProcessors;
import com.arm.mgd.lightweight.asset.processor.cl.AbstractClAssetValueProcessorBase;
import com.arm.mgd.lightweight.asset.properties.IAssetPropertyValue;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimplePropertyValue;
import com.arm.mgd.lightweight.model.api.CLApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ClAssetValueProcessor {

    public static final class ClBufferMemoryAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<CLApi, ClBufferMemoryAsset, ClBufferMemoryAsset.Value> {
        public static final @NonNull ClBufferMemoryAssetValueProcessor INSTANCE = new ClBufferMemoryAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.CL.functions.CLCREATEBUFFER, ClCreateBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLENQUEUECOPYBUFFER, ClEnqueueCopyBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER, ClEnqueueWriteBuffer.HELPER_INSTANCE);
            }
        };

        private ClBufferMemoryAssetValueProcessor() {
        }

        @Override
        public @NonNull ClBufferMemoryAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClBufferMemoryAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClBufferMemoryAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset = assetObject.getImmutablePropertyContextAsset();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            SimplePropertyValue<@Nullable Long> size = new SimplePropertyValue<Long>(assetObject, AbstractClBufferMemoryAsset.ClBufferMemoryAssetProperties.PROPERTY_SIZE, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, contextAsset, flags, size)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClBufferMemoryAsset.Value(validRange, assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, flags, size);
        }

        @Override
        public @NonNull ClBufferMemoryAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClBufferMemoryAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull ClBufferMemoryAsset assetObject = (ClBufferMemoryAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClBufferMemoryAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset = assetObject.getImmutablePropertyContextAsset();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            SimplePropertyValue<@Nullable Long> size = new SimplePropertyValue<Long>(fromValue.getSize());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, contextAsset, flags, size)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClBufferMemoryAsset.Value(validRange, assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, flags, size);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClBufferMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull SimplePropertyValue<@Nullable Long> size) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, contextAsset, flags, size);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                ClBufferMemoryAsset.Value processedValue;
                ClBufferMemoryAsset.Value unProcessedValue = new ClBufferMemoryAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, flags, size);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                size.setValueFrom(functionCall, processedValue.getSize());
            }
            return result;
        }

        private static final class ClCreateBuffer
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClCreateBuffer HELPER_INSTANCE = new ClCreateBuffer();

            private ClCreateBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClBufferMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull SimplePropertyValue<@Nullable Long> property_size) throws Exception {
                assert (KapiSpec.CL.functions.CLCREATEBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_context = CL.ClCreateBufferDecorator.getArgumentContext(functionCall);
                    Bitfield arg_flags = CL.ClCreateBufferDecorator.getArgumentFlags(functionCall);
                    Long arg_size = CL.ClCreateBufferDecorator.getArgumentSize(functionCall);
                    BufferArgAttachment arg_host_ptr = CL.ClCreateBufferDecorator.getArgumentHost_ptr(functionCall);
                    LongPtrArgAttachment arg_errcode_ret = CL.ClCreateBufferDecorator.getArgumentErrcode_ret(functionCall);
                    Pointer returnValue_ = CL.ClCreateBufferDecorator.getReturnValue(functionCall);
                    AssetItemID contextAsset_id_value = AssetItemID.valueOf(arg_context);
                    ClContextAsset contextAsset = ClCreateBuffer.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateBuffer.getClContextAsset(callbacks, functionCall, contextAsset_id_value), contextAsset_id_value);
                    ClBufferMemoryAsset clMemoryAsset = assetObject;
                    property_size.setValue(functionCall, arg_size);
                    return true;
                }
                return false;
            }
        }

        private static final class ClEnqueueCopyBuffer
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClEnqueueCopyBuffer HELPER_INSTANCE = new ClEnqueueCopyBuffer();

            private ClEnqueueCopyBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClBufferMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull SimplePropertyValue<@Nullable Long> property_size) throws Exception {
                assert (KapiSpec.CL.functions.CLENQUEUECOPYBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_command_queue = CL.ClEnqueueCopyBufferDecorator.getArgumentCommand_queue(functionCall);
                    Pointer arg_src_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_buffer(functionCall);
                    Pointer arg_dst_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_buffer(functionCall);
                    Long arg_src_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_offset(functionCall);
                    Long arg_dst_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_offset(functionCall);
                    Long arg_size = CL.ClEnqueueCopyBufferDecorator.getArgumentSize(functionCall);
                    Long arg_num_events_in_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                    LongsArgAttachment arg_event_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent_wait_list(functionCall);
                    LongPtrArgAttachment arg_event = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueCopyBufferDecorator.getReturnValue(functionCall);
                    ClBufferMemoryAsset sourceBuffer = assetObject;
                    ClBufferMemoryAsset destinationBuffer = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForClMemoryAssetOnClEnqueueCopyBuffer(callbacks, functionCall, destinationBuffer, arg_command_queue, arg_src_buffer, arg_dst_buffer, arg_src_offset, arg_dst_offset, arg_size, arg_num_events_in_wait_list, arg_event_wait_list, arg_event, returnValue_, sourceBuffer);
                    return true;
                }
                return false;
            }
        }

        private static final class ClEnqueueWriteBuffer
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClEnqueueWriteBuffer HELPER_INSTANCE = new ClEnqueueWriteBuffer();

            private ClEnqueueWriteBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClBufferMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull SimplePropertyValue<@Nullable Long> property_size) throws Exception {
                assert (KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_command_queue = CL.ClEnqueueWriteBufferDecorator.getArgumentCommand_queue(functionCall);
                    Pointer arg_buffer = CL.ClEnqueueWriteBufferDecorator.getArgumentBuffer(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_blocking_write = CL.ClEnqueueWriteBufferDecorator.getArgumentBlocking_write(functionCall);
                    Long arg_offset = CL.ClEnqueueWriteBufferDecorator.getArgumentOffset(functionCall);
                    Long arg_size = CL.ClEnqueueWriteBufferDecorator.getArgumentSize(functionCall);
                    BufferArgAttachment arg_ptr = CL.ClEnqueueWriteBufferDecorator.getArgumentPtr(functionCall);
                    Long arg_num_events_in_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                    LongsArgAttachment arg_event_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent_wait_list(functionCall);
                    LongPtrArgAttachment arg_event = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueWriteBufferDecorator.getReturnValue(functionCall);
                    ClBufferMemoryAsset bufferAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForClMemoryAssetOnClEnqueueWriteBuffer(callbacks, functionCall, bufferAsset, arg_command_queue, arg_buffer, arg_blocking_write, arg_offset, arg_size, arg_ptr, arg_num_events_in_wait_list, arg_event_wait_list, arg_event, returnValue_);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> var1, @NonNull ClBufferMemoryAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> var4, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var5, @NonNull SimplePropertyValue<@Nullable Long> var6) throws Exception;
        }
    }

    public static final class ClContextAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<CLApi, ClContextAsset, ClContextAsset.Value> {
        public static final @NonNull ClContextAssetValueProcessor INSTANCE = new ClContextAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private ClContextAssetValueProcessor() {
        }

        @Override
        public @NonNull ClContextAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClContextAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClContextAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClContextAsset.Value(validRange, assetObject);
        }

        @Override
        public @NonNull ClContextAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClContextAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull ClContextAsset assetObject = (ClContextAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClContextAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClContextAsset.Value(validRange, assetObject);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClContextAsset assetObject, @NonNull FunctionCall functionCall) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                ClContextAsset.Value processedValue;
                ClContextAsset.Value unProcessedValue = new ClContextAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> var1, @NonNull ClContextAsset var2, @NonNull FunctionCall var3) throws Exception;
        }
    }

    public static final class ClImageMemoryAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<CLApi, ClImageMemoryAsset, ClImageMemoryAsset.Value> {
        public static final @NonNull ClImageMemoryAssetValueProcessor INSTANCE = new ClImageMemoryAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.CL.functions.CLCREATEIMAGE, ClCreateImage.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLCREATEIMAGE2D, ClCreateImage2D.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLCREATEIMAGE3D, ClCreateImage3D.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLENQUEUECOPYBUFFER, ClEnqueueCopyBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER, ClEnqueueWriteBuffer.HELPER_INSTANCE);
            }
        };

        private ClImageMemoryAssetValueProcessor() {
        }

        @Override
        public @NonNull ClImageMemoryAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClImageMemoryAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClImageMemoryAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset = assetObject.getImmutablePropertyContextAsset();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelDataType = assetObject.getImmutablePropertyChannelDataType();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelOrder = assetObject.getImmutablePropertyChannelOrder();
            SimplePropertyValue<@Nullable Long> depth = new SimplePropertyValue<Long>(assetObject, AbstractClImageMemoryAsset.ClImageMemoryAssetProperties.PROPERTY_DEPTH, 0L);
            SimplePropertyValue<@Nullable Long> height = new SimplePropertyValue<Long>(assetObject, AbstractClImageMemoryAsset.ClImageMemoryAssetProperties.PROPERTY_HEIGHT, 0L);
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            SimplePropertyValue<@Nullable Long> width = new SimplePropertyValue<Long>(assetObject, AbstractClImageMemoryAsset.ClImageMemoryAssetProperties.PROPERTY_WIDTH, 0L);
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, contextAsset, flags, channelDataType, channelOrder, depth, height, type, width)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClImageMemoryAsset.Value(validRange, assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)channelDataType, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)channelOrder, (IAssetPropertyValue<Long>)depth, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type, (IAssetPropertyValue<Long>)width);
        }

        @Override
        public @NonNull ClImageMemoryAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClImageMemoryAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull ClImageMemoryAsset assetObject = (ClImageMemoryAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClImageMemoryAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset = assetObject.getImmutablePropertyContextAsset();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelDataType = assetObject.getImmutablePropertyChannelDataType();
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelOrder = assetObject.getImmutablePropertyChannelOrder();
            SimplePropertyValue<@Nullable Long> depth = new SimplePropertyValue<Long>(fromValue.getDepth());
            SimplePropertyValue<@Nullable Long> height = new SimplePropertyValue<Long>(fromValue.getHeight());
            ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type = assetObject.getImmutablePropertyType();
            SimplePropertyValue<@Nullable Long> width = new SimplePropertyValue<Long>(fromValue.getWidth());
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, contextAsset, flags, channelDataType, channelOrder, depth, height, type, width)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClImageMemoryAsset.Value(validRange, assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)channelDataType, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)channelOrder, (IAssetPropertyValue<Long>)depth, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type, (IAssetPropertyValue<Long>)width);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClImageMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelDataType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> channelOrder, @NonNull SimplePropertyValue<@Nullable Long> depth, @NonNull SimplePropertyValue<@Nullable Long> height, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> type, @NonNull SimplePropertyValue<@Nullable Long> width) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, contextAsset, flags, channelDataType, channelOrder, depth, height, type, width);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                ClImageMemoryAsset.Value processedValue;
                ClImageMemoryAsset.Value unProcessedValue = new ClImageMemoryAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)channelDataType, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)channelOrder, (IAssetPropertyValue<Long>)depth, (IAssetPropertyValue<Long>)height, (IAssetPropertyValue<AbstractConstantOrAliasSpecExtended>)type, (IAssetPropertyValue<Long>)width);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                depth.setValueFrom(functionCall, processedValue.getDepth());
                height.setValueFrom(functionCall, processedValue.getHeight());
                width.setValueFrom(functionCall, processedValue.getWidth());
            }
            return result;
        }

        private static final class ClCreateImage
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClCreateImage HELPER_INSTANCE = new ClCreateImage();

            private ClCreateImage() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClImageMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelDataType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelOrder, @NonNull SimplePropertyValue<@Nullable Long> property_depth, @NonNull SimplePropertyValue<@Nullable Long> property_height, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type, @NonNull SimplePropertyValue<@Nullable Long> property_width) throws Exception {
                assert (KapiSpec.CL.functions.CLCREATEIMAGE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_context = CL.ClCreateImageDecorator.getArgumentContext(functionCall);
                    Bitfield arg_flags = CL.ClCreateImageDecorator.getArgumentFlags(functionCall);
                    CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImageDecorator.getArgumentImage_format(functionCall);
                    CL.Structs.ClImageDescStruct arg_image_desc = CL.ClCreateImageDecorator.getArgumentImage_desc(functionCall);
                    BufferArgAttachment arg_host_ptr = CL.ClCreateImageDecorator.getArgumentHost_ptr(functionCall);
                    LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImageDecorator.getArgumentErrcode_ret(functionCall);
                    Pointer returnValue_ = CL.ClCreateImageDecorator.getReturnValue(functionCall);
                    AssetItemID imageContextAsset_id_value = AssetItemID.valueOf(arg_context);
                    ClContextAsset imageContextAsset = ClCreateImage.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateImage.getClContextAsset(callbacks, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                    ClImageMemoryAsset imageAsset = assetObject;
                    property_width.setValue(functionCall, arg_image_desc.getImage_width());
                    property_height.setValue(functionCall, arg_image_desc.getImage_height());
                    property_depth.setValue(functionCall, arg_image_desc.getImage_depth());
                    return true;
                }
                return false;
            }
        }

        private static final class ClCreateImage2D
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClCreateImage2D HELPER_INSTANCE = new ClCreateImage2D();

            private ClCreateImage2D() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClImageMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelDataType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelOrder, @NonNull SimplePropertyValue<@Nullable Long> property_depth, @NonNull SimplePropertyValue<@Nullable Long> property_height, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type, @NonNull SimplePropertyValue<@Nullable Long> property_width) throws Exception {
                assert (KapiSpec.CL.functions.CLCREATEIMAGE2D.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_context = CL.ClCreateImage2DDecorator.getArgumentContext(functionCall);
                    Bitfield arg_flags = CL.ClCreateImage2DDecorator.getArgumentFlags(functionCall);
                    CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImage2DDecorator.getArgumentImage_format(functionCall);
                    Long arg_image_width = CL.ClCreateImage2DDecorator.getArgumentImage_width(functionCall);
                    Long arg_image_height = CL.ClCreateImage2DDecorator.getArgumentImage_height(functionCall);
                    Long arg_image_row_pitch = CL.ClCreateImage2DDecorator.getArgumentImage_row_pitch(functionCall);
                    BufferArgAttachment arg_host_ptr = CL.ClCreateImage2DDecorator.getArgumentHost_ptr(functionCall);
                    LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImage2DDecorator.getArgumentErrcode_ret(functionCall);
                    Pointer returnValue_ = CL.ClCreateImage2DDecorator.getReturnValue(functionCall);
                    AssetItemID imageContextAsset_id_value = AssetItemID.valueOf(arg_context);
                    ClContextAsset imageContextAsset = ClCreateImage2D.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateImage2D.getClContextAsset(callbacks, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                    ClImageMemoryAsset imageAsset = assetObject;
                    property_width.setValue(functionCall, arg_image_width);
                    property_height.setValue(functionCall, arg_image_height);
                    property_depth.setValue(functionCall, null);
                    return true;
                }
                return false;
            }
        }

        private static final class ClCreateImage3D
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClCreateImage3D HELPER_INSTANCE = new ClCreateImage3D();

            private ClCreateImage3D() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClImageMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelDataType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelOrder, @NonNull SimplePropertyValue<@Nullable Long> property_depth, @NonNull SimplePropertyValue<@Nullable Long> property_height, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type, @NonNull SimplePropertyValue<@Nullable Long> property_width) throws Exception {
                assert (KapiSpec.CL.functions.CLCREATEIMAGE3D.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_context = CL.ClCreateImage3DDecorator.getArgumentContext(functionCall);
                    Bitfield arg_flags = CL.ClCreateImage3DDecorator.getArgumentFlags(functionCall);
                    CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImage3DDecorator.getArgumentImage_format(functionCall);
                    Long arg_image_width = CL.ClCreateImage3DDecorator.getArgumentImage_width(functionCall);
                    Long arg_image_height = CL.ClCreateImage3DDecorator.getArgumentImage_height(functionCall);
                    Long arg_image_depth = CL.ClCreateImage3DDecorator.getArgumentImage_depth(functionCall);
                    Long arg_image_row_pitch = CL.ClCreateImage3DDecorator.getArgumentImage_row_pitch(functionCall);
                    Long arg_image_slice_pitch = CL.ClCreateImage3DDecorator.getArgumentImage_slice_pitch(functionCall);
                    BufferArgAttachment arg_host_ptr = CL.ClCreateImage3DDecorator.getArgumentHost_ptr(functionCall);
                    LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImage3DDecorator.getArgumentErrcode_ret(functionCall);
                    Pointer returnValue_ = CL.ClCreateImage3DDecorator.getReturnValue(functionCall);
                    AssetItemID imageContextAsset_id_value = AssetItemID.valueOf(arg_context);
                    ClContextAsset imageContextAsset = ClCreateImage3D.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateImage3D.getClContextAsset(callbacks, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                    ClImageMemoryAsset imageAsset = assetObject;
                    property_width.setValue(functionCall, arg_image_width);
                    property_height.setValue(functionCall, arg_image_height);
                    property_depth.setValue(functionCall, arg_image_depth);
                    return true;
                }
                return false;
            }
        }

        private static final class ClEnqueueCopyBuffer
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClEnqueueCopyBuffer HELPER_INSTANCE = new ClEnqueueCopyBuffer();

            private ClEnqueueCopyBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClImageMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelDataType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelOrder, @NonNull SimplePropertyValue<@Nullable Long> property_depth, @NonNull SimplePropertyValue<@Nullable Long> property_height, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type, @NonNull SimplePropertyValue<@Nullable Long> property_width) throws Exception {
                assert (KapiSpec.CL.functions.CLENQUEUECOPYBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_command_queue = CL.ClEnqueueCopyBufferDecorator.getArgumentCommand_queue(functionCall);
                    Pointer arg_src_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_buffer(functionCall);
                    Pointer arg_dst_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_buffer(functionCall);
                    Long arg_src_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_offset(functionCall);
                    Long arg_dst_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_offset(functionCall);
                    Long arg_size = CL.ClEnqueueCopyBufferDecorator.getArgumentSize(functionCall);
                    Long arg_num_events_in_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                    LongsArgAttachment arg_event_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent_wait_list(functionCall);
                    LongPtrArgAttachment arg_event = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueCopyBufferDecorator.getReturnValue(functionCall);
                    ClImageMemoryAsset sourceBuffer = assetObject;
                    ClImageMemoryAsset destinationBuffer = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForClMemoryAssetOnClEnqueueCopyBuffer(callbacks, functionCall, destinationBuffer, arg_command_queue, arg_src_buffer, arg_dst_buffer, arg_src_offset, arg_dst_offset, arg_size, arg_num_events_in_wait_list, arg_event_wait_list, arg_event, returnValue_, sourceBuffer);
                    return true;
                }
                return false;
            }
        }

        private static final class ClEnqueueWriteBuffer
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClEnqueueWriteBuffer HELPER_INSTANCE = new ClEnqueueWriteBuffer();

            private ClEnqueueWriteBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClImageMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelDataType, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_channelOrder, @NonNull SimplePropertyValue<@Nullable Long> property_depth, @NonNull SimplePropertyValue<@Nullable Long> property_height, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> property_type, @NonNull SimplePropertyValue<@Nullable Long> property_width) throws Exception {
                assert (KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_command_queue = CL.ClEnqueueWriteBufferDecorator.getArgumentCommand_queue(functionCall);
                    Pointer arg_buffer = CL.ClEnqueueWriteBufferDecorator.getArgumentBuffer(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_blocking_write = CL.ClEnqueueWriteBufferDecorator.getArgumentBlocking_write(functionCall);
                    Long arg_offset = CL.ClEnqueueWriteBufferDecorator.getArgumentOffset(functionCall);
                    Long arg_size = CL.ClEnqueueWriteBufferDecorator.getArgumentSize(functionCall);
                    BufferArgAttachment arg_ptr = CL.ClEnqueueWriteBufferDecorator.getArgumentPtr(functionCall);
                    Long arg_num_events_in_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                    LongsArgAttachment arg_event_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent_wait_list(functionCall);
                    LongPtrArgAttachment arg_event = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueWriteBufferDecorator.getReturnValue(functionCall);
                    ClImageMemoryAsset bufferAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForClMemoryAssetOnClEnqueueWriteBuffer(callbacks, functionCall, bufferAsset, arg_command_queue, arg_buffer, arg_blocking_write, arg_offset, arg_size, arg_ptr, arg_num_events_in_wait_list, arg_event_wait_list, arg_event, returnValue_);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> var1, @NonNull ClImageMemoryAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> var4, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var5, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var6, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var7, @NonNull SimplePropertyValue<@Nullable Long> var8, @NonNull SimplePropertyValue<@Nullable Long> var9, @NonNull ImmutablePropertyValue<@NonNull AbstractConstantOrAliasSpecExtended> var10, @NonNull SimplePropertyValue<@Nullable Long> var11) throws Exception;
        }
    }

    public static final class ClKernelAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<CLApi, ClKernelAsset, ClKernelAsset.Value> {
        public static final @NonNull ClKernelAssetValueProcessor INSTANCE = new ClKernelAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){};

        private ClKernelAssetValueProcessor() {
        }

        @Override
        public @NonNull ClKernelAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClKernelAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClKernelAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull String> kernelName = assetObject.getImmutablePropertyKernelName();
            ImmutablePropertyValue<@NonNull ClProgramAsset> programAsset = assetObject.getImmutablePropertyProgramAsset();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, kernelName, programAsset)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClKernelAsset.Value(validRange, assetObject, (IAssetPropertyValue<String>)kernelName, (IAssetPropertyValue<ClProgramAsset>)programAsset);
        }

        @Override
        public @NonNull ClKernelAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClKernelAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull ClKernelAsset assetObject = (ClKernelAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClKernelAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull String> kernelName = assetObject.getImmutablePropertyKernelName();
            ImmutablePropertyValue<@NonNull ClProgramAsset> programAsset = assetObject.getImmutablePropertyProgramAsset();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, kernelName, programAsset)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClKernelAsset.Value(validRange, assetObject, (IAssetPropertyValue<String>)kernelName, (IAssetPropertyValue<ClProgramAsset>)programAsset);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClKernelAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull String> kernelName, @NonNull ImmutablePropertyValue<@NonNull ClProgramAsset> programAsset) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, kernelName, programAsset);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                ClKernelAsset.Value processedValue;
                ClKernelAsset.Value unProcessedValue = new ClKernelAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<String>)kernelName, (IAssetPropertyValue<ClProgramAsset>)programAsset);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> var1, @NonNull ClKernelAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull String> var4, @NonNull ImmutablePropertyValue<@NonNull ClProgramAsset> var5) throws Exception;
        }
    }

    public static final class ClProgramAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<CLApi, ClProgramAsset, ClProgramAsset.Value> {
        public static final @NonNull ClProgramAssetValueProcessor INSTANCE = new ClProgramAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.CL.functions.CLCREATEPROGRAMWITHBINARY, ClCreateProgramWithBinary.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLCREATEPROGRAMWITHSOURCE, ClCreateProgramWithSource.HELPER_INSTANCE);
            }
        };

        private ClProgramAssetValueProcessor() {
        }

        @Override
        public @NonNull ClProgramAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClProgramAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClProgramAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable Object> buildOptions = new SimplePropertyValue<Object>(assetObject, AbstractClProgramAsset.ClProgramAssetProperties.PROPERTY_BUILD_OPTIONS, null);
            ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset = assetObject.getImmutablePropertyContextAsset();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, buildOptions, contextAsset)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClProgramAsset.Value(validRange, assetObject, (IAssetPropertyValue<String>)buildOptions, (IAssetPropertyValue<ClContextAsset>)contextAsset);
        }

        @Override
        public @NonNull ClProgramAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClProgramAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull ClProgramAsset assetObject = (ClProgramAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClProgramAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            SimplePropertyValue<@Nullable String> buildOptions = new SimplePropertyValue<String>(fromValue.getBuildOptions());
            ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset = assetObject.getImmutablePropertyContextAsset();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, buildOptions, contextAsset)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClProgramAsset.Value(validRange, assetObject, (IAssetPropertyValue<String>)buildOptions, (IAssetPropertyValue<ClContextAsset>)contextAsset);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable String> buildOptions, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, buildOptions, contextAsset);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                ClProgramAsset.Value processedValue;
                ClProgramAsset.Value unProcessedValue = new ClProgramAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<String>)buildOptions, (IAssetPropertyValue<ClContextAsset>)contextAsset);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
                buildOptions.setValueFrom(functionCall, processedValue.getBuildOptions());
            }
            return result;
        }

        private static final class ClCreateProgramWithBinary
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClCreateProgramWithBinary HELPER_INSTANCE = new ClCreateProgramWithBinary();

            private ClCreateProgramWithBinary() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable String> property_buildOptions, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset) throws Exception {
                assert (KapiSpec.CL.functions.CLCREATEPROGRAMWITHBINARY.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_context = CL.ClCreateProgramWithBinaryDecorator.getArgumentContext(functionCall);
                    Long arg_num_devices = CL.ClCreateProgramWithBinaryDecorator.getArgumentNum_devices(functionCall);
                    LongsArgAttachment arg_device_list = CL.ClCreateProgramWithBinaryDecorator.getArgumentDevice_list(functionCall);
                    LongsArgAttachment arg_lengths = CL.ClCreateProgramWithBinaryDecorator.getArgumentLengths(functionCall);
                    Pointer arg_binaries = CL.ClCreateProgramWithBinaryDecorator.getArgumentBinaries(functionCall);
                    LongsArgAttachment arg_binary_status = CL.ClCreateProgramWithBinaryDecorator.getArgumentBinary_status(functionCall);
                    LongPtrArgAttachment arg_errcode_ret = CL.ClCreateProgramWithBinaryDecorator.getArgumentErrcode_ret(functionCall);
                    Pointer returnValue_ = CL.ClCreateProgramWithBinaryDecorator.getReturnValue(functionCall);
                    AssetItemID contextAsset_id_value = AssetItemID.valueOf(arg_context);
                    ClContextAsset contextAsset = ClCreateProgramWithBinary.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateProgramWithBinary.getClContextAsset(callbacks, functionCall, contextAsset_id_value), contextAsset_id_value);
                    ClProgramAsset clProgramAsset = assetObject;
                    return true;
                }
                return false;
            }
        }

        private static final class ClCreateProgramWithSource
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClCreateProgramWithSource HELPER_INSTANCE = new ClCreateProgramWithSource();

            private ClCreateProgramWithSource() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClProgramAsset assetObject, @NonNull FunctionCall functionCall, @NonNull SimplePropertyValue<@Nullable String> property_buildOptions, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset) throws Exception {
                assert (KapiSpec.CL.functions.CLCREATEPROGRAMWITHSOURCE.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_context = CL.ClCreateProgramWithSourceDecorator.getArgumentContext(functionCall);
                    Long arg_count = CL.ClCreateProgramWithSourceDecorator.getArgumentCount(functionCall);
                    StringsArgAttachment arg_strings = CL.ClCreateProgramWithSourceDecorator.getArgumentStrings(functionCall);
                    LongsArgAttachment arg_lengths = CL.ClCreateProgramWithSourceDecorator.getArgumentLengths(functionCall);
                    LongPtrArgAttachment arg_errcode_ret = CL.ClCreateProgramWithSourceDecorator.getArgumentErrcode_ret(functionCall);
                    Pointer returnValue_ = CL.ClCreateProgramWithSourceDecorator.getReturnValue(functionCall);
                    AssetItemID contextAsset_id_value = AssetItemID.valueOf(arg_context);
                    ClContextAsset contextAsset = ClCreateProgramWithSource.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateProgramWithSource.getClContextAsset(callbacks, functionCall, contextAsset_id_value), contextAsset_id_value);
                    ClProgramAsset clProgramAsset = assetObject;
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> var1, @NonNull ClProgramAsset var2, @NonNull FunctionCall var3, @NonNull SimplePropertyValue<@Nullable String> var4, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> var5) throws Exception;
        }
    }

    public static final class ClSubBufferMemoryAssetValueProcessor
    extends AbstractLightweightAssetValueProcessor<CLApi, ClSubBufferMemoryAsset, ClSubBufferMemoryAsset.Value> {
        public static final @NonNull ClSubBufferMemoryAssetValueProcessor INSTANCE = new ClSubBufferMemoryAssetValueProcessor();
        private static final Map<IFunctionOrAliasSpecExtended, IFunctionProcessor> PROCESSOR_LOOKUP_MAP = new HashMap<IFunctionOrAliasSpecExtended, IFunctionProcessor>(){
            {
                this.put(KapiSpec.CL.functions.CLCREATESUBBUFFER, ClCreateSubBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLENQUEUECOPYBUFFER, ClEnqueueCopyBuffer.HELPER_INSTANCE);
                this.put(KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER, ClEnqueueWriteBuffer.HELPER_INSTANCE);
            }
        };

        private ClSubBufferMemoryAssetValueProcessor() {
        }

        @Override
        public @NonNull ClSubBufferMemoryAsset.Value execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClSubBufferMemoryAsset assetObject, @NonNull FunctionCallID lastCallID) throws Exception {
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset retained range");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClSubBufferMemoryAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset = assetObject.getImmutablePropertyContextAsset();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull CL.Structs.ClBufferRegionStruct> bufferRegion = assetObject.getImmutablePropertyBufferRegion();
            ImmutablePropertyValue<@NonNull ClMemoryAsset<?, ?>> parentBufferAsset = assetObject.getImmutablePropertyParentBufferAsset();
            FunctionCallID lastModifyingCallID = assetObject.getCreatingFunction().getID();
            for (FunctionCall functionCall : assetObject) {
                FunctionCallID currentCallID = functionCall.getID();
                if (currentCallID.compareTo(lastCallID) <= 0) {
                    if (this.process(callbacks, assetObject, functionCall, contextAsset, flags, bufferRegion, parentBufferAsset)) {
                        lastModifyingCallID = currentCallID;
                    }
                } else {
                    progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                    break;
                }
                progressMonitor.incProgress(currentCallID.delta(progressFrom));
                progressFrom = currentCallID;
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClSubBufferMemoryAsset.Value(validRange, assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<CL.Structs.ClBufferRegionStruct>)bufferRegion, (IAssetPropertyValue<ClMemoryAsset<?, ?>>)parentBufferAsset);
        }

        @Override
        public @NonNull ClSubBufferMemoryAsset.Value update(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ICoreProgressMonitor progressMonitor, @NonNull ClSubBufferMemoryAsset.Value fromValue, @NonNull FunctionCallID lastCallID) throws Exception {
            @NonNull ClSubBufferMemoryAsset assetObject = (ClSubBufferMemoryAsset)fromValue.getAssetObject();
            if (!assetObject.getLifecycleManager().isAssetRetained(lastCallID)) {
                throw new IndexOutOfBoundsException("Function call ID invalid for asset live range");
            }
            FunctionCallID startingCallID = fromValue.getValidFunctionCallRange().getTo();
            if (startingCallID.compareTo(lastCallID) > 0) {
                throw new IndexOutOfBoundsException("Value supplied is after specified function call ID");
            }
            FunctionCallID progressFrom = assetObject.getCreatingFunction().getID();
            progressMonitor.setTask("Get ClSubBufferMemoryAsset value at " + lastCallID, lastCallID.next().delta(progressFrom));
            ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset = assetObject.getImmutablePropertyContextAsset();
            ImmutablePropertyValue<@NonNull Bitfield> flags = assetObject.getImmutablePropertyFlags();
            ImmutablePropertyValue<@NonNull CL.Structs.ClBufferRegionStruct> bufferRegion = assetObject.getImmutablePropertyBufferRegion();
            ImmutablePropertyValue<@NonNull ClMemoryAsset<?, ?>> parentBufferAsset = assetObject.getImmutablePropertyParentBufferAsset();
            FunctionCallID lastModifyingCallID = fromValue.getValidFunctionCallRange().getFrom();
            FunctionCall firstCallToProcess = assetObject.findFirstFunctionCallOnOrAfter(startingCallID);
            if (firstCallToProcess != null) {
                int startingIndex = assetObject.indexOf(firstCallToProcess);
                int finishingIndex = assetObject.getFunctionCallCount();
                int index = startingIndex;
                while (index < finishingIndex) {
                    FunctionCall functionCall = assetObject.getFunctionCall(index);
                    FunctionCallID currentCallID = functionCall.getID();
                    if (currentCallID.compareTo(startingCallID) < 0) {
                        assert (false);
                    } else {
                        if (currentCallID.compareTo(lastCallID) <= 0) {
                            if (this.process(callbacks, assetObject, functionCall, contextAsset, flags, bufferRegion, parentBufferAsset)) {
                                lastModifyingCallID = currentCallID;
                            }
                        } else {
                            progressMonitor.incProgress(lastCallID.next().delta(progressFrom));
                            break;
                        }
                        progressMonitor.incProgress(currentCallID.delta(progressFrom));
                        progressFrom = currentCallID;
                    }
                    ++index;
                }
            }
            ClosedFunctionCallIDRange validRange = this.getFunctionCallRange(assetObject, lastModifyingCallID, lastCallID, callbacks.getLastProcessedCall());
            return new ClSubBufferMemoryAsset.Value(validRange, assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<CL.Structs.ClBufferRegionStruct>)bufferRegion, (IAssetPropertyValue<ClMemoryAsset<?, ?>>)parentBufferAsset);
        }

        private boolean process(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClSubBufferMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> flags, @NonNull ImmutablePropertyValue<@NonNull CL.Structs.ClBufferRegionStruct> bufferRegion, @NonNull ImmutablePropertyValue<@NonNull ClMemoryAsset<?, ?>> parentBufferAsset) throws Exception {
            List<AbstractFreeAttachment> freeAttachmentsToProcess;
            boolean result = false;
            if (!this.isIgnoredCall(callbacks, functionCall, false)) {
                IFunctionOrAliasSpecExtended iFunctionOrAliasSpecExtended = functionCall.getFunctionSpec();
                IFunctionProcessor functionProcessor = PROCESSOR_LOOKUP_MAP.get(iFunctionOrAliasSpecExtended);
                if (functionProcessor != null) {
                    result = functionProcessor.execute(callbacks, assetObject, functionCall, contextAsset, flags, bufferRegion, parentBufferAsset);
                }
                freeAttachmentsToProcess = functionCall.getFreeAttachments();
            } else {
                freeAttachmentsToProcess = new ArrayList<MidstreamDataAttachment>();
                MidstreamDataAttachment midstreamDataAttachment = functionCall.findFreeAttachment(MidstreamDataAttachment.class);
                if (midstreamDataAttachment != null) {
                    freeAttachmentsToProcess.add(midstreamDataAttachment);
                }
            }
            for (AbstractFreeAttachment abstractFreeAttachment : freeAttachmentsToProcess) {
                ClSubBufferMemoryAsset.Value processedValue;
                ClSubBufferMemoryAsset.Value unProcessedValue = new ClSubBufferMemoryAsset.Value(new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID()), assetObject, (IAssetPropertyValue<ClContextAsset>)contextAsset, (IAssetPropertyValue<Bitfield>)flags, (IAssetPropertyValue<CL.Structs.ClBufferRegionStruct>)bufferRegion, (IAssetPropertyValue<ClMemoryAsset<?, ?>>)parentBufferAsset);
                if (unProcessedValue == (processedValue = abstractFreeAttachment.processLightweightValue(callbacks, assetObject, unProcessedValue))) continue;
                result = true;
            }
            return result;
        }

        private static final class ClCreateSubBuffer
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClCreateSubBuffer HELPER_INSTANCE = new ClCreateSubBuffer();

            private ClCreateSubBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClSubBufferMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull CL.Structs.ClBufferRegionStruct> property_bufferRegion, @NonNull ImmutablePropertyValue<@NonNull ClMemoryAsset<?, ?>> property_parentBufferAsset) throws Exception {
                assert (KapiSpec.CL.functions.CLCREATESUBBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_buffer = CL.ClCreateSubBufferDecorator.getArgumentBuffer(functionCall);
                    Bitfield arg_flags = CL.ClCreateSubBufferDecorator.getArgumentFlags(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_buffer_create_type = CL.ClCreateSubBufferDecorator.getArgumentBuffer_create_type(functionCall);
                    CL.Structs.ClBufferRegionStruct arg_buffer_create_info = CL.ClCreateSubBufferDecorator.getArgumentBuffer_create_info(functionCall);
                    LongPtrArgAttachment arg_errcode_ret = CL.ClCreateSubBufferDecorator.getArgumentErrcode_ret(functionCall);
                    Pointer returnValue_ = CL.ClCreateSubBufferDecorator.getReturnValue(functionCall);
                    ClSubBufferMemoryAsset parentMemAsset = assetObject;
                    ClSubBufferMemoryAsset clMemoryAsset = assetObject;
                    return true;
                }
                return false;
            }
        }

        private static final class ClEnqueueCopyBuffer
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClEnqueueCopyBuffer HELPER_INSTANCE = new ClEnqueueCopyBuffer();

            private ClEnqueueCopyBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClSubBufferMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull CL.Structs.ClBufferRegionStruct> property_bufferRegion, @NonNull ImmutablePropertyValue<@NonNull ClMemoryAsset<?, ?>> property_parentBufferAsset) throws Exception {
                assert (KapiSpec.CL.functions.CLENQUEUECOPYBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_command_queue = CL.ClEnqueueCopyBufferDecorator.getArgumentCommand_queue(functionCall);
                    Pointer arg_src_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_buffer(functionCall);
                    Pointer arg_dst_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_buffer(functionCall);
                    Long arg_src_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_offset(functionCall);
                    Long arg_dst_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_offset(functionCall);
                    Long arg_size = CL.ClEnqueueCopyBufferDecorator.getArgumentSize(functionCall);
                    Long arg_num_events_in_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                    LongsArgAttachment arg_event_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent_wait_list(functionCall);
                    LongPtrArgAttachment arg_event = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueCopyBufferDecorator.getReturnValue(functionCall);
                    ClSubBufferMemoryAsset sourceBuffer = assetObject;
                    ClSubBufferMemoryAsset destinationBuffer = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForClMemoryAssetOnClEnqueueCopyBuffer(callbacks, functionCall, destinationBuffer, arg_command_queue, arg_src_buffer, arg_dst_buffer, arg_src_offset, arg_dst_offset, arg_size, arg_num_events_in_wait_list, arg_event_wait_list, arg_event, returnValue_, sourceBuffer);
                    return true;
                }
                return false;
            }
        }

        private static final class ClEnqueueWriteBuffer
        extends AbstractClAssetValueProcessorBase
        implements IFunctionProcessor {
            private static final ClEnqueueWriteBuffer HELPER_INSTANCE = new ClEnqueueWriteBuffer();

            private ClEnqueueWriteBuffer() {
            }

            @Override
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull ClSubBufferMemoryAsset assetObject, @NonNull FunctionCall functionCall, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> property_contextAsset, @NonNull ImmutablePropertyValue<@NonNull Bitfield> property_flags, @NonNull ImmutablePropertyValue<@NonNull CL.Structs.ClBufferRegionStruct> property_bufferRegion, @NonNull ImmutablePropertyValue<@NonNull ClMemoryAsset<?, ?>> property_parentBufferAsset) throws Exception {
                assert (KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER.equals(functionCall.getFunctionSpec()));
                if (!functionCall.hasError()) {
                    Pointer arg_command_queue = CL.ClEnqueueWriteBufferDecorator.getArgumentCommand_queue(functionCall);
                    Pointer arg_buffer = CL.ClEnqueueWriteBufferDecorator.getArgumentBuffer(functionCall);
                    AbstractConstantOrAliasSpecExtended arg_blocking_write = CL.ClEnqueueWriteBufferDecorator.getArgumentBlocking_write(functionCall);
                    Long arg_offset = CL.ClEnqueueWriteBufferDecorator.getArgumentOffset(functionCall);
                    Long arg_size = CL.ClEnqueueWriteBufferDecorator.getArgumentSize(functionCall);
                    BufferArgAttachment arg_ptr = CL.ClEnqueueWriteBufferDecorator.getArgumentPtr(functionCall);
                    Long arg_num_events_in_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                    LongsArgAttachment arg_event_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent_wait_list(functionCall);
                    LongPtrArgAttachment arg_event = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent(functionCall);
                    AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueWriteBufferDecorator.getReturnValue(functionCall);
                    ClSubBufferMemoryAsset bufferAsset = assetObject;
                    ProvidedAssetProcessors.processProvidedActionForClMemoryAssetOnClEnqueueWriteBuffer(callbacks, functionCall, bufferAsset, arg_command_queue, arg_buffer, arg_blocking_write, arg_offset, arg_size, arg_ptr, arg_num_events_in_wait_list, arg_event_wait_list, arg_event, returnValue_);
                    return true;
                }
                return false;
            }
        }

        public static interface IFunctionProcessor {
            public boolean execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> var1, @NonNull ClSubBufferMemoryAsset var2, @NonNull FunctionCall var3, @NonNull ImmutablePropertyValue<@NonNull ClContextAsset> var4, @NonNull ImmutablePropertyValue<@NonNull Bitfield> var5, @NonNull ImmutablePropertyValue<@NonNull CL.Structs.ClBufferRegionStruct> var6, @NonNull ImmutablePropertyValue<@NonNull ClMemoryAsset<?, ?>> var7) throws Exception;
        }
    }
}

