/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.cl;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.CL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.cl.ClBufferMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClContextAsset;
import com.arm.mgd.lightweight.asset.cl.ClImageMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClKernelAsset;
import com.arm.mgd.lightweight.asset.cl.ClMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClProgramAsset;
import com.arm.mgd.lightweight.asset.cl.ClSubBufferMemoryAsset;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.cl.AbstractClAssetCallProcessorBase;
import com.arm.mgd.lightweight.model.api.CLApi;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ClAssetCallProcessor {
    private static final Map<IFunctionOrAliasSpecExtended, AbstractLightweightAssetFunctionCallProcessor> ASSET_PROCESSORS = new HashMap<IFunctionOrAliasSpecExtended, AbstractLightweightAssetFunctionCallProcessor>(){
        {
            this.put(KapiSpec.CL.functions.CLCREATEBUFFER, new ClCreateBuffer());
            this.put(KapiSpec.CL.functions.CLCREATECONTEXT, new ClCreateContext());
            this.put(KapiSpec.CL.functions.CLCREATECONTEXTFROMTYPE, new ClCreateContextFromType());
            this.put(KapiSpec.CL.functions.CLCREATEIMAGE, new ClCreateImage());
            this.put(KapiSpec.CL.functions.CLCREATEIMAGE2D, new ClCreateImage2D());
            this.put(KapiSpec.CL.functions.CLCREATEIMAGE3D, new ClCreateImage3D());
            this.put(KapiSpec.CL.functions.CLCREATEPROGRAMWITHBINARY, new ClCreateProgramWithBinary());
            this.put(KapiSpec.CL.functions.CLCREATEPROGRAMWITHSOURCE, new ClCreateProgramWithSource());
            this.put(KapiSpec.CL.functions.CLCREATESUBBUFFER, new ClCreateSubBuffer());
            this.put(KapiSpec.CL.functions.CLENQUEUECOPYBUFFER, new ClEnqueueCopyBuffer());
            this.put(KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER, new ClEnqueueWriteBuffer());
            this.put(KapiSpec.CL.functions.CLRELEASECONTEXT, new ClReleaseContext());
            this.put(KapiSpec.CL.functions.CLRELEASEKERNEL, new ClReleaseKernel());
            this.put(KapiSpec.CL.functions.CLRELEASEMEMOBJECT, new ClReleaseMemObject());
            this.put(KapiSpec.CL.functions.CLRELEASEPROGRAM, new ClReleaseProgram());
            this.put(KapiSpec.CL.functions.CLRETAINCONTEXT, new ClRetainContext());
            this.put(KapiSpec.CL.functions.CLRETAINKERNEL, new ClRetainKernel());
            this.put(KapiSpec.CL.functions.CLRETAINMEMOBJECT, new ClRetainMemObject());
            this.put(KapiSpec.CL.functions.CLRETAINPROGRAM, new ClRetainProgram());
        }
    };

    public static @Nullable AbstractLightweightAssetFunctionCallProcessor forFunctionCall(@NonNull FunctionCall functionCall) {
        if (functionCall.hasError()) {
            return null;
        }
        return ASSET_PROCESSORS.get(functionCall.getFunctionSpec());
    }

    public static final class ClCreateBuffer
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateBufferDecorator.getArgumentContext(functionCall);
                Bitfield arg_flags = CL.ClCreateBufferDecorator.getArgumentFlags(functionCall);
                Long arg_size = CL.ClCreateBufferDecorator.getArgumentSize(functionCall);
                BufferArgAttachment arg_host_ptr = CL.ClCreateBufferDecorator.getArgumentHost_ptr(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateBufferDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateBufferDecorator.getReturnValue(functionCall);
                AssetItemID contextAsset_id_value = AssetItemID.valueOf(arg_context);
                ClContextAsset contextAsset = ClCreateBuffer.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateBuffer.getClContextAsset(callbacks, functionCall, contextAsset_id_value), contextAsset_id_value);
                AssetItemID clMemoryAsset_id_value = AssetItemID.valueOf(returnValue_);
                ClBufferMemoryAsset clBufferMemoryAsset = this.createNewClBufferMemoryAsset(callbacks, functionCall, clMemoryAsset_id_value, contextAsset, arg_flags);
            }
        }
    }

    public static final class ClCreateContext
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATECONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_properties = CL.ClCreateContextDecorator.getArgumentProperties(functionCall);
                Long arg_num_devices = CL.ClCreateContextDecorator.getArgumentNum_devices(functionCall);
                LongsArgAttachment arg_devices = CL.ClCreateContextDecorator.getArgumentDevices(functionCall);
                Pointer arg_pfn_notify = CL.ClCreateContextDecorator.getArgumentPfn_notify(functionCall);
                Pointer arg_user_data = CL.ClCreateContextDecorator.getArgumentUser_data(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateContextDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateContextDecorator.getReturnValue(functionCall);
                if (!returnValue_.equals(Pointer.NULL)) {
                    AssetItemID contextAsset_id_value = AssetItemID.valueOf(returnValue_);
                    ClContextAsset clContextAsset = this.createNewClContextAsset(callbacks, functionCall, contextAsset_id_value);
                }
            }
        }
    }

    public static final class ClCreateContextFromType
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATECONTEXTFROMTYPE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_properties = CL.ClCreateContextFromTypeDecorator.getArgumentProperties(functionCall);
                Bitfield arg_device_type = CL.ClCreateContextFromTypeDecorator.getArgumentDevice_type(functionCall);
                Pointer arg_pfn_notify = CL.ClCreateContextFromTypeDecorator.getArgumentPfn_notify(functionCall);
                Pointer arg_user_data = CL.ClCreateContextFromTypeDecorator.getArgumentUser_data(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateContextFromTypeDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateContextFromTypeDecorator.getReturnValue(functionCall);
                if (!returnValue_.equals(Pointer.NULL)) {
                    AssetItemID contextAsset_id_value = AssetItemID.valueOf(returnValue_);
                    ClContextAsset clContextAsset = this.createNewClContextAsset(callbacks, functionCall, contextAsset_id_value);
                }
            }
        }
    }

    public static final class ClCreateImage
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateImageDecorator.getArgumentContext(functionCall);
                Bitfield arg_flags = CL.ClCreateImageDecorator.getArgumentFlags(functionCall);
                CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImageDecorator.getArgumentImage_format(functionCall);
                CL.Structs.ClImageDescStruct arg_image_desc = CL.ClCreateImageDecorator.getArgumentImage_desc(functionCall);
                BufferArgAttachment arg_host_ptr = CL.ClCreateImageDecorator.getArgumentHost_ptr(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImageDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateImageDecorator.getReturnValue(functionCall);
                AssetItemID imageContextAsset_id_value = AssetItemID.valueOf(arg_context);
                ClContextAsset imageContextAsset = ClCreateImage.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateImage.getClContextAsset(callbacks, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                AssetItemID imageAsset_id_value = AssetItemID.valueOf(returnValue_);
                assert (arg_image_format.getImage_channel_data_type() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_0 = ClCreateImage.validateConstantIsInSetLogError(callbacks, functionCall, arg_image_format.getImage_channel_data_type(), Constants.CONSTANT_SET_0);
                assert (arg_image_format.getImage_channel_order() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_1 = ClCreateImage.validateConstantIsInSetLogError(callbacks, functionCall, arg_image_format.getImage_channel_order(), Constants.CONSTANT_SET_1);
                assert (arg_image_desc.getImage_type() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_2 = ClCreateImage.validateConstantIsInSetLogError(callbacks, functionCall, arg_image_desc.getImage_type(), Constants.CONSTANT_SET_2);
                ClImageMemoryAsset clImageMemoryAsset = this.createNewClImageMemoryAsset(callbacks, functionCall, imageAsset_id_value, imageContextAsset, arg_flags, temp_validateConstantIsInSetLogError_return_value_0, temp_validateConstantIsInSetLogError_return_value_1, temp_validateConstantIsInSetLogError_return_value_2);
            }
        }
    }

    public static final class ClCreateImage2D
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEIMAGE2D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateImage2DDecorator.getArgumentContext(functionCall);
                Bitfield arg_flags = CL.ClCreateImage2DDecorator.getArgumentFlags(functionCall);
                CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImage2DDecorator.getArgumentImage_format(functionCall);
                Long arg_image_width = CL.ClCreateImage2DDecorator.getArgumentImage_width(functionCall);
                Long arg_image_height = CL.ClCreateImage2DDecorator.getArgumentImage_height(functionCall);
                Long arg_image_row_pitch = CL.ClCreateImage2DDecorator.getArgumentImage_row_pitch(functionCall);
                BufferArgAttachment arg_host_ptr = CL.ClCreateImage2DDecorator.getArgumentHost_ptr(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImage2DDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateImage2DDecorator.getReturnValue(functionCall);
                AssetItemID imageContextAsset_id_value = AssetItemID.valueOf(arg_context);
                ClContextAsset imageContextAsset = ClCreateImage2D.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateImage2D.getClContextAsset(callbacks, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                AssetItemID imageAsset_id_value = AssetItemID.valueOf(returnValue_);
                assert (arg_image_format.getImage_channel_data_type() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_0 = ClCreateImage2D.validateConstantIsInSetLogError(callbacks, functionCall, arg_image_format.getImage_channel_data_type(), Constants.CONSTANT_SET_0);
                assert (arg_image_format.getImage_channel_order() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_1 = ClCreateImage2D.validateConstantIsInSetLogError(callbacks, functionCall, arg_image_format.getImage_channel_order(), Constants.CONSTANT_SET_1);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_2 = ClCreateImage2D.validateConstantIsInSetLogError(callbacks, functionCall, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D, Constants.CONSTANT_SET_2);
                ClImageMemoryAsset clImageMemoryAsset = this.createNewClImageMemoryAsset(callbacks, functionCall, imageAsset_id_value, imageContextAsset, arg_flags, temp_validateConstantIsInSetLogError_return_value_0, temp_validateConstantIsInSetLogError_return_value_1, temp_validateConstantIsInSetLogError_return_value_2);
            }
        }
    }

    public static final class ClCreateImage3D
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEIMAGE3D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateImage3DDecorator.getArgumentContext(functionCall);
                Bitfield arg_flags = CL.ClCreateImage3DDecorator.getArgumentFlags(functionCall);
                CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImage3DDecorator.getArgumentImage_format(functionCall);
                Long arg_image_width = CL.ClCreateImage3DDecorator.getArgumentImage_width(functionCall);
                Long arg_image_height = CL.ClCreateImage3DDecorator.getArgumentImage_height(functionCall);
                Long arg_image_depth = CL.ClCreateImage3DDecorator.getArgumentImage_depth(functionCall);
                Long arg_image_row_pitch = CL.ClCreateImage3DDecorator.getArgumentImage_row_pitch(functionCall);
                Long arg_image_slice_pitch = CL.ClCreateImage3DDecorator.getArgumentImage_slice_pitch(functionCall);
                BufferArgAttachment arg_host_ptr = CL.ClCreateImage3DDecorator.getArgumentHost_ptr(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImage3DDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateImage3DDecorator.getReturnValue(functionCall);
                AssetItemID imageContextAsset_id_value = AssetItemID.valueOf(arg_context);
                ClContextAsset imageContextAsset = ClCreateImage3D.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateImage3D.getClContextAsset(callbacks, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                AssetItemID imageAsset_id_value = AssetItemID.valueOf(returnValue_);
                assert (arg_image_format.getImage_channel_data_type() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_0 = ClCreateImage3D.validateConstantIsInSetLogError(callbacks, functionCall, arg_image_format.getImage_channel_data_type(), Constants.CONSTANT_SET_0);
                assert (arg_image_format.getImage_channel_order() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_1 = ClCreateImage3D.validateConstantIsInSetLogError(callbacks, functionCall, arg_image_format.getImage_channel_order(), Constants.CONSTANT_SET_1);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_2 = ClCreateImage3D.validateConstantIsInSetLogError(callbacks, functionCall, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE3D, Constants.CONSTANT_SET_2);
                ClImageMemoryAsset clImageMemoryAsset = this.createNewClImageMemoryAsset(callbacks, functionCall, imageAsset_id_value, imageContextAsset, arg_flags, temp_validateConstantIsInSetLogError_return_value_0, temp_validateConstantIsInSetLogError_return_value_1, temp_validateConstantIsInSetLogError_return_value_2);
            }
        }
    }

    public static final class ClCreateProgramWithBinary
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEPROGRAMWITHBINARY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateProgramWithBinaryDecorator.getArgumentContext(functionCall);
                Long arg_num_devices = CL.ClCreateProgramWithBinaryDecorator.getArgumentNum_devices(functionCall);
                LongsArgAttachment arg_device_list = CL.ClCreateProgramWithBinaryDecorator.getArgumentDevice_list(functionCall);
                LongsArgAttachment arg_lengths = CL.ClCreateProgramWithBinaryDecorator.getArgumentLengths(functionCall);
                Pointer arg_binaries = CL.ClCreateProgramWithBinaryDecorator.getArgumentBinaries(functionCall);
                LongsArgAttachment arg_binary_status = CL.ClCreateProgramWithBinaryDecorator.getArgumentBinary_status(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateProgramWithBinaryDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateProgramWithBinaryDecorator.getReturnValue(functionCall);
                AssetItemID contextAsset_id_value = AssetItemID.valueOf(arg_context);
                ClContextAsset contextAsset = ClCreateProgramWithBinary.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateProgramWithBinary.getClContextAsset(callbacks, functionCall, contextAsset_id_value), contextAsset_id_value);
                AssetItemID clProgramAsset_id_value = AssetItemID.valueOf(returnValue_);
                ClProgramAsset clProgramAsset = this.createNewClProgramAsset(callbacks, functionCall, clProgramAsset_id_value, contextAsset);
            }
        }
    }

    public static final class ClCreateProgramWithSource
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEPROGRAMWITHSOURCE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateProgramWithSourceDecorator.getArgumentContext(functionCall);
                Long arg_count = CL.ClCreateProgramWithSourceDecorator.getArgumentCount(functionCall);
                StringsArgAttachment arg_strings = CL.ClCreateProgramWithSourceDecorator.getArgumentStrings(functionCall);
                LongsArgAttachment arg_lengths = CL.ClCreateProgramWithSourceDecorator.getArgumentLengths(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateProgramWithSourceDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateProgramWithSourceDecorator.getReturnValue(functionCall);
                AssetItemID contextAsset_id_value = AssetItemID.valueOf(arg_context);
                ClContextAsset contextAsset = ClCreateProgramWithSource.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClCreateProgramWithSource.getClContextAsset(callbacks, functionCall, contextAsset_id_value), contextAsset_id_value);
                AssetItemID clProgramAsset_id_value = AssetItemID.valueOf(returnValue_);
                ClProgramAsset clProgramAsset = this.createNewClProgramAsset(callbacks, functionCall, clProgramAsset_id_value, contextAsset);
            }
        }
    }

    public static final class ClCreateSubBuffer
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATESUBBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_buffer = CL.ClCreateSubBufferDecorator.getArgumentBuffer(functionCall);
                Bitfield arg_flags = CL.ClCreateSubBufferDecorator.getArgumentFlags(functionCall);
                AbstractConstantOrAliasSpecExtended arg_buffer_create_type = CL.ClCreateSubBufferDecorator.getArgumentBuffer_create_type(functionCall);
                CL.Structs.ClBufferRegionStruct arg_buffer_create_info = CL.ClCreateSubBufferDecorator.getArgumentBuffer_create_info(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateSubBufferDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateSubBufferDecorator.getReturnValue(functionCall);
                AssetItemID parentMemAsset_id_value = AssetItemID.valueOf(arg_buffer);
                ClMemoryAsset<?, ?> parentMemAsset = ClCreateSubBuffer.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, callbacks, functionCall, ClCreateSubBuffer.getClMemoryAsset(callbacks, functionCall, parentMemAsset_id_value), parentMemAsset_id_value);
                AssetItemID clMemoryAsset_id_value = AssetItemID.valueOf(returnValue_);
                ClContextAsset temp_getValue_return_value_0 = parentMemAsset.getImmutablePropertyContextAsset().getValue();
                ClSubBufferMemoryAsset clSubBufferMemoryAsset = this.createNewClSubBufferMemoryAsset(callbacks, functionCall, clMemoryAsset_id_value, temp_getValue_return_value_0, arg_flags, arg_buffer_create_info, parentMemAsset);
            }
        }
    }

    public static final class ClEnqueueCopyBuffer
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLENQUEUECOPYBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_command_queue = CL.ClEnqueueCopyBufferDecorator.getArgumentCommand_queue(functionCall);
                Pointer arg_src_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_buffer(functionCall);
                Pointer arg_dst_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_buffer(functionCall);
                Long arg_src_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_offset(functionCall);
                Long arg_dst_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_offset(functionCall);
                Long arg_size = CL.ClEnqueueCopyBufferDecorator.getArgumentSize(functionCall);
                Long arg_num_events_in_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                LongsArgAttachment arg_event_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent_wait_list(functionCall);
                LongPtrArgAttachment arg_event = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueCopyBufferDecorator.getReturnValue(functionCall);
                AssetItemID sourceBuffer_id_value = AssetItemID.valueOf(arg_src_buffer);
                ClMemoryAsset<?, ?> sourceBuffer = ClEnqueueCopyBuffer.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, callbacks, functionCall, ClEnqueueCopyBuffer.getClMemoryAsset(callbacks, functionCall, sourceBuffer_id_value), sourceBuffer_id_value);
                AssetItemID destinationBuffer_id_value = AssetItemID.valueOf(arg_dst_buffer);
                ClMemoryAsset<?, ?> destinationBuffer = ClEnqueueCopyBuffer.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, callbacks, functionCall, ClEnqueueCopyBuffer.getClMemoryAsset(callbacks, functionCall, destinationBuffer_id_value), destinationBuffer_id_value);
                destinationBuffer.addFunctionCall(functionCall);
            }
        }
    }

    public static final class ClEnqueueWriteBuffer
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_command_queue = CL.ClEnqueueWriteBufferDecorator.getArgumentCommand_queue(functionCall);
                Pointer arg_buffer = CL.ClEnqueueWriteBufferDecorator.getArgumentBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended arg_blocking_write = CL.ClEnqueueWriteBufferDecorator.getArgumentBlocking_write(functionCall);
                Long arg_offset = CL.ClEnqueueWriteBufferDecorator.getArgumentOffset(functionCall);
                Long arg_size = CL.ClEnqueueWriteBufferDecorator.getArgumentSize(functionCall);
                BufferArgAttachment arg_ptr = CL.ClEnqueueWriteBufferDecorator.getArgumentPtr(functionCall);
                Long arg_num_events_in_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                LongsArgAttachment arg_event_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent_wait_list(functionCall);
                LongPtrArgAttachment arg_event = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueWriteBufferDecorator.getReturnValue(functionCall);
                AssetItemID bufferAsset_id_value = AssetItemID.valueOf(arg_buffer);
                ClMemoryAsset<?, ?> bufferAsset = ClEnqueueWriteBuffer.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, callbacks, functionCall, ClEnqueueWriteBuffer.getClMemoryAsset(callbacks, functionCall, bufferAsset_id_value), bufferAsset_id_value);
                bufferAsset.addFunctionCall(functionCall);
            }
        }
    }

    public static final class ClReleaseContext
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRELEASECONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClReleaseContextDecorator.getArgumentContext(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClReleaseContextDecorator.getReturnValue(functionCall);
                AssetItemID contextAsset_id_value = AssetItemID.valueOf(arg_context);
                ClContextAsset contextAsset = ClReleaseContext.warnIfMissingAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClReleaseContext.getClContextAsset(callbacks, functionCall, contextAsset_id_value), contextAsset_id_value, AssetItemID.valueOf(0));
                if (contextAsset != null) {
                    contextAsset.addFunctionCall(functionCall);
                    contextAsset.getLifecycleManager().release(functionCall);
                }
            }
        }
    }

    public static final class ClReleaseKernel
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRELEASEKERNEL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_kernel = CL.ClReleaseKernelDecorator.getArgumentKernel(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClReleaseKernelDecorator.getReturnValue(functionCall);
                AssetItemID kernelAsset_id_value = AssetItemID.valueOf(arg_kernel);
                ClKernelAsset kernelAsset = ClReleaseKernel.warnIfMissingAsset(KapiSpec.CL.assetTables.KERNEL_TRAITS, callbacks, functionCall, ClReleaseKernel.getClKernelAsset(callbacks, functionCall, kernelAsset_id_value), kernelAsset_id_value, AssetItemID.valueOf(0));
                if (kernelAsset != null) {
                    kernelAsset.addFunctionCall(functionCall);
                    kernelAsset.getLifecycleManager().release(functionCall);
                }
            }
        }
    }

    public static final class ClReleaseMemObject
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRELEASEMEMOBJECT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_memobj = CL.ClReleaseMemObjectDecorator.getArgumentMemobj(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClReleaseMemObjectDecorator.getReturnValue(functionCall);
                AssetItemID memoryAsset_id_value = AssetItemID.valueOf(arg_memobj);
                ClMemoryAsset<?, ?> memoryAsset = ClReleaseMemObject.warnIfMissingAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, callbacks, functionCall, ClReleaseMemObject.getClMemoryAsset(callbacks, functionCall, memoryAsset_id_value), memoryAsset_id_value, AssetItemID.valueOf(0));
                if (memoryAsset != null) {
                    memoryAsset.addFunctionCall(functionCall);
                    memoryAsset.getLifecycleManager().release(functionCall);
                }
            }
        }
    }

    public static final class ClReleaseProgram
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRELEASEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_program = CL.ClReleaseProgramDecorator.getArgumentProgram(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClReleaseProgramDecorator.getReturnValue(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                ClProgramAsset programAsset = ClReleaseProgram.warnIfMissingAsset(KapiSpec.CL.assetTables.PROGRAM_TRAITS, callbacks, functionCall, ClReleaseProgram.getClProgramAsset(callbacks, functionCall, programAsset_id_value), programAsset_id_value, AssetItemID.valueOf(0));
                if (programAsset != null) {
                    programAsset.addFunctionCall(functionCall);
                    programAsset.getLifecycleManager().release(functionCall);
                }
            }
        }
    }

    public static final class ClRetainContext
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRETAINCONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClRetainContextDecorator.getArgumentContext(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClRetainContextDecorator.getReturnValue(functionCall);
                AssetItemID contextAsset_id_value = AssetItemID.valueOf(arg_context);
                ClContextAsset contextAsset = ClRetainContext.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, callbacks, functionCall, ClRetainContext.getClContextAsset(callbacks, functionCall, contextAsset_id_value), contextAsset_id_value);
                contextAsset.addFunctionCall(functionCall);
                contextAsset.getLifecycleManager().retain(functionCall);
            }
        }
    }

    public static final class ClRetainKernel
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRETAINKERNEL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_kernel = CL.ClRetainKernelDecorator.getArgumentKernel(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClRetainKernelDecorator.getReturnValue(functionCall);
                AssetItemID kernelAsset_id_value = AssetItemID.valueOf(arg_kernel);
                ClKernelAsset kernelAsset = ClRetainKernel.requireAsset(KapiSpec.CL.assetTables.KERNEL_TRAITS, callbacks, functionCall, ClRetainKernel.getClKernelAsset(callbacks, functionCall, kernelAsset_id_value), kernelAsset_id_value);
                kernelAsset.addFunctionCall(functionCall);
                kernelAsset.getLifecycleManager().retain(functionCall);
            }
        }
    }

    public static final class ClRetainMemObject
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRETAINMEMOBJECT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_memobj = CL.ClRetainMemObjectDecorator.getArgumentMemobj(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClRetainMemObjectDecorator.getReturnValue(functionCall);
                AssetItemID memoryAsset_id_value = AssetItemID.valueOf(arg_memobj);
                ClMemoryAsset<?, ?> memoryAsset = ClRetainMemObject.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, callbacks, functionCall, ClRetainMemObject.getClMemoryAsset(callbacks, functionCall, memoryAsset_id_value), memoryAsset_id_value);
                memoryAsset.addFunctionCall(functionCall);
                memoryAsset.getLifecycleManager().retain(functionCall);
            }
        }
    }

    public static final class ClRetainProgram
    extends AbstractClAssetCallProcessorBase {
        @Override
        public void execute(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRETAINPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_program = CL.ClRetainProgramDecorator.getArgumentProgram(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClRetainProgramDecorator.getReturnValue(functionCall);
                AssetItemID programAsset_id_value = AssetItemID.valueOf(arg_program);
                ClProgramAsset programAsset = ClRetainProgram.requireAsset(KapiSpec.CL.assetTables.PROGRAM_TRAITS, callbacks, functionCall, ClRetainProgram.getClProgramAsset(callbacks, functionCall, programAsset_id_value), programAsset_id_value);
                programAsset.addFunctionCall(functionCall);
                programAsset.getLifecycleManager().retain(functionCall);
            }
        }
    }

    private static class Constants {
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_0 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.CL.constants.CL_SNORM_INT8, KapiSpec.CL.constants.CL_SIGNED_INT32, KapiSpec.CL.constants.CL_UNORM_INT16, KapiSpec.CL.constants.CL_UNORM_SHORT_565, KapiSpec.CL.constants.CL_UNORM_SHORT_555, KapiSpec.CL.constants.CL_UNSIGNED_INT32, KapiSpec.CL.constants.CL_FLOAT, KapiSpec.CL.constants.CL_SIGNED_INT16, KapiSpec.CL.constants.CL_UNORM_INT_101010, KapiSpec.CL.constants.CL_HALF_FLOAT, KapiSpec.CL.constants.CL_SIGNED_INT8, KapiSpec.CL.constants.CL_UNORM_INT8, KapiSpec.CL.constants.CL_SNORM_INT16, KapiSpec.CL.constants.CL_UNSIGNED_INT8, KapiSpec.CL.constants.CL_UNSIGNED_INT16));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_1 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.CL.constants.CL_RG, KapiSpec.CL.constants.CL_RGBA, KapiSpec.CL.constants.CL_RA, KapiSpec.CL.constants.CL_BGRA, KapiSpec.CL.constants.CL_RX, KapiSpec.CL.constants.CL_LUMINANCE, KapiSpec.CL.constants.CL_RGBX, KapiSpec.CL.constants.CL_ARGB, KapiSpec.CL.constants.CL_RGB, KapiSpec.CL.constants.CL_INTENSITY, KapiSpec.CL.constants.CL_R, KapiSpec.CL.constants.CL_A, KapiSpec.CL.constants.CL_RGX));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_2 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D_ARRAY, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D_BUFFER, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D_ARRAY, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE3D));

        private Constants() {
        }
    }
}

