/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor.attachments;

import com.arm.mgd.core.midstream.LightweightAssetBuilder;
import com.arm.mgd.core.midstream.LightweightAssetValueBuilder;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.MidstreamDataAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.MidstreamAssetFactory;
import com.arm.mgd.lightweight.asset.processor.AbstractLightweightAssetFunctionCallProcessor;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.processor.gles.AbstractGlesAssetValueProcessorBase;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class MidstreamDataAttachmentLightweightProcessor {

    public static class CallProcessor<API_MODEL>
    extends AbstractLightweightAssetFunctionCallProcessor<API_MODEL> {
        private final LightweightAssetBuilder<API_MODEL> assetBuilder;
        private final MidstreamDataAttachment attachment;

        public CallProcessor(MidstreamDataAttachment attachment, LightweightAssetBuilder<API_MODEL> assetBuilder) {
            this.attachment = attachment;
            this.assetBuilder = assetBuilder;
        }

        @Override
        public void execute(ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, FunctionCall functionCall) throws Exception {
            this.assetBuilder.updateState();
            callbacks.addMidstreamTraceStateUpdates(functionCall, this.attachment.getStateItemsAsMap());
        }
    }

    public static class ValueProcessor
    extends AbstractGlesAssetValueProcessorBase {
        private final MidstreamDataAttachment attachment;

        public ValueProcessor(MidstreamDataAttachment attachment) {
            this.attachment = attachment;
        }

        public <M, P extends IAssetItem<M, V>, V extends IAssetItem.Value<P>> V execute(ILightweightAssetProcessorCallbacks<M> callbacks, P assetObject, V value) throws Exception {
            MidstreamAssetItem assetAttachment = this.attachment.findAssetAttachmentFor(assetObject);
            if (assetAttachment == null) {
                CoreLogging.warning(callbacks, "No update data found for asset value: " + assetObject);
                return value;
            }
            return MidstreamAssetFactory.update(new LightweightAssetValueBuilder<M>(callbacks, this.attachment), assetAttachment, this.attachment.getParentFunctionCall(), value);
        }
    }
}

