/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.properties.ImmutablePropertyValue;
import com.arm.mgd.lightweight.asset.properties.ListPropertyValue;
import com.arm.mgd.lightweight.asset.properties.MapPropertyValue;
import com.arm.mgd.lightweight.asset.properties.SimplePropertyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractLightweightAssetValueProcessor<API_MODEL, ASSET_TYPE extends IAssetItem<API_MODEL, VALUE_TYPE>, VALUE_TYPE extends IAssetItem.Value<ASSET_TYPE>> {
    public abstract @NonNull VALUE_TYPE execute(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> var1, @NonNull ICoreProgressMonitor var2, @NonNull ASSET_TYPE var3, @NonNull FunctionCallID var4) throws Exception;

    public abstract @NonNull VALUE_TYPE update(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> var1, @NonNull ICoreProgressMonitor var2, @NonNull VALUE_TYPE var3, @NonNull FunctionCallID var4) throws Exception;

    protected <T> void ensureAssetReferencesValidAt(@NonNull ImmutablePropertyValue<T> property, @NonNull FunctionCall functionCall) {
        this.ensureAssetReferencesValidAt(property.getValue(), functionCall);
    }

    private <T> void ensureAssetReferencesValidAt(@Nullable T assetValue, @NonNull FunctionCall functionCall) {
        if (assetValue != null) {
            if (assetValue instanceof IAssetItem) {
                assert (((IAssetItem)assetValue).getLifecycleManager().isAssetRetained(functionCall.getID())) : "Expected an immutable property to be available at this point: " + functionCall + " @ " + functionCall.getID();
            } else if (assetValue instanceof List) {
                for (Object item : (List)assetValue) {
                    this.ensureAssetReferencesValidAt(item, functionCall);
                }
            } else assert (false) : "Expected the property to either be null, an IAssetItem or a list of IAssetItems: " + assetValue;
        }
    }

    protected <K, T extends IAssetItem<API_MODEL, ?>> void ensureAssetReferencesValidAt(@NonNull MapPropertyValue<K, T> property, @NonNull FunctionCall functionCall) {
        ArrayList keysForRemoval = new ArrayList(0);
        for (Map.Entry entry : property.getValue().entrySet()) {
            @Nullable IAssetItem assetValue = (IAssetItem)entry.getValue();
            if (assetValue == null || assetValue.getLifecycleManager().isAssetRetained(functionCall.getID())) continue;
            keysForRemoval.add(entry.getKey());
        }
        property.eraseKeys(functionCall, keysForRemoval);
    }

    protected <T extends IAssetItem<API_MODEL, ?>> void ensureAssetReferencesValidAt(@NonNull ListPropertyValue<T> property, @NonNull FunctionCall functionCall) {
        ArrayList values = new ArrayList(property.getValue());
        for (IAssetItem assetValue : values) {
            if (assetValue == null || assetValue.getLifecycleManager().isAssetRetained(functionCall.getID())) continue;
            property.removeValue(functionCall, assetValue);
        }
    }

    protected <T extends IAssetItem<API_MODEL, ?>> void ensureAssetReferencesValidAt(@NonNull SimplePropertyValue<@Nullable T> property, @NonNull FunctionCall functionCall) {
        @Nullable IAssetItem assetValue = (IAssetItem)property.getValue();
        if (assetValue != null && !assetValue.getLifecycleManager().isAssetRetained(functionCall.getID())) {
            property.setValue(functionCall, null);
        }
    }

    protected @NonNull ClosedFunctionCallIDRange getFunctionCallRange(@NonNull ASSET_TYPE assetObject, @NonNull FunctionCallID lastAffectingCallID, @NonNull FunctionCallID targetCallID, @Nullable FunctionCall lastProcessedCall) {
        FunctionCall firstCallAfterTarget = assetObject.findFirstFunctionCallAfter(targetCallID);
        FunctionCall rangeEndCall = firstCallAfterTarget != null ? firstCallAfterTarget : lastProcessedCall;
        FunctionCallID rangeEndID = rangeEndCall != null ? rangeEndCall.getID() : lastAffectingCallID.next();
        FunctionCallID toID = rangeEndID.compareTo(lastAffectingCallID) > 0 ? rangeEndID : lastAffectingCallID.next();
        return new ClosedFunctionCallIDRange(lastAffectingCallID, toID);
    }

    protected boolean isIgnoredCall(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, boolean isLocalScope) {
        return callbacks.isIgnoredCall(functionCall, isLocalScope);
    }
}

