/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.asset.processor;

import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.asset.processors.MissingAssetException;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.TargetBindingGroupSpec;
import com.arm.mgd.kapi.gen.TargetBindingSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.asset.cl.ClContextAsset;
import com.arm.mgd.lightweight.asset.cl.ClKernelAsset;
import com.arm.mgd.lightweight.asset.cl.ClMemoryAsset;
import com.arm.mgd.lightweight.asset.cl.ClProgramAsset;
import com.arm.mgd.lightweight.asset.egl.EglConfigAsset;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.egl.EglImageAsset;
import com.arm.mgd.lightweight.asset.egl.EglPbufferSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglPixmapSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglSurfaceAsset;
import com.arm.mgd.lightweight.asset.egl.EglSyncAsset;
import com.arm.mgd.lightweight.asset.egl.EglWindowSurfaceAsset;
import com.arm.mgd.lightweight.asset.gles.GlAtomicCounterBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlBufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferRenderbufferAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferTextureAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlFramebufferZeroAttachmentAsset;
import com.arm.mgd.lightweight.asset.gles.GlImageUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramAsset;
import com.arm.mgd.lightweight.asset.gles.GlProgramPipelineAsset;
import com.arm.mgd.lightweight.asset.gles.GlQueryObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlRenderbufferAsset;
import com.arm.mgd.lightweight.asset.gles.GlSamplerAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderAsset;
import com.arm.mgd.lightweight.asset.gles.GlShaderStorageBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlSyncObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureImageAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureSurfaceAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureUnitAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackAsset;
import com.arm.mgd.lightweight.asset.gles.GlTransformFeedbackBufferBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlUniformBindingPointAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexArrayObjectAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.lightweight.asset.gles.GlVertexBufferBindingAsset;
import com.arm.mgd.lightweight.asset.gles.ShaderUniform;
import com.arm.mgd.lightweight.asset.processor.ILightweightAssetProcessorCallbacks;
import com.arm.mgd.lightweight.asset.vulkan.VkBufferAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDescriptorPoolAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkDeviceMemoryAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkImageAsset;
import com.arm.mgd.lightweight.asset.vulkan.VkRenderPassAsset;
import com.arm.mgd.lightweight.model.api.CLApi;
import com.arm.mgd.lightweight.model.api.EGLApi;
import com.arm.mgd.lightweight.model.api.GLESApi;
import com.arm.mgd.lightweight.model.api.VULKANApi;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractLightweightAssetProcessorBase<API_MODEL> {
    public static @NonNull GlTextureImageAsset getGlTextureImageAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull GlTextureSurfaceAsset textureSurfaceAsset, @NonNull AssetItemID id) {
        GlTextureImageAsset result = textureSurfaceAsset.getLastAssetBefore(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, id, functionCall.getID(), specificInstanceId);
        if (result == null && specificInstanceId == null) {
            result = new GlTextureImageAsset(functionCall, textureSurfaceAsset, id);
            textureSurfaceAsset.addChildAsset(result);
            callbacks.onAssetCreated(result);
        }
        assert (result != null);
        return result;
    }

    public static @NonNull GlVertexAttributeNonArrayValueAsset getOrCreateNewGlVertexAttributeNonArrayValueAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlVertexAttributeNonArrayValueAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_TRAITS, functionCall.getID(), id, true);
        if (result == null) {
            result = new GlVertexAttributeNonArrayValueAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlBufferAsset createNewGlBufferAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlBufferAsset result = new GlBufferAsset(functionCall, id);
        callbacks.insertNewAsset(result);
        callbacks.onAssetCreated(result);
        return result;
    }

    protected static @NonNull GlProgramPipelineAsset createNewGlProgramPipelineAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlProgramPipelineAsset result = new GlProgramPipelineAsset(functionCall, id);
        callbacks.insertNewAsset(result);
        callbacks.onAssetCreated(result);
        return result;
    }

    protected static @NonNull GlFramebufferAsset createNewGlFramebufferAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, @NonNull AssetItemID defaultObjectId) {
        if (id.equals(defaultObjectId)) {
            return (GlFramebufferAsset)NullUtils.neverNull((Object)AbstractLightweightAssetProcessorBase.getGlFramebufferAsset(callbacks, functionCall, null, id, defaultObjectId));
        }
        GlFramebufferAsset result = new GlFramebufferAsset(functionCall, id);
        callbacks.insertNewAsset(result);
        callbacks.onAssetCreated(result);
        return result;
    }

    protected static @NonNull GlRenderbufferAsset createNewGlRenderbufferAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlRenderbufferAsset result = new GlRenderbufferAsset(functionCall, id);
        callbacks.insertNewAsset(result);
        callbacks.onAssetCreated(result);
        return result;
    }

    private static @NonNull GlTransformFeedbackAsset createNewGlTransformFeedbackAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, @NonNull AssetItemID defaultObjectId) {
        if (id.equals(defaultObjectId)) {
            return (GlTransformFeedbackAsset)NullUtils.neverNull((Object)AbstractLightweightAssetProcessorBase.getGlTransformFeedbackAsset(callbacks, functionCall, null, id, defaultObjectId));
        }
        GlTransformFeedbackAsset result = new GlTransformFeedbackAsset(functionCall, id);
        callbacks.insertNewAsset(result);
        callbacks.onAssetCreated(result);
        return result;
    }

    protected static @NonNull GlTextureAsset createNewGlTextureAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id, @NonNull AssetItemID defaultObjectId) {
        if (id.equals(defaultObjectId)) {
            return (GlTextureAsset)NullUtils.neverNull((Object)AbstractLightweightAssetProcessorBase.getGlTextureAsset(callbacks, functionCall, null, id, defaultObjectId));
        }
        GlTextureAsset result = new GlTextureAsset(functionCall, id);
        callbacks.insertNewAsset(result);
        callbacks.onAssetCreated(result);
        return result;
    }

    protected static <T extends IAssetItem<?, ?>> void forEachAssetItem(@NonNull List<@NonNull T> assets, @NonNull IForEachAssetItemFunction<T> function) throws AbortActionException {
        for (IAssetItem asset : assets) {
            function.call(asset);
        }
    }

    protected static void forEachAssetItemID(@NonNull List<@NonNull AssetItemID> ids, @NonNull IForEachAssetItemIDFunction function) throws AbortActionException {
        for (AssetItemID id : ids) {
            function.call(id);
        }
    }

    protected static @Nullable ClContextAsset getClContextAsset(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.CL.assetTables.CONTEXT_TRAITS, functionCall.getID(), id, true);
    }

    protected static @Nullable ClKernelAsset getClKernelAsset(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.CL.assetTables.KERNEL_TRAITS, functionCall.getID(), id, true);
    }

    protected static @Nullable ClMemoryAsset<?, ?> getClMemoryAsset(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.CL.assetTables.MEMORY_TRAITS, functionCall.getID(), id, true);
    }

    protected static @Nullable ClProgramAsset getClProgramAsset(@NonNull ILightweightAssetProcessorCallbacks<CLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.CL.assetTables.PROGRAM_TRAITS, functionCall.getID(), id, true);
    }

    protected static @Nullable EglContextAsset getEglContextAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @Nullable EglDisplayAsset parentAssetObject, @NonNull AssetItemID id) {
        if (parentAssetObject == null) {
            return null;
        }
        return parentAssetObject.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, id, functionCall.getID(), specificInstanceId);
    }

    protected static @Nullable EglDisplayAsset getEglDisplayAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return AbstractLightweightAssetProcessorBase.getOrCreateNewEglDisplayAsset(callbacks, functionCall, specificInstanceId, id, Pointer.NULL);
    }

    protected static @Nullable EglImageAsset getEglImageAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @Nullable EglDisplayAsset parentAssetObject, @NonNull AssetItemID id) {
        if (parentAssetObject == null) {
            return null;
        }
        return parentAssetObject.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS, id, functionCall.getID(), specificInstanceId);
    }

    protected static @Nullable EglPbufferSurfaceAsset getEglPbufferSurfaceAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @Nullable EglDisplayAsset parentAssetObject, @NonNull AssetItemID id) {
        EglSurfaceAsset<?, ?> result = AbstractLightweightAssetProcessorBase.getEglSurfaceAsset(callbacks, functionCall, specificInstanceId, parentAssetObject, id);
        if (result instanceof EglPbufferSurfaceAsset) {
            return (EglPbufferSurfaceAsset)result;
        }
        return null;
    }

    protected static @Nullable EglPixmapSurfaceAsset getEglPixmapSurfaceAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @Nullable EglDisplayAsset parentAssetObject, @NonNull AssetItemID id) {
        EglSurfaceAsset<?, ?> result = AbstractLightweightAssetProcessorBase.getEglSurfaceAsset(callbacks, functionCall, specificInstanceId, parentAssetObject, id);
        if (result instanceof EglPixmapSurfaceAsset) {
            return (EglPixmapSurfaceAsset)result;
        }
        return null;
    }

    protected static @Nullable EglSurfaceAsset<?, ?> getEglSurfaceAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @Nullable EglDisplayAsset parentAssetObject, @NonNull AssetItemID id) {
        if (parentAssetObject == null) {
            return null;
        }
        return parentAssetObject.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, id, functionCall.getID(), specificInstanceId);
    }

    protected static @Nullable EglSyncAsset getEglSyncAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @Nullable EglDisplayAsset parentAssetObject, @NonNull AssetItemID id) {
        if (parentAssetObject == null) {
            return null;
        }
        return parentAssetObject.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS, id, functionCall.getID(), specificInstanceId);
    }

    protected static @Nullable EglWindowSurfaceAsset getEglWindowSurfaceAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @Nullable EglDisplayAsset parentAssetObject, @NonNull AssetItemID id) {
        EglSurfaceAsset<?, ?> result = AbstractLightweightAssetProcessorBase.getEglSurfaceAsset(callbacks, functionCall, specificInstanceId, parentAssetObject, id);
        if (result instanceof EglWindowSurfaceAsset) {
            return (EglWindowSurfaceAsset)result;
        }
        return null;
    }

    protected static @Nullable GlBufferAsset getGlBufferAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.GLES.assetTables.BUFFER_TRAITS, functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlFramebufferAsset getGlFramebufferAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id, @NonNull AssetItemID defaultObjectId) {
        GlFramebufferAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, functionCall.getID(), id, id.equals(defaultObjectId) ? null : specificInstanceId);
        if (result == null && specificInstanceId == null && id.equals(defaultObjectId)) {
            result = new GlFramebufferAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @Nullable GlFramebufferRenderbufferAttachmentAsset getGlFramebufferRenderbufferAttachmentAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull GlFramebufferAsset parentAsset, @NonNull AssetItemID id) {
        return parentAsset.getGlFramebufferRenderbufferAttachmentAssetAt(functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlFramebufferTextureAttachmentAsset getGlFramebufferTextureAttachmentAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull GlFramebufferAsset parentAsset, @NonNull AssetItemID id) {
        return parentAsset.getGlFramebufferTextureAttachmentAssetAt(functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlFramebufferZeroAttachmentAsset getGlFramebufferZeroAttachmentAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull GlFramebufferAsset parentAsset, @NonNull AssetItemID id) {
        return parentAsset.getGlFramebufferZeroAttachmentAssetAt(functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlProgramAsset getGlProgramAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlProgramPipelineAsset getGlProgramPipelineAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlQueryObjectAsset getGlQueryObjectAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.GLES.assetTables.QUERY_TRAITS, functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlRenderbufferAsset getGlRenderbufferAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlSamplerAsset getGlSamplerAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlShaderAsset getGlShaderAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.GLES.assetTables.SHADER_TRAITS, functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlSyncObjectAsset getGlSyncObjectAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS, functionCall.getID(), id, specificInstanceId);
    }

    protected static @Nullable GlTextureAsset getGlTextureAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id, @NonNull AssetItemID defaultObjectId) {
        GlTextureAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, functionCall.getID(), id, id.equals(defaultObjectId) ? null : specificInstanceId);
        if (result == null && specificInstanceId == null && id.equals(defaultObjectId)) {
            result = new GlTextureAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @Nullable GlTransformFeedbackAsset getGlTransformFeedbackAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id, @NonNull AssetItemID defaultObjectId) {
        GlTransformFeedbackAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, functionCall.getID(), id, id.equals(defaultObjectId) ? null : specificInstanceId);
        if (result == null && specificInstanceId == null && id.equals(defaultObjectId)) {
            result = new GlTransformFeedbackAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlTextureSurfaceAsset getGlTextureSurfaceAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull GlTextureAsset textureAsset, @NonNull AssetItemID id) {
        GlTextureSurfaceAsset result = textureAsset.getLastAssetBefore(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_TRAITS, id, functionCall.getID(), specificInstanceId);
        if (result == null && specificInstanceId == null) {
            result = new GlTextureSurfaceAsset(functionCall, textureAsset, id);
            textureAsset.addChildAsset(result);
            callbacks.onAssetCreated(result);
        }
        assert (result != null);
        return result;
    }

    protected static @Nullable GlVertexArrayObjectAsset getGlVertexArrayObjectAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id, @NonNull AssetItemID defaultObjectId) {
        GlVertexArrayObjectAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, functionCall.getID(), id, id.equals(defaultObjectId) ? null : specificInstanceId);
        if (result == null && specificInstanceId == null && id.equals(defaultObjectId)) {
            result = new GlVertexArrayObjectAsset(functionCall, defaultObjectId);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @Nullable VkImageAsset getVkImageAsset(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, functionCall.getID(), id, true);
    }

    protected static @NonNull EglConfigAsset getOrCreateNewEglConfigAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAssetObject, @NonNull AssetItemID id) {
        EglConfigAsset result = parentAssetObject.getLastAssetBefore(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, id, functionCall.getID(), true);
        if (result == null) {
            result = new EglConfigAsset(functionCall, parentAssetObject, id);
            parentAssetObject.addChildAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @Nullable EglDisplayAsset getOrCreateNewEglDisplayAsset(@NonNull ILightweightAssetProcessorCallbacks<EGLApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull AssetItemID id, @NonNull Pointer nativeDisplay) {
        EglDisplayAsset result = callbacks.getAssetObject(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, functionCall.getID(), id, specificInstanceId);
        if (!(id.asLong() == 0L || specificInstanceId != null || result != null && result.getLifecycleManager().isAssetLive(functionCall.getID()))) {
            result = new EglDisplayAsset(functionCall, id, nativeDisplay);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlAtomicCounterBufferBindingPointAsset getOrCreateNewGlAtomicCounterBufferBindingPointAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlAtomicCounterBufferBindingPointAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, functionCall.getID(), id, true);
        if (result == null) {
            result = new GlAtomicCounterBufferBindingPointAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlImageUnitAsset getOrCreateNewGlImageUnitAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlImageUnitAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.IMAGE_UNIT_TRAITS, functionCall.getID(), id, true);
        if (result == null) {
            result = new GlImageUnitAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlShaderStorageBufferBindingPointAsset getOrCreateNewGlShaderStorageBufferBindingPointAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlShaderStorageBufferBindingPointAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, functionCall.getID(), id, true);
        if (result == null) {
            result = new GlShaderStorageBufferBindingPointAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlTextureUnitAsset getOrCreateNewGlTextureUnitAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlTextureUnitAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS, functionCall.getID(), id, true);
        if (result == null) {
            result = new GlTextureUnitAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlTransformFeedbackBufferBindingPointAsset getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlTransformFeedbackBufferBindingPointAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, functionCall.getID(), id, true);
        if (result == null) {
            result = new GlTransformFeedbackBufferBindingPointAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlUniformBindingPointAsset getOrCreateNewGlUniformBindingPointAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        GlUniformBindingPointAsset result = callbacks.getAssetObject(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, functionCall.getID(), id, true);
        if (result == null) {
            result = new GlUniformBindingPointAsset(functionCall, id);
            callbacks.insertNewAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @Nullable GlVertexAttributeAsset getOrCreateNewGlVertexAttributeAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset parentAsset, @NonNull AssetItemID id, @NonNull GlVertexAttributeNonArrayValueAsset nonArrayDataSource) {
        GlVertexAttributeAsset result = parentAsset.getGlVertexAttributeAssetAt(functionCall.getID(), id, true);
        if (result == null) {
            result = new GlVertexAttributeAsset(functionCall, parentAsset, id, nonArrayDataSource);
            parentAsset.addChildAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @NonNull GlVertexBufferBindingAsset getOrCreateNewGlVertexBufferBindingAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset parentAsset, @NonNull AssetItemID id) {
        GlVertexBufferBindingAsset result = parentAsset.getGlVertexBufferBindingAssetAt(functionCall.getID(), id, true);
        if (result == null) {
            result = new GlVertexBufferBindingAsset(functionCall, parentAsset, id);
            parentAsset.addChildAsset(result);
            callbacks.onAssetCreated(result);
        }
        return result;
    }

    protected static @Nullable ShaderUniform getShaderUniform(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull GlProgramAsset parentAsset, @NonNull AssetItemID id) {
        return parentAsset.getShaderUniformAt(functionCall.getID(), id, true);
    }

    protected static <API_MODEL, T extends IAssetItem<API_MODEL, ?>> @Nullable T getStateItemAssetValue(@NonNull KapiSpec.AssetTraits<?, T, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @NonNull StateSpec stateSpec) {
        block5: {
            try {
                IStateItem<?> stateItem = callbacks.getStateItem(functionCall, stateSpec);
                assert (stateItem != null) : "Missing state item for " + stateSpec.getId();
                Object value = stateItem.waitForValue(functionCall.getID());
                if (value instanceof IStateItemValueWithAssetValue) {
                    IStateItemValueWithAssetValue assetStateValue = (IStateItemValueWithAssetValue)value;
                    if (!traits.LIGHTWEIGHT_ASSET_CLASS.isAssignableFrom(assetStateValue.getAssetClass())) {
                        throw new ClassCastException("Invalid asset class for state item " + value.getParent().getStateSpec().getId());
                    }
                    return callbacks.getAssetObject(traits, functionCall.getID(), (AssetItemID)NullUtils.neverNull((Object)assetStateValue.getValueAsAssetItemID()), false);
                }
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)("Invalid state item " + stateSpec.getId() + " does not have an asset class"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected static @NonNull IStateItemValue<?> getStateItemValue(@NonNull ILightweightAssetProcessorCallbacks<?> callbacks, @NonNull FunctionCall functionCall, @NonNull StateSpec stateSpec) {
        IStateItem<?> stateItem = callbacks.getStateItem(functionCall, stateSpec);
        return stateItem.waitForValue(functionCall.getID());
    }

    protected static <API_MODEL> void logInvalidConstant(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @NonNull AbstractConstantOrAliasSpecExtended constant) {
        CoreLogging.warning(callbacks, "Unexpected constant value " + constant + " @ " + functionCall.getID() + ": " + functionCall);
    }

    protected static <API_MODEL> void logMissingAsset(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, String assetType) {
        CoreLogging.warning(callbacks, "Lightweight processing failed. Asset " + assetType + " not found @ " + functionCall.getID() + ": " + functionCall);
    }

    protected static <API_MODEL> void logMissingAssetParent(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, String assetType, String parentType) {
        CoreLogging.warning(callbacks, "Lightweight processing failed. Asset " + parentType + " not found when looking for parent for " + assetType + " @ " + functionCall.getID() + ": " + functionCall);
    }

    protected static <API_MODEL, T extends IAssetItem<API_MODEL, ?>> @Nullable T mapStateValueToAssetObject(@NonNull KapiSpec.AssetTraits<?, T, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @NonNull IStateItemValue<?> stateValue) {
        if (stateValue instanceof IStateItemValueWithAssetValue) {
            IStateItemValueWithAssetValue assetStateValue = (IStateItemValueWithAssetValue)stateValue;
            if (!traits.LIGHTWEIGHT_ASSET_CLASS.isAssignableFrom(assetStateValue.getAssetClass())) {
                throw new ClassCastException("Invalid asset class for state item " + stateValue.getParent().getStateSpec().getId());
            }
            return callbacks.getAssetObject(traits, functionCall.getID(), (AssetItemID)NullUtils.neverNull((Object)assetStateValue.getValueAsAssetItemID()), false);
        }
        return null;
    }

    protected static @NonNull IStateItemValue<?> mapTargetToStateValue(@NonNull ILightweightAssetProcessorCallbacks<?> callbacks, @NonNull FunctionCall functionCall, @NonNull TargetBindingGroupSpec specObject, @NonNull AbstractConstantOrAliasSpecExtended target) {
        for (TargetBindingSpec targetBindingSpec : specObject.getTargetBinding()) {
            if (!targetBindingSpec.getTarget().equals(target)) continue;
            return AbstractLightweightAssetProcessorBase.getStateItemValue(callbacks, functionCall, (StateSpec)NullUtils.neverNull((Object)targetBindingSpec.getState()));
        }
        throw new AssertionError((Object)("Missing target item for target binding spec " + specObject.getName() + " : " + target.getName()));
    }

    protected static <API_MODEL, T extends IAssetItem<API_MODEL, ?>> @NonNull T requireAsset(@NonNull KapiSpec.AssetTraits<?, ? super T, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @Nullable T asset, @NonNull AssetItemID id) throws AbortActionException {
        if (asset != null && asset.getLifecycleManager().isAssetRetained(functionCall.getID())) {
            return asset;
        }
        throw new MissingAssetException(traits, functionCall, id.asLong());
    }

    protected static @NonNull GlBufferAsset requireAsset(@NonNull KapiSpec.AssetTraits<?, GlBufferAsset, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable GlBufferAsset asset, @NonNull AssetItemID id) throws AbortActionException {
        if (asset != null && asset.getLifecycleManager().isAssetRetained(functionCall.getID())) {
            return asset;
        }
        if (!id.equals(AssetItemID.ZERO) && functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDBUFFER)) {
            CoreLogging.warning(callbacks, "Binding buffers without first calling glGenBuffers to generate IDs is deprecated in OpenGL ES 3.0.");
            return AbstractLightweightAssetProcessorBase.createNewGlBufferAsset(callbacks, functionCall, id);
        }
        throw new MissingAssetException(traits, functionCall, id.asLong());
    }

    protected static @NonNull GlFramebufferAsset requireAsset(@NonNull KapiSpec.AssetTraits<?, GlFramebufferAsset, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable GlFramebufferAsset asset, @NonNull AssetItemID id) throws AbortActionException {
        if (asset != null && asset.getLifecycleManager().isAssetRetained(functionCall.getID())) {
            return asset;
        }
        assert (!AssetItemID.ZERO.equals(id));
        if (functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDFRAMEBUFFER)) {
            CoreLogging.warning(callbacks, "Binding framebuffers without first calling glGenFramebuffers to generate IDs is deprecated in OpenGL ES 3.0.");
            return AbstractLightweightAssetProcessorBase.createNewGlFramebufferAsset(callbacks, functionCall, id, AssetItemID.ZERO);
        }
        throw new MissingAssetException(traits, functionCall, id.asLong());
    }

    protected static @NonNull GlRenderbufferAsset requireAsset(@NonNull KapiSpec.AssetTraits<?, GlRenderbufferAsset, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable GlRenderbufferAsset asset, @NonNull AssetItemID id) throws AbortActionException {
        if (asset != null && asset.getLifecycleManager().isAssetRetained(functionCall.getID())) {
            return asset;
        }
        if (!id.equals(AssetItemID.ZERO) && functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDRENDERBUFFER)) {
            CoreLogging.warning(callbacks, "Binding renderbuffers without first calling glGenRenderbuffers to generate IDs is deprecated in OpenGL ES 3.0.");
            return AbstractLightweightAssetProcessorBase.createNewGlRenderbufferAsset(callbacks, functionCall, id);
        }
        throw new MissingAssetException(traits, functionCall, id.asLong());
    }

    protected static @NonNull GlProgramPipelineAsset requireAsset(@NonNull KapiSpec.AssetTraits<?, GlProgramPipelineAsset, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable GlProgramPipelineAsset asset, @NonNull AssetItemID id) throws AbortActionException {
        if (asset != null && asset.getLifecycleManager().isAssetRetained(functionCall.getID())) {
            return asset;
        }
        if (!id.equals(AssetItemID.ZERO) && functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDPROGRAMPIPELINE)) {
            CoreLogging.warning(callbacks, "Binding program pipeline objects without first calling glGenProgramPipelineobjects to generate IDs is deprecated in OpenGL ES 3.0.");
            return AbstractLightweightAssetProcessorBase.createNewGlProgramPipelineAsset(callbacks, functionCall, id);
        }
        throw new MissingAssetException(traits, functionCall, id.asLong());
    }

    protected static @NonNull GlTransformFeedbackAsset requireAsset(@NonNull KapiSpec.AssetTraits<?, GlTransformFeedbackAsset, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable GlTransformFeedbackAsset asset, @NonNull AssetItemID id) throws AbortActionException {
        if (asset != null && asset.getLifecycleManager().isAssetRetained(functionCall.getID())) {
            return asset;
        }
        assert (!AssetItemID.ZERO.equals(id));
        if (functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDTRANSFORMFEEDBACK)) {
            CoreLogging.warning(callbacks, "Binding transform feedbacks without first calling glGenTransformFeedbacks to generate IDs is deprecated in OpenGL ES 3.0.");
            return AbstractLightweightAssetProcessorBase.createNewGlTransformFeedbackAsset(callbacks, functionCall, id, AssetItemID.ZERO);
        }
        throw new MissingAssetException(traits, functionCall, id.asLong());
    }

    protected static @NonNull GlTextureAsset requireAsset(@NonNull KapiSpec.AssetTraits<?, GlTextureAsset, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable GlTextureAsset asset, @NonNull AssetItemID id) throws AbortActionException {
        if (asset != null && asset.getLifecycleManager().isAssetRetained(functionCall.getID())) {
            return asset;
        }
        assert (!AssetItemID.ZERO.equals(id));
        if (functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDTEXTURE)) {
            CoreLogging.warning(callbacks, "Binding textures without first calling glGenTextures to generate IDs is deprecated in OpenGL ES 3.0.");
            return AbstractLightweightAssetProcessorBase.createNewGlTextureAsset(callbacks, functionCall, id, AssetItemID.ZERO);
        }
        throw new MissingAssetException(traits, functionCall, id.asLong());
    }

    protected static <API_MODEL, ASSET_CLASS extends IAssetItem<API_MODEL, VALUE_TYPE>, VALUE_TYPE extends IAssetItem.Value<? extends ASSET_CLASS>> @Nullable VALUE_TYPE safeWaitForValue(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @Nullable ASSET_CLASS asset, @NonNull FunctionCallID id) throws Exception {
        if (asset == null) {
            return null;
        }
        return asset.waitForValue(callbacks, id);
    }

    protected static AbstractConstantOrAliasSpecExtended validateConstantIsInSet(@NonNull ILightweightAssetProcessorCallbacks<?> callbacks, @NonNull FunctionCall functionCall, @NonNull AbstractConstantOrAliasSpecExtended constantToValidate, @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> constantSet) {
        if (!constantSet.contains(constantToValidate)) {
            CoreLogging.warning(callbacks, "Unexpected constant value " + constantToValidate.getName());
        }
        return constantToValidate;
    }

    protected static @Nullable VkBufferAsset getVkBufferAsset(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, functionCall.getID(), id, true);
    }

    protected static @Nullable VkRenderPassAsset getVkRenderPassAsset(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, functionCall.getID(), id, true);
    }

    protected static @Nullable VkDescriptorPoolAsset getVkDescriptorPoolAsset(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, functionCall.getID(), id, true);
    }

    protected static @Nullable VkDeviceMemoryAsset getVkDeviceMemoryAsset(@NonNull ILightweightAssetProcessorCallbacks<VULKANApi> callbacks, @NonNull FunctionCall functionCall, @NonNull AssetItemID id) {
        return callbacks.getAssetObject(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, functionCall.getID(), id, true);
    }

    protected static AbstractConstantOrAliasSpecExtended validateConstantIsInSetLogError(@NonNull ILightweightAssetProcessorCallbacks<?> callbacks, @NonNull FunctionCall functionCall, @NonNull AbstractConstantOrAliasSpecExtended constantToValidate, @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> constantSet) {
        if (!constantSet.contains(constantToValidate)) {
            CoreLogging.severe(callbacks, "Unexpected constant value " + constantToValidate.getName());
        }
        return constantToValidate;
    }

    protected static <API_MODEL, T extends IAssetItem<API_MODEL, ?>> @Nullable T warnIfMissingAsset(@NonNull KapiSpec.AssetTraits<?, ? super T, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @Nullable T asset, @NonNull AssetItemID id) {
        return AbstractLightweightAssetProcessorBase.warnIfMissingAsset(traits, callbacks, functionCall, asset, id, null);
    }

    protected static <API_MODEL, T extends IAssetItem<API_MODEL, ?>> @Nullable T warnIfMissingAsset(@NonNull KapiSpec.AssetTraits<?, ? super T, ?> traits, @NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @Nullable T asset, @NonNull AssetItemID id, @Nullable AssetItemID invalidItemId) {
        if (!(asset != null || invalidItemId != null && invalidItemId.equals(id))) {
            CoreLogging.warning(callbacks, (String)NullUtils.neverNull((Object)String.format("No asset object found of type %s with id of %s found @ %s: %s)", traits.SPEC.getSingularName(), id, functionCall.getID(), functionCall)));
        }
        return asset;
    }

    protected static <API_MODEL, T extends IAssetItem<API_MODEL, ?>> @Nullable T warnIfMissingAsset(@NonNull ILightweightAssetProcessorCallbacks<API_MODEL> callbacks, @NonNull FunctionCall functionCall, @Nullable T asset, @NonNull AssetItemID id) {
        if (asset == null && id.asLong() != 0L) {
            CoreLogging.warning(callbacks, "Missing asset object in " + functionCall.getFunctionSpec().getName() + " @ " + functionCall.getID());
        }
        return asset;
    }

    protected static @Nullable GlFramebufferTextureMultiviewAttachmentAsset getGlFramebufferTextureMultiviewAttachmentAsset(@NonNull ILightweightAssetProcessorCallbacks<GLESApi> callbacks, @NonNull FunctionCall functionCall, @Nullable Long specificInstanceId, @NonNull GlFramebufferAsset parentAsset, @NonNull AssetItemID id) {
        return parentAsset.getGlFramebufferTextureMultiviewAttachmentAssetAt(functionCall.getID(), id, specificInstanceId);
    }

    @FunctionalInterface
    protected static interface IForEachAssetItemFunction<T extends IAssetItem<?, ?>> {
        public void call(@NonNull T var1) throws AbortActionException;
    }

    @FunctionalInterface
    protected static interface IForEachAssetItemIDFunction {
        public void call(@NonNull AssetItemID var1) throws AbortActionException;
    }
}

